<?php
    
    date_default_timezone_set('America/Chicago');
    
    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    
    include('process/functions.php');
    include('includes/database_include.php');
    
    function get_user_info( $patient_id, $field = null ){
        
        //$patient_id = $_GET["patient_id"];
        $servername = "localhost";
        $username = "ddxrx_patient";
        $password = "Coastpcp%003";
        $dbname = "telemedicine";
                            
        // Create connection
        $mysqli = new mysqli($servername, $username, $password, $dbname);
        
        // Check connection
        if ($mysqli->connect_error) {
            die("Connection failed: " . $mysqli->connect_error);
        }
    
        $query = "SELECT * FROM patients WHERE patient_id = '$patient_id' limit 1";
        
        $results = array();
        
        if ($result = $mysqli->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        $mysqli->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }
    
    
    
?>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Billing Codes</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/2.0.4/css/dataTables.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
	<!-- <script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script> -->
    <script type="text/javascript" src="//cdn.datatables.net/2.0.5/js/dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">

	    // $(document).ready(function(){
        
        //     // Load DataTable JS
        //     $('#myTable').DataTable({
        //         "pageLength": 100,
        //         "bSort": false
        //     });
            
        // });

        $(document).ready(function(){
            $('#myTable').DataTable({
                "processing": false,
                "serverSide": true,
                "ajax": {
                    "url": "process/billing-code-data.php",
                    "type": "POST",
                    "data": function(d) {
                        d.month = $('.filterSelect.month').val();
                        d.year = $('.filterSelect.year').val();
                    }
                },
                "pageLength": 50,
                "bSort": true,
                "paging": true, // Explicitly enable pagination
                "language": {
                    "loadingRecords": "<p>Please wait, loading data...</p>"
                }
            });
        });

	</script>
	
</head>
<body>
    
    <!-- Popup -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup -->
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            <div class="col-md-12">
                <div class="patient-info">
                    <h3 class="tabtitle">Billing Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
        <div class="menu-container">
            
            <div class="container">
            <div class="filter-container">
                <form method="POST">
                    <!-- Month -->
                    <select name="month" class="filterSelect month">
                    <?php
                    $cur_month = intval(date('n'));
                    for( $x = 1; $x <= 12; $x++ ){
                        
                        if( $x == $_POST['month'] ){
                            $cur_month_select = 'selected';
                        }else if( $x == $cur_month && !isset($_POST['month']) ){
                            $cur_month_select = 'selected';
                        }else{
                            $cur_month_select = '';
                        }

                        if( $x == 1 ){$display_date = "January"; }
                        if( $x == 2 ){ $display_date = "February"; }
                        if( $x == 3 ){ $display_date = "March"; }
                        if( $x == 4 ){ $display_date = "April"; }
                        if( $x == 5 ){ $display_date = "May"; }
                        if( $x == 6 ){ $display_date = "June"; }
                        if( $x == 7 ){ $display_date = "July"; }
                        if( $x == 8 ){ $display_date = "August"; }
                        if( $x == 9 ){ $display_date = "September"; }
                        if( $x == 10 ){ $display_date = "October"; }
                        if( $x == 11 ){ $display_date = "November"; }
                        if( $x == 12 ){ $display_date = "December"; }

                    ?>
                        <option value="<?php echo $x; ?>" <?php echo $cur_month_select; ?>><?php echo $display_date; ?></option>
                    <?php } ?>
                    </select>
                    <!-- Month -->
                    
                    <!-- Year -->
                    <select name="year" class="filterSelect year">
                    <?php
                    $cur_year = intval(date('Y'));
                    for( $y = 2014; $y <= $cur_year; $y++ ){
                        
                        if( $y == $_POST['year'] ){
                            $cur_year_select = 'selected';
                        }else if( $y == $cur_year && !isset($_POST['year']) ){
                            $cur_year_select = 'selected';
                        }else{
                            $cur_year_select = '';
                        }
                    ?>
                    
                        <option value="<?php echo $y; ?>" <?php echo $cur_year_select; ?>><?php echo $y; ?></option>
                        
                    <?php } ?>
                    </select>
                    <!-- Year -->
                    
                    <input type="submit" value="Filter" class="filterBtn">
                </form>
                
            </div>
            
            <?php
                if( $_SESSION['user_type'] == 'nurse' ){
                    include('nurse_dashboard_nav.php');
                }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                    include('physician_dashboard_nav.php');
                }
            ?>
            <div class="clear"></div>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="col-md-12">
            <div class="TableContainer">
                <table id="myTable">
                	<thead>
                        <tr>
                            <td>Last Name</td>
                            <td>First Name</td>
                            <td>Gender</td>
                            <td>DOB</td>
                            <td>99453</td> <!-- Enrollment Date(Optional and should be blank) !-->
                            <td>99454</td> <!-- if they have more than 16 measurements of blood pressure count( Show blood pressure counts ) -->
                            <td>99457</td> <!-- the date they become 20 minutes of consultion -->
                            <td>99458</td> <!-- 40 minutes additional -->
                        </tr>
                    </thead>
        
                    <tbody>
                        
                        <?php
                        /*
                        $groupid = get_version();
    
                        if( !isset($_POST['month']) && !isset($_POST['year']) ){
                            $month = intval(date("n"));
                            $year = intval(date("Y"));
                        }else{
                            $month = $_POST['month'];
                            $year = $_POST['year'];
                        }

                        //$sql = "SELECT * FROM cardiowell_users INNER JOIN patients ON cardiowell_users.patient_id = patients.patient_id WHERE cardiowell_users.type = 'bp' AND patients.groupid = '100018'";
                        $sql = "SELECT * FROM cardiowell_users INNER JOIN patients ON cardiowell_users.patient_id = patients.patient_id WHERE cardiowell_users.type = 'bp' AND patients.groupid = '$groupid'";
                        
                        $result = ddxrxDBConnect()->query($sql);
                        
                        if ($result->num_rows > 0) {
                            // output data of each row
                            while($row = $result->fetch_assoc()) {
                                
                                if( $row["patient_gender"] == 'm' || $row["patient_gender"] == 'M' ){
                                    $gender = 'Male';
                                }elseif( $row["patient_gender"] == 'f' || $row["patient_gender"] == 'F' ){
                                    $gender = 'Female';
                                }

                                // Additional 40 minutes
                                $timelapsed = (int)get_bp_count($row["patient_id"], $month, $year, 'raw');
                                $timedisplay = get_bp_count($row["patient_id"], $month, $year, '20min');

                                if( $timelapsed >= 40 ){
                                    $time_added = 'Additional 40 min added('.$timedisplay.')';
                                }else{
                                    $time_added = 'No additional time('.$timedisplay.')';
                                }
                                
                                echo '<tr>';
                                echo '<td>'.$row["patient_fname"].'</td>';
                                echo '<td>'.$row["patient_lname"].'</td>';
                                echo '<td>'.$gender.'</td>';
                                echo '<td>'.$row["patient_dob"].'</td>';

                                echo '<td></td>';
                                echo '<td>'.get_bp_count($row["patient_id"], $month, $year).' BP Counts</td>';
                                echo '<td>'.session_time($row["patient_id"], $month, $year, '20min').'</td>';
                                echo '<td>'.exceeded_time($row["patient_id"], $month, $year, 'excess').'</td>';
                                //echo '<td>'.$time_added.'</td>';
                                echo '</tr>';
                                
                            }
                        }
                        
                        ddxrxDBConnect()->close();
                        */
                        ?>
                        
                    </tbody>
                </table>
                
                <div class="table-controls">
                    <!-- <?php if( isset($_POST['month']) && isset($_POST['year']) ){ ?>
                        <a href="process/export-billing-code.php?month=<?php echo $_POST['month']; ?>&year=<?php echo $_POST['year']; ?>" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Export</a>
                    <?php }else{ ?>
                        <a href="process/export-billing-code.php" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Export</a>
                    <?php } ?> -->
                    
                    <?php
                    if( isset($_POST['month']) && $_POST['year'] ){
                        $month = $_POST['month'];
                        $year = $_POST['year'];
                    }else{
                        $month = intval(date("n"));
                        $year = intval(date("Y"));
                    }
                    ?>
                    <a href="billing-pdf.php?groupid=<?php echo get_version(); ?>&month=<?php echo $month; ?>&year=<?php echo $year; ?>" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Print Report</a>
                
                </div>
                
            </div>
        </div>
    </div>
    
    <?php
        if( $_SESSION['user_type'] == 'nurse' ){
            provider_bottom_nav();
        }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
            physician_bottom_nav();
        }
    ?>
    
</body>
</html>