$(document).ready(function(){
            
    // Get monitor height
    var screenHeight = $(window).height();

    // Get form container height
    var formHeight = $('.form-container').outerHeight();

    // Get Message List height
    var messageListHeight = screenHeight-formHeight;
    
    // Set Message List height
    $('#messages').css('height', messageListHeight);
    //$('.chat-wrapper').css('height', messageListHeight);
    $('.sidebar').css('height', messageListHeight);

    // Scroll down by default
    scrollToBottomChat();

});

// Scroll to bottom of chat when page is loaded
function scrollToBottomChat(){
    var element = document.getElementById("messages");
    var chatHeight = element.scrollHeight;
    $('#messages').animate({ scrollTop: chatHeight }, 100);
}

// Play Chat Sound
function chat_sound( soundType = 'chat' ){

    if( soundType == 'chat' ){
        var audio = new Audio('assets/others/chat-sound.mp3');
    }else if( soundType == 'chat-2' ){
        var audio = new Audio('assets/others/chat-sound-2.mp3');
    }else if( soundType == 'notification' ){
        var audio = new Audio('assets/others/join.mp3');
    }

    audio.play();
}

// Epoch to elapsed time
function timeSince(date) {

    // Assign date
    var seconds = Math.floor((new Date() - date) / 1000);

    // Get time lapsed in years
    var interval = seconds / 31536000;
    if (interval > 1) {
        // if years is 1, show year
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " year ago";
        }else{
            return Math.floor(interval) + " years ago";
        }
    }
    
    // Get time lapsed in months
    interval = seconds / 2592000;
    if (interval > 1) {
        // if months is 1, show month
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " month ago";
        }else{
            return Math.floor(interval) + " months ago";
        }
    }
    
    // Get time lapsed in days
    interval = seconds / 86400;
    if (interval > 1) {
        // if days is 1, show day
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " day ago";
        }else{
            return Math.floor(interval) + " days ago";
        }
    }

    // Get time lapsed in hours
    interval = seconds / 3600;
    if (interval > 1) {
        // If hours is 1, show hour
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " hour ago";
        }else{
            return Math.floor(interval) + " hours ago";
        }
    }

    // Get time lapsed in minutes
    interval = seconds / 60;
    if (interval > 1) {
        // If minutes is 1, show minute
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " minute ago";
        }else{
            return Math.floor(interval) + " minutes ago";
        }
    }

    // Get time lapsed in seconds
    // if seconds is 1, show second
    if(Math.floor(seconds) == 1){
        return Math.floor(seconds) + " second ago";
    }else{
        return Math.floor(seconds) + " seconds ago";
    }

}

// Update time lapsed
function updateTimeLapsed() {
    var timeLapsed = document.querySelectorAll('.time-lapsed');
    timeLapsed.forEach(function(time) {
        var timeLapsed = timeSince(time.getAttribute('data-time'));
        time.innerHTML = timeLapsed;
    });
}

// Update time lapsed every 60 seconds
setInterval(updateTimeLapsed, 10000);