<!DOCTYPE html>
<html>
<head>
    <title>Confidence Level</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="assets/css/reset.css">
    <link rel="stylesheet" href="assets/css/grid.css">
    <style>
        @import url('https://fonts.googleapis.com/css?family=Montserrat:100,200,300,400,500,600,700,800,900|Open+Sans:300,400,600,700,800');

        body{
            font-family: 'Open Sans', sans-serif;
            background-color: #027eff;
            color: #FFFFFF;
        }

        h1,h2,h3,h4,h5,h6{
            font-family: 'Montserrat', sans-serif;
        }

        h1{ font-size: 50px }

        .output_container{
            width: 100%;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

    </style>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script>

        $(document).ready(function(){

            // Ajax to get the confidence level every 1 second
            setInterval(function() {
                
                $.ajax({
                    url: 'process/confidence-checker.php',
                    type: 'POST',
                    data: {
                        user_id: "<?php echo $_GET['user_id']; ?>"
                    },
                    success: function(result) {
                        if (result.response === true) {
                            $('.output_container').html('<h1>Confidence Level: ' + result.confidence_lvl + ' for '+result.patient_name+'</h1>');
                        } else {
                            //$('.output_container').html('<h1>'+ result.msg +'</h1>');
                        }
                    }
                });

            }, 1000);

        });

    </script>
</head>
<body>

    <div class="output_container">
        <h1>Loading Please Wait...</h1>
    </div>

</body>
</html>