<?php

    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');
    include('includes/database_include.php');

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Critical Vitals Dashboard</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.0/dist/js.cookie.min.js"></script>
	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 100,
                //"bSort": false,
                "order": []
            });

        });
	</script>
	
</head>
<body class="critical-dashboard" style="padding-bottom: 70px;">
    
    <!-- Popup -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup -->
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            
            <div class="padded">
                <div class="patient-info">
                    <h3 class="tabtitle">Critical Vitals Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>

        </div>
        
        <div class="menu-container">
            <div class="container">
                <div class="col-md-12">
                    <?php
                        if( $_SESSION['user_type'] == 'nurse' ){
                            include('nurse_dashboard_nav.php');
                        }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                            include('physician_dashboard_nav.php');
                        }
                    ?>
                    <?php include('nav/critical_vital_nav.php'); ?>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="col-md-12">
            <div class="TableContainer">
                <table id="myTable">
                	<thead>
                        <tr>
                            <td>First Name</td>
                            <td>Last Name</td>
                            <td>Gender</td>
                            <td>Age</td>
                            <td>Phone Number</td>
                            <td>User Type</td>
                        </tr>
                    </thead>
        
                    <tbody>
                        
                        <?php
                            $patient_id = $_GET['patient_id'];
                            $servername = "localhost";
                        	$username = "ddxrx_patient";
                        	$password = "Coastpcp%003";
                        	$dbname = "telemedicine";
                            
                            // Create connection
                            $conn = new mysqli($servername, $username, $password, $dbname);
                            // Check connection
                            if ($conn->connect_error) {
                                die("Connection failed: " . $conn->connect_error);
                            }
                            
                            // if( !isset($_GET['ctab']) || $_GET['ctab'] == 'criticalline' ){
                            //     $sql = "SELECT * FROM patients LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND ((vitals_history.systolic > 150 AND vitals_history.systolic < 300) OR (vitals_history.diastolic > 90 AND vitals_history.diastolic < 130))";
                            // }elseif( $_GET['ctab'] == 'borderline' ){
                            //     $sql = "SELECT * FROM patients LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND ((vitals_history.systolic > 130 AND vitals_history.systolic < 150) OR (vitals_history.diastolic > 80 AND vitals_history.diastolic < 90))";
                            // }elseif( $_GET['ctab'] == 'lowheartrate' ){
                            //     $sql = "SELECT * FROM patients LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE  vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND vitals_history.heartrate < 50";
                            // }elseif( $_GET['ctab'] == 'highheartrate' ){
                            //     $sql = "SELECT * FROM patients LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND (vitals_history.heartrate > 100 OR vitals_history.respiratory = 1)";
                            // }
                            
                            $version = get_version();
                            
                            if( !isset($_GET['ctab']) || $_GET['ctab'] == 'criticalline' ){
                                $sql = "SELECT * FROM patients LEFT JOIN cardiowell_users ON patients.patient_id = cardiowell_users.patient_id LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE patients.groupid = '$version' AND vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND ((vitals_history.systolic > 150 AND vitals_history.systolic < 300) OR (vitals_history.diastolic > 90 AND vitals_history.diastolic < 130)) AND cardiowell_users.imei IS NOT NULL GROUP BY patients.patient_id HAVING count(patients.patient_id) > 1";
                            }elseif( $_GET['ctab'] == 'borderline' ){
                                $sql = "SELECT * FROM patients LEFT JOIN cardiowell_users ON patients.patient_id = cardiowell_users.patient_id LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE patients.groupid = '$version' AND vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND ((vitals_history.systolic > 130 AND vitals_history.systolic < 150) OR (vitals_history.diastolic > 80 AND vitals_history.diastolic < 90)) AND cardiowell_users.imei IS NOT NULL GROUP BY patients.patient_id HAVING count(patients.patient_id) > 1";
                            }elseif( $_GET['ctab'] == 'lowheartrate' ){
                                $sql = "SELECT * FROM patients LEFT JOIN cardiowell_users ON patients.patient_id = cardiowell_users.patient_id LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE patients.groupid = '$version' AND vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND vitals_history.heartrate < 50 AND cardiowell_users.imei IS NOT NULL GROUP BY patients.patient_id HAVING count(patients.patient_id) > 1";
                            }elseif( $_GET['ctab'] == 'highheartrate' ){
                                $sql = "SELECT * FROM patients LEFT JOIN cardiowell_users ON patients.patient_id = cardiowell_users.patient_id LEFT JOIN vitals_history ON patients.patient_id = vitals_history.patient_id WHERE patients.groupid = '$version' AND vitals_history.date_added >= DATE(NOW()) - INTERVAL 7 DAY AND (vitals_history.heartrate > 100 OR vitals_history.respiratory = 1) AND cardiowell_users.imei IS NOT NULL GROUP BY patients.patient_id HAVING count(patients.patient_id) > 1";
                            }
                            
                            $result = $conn->query($sql);
    
                            if ($result->num_rows > 0) {
                                // output data of each row
                                while($row = $result->fetch_assoc()) {
                                    
                                    if( $row["patient_gender"] == 'm' ){
                                        $gender = 'Male';
                                    }elseif( $row["patient_gender"] == 'f' ){
                                        $gender = 'Female';
                                    }
                                    
                                    if( !empty($row["imei"]) ){
                                        $patient_type = '<span class="patientType ihealth">Cellular User</span>';
                                    }else{
                                        $patient_type = '<span class="patientType regular">Regular User</span>';
                                    }
                                    
                                    echo '<tr class="patient_id patient_'.$row["patient_id"].'" id="patient_'.$row["patient_id"].'" data-patient-id="'.$row["patient_id"].'">';
                                    
                                    echo '<td class="enabled">' . $row["patient_fname"] . '</td>';
                                    echo '<td class="enabled">' . $row["patient_lname"] . '</td>';
                                    echo '<td class="enabled">' . $gender . '</td>';
                                    echo '<td class="enabled">' . $row["patient_dob"] . '</td>';
                                    echo '<td class="enabled">' . $row["cell"] . '</td>';
                                    echo '<td class="enabled">' . $patient_type . '</td>';
                                    
                                    echo '</tr>';
                                    
                                }
                            } else {
                                //echo "0 results";
                            }
                            
                            $conn->close();
                            
                        ?>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <?php
                
    	if( $_SESSION['userType'] == 'nurse' ){
                        
    		provider_bottom_nav();
                        
    	}elseif( $_SESSION['userType'] == 'doctor' ){
                        
    		physician_bottom_nav();
                        
    	}else{
                        
    		bottom_nav();
                        
    	}

    ?>
    
</body>
</html>