<?php
    
    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');
    
?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Dictation Notes</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
	    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
        
        
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript" src="https://kit.fontawesome.com/e424c30ea6.js" crossorigin="anonymous"></script>
        <script type="text/javascript" src="assets/js/faq.js"></script>
        <script type="text/javascript" src="assets/js/dictation-list.js"></script>
        
    </head>
    <body class="patien-data-table dashboard-area">
        
        <!-- Header -->
        <div class="header">
            
            <div class="container">
                <div class="col-md-12">
                    <div class="patient-info">
                        <h3 class="tabtitle">Dictation Notes</h3>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            
            <div class="menu-container">
                <div class="container">
                    <div class="col-md-12">
                    <ul class="dashboard-nav fix">
                        <li><a href="nurse_default.php">Home</a></li>
                        <li><a href="dashboard.php">Diagnosis</a></li>
                        <li class="current"><a href="dictation-notes.php">Dictation Notes</a></li>
                        <li><a href="vitals_dashboard.php">RPM</a></li>
                        <li><a href="ccm_dashboard.php">CCM</a></li>
                    </ul>
                    </div>
                </div>
            </div>
            
        </div>
        <!-- Header -->
        
        <div class="container">
            <div class="col-md-12">
                <div class="row">

                    <div class="dictation-list">
                        <div class="heading">
                            <div class="item">Patient information</div>
                            <div class="item">Dictated At</div>
                            <div class="item">Dictation</div>
                        </div>

                        <div class="body">
                            <?php

                                $sql = "SELECT CONCAT(`patients`.`patient_fname`, ' ', `patients`.`patient_lname`) AS `full_name`, `patients`.`patient_dob`, `patients`.`patient_gender`, `patients`.`cell`, notes_dictation.*, DATE_FORMAT(`notes_dictation`.`date`, '%b %d, %Y') AS `note_date`, DATE_FORMAT(`notes_dictation`.`date`, '%h:%i %p') AS `note_time` 
                                FROM `notes_dictation` 
                                JOIN `patients` ON `notes_dictation`.`patient_id` = `patients`.`patient_id` 
                                WHERE `notes_dictation`.`date` >= CURDATE() - INTERVAL 60 DAY ORDER BY `id` desc";
                                
                                $result = ddxrxDBConnect()->query($sql);

                                if ($result->num_rows > 0) {

                                    // output data of each row
                                    while($row = $result->fetch_assoc()) {
                                    
                                        $cell = $row["cell"];
                                        $formatted_cell = sprintf("(%s) %s-%s", substr($cell, 0, 3), substr($cell, 3, 3), substr($cell, 6));

                                        echo '<div class="row" id="dictation_'.$row["id"].'" data-id="'.$row["id"].'">';
                                            echo '<div class="item">
                                                    <ul>
                                                        <li><strong>Name:</strong> '.$row["full_name"].'</li>
                                                        <li><strong>Birth Date:</strong> '.date("F d, Y", strtotime($row["patient_dob"])).'</li>
                                                        <li><strong>Gender:</strong> '.($row["patient_gender"] == 'g' ? 'Male' : 'Female').'</li>
                                                        <li><strong>Phone:</strong> '.$formatted_cell.'</li>
                                                    </ul>
                                                </div>';

                                            echo '<div class="item">'.$row["note_date"].' - '.$row["note_time"].'</div>';

                                            echo '
                                                <div class="item">
                                                    <div class="view-container">
                                                        <p>'.$row["message"].'</p>
                                                        <a href="#" class="link edit">Edit</a>
                                                    </div>

                                                    <div class="edit-container">
                                                        <div class="aienhanced-placeholder"></div>
                                                        <textarea class="text-editor">'.$row["message"].'</textarea>
                                                        <a href="#" class="link save">Save</a>
                                                        <a href="#" class="link cancel">Cancel</a>
                                                        <i class="fa-solid fa-wand-magic-sparkles fa-beat-fade editor aienhanceBtn" data-add-id="'.$row['id'].'"></i>
                                                        <i class="fa-solid fa-spinner fa-spin-pulse aienhanceloading"></i>
                                                    </div>

                                                    <i class="fa-solid fa-spinner fa-spin-pulse plain aienhanceloading"></i>
                                                    <i class="fa-solid fa-wand-magic-sparkles fa-beat-fade plain aienhanceBtn" data-add-id="'.$row['id'].'"></i>
                                                </div>';

                                        echo '</div>';

                                    }

                                } else {
                                    
                                    echo '<div style="text-align:center; margin-top: 50px; font-size: 30px;">No dictation notes at this time, please come back later.</div>';

                                }

                                ddxrxDBConnect()->close();

                            ?>
                        </body>

                    </div>

                </div>
            </div>
        </div>
        
        <?php provider_bottom_nav(); ?>
        
    </body>
</html>