<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    session_start();
    //if((!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) && ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor')) {
    if(  !isset($_SESSION['userid']) && !isset($_SESSION['userType']) ){
        header("Location: provider_login.php");
        die();
    }
    
    date_default_timezone_set('America/Chicago');
    include ('includes/database_include.php');
    include('includes/functions.php');
    include('process/functions.php');
    
    $vitalFieldLables = new StdClass();
    $vitalFieldLables->systolicBP = 'Systolic BP';
    $vitalFieldLables->diastolicBP = 'Diastolic BP';
    $vitalFieldLables->heartRate = 'Heart Rate';
    $vitalFieldLables->respRate = 'Respiratory Rate';
    $vitalFieldLables->pulseOX = 'Pulse Ox';
    $vitalFieldLables->temp = 'Temperature';
    
    $wid = $_GET['wID'];
    $_SESSION['wID'] = $wid;
    $waitingroomQuery = "Select * from waiting_room left join patients on waiting_room.patient_id = patients.patient_id where waitingroom_id =".$wid;
    $waitingroomResult = mysqli_query($con, $waitingroomQuery);
    $waitingroom = mysqli_fetch_array($waitingroomResult);
    
    $_SESSION['dd_id']=$_GET['wID'];
    $_SESSION['ss'] = $waitingroom['symptoms'];
    $_SESSION['havingz'] = $waitingroom['havingz'];
    $_SESSION['denied'] = $waitingroom['denied'];
    $vitals = $waitingroom['vital_json'];
    $positive_diagnosis_id = json_decode($waitingroom['diagnosis_id']);
    $negative_diagnosis_id = json_decode($waitingroom['failed_diagnosis_id']);
    if($waitingroom['answers_per_diagnosis'] != "") {
        $answers_per_diagnosis = json_decode($waitingroom['answers_per_diagnosis']);
        $all_diagnosis = new stdClass();
        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
            $diagnosis_query = "Select * from differential_diagnoses where id='". $diagnosis_id ."' limit 1";
            $result_diagnosis_query = mysqli_query($con, $diagnosis_query);
            $diagnosis = mysqli_fetch_array($result_diagnosis_query);
            $all_diagnosis->$diagnosis_id = $diagnosis;
        }
    }
    

    $user_query = "SELECT * FROM all_users WHERE userid='".$_SESSION['userid']."'";
	$run_query = mysqli_query($con, $user_query);
	$count = mysqli_num_rows($run_query);
	$data = mysqli_fetch_array($run_query);
	
	if($count==1) {
		
		if($data['user_type'] == 2) {
			$_SESSION['user_type'] = "doctor";
		} else if($data['user_type'] == 3) {
			$_SESSION['user_type'] = "patient";
		} else if($data['user_type'] == 4) {
			$_SESSION['user_type'] = "nurse";
		}
	}

?>
<!DOCTYPE html>
<html>
    <head>
        <title>Artificial Intelligence Software for Medicine: DDxRx Software</title>

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/search-style-reports.css">
        <link rel="stylesheet" type="text/css" href="assets/css/single-notes-ai.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
        <script type="text/javascript" src="assets/js/ddx_reports_ui.js"></script>
        
        <script>
            jQuery(document).ready(function($){
                $('#submit').remove();
                $('.ui-grid-a').css("margin-top", "50px");
            });
        </script>
        
        <script>
            $(document).ready(function(){
                
                var jsonData = JSON.parse('<?php echo $waitingroom['note_selection_json']; ?>');
                
                // Additional Information
                if( jsonData.additional_info != undefined && jsonData.additional_info != '' ){
                    $('textarea[name="additional_info"]').text(jsonData.additional_info);
                }
                
                // Additional Treatment
                if( jsonData.additional_treatment != undefined && jsonData.additional_treatment != '' ){
                    $('textarea[name="additional_treatment"]').text(jsonData.additional_treatment);
                }
                
                if( jsonData.additional_treatment_1 != undefined && jsonData.additional_treatment_1 != '' ){
                    $('textarea[name="additional_treatment_1"]').text(jsonData.additional_treatment_1);
                }
                
                if( jsonData.additional_treatment_2 != undefined && jsonData.additional_treatment_2 != '' ){
                    $('textarea[name="additional_treatment_2"]').text(jsonData.additional_treatment_2);
                }
                
                if( jsonData.additional_treatment_3 != undefined && jsonData.additional_treatment_3 != '' ){
                    $('textarea[name="additional_treatment_3"]').text(jsonData.additional_treatment_3);
                }
                
                if( jsonData.additional_treatment_4 != undefined && jsonData.additional_treatment_4 != '' ){
                    $('textarea[name="additional_treatment_4"]').text(jsonData.additional_treatment_4);
                }
                
                if( jsonData.additional_treatment_5 != undefined && jsonData.additional_treatment_5 != '' ){
                    $('textarea[name="additional_treatment_5"]').text(jsonData.additional_treatment_5);
                }
                
                if( jsonData.additional_treatment_6 != undefined && jsonData.additional_treatment_6 != '' ){
                    $('textarea[name="additional_treatment_6"]').text(jsonData.additional_treatment_6);
                }
                
                if( jsonData.additional_treatment_7 != undefined && jsonData.additional_treatment_7 != '' ){
                    $('textarea[name="additional_treatment_7"]').text(jsonData.additional_treatment_7);
                }
                
                if( jsonData.additional_treatment_8 != undefined && jsonData.additional_treatment_8 != '' ){
                    $('textarea[name="additional_treatment_8"]').text(jsonData.additional_treatment_8);
                }
                
                if( jsonData.additional_treatment_9 != undefined && jsonData.additional_treatment_9 != '' ){
                    $('textarea[name="additional_treatment_9"]').text(jsonData.additional_treatment_9);
                }
                
                if( jsonData.additional_treatment_10 != undefined && jsonData.additional_treatment_10 != '' ){
                    $('textarea[name="additional_treatment_10"]').text(jsonData.additional_treatment_10);
                }
                
                // Checkbox
                // if( jsonData.checkbox_1_11 != undefined && jsonData.checkbox_1_11 != '' ){
                //     //$('#label_1_11').children('.check-box').addClass('checked');
                //     $('#label_1_11 .check-box').addClass('checked');
                //     $('#checkbox_1_11').prop('checked', true);
                // }
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_1_<?php echo $i; ?> != undefined && jsonData.checkbox_1_<?php echo $i; ?> != '' ){
                        $( '#label_1_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_1_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_2_<?php echo $i; ?> != undefined && jsonData.checkbox_2_<?php echo $i; ?> != '' ){
                        $( '#label_2_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_2_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_3_<?php echo $i; ?> != undefined && jsonData.checkbox_3_<?php echo $i; ?> != '' ){
                        $( '#label_3_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_3_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_4_<?php echo $i; ?> != undefined && jsonData.checkbox_4_<?php echo $i; ?> != '' ){
                        $( '#label_4_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_4_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_5_<?php echo $i; ?> != undefined && jsonData.checkbox_5_<?php echo $i; ?> != '' ){
                        $( '#label_5_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_5_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_1_<?php echo $i; ?> != undefined && jsonData.textfield_1_<?php echo $i; ?> != '' ){
                        $( '#textfield_1_<?php echo $i; ?>' ).val( jsonData.textfield_1_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_2_<?php echo $i; ?> != undefined && jsonData.textfield_2_<?php echo $i; ?> != '' ){
                        $( '#textfield_2_<?php echo $i; ?>' ).val( jsonData.textfield_2_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_3_<?php echo $i; ?> != undefined && jsonData.textfield_3_<?php echo $i; ?> != '' ){
                        $( '#textfield_3_<?php echo $i; ?>' ).val( jsonData.textfield_3_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_4_<?php echo $i; ?> != undefined && jsonData.textfield_4_<?php echo $i; ?> != '' ){
                        $( '#textfield_4_<?php echo $i; ?>' ).val( jsonData.textfield_4_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_5_<?php echo $i; ?> != undefined && jsonData.textfield_5_<?php echo $i; ?> != '' ){
                        $( '#textfield_5_<?php echo $i; ?>' ).val( jsonData.textfield_5_<?php echo $i; ?> );
                    }
                <?php } ?>
                
            });
        </script>
        
        <script>
        $(document).ready(function(){
            $('.each_diagnosis label').append('<div class="clear"></div>');
        });
        </script>
        
        <?php if( isset($_GET['preview']) && $_GET['preview'] == 'true' ){ ?>
            
            <script>
                $(document).ready(function(){
                    $('body').hide();
                    $('#missingDDs').submit();
                });
            </script>
            
        <?php } ?>
        
    </head>
    <body>
        
        <?php note_nav( $_GET['uid'] ); ?>
        
    	<div class="container">
    		<div class="col-md-12">
    		    
    		    <div class="edit-note-header">
    		        <h6>Edit Notes</h6>
    		        <!--<a href="notes-ai.php?id=<?php echo $_GET['uid']; ?>" class="go-back-button">Go Back</a>-->
    		    </div>
    		    
    			<div class="user-info-bar">
    				
    				<ul>
        				<li><img src="images/topbar/name.svg"> <span><strong>Name:</strong> <?php echo $waitingroom['patient_fname'].' '.$waitingroom['patient_lname']; ?></span></li>
        				<li><img src="images/topbar/dob.svg"> <span><strong>Date of Birth:</strong> <?php echo $waitingroom['patient_dob']; ?></span></li>
        				<li><img src="images/topbar/gender.svg"> <span><strong>Gender:</strong> <?php if($waitingroom['patient_gender'] == 'M' || $waitingroom['patient_gender'] == 'm'){ echo 'Male'; }else{ echo 'Female'; } ?></span></li>
        				<li><img src="images/topbar/mobile.svg"> <span><strong>Cell:</strong> <?php echo $waitingroom['cell']; ?></span></li>

        				<li class="right"><img src="images/topbar/calendar.svg"> <span><strong>Date of Encounter:</strong> <?php echo date_format(date_create($waitingroom['checkin_time']),"M/d/Y"); ?></span></li>
        				<li class="right"><img src="images/topbar/login.svg"> <span><strong>Encounter ID:</strong> <i class="encounter_id"><?php echo $waitingroom['waitingroom_id']; ?></i></span></li>
    				</ul>
    				<div class="clear"></div>
    
    			</div>
    			
    		</div>
    	</div>
        
        <div class="container optimized-container typography-entry">
            <div class="col-md-12">
                <div class="results-container provider">
                    <div class="chief_complaints">
                        <?php
                        if($waitingroom['chief_complaints'] != "") {
                        ?>
                            <h6>Chief Complaints:</h6>
                            <ul>
                                <?php
                                $chief_complaints = explode(";", $waitingroom['chief_complaints']);
                                $presentedString = "";
                                $count = 1;
                                $counter = count($chief_complaints);
                                foreach ($chief_complaints as $key => $value) {
                                    $count++;
                                    echo "<li> $value </li>";
                                    $presentedString .= $value;
                                    if ($count < $counter) {
                                        $presentedString .= ", ";
                                    } elseif ($count == $counter) {
                                        $presentedString .= " and ";
                                    }
                                }
                                ?>
                            </ul>
                
                            <h6>History of present illness:</h6>
                            <p>Patient presented with <?php echo $presentedString; ?></p>
                        <?php
                        } else {
                            echo "<center><h5>No patient data available!</h5></center>";
                            exit();
                        }
                        ?>
                    </div>
                    
                    <div class="diagnosis_and_symptoms">
                        <?php
                        $denied = [];
                        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
                            $diag = $all_diagnosis->$diagnosis_id;
                            echo "<h6>".$diag['name']."</h6>";
                            echo "Patient complained of having ".implode(", ", $answers->positives);
                            $denied = array_merge($denied, $answers->negatives);
                        }
                        ?>
                    </div>
                    <form id="missingDDs" action="preview-note-changes.php?wID=<?php echo $wid; ?>&uid=<?php echo $_GET['uid']; ?>" method="post" name="checkboxSelectSelected">
                        <div class="additional_info">
                            <label>
                                <h6>Additional Information</h6>
                                <textarea class="textarea" name="additional_info" placeholder="Type additional information..."></textarea>
                            </label>
                        </div>
                        <div class="checkbox-group">
                            <div class="review_of_system">
                                <h6>Review of System:</h6>
                                Patient denied having : <?php echo implode(", ", array_unique($denied)); ?>
                                <br/><br/>
                                <label>
                                    <div class="check-box checked"></div>
                                    <span>All system were reviewed and was found negative except the above in HPI.</span>
                                    <input type="checkbox" class="checkbox" name="review" value="checkbox" checked="checked">
                                    <div class="clear"></div>
                                </label>
                            </div>
                            <div class="vitals">
                                <h6>Vitals</h6>
                                <label>
                                    <div class="check-box checked"></div>
                                    <span>All vitals were reviewed.</span>
                                    <input type="checkbox" class="checkbox" name="vital" value="checkbox" checked="checked">
                                    <br>
                                    <div>
                                        <?php
                                        if($vitals != "") {
                                            $vitalArray = json_decode($vitals);
                                            foreach($vitalArray as $key => $value) {
                                                echo "<b class='vital-label'>".$vitalFieldLables->$key."</b> : ".$value."<br/>";
                                            }
                                        }
                                        ?>
                                    </div>
                                    <div class="clear"></div>
                                </label>
                            </div>
                            <div class="physical_exam">
                                <h6>Physical Exam:</h6>
                                <label>
                                    <div class="check-box checked"></div>
                                    <span>Approve normal physical exam</span>
                                    <input type="checkbox" class="checkbox" name="physical_exam" value="checkbox" checked="checked">
                                    <div class="clear"></div>
                                </label>
                            </div>
                        </div>
                        <?php
                        $negative_diagnosis_names = [];
                        
                        foreach($negative_diagnosis_id as $id) {
                            $diag = $all_diagnosis->$id;
                            $negative_diagnosis_names[] = $diag['name'];
                        }
                        if(sizeof($negative_diagnosis_names) > 0) {
                            echo "Patient less likely have ".implode(", ", $negative_diagnosis_names);
                            echo "<br/><br/>";   
                        }
                        
                        $i = 0;
                        $j = 0;
                        $return = "";
                        foreach($positive_diagnosis_id as $id) {
                            $i = $i + 1;
                            $decision_support_query = "Select * from decision_supports where differential_diagnose_id='".$id."' limit 1";
                            $result_decision_support = mysqli_query($con, $decision_support_query);
                            $decision_support = mysqli_fetch_array($result_decision_support);
                            $var = trim($decision_support['decisions_edited']);
                            $var = str_replace('</p>', '', $var);
                            $var = str_replace('<br /><br />', '<br />', $var);
                            $var = trim(html_entity_decode($var), " \t\n\r\0\x0B\xC2\xA0");
                            $var = RemoveBS($var);
                            $var = multiexplode(array("<br />", "<p>", "<br>"), $var);
                            $var = array_filter(array_map('trim', $var));
                            $diag = $all_diagnosis->$id;
                            $return .= '<div class="each_diagnosis">';
                            $return .= '<strong style="font-weight:700">' . $i . ' . ' . $diag['name'] . '</strong><br/>';
                            foreach ($var as $key => $value) {
                            
                                $pos = strpos($value, "**");
                                $posh = strpos($value, "##");
                                if (($pos === false) and ($posh === false)) {
                                    $j = $j + 1;
                                    
                                    $reved = ucfirst(str_replace("()", "<input class='textbox' id='textfield_".$i."_".$key."' type=text name='textfield_".$i."_".$key."' ><!--$j-->", "$value"));
                                    
                                    // $_SESSION['dataArray'][$key1][$key] = $reved;
                                    // // preg_replace('#\s*\[.+\]\s*#U', ' ', $rr)
                                    $return .= '<label for="checkbox_'.$i.'_'.$key.'" id="label_'.$i.'_'.$key.'">
                                                    <div class="check-box"></div>
                                                    <span class="inline">'.$reved.'</span>
                                                    <input class="checkbox" name="checkbox_'.$i.'_'.$key.'" type="checkbox" id="checkbox_'.$i.'_'.$key.'">
                                                </label>';
                                } else {
                                    if ($posh !== false) {
                                        $value = str_replace('##', '', $value);
                                        $return .= ucfirst(RemoveBS($value));
                
                                    } else {
                                        $value = str_replace('**', '', $value);
                                        $j = $j + 1;
                
                                        $reved = ucfirst(str_replace("()", "<input class='textbox' type='text' id='textfield_".$i."_".$key."' name='textfield_".$i."_".$key."'><!--$j-->", "$value"));
                                        $return .= '<label for="checkbox_'.$i.'_'.$key.'" id="label_'.$i.'_'.$key.'">
                                                        <div class="check-box checked"></div>
                                                        <span class="inline">'.$reved.'</span>
                                                        <input class="checkbox" name="checkbox_'.$i.'_'.$key.'" type="checkbox" checked>
                                                    </label>';
                                    }
                                }
                            }
                            $return .= '
                        <div class="additional_info">
                            <label>
                                <h6>Additional Treatment</h6>
                                <textarea class="textarea additional_treatment" name="additional_treatment_'.$i.'" placeholder="Type additional treatment..."></textarea>
                            </label>
                        </div>';
                            $return .= "</div>";
                        }
                        echo $return;
                        ?>
            
                        <input type="hidden" name="checkbox_selected">
                        
                        <?php if( $waitingroom['signed'] == false ){ ?>
                        
                            <input type="submit" name="Submit2" value="Submit" data-mini="true" data-theme="b" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">
                            <input type="submit" name="Submit" value="Next" data-theme="b" data-mini="true" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">
                            
                        <?php }else{ ?>
                        
                            <h6 style="margin-bottom:5px; line-height: 1.5em;">Note Signed</h6>
                            <p style="margin-top: 0px!important;">This note have already been signed and cannot be edited</p>
                            <input type="submit" name="Submit2" value="Submit" data-mini="true" data-theme="b" class="button large rounded solid gray" style="display:inline-block!important; width:auto!important; cursor: not-allowed" disabled="disabled">
                            <input type="submit" name="Submit" value="Next" data-theme="b" data-mini="true" class="button large rounded solid gray" style="display:inline-block!important; width:auto!important; cursor: not-allowed" disabled="disabled">
                        
                        <?php } ?>
                        
                    </form>		
            	    <a href="javascript:;"></a>
            	    <div class="clear" style="clear:both"></div>
        		</div>
            </div>
        </div>
        
    </body>
</html>