<?php

// Get Base URL
function theme_path_url(){
    $link = (!empty($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . '/';
    return $link;
}

// Get Meta Data
function header_meta( $header_title, $description = null, array $keyword = null, array $css = null, array $js = null ){
    
    if( $header_title != null || $header_title != '' ){ $header_title = $header_title.','; }
    if( $description != null || $description != '' ){ $description = $description.','; }
    if( $keyword != null || $keyword != '' ){ $keyword = $keyword.','; }
    if( $css != null || $css != '' ){ $css = $css.','; }
    if( $js != null || $js != '' ){ $js = $js; }
    
    return $header_title.$description.$keyword.$css.$js;
    
}

?>

<?php function get_header( $header_title, $description = null, array $keyword = null, array $css = null, array $js = null ){ ?>
    <!DOCTYPE html>
    <html>
    <head>
    	
    	<!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-3"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());
        
          gtag('config', 'UA-148409281-3');
        </script>
    	
    	<title>AI Based Health Care<?php if( $GLOBALS['title'] != '' ){ echo '- '.$GLOBALS['title']; } ?> </title>
    	
    	<?php if( $description != null || $description != '' ){ ?><meta name="description" content="<?php echo $description; ?>"><?php } ?>
        <?php if( $keyword != null || $keyword != '' ){ ?><meta name="keywords" content="<?php foreach ($keyword as $value) { echo $value.','; } ?>"><?php } ?>
    	<meta name="viewport" content="width=device-width, initial-scale=1">
    	
        <?php if( basename($_SERVER['REQUEST_URI']) == 'ios-launch.php' ){ include('header-ios-launch.php'); } ?>
        <?php if( basename($_SERVER['REQUEST_URI']) == 'search_dd.php' ){ include('header-search-dd.php'); } ?>
    
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/reset.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/grid.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/main-menu.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/slicknav.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/jquery.fancybox.min.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/easy-autocomplete.min.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/easy-autocomplete.themes.min.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/login-selector.css">
    	<link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/style.css">
    	<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
    	
    	<?php if( $css != null ){ ?>
    	    <?php foreach ($css as $value) { ?>
    	    
    	        <link rel="stylesheet" type="text/css" href="<?php echo theme_path_url(); ?>assets/css/<?php echo $value; ?>">
    	    
    	    <?php } ?>
    	<?php } ?>
        
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/jquery.min.js"></script>
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/jquery.waypoints.min.js"></script>
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/jquery.slicknav.js"></script>
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/jquery.fancybox.min.js"></script>
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/jquery-ui.min.js"></script>
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/jquery.easy-autocomplete.min.js"></script>
    	<script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/admin.js"></script>
    	<!--<script type="text/javascript" src="assets/js/init.js"></script>-->
        
        <?php if( $js != null ){ ?>
    	    <?php foreach ($js as $value) { ?>
    	    
    	        <script type="text/javascript" src="<?php echo theme_path_url(); ?>assets/js/<?php echo $value; ?>"></script>
    	    
    	    <?php } ?>
    	<?php } ?>
        
        <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', 
            layout:     google.translate.TranslateElement.InlineLayout.SIMPLE,
            autoDisplay: false, 
            includedLanguages: ''}, 'google_translate_element');}
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        
        <style type="text/css">
            body{
                top: 0px!important;
            }
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }
            #goog-gt-tt{
                display:none!important;
            }
            #google_translate_element{
                position: fixed; left:20px; top: 20px; z-index: 9999999;
            }
        </style>
        
    </head>
    <body>
    
    <div id="google_translate_element"></div>
    
	<!-- Nav Menu -->
	<div class="nav-menu-container">
		<ul class="nav-menu">
			<li><a href="<?php echo theme_path_url(); ?>index.php">Home</a></li>
			<li><a href="<?php echo theme_path_url(); ?>products.php">Products</a></li>
			<li><a href="<?php echo theme_path_url(); ?>contact.php">Contact</a></li>
		</ul>
	</div>
	<!-- Nav Menu -->
    <?php if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {  ?>
	<!-- Header Bar -->
	<div class="header-bar">
		<div class="container">
		
		<div class="container">

			<!-- Contacts -->
			<div class="col-md-7">
				<div class="contact">
					<span><img src="<?php echo theme_path_url(); ?>assets/images/icons/mail.svg"><strong>support@ddxrx.com</strong></span>
					<span><img src="<?php echo theme_path_url(); ?>assets/images/icons/phone.svg"><strong>(228) 202 7872</strong></span>
					<div class="clear"></div>
				</div>
			</div>
			<!-- Contacts -->

			<!-- Buttons -->
			<div class="col-md-5 user-buttons">
				<a href="<?php echo theme_path_url(); ?>provider_login.php" class="button medium border rounded white provider_login">Provider Login</a>
				<a href="<?php echo theme_path_url(); ?>ios-launch.php" class="button medium solid rounded yellow patient_login">Patient Login</a>
			</div>
			<!-- Buttons -->

		</div>

		</div>
	</div>
	<div class="clear"></div>
	<!-- Header Bar -->
	
    <?php } else { ?>
    
    <!-- Header -->
    <div class="header-bar">
		<div class="container optimized-container">

			<!-- Contacts -->
			<div class="col-md-8">
				<div class="contact">
					<span><img src="<?php echo theme_path_url(); ?>images/icons/mail.svg"><strong>support@ddxrx.com</strong></span>
					<span><img src="<?php echo theme_path_url(); ?>images/icons/phone.svg"><strong>(228) 202 7872</strong></span>
					<div class="clear"></div>
				</div>
			</div>
			<!-- Contacts -->

			<!-- Buttons -->
			<div class="col-md-4" style="text-align: right;">
	        	<a href="<?php echo theme_path_url(); ?>search_dd.php" class="button medium solid rounded yellow" rel="external" style="width:auto!important!; display:inline-block!important">Search</a>
	        	<a href="<?php echo theme_path_url(); ?>edit-profile.php" class="button medium border rounded white" rel="external" style="width:auto!important!; display:inline-block!important">Account</a>
	        	<a href="<?php echo theme_path_url(); ?>logout.php" class="button medium border rounded white" rel="external" style="width:auto!important!; display:inline-block!important">Logout</a>
	    	</div>
			<!-- Buttons -->
				
			<div class="clear"></div>
		</div>
	</div>
    <!-- Header -->
    <?php
    }
    ?>

	<!-- Mid Header -->
	<div class="container optimized-container">
		<div class="header-mid-bar">

			<!-- Logo -->
			<div class="col-md-3">
				<a href="<?php echo theme_path_url(); ?>"><img src="<?php echo theme_path_url(); ?>assets/images/logo.png" class="logo"></a>
			</div>
			<!-- Logo -->

			<!-- Main Menu -->
			<div class="menu-container">
				<ul class="main-menu">
					<li><a href="<?php echo theme_path_url(); ?>index.php">Home</a></li>
        			<li><a href="<?php echo theme_path_url(); ?>products.php">Products</a></li>
        			<li><a href="<?php echo theme_path_url(); ?>about.php">About</a></li>
        			<li><a href="<?php echo theme_path_url(); ?>contact.php">Contact</a></li>
				</ul>
			</div>
			<!-- Main Menu -->

		<div class="clear"></div>
		</div>
	</div>
	<!-- Mid Header -->
<?php } ?>



<?php function get_footer(){ ?>
    
    	<!-- Footer -->
	<section class="pt-100 pb-100 footer-container">
		<div class="container optimized-container">

			<div class="col-md-8">
				<div class="row">

					<div class="col-md-3">
						<h6 class="title-bar">Learn More</h6>
						<ul>
							<li><a href="<?php echo theme_path_url(); ?>privacy_policy.php">Privacy Policy</a></li>
							<li><a href="<?php echo theme_path_url(); ?>terms_condition.php">Terms and Conditions</a></li>
							<li><a href="<?php echo theme_path_url(); ?>nda.php">Non-Disclosure Agreement</a></li>
							<li><a href="<?php echo theme_path_url(); ?>medical-disclaimer.php">Medical Disclaimer</a></li>
						</ul>
					</div>

					<div class="col-md-3">
						<h6 class="title-bar">Products</h6>
						<ul>
							<li><a href="#">Products</a></li>
						</ul>
					</div>

					<div class="col-md-3">
						<h6 class="title-bar">Support</h6>
						<ul>
							<li><a href="contact.php">Contact us</a></li>
						</ul>
					</div>

					<div class="col-md-3">
						<ul class="footer-social">
							<li><a href="#"><img src="<?php echo theme_path_url(); ?>assets/images/icons/svg-social/facebook.svg"></a></li>
							<li><a href="#"><img src="<?php echo theme_path_url(); ?>assets/images/icons/svg-social/twitter.svg"></a></li>
							<li><a href="#"><img src="<?php echo theme_path_url(); ?>assets/images/icons/svg-social/instagram.svg"></a></li>
							<li><a href="#"><img src="<?php echo theme_path_url(); ?>assets/images/icons/svg-social/linkedin.svg"></a></li>
							<li><a href="#"><img src="<?php echo theme_path_url(); ?>assets/images/icons/svg-social/pinterest.svg"></a></li>
							<li><a href="#"><img src="<?php echo theme_path_url(); ?>assets/images/icons/svg-social/youtube.svg"></a></li>
						</ul>
						<div class="clear"></div>
						<p>&copy; 2019 All Rights Reserved - United States Patent US 9,536,051,B1 - DDxRx AI. Lighthouse Associates, PLLC - 1120 Beach Blvd, Biloxi, MS 39530.</p>
						<div class="clear"></div>
					</div>

				<div class="clear"></div>
				</div>
			</div>

			<div class="clear"></div>
		</div>
	</section>
	<!-- Footer -->

    <?php if( basename($_SERVER['REQUEST_URI']) == 'ios-launch.php' ){ include('footer-ios-launch.php'); } ?>
    
</body>
</html>
    
<?php } ?>