<?php

/**
 * REQUIRE FUNCTIONS
 */
include('process/functions.php');

/**
 * REQUIRE PDF LIBRARY
 * 
 * FPDF is a PHP class which allows to generate PDF files with pure PHP,
 * that is to say without using the PDFlib library. F from FPDF stands for Free:
 * you may use it for any kind of usage and modify it to suit your needs.
 */
require('lib/fpdf.php');

    function additional_items(){
        
        $resultArr = array();
        $tempArr = array();
        $version = get_version();
        $sql = "SELECT pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender, cuser.imei FROM patients as pat LEFT JOIN cardiowell_users as cuser ON pat.patient_id = cuser.patient_id WHERE pat.groupid = '$version' AND cuser.imei IS NOT NULL GROUP BY pat.patient_id ORDER BY cardiowellid DESC";
        $result = ddxrxDBConnect()->query($sql);

        if ($result->num_rows > 0) {
            // output data of each row
            while($row = $result->fetch_assoc()) {
                
                if( $row["patient_gender"] == 'm' ){
                    $gender = 'Male';
                }elseif( $row["patient_gender"] == 'f' ){
                    $gender = 'Female';
                }
                
                $tempArr = array(
                    'patient_fname' => $row['patient_fname'],
                    'patient_lname' => $row['patient_lname'],
                    'patient_gender' => $gender,
                    'patient_dob' => $row['patient_dob'],
                    'cell' => format_phone($row["cell"])
                );
                
                array_push($resultArr, $tempArr);
                
            }
        }
        
        ddxrxDBConnect()->close();
        
        return $resultArr;
    
    }

class PDF extends FPDF {
    
    // Page header
    function Header() {
        
        // Set font family to Arial bold 
        $this->SetFont('Arial', '', 10);
        
        $this->SetFillColor(255,255,255);
        
        // Add logo to page
        $this->Image('assets/images/logo.png', 150, 10, 50);
        
        // Bill From
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(50, 5, 'Company Address:', '0', 2, 'L');
        
        // From Address
        $this->SetFont('Arial', '', 10);
        $this->MultiCell(50, 5, 'American Healthcare AI, LLC 1120 Beach Blvd; Biloxi; MS 39530', '0', 2, 'L');
        
        // Line break
        $this->Ln(5);

    }
  
    // Page footer
    function Footer() {
          
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
          
        // Arial italic 8
        $this->SetFont('Arial','I',8);
          
        // Page number
        $this->Cell(0,10,'Page ' . $this->PageNo() . '/{nb}',0,0,'C');
    }
    
    // Content
    function contentTable(){
        
        $total_amount_final = 0;
        $total_custom_items = 0;
        
        $this->SetFont('Arial', 'B', 10);
        $this->SetFillColor(255, 0, 51);
        
        // Tick Border
        $this->SetFillColor(85, 85, 85);
        $this->Cell(0, 3, '', 't', 2, 'r', true);
        
        // Table Header
        $this->Cell(40, 10, 'First Name', 0, 0, 'L');
        $this->Cell(40, 10, 'Last Name', 0, 0, 'L');
        $this->Cell(40, 10, 'Gender', 0, 0, 'L');
        $this->Cell(30, 10, 'Age', 0, 0, 'L');
        $this->Cell(40, 10, 'Phone', 0, 0, 'L');
        $this->Ln();
        
        // Output Thick Border
        $this->SetFillColor(85, 85, 85);
        $this->Cell(0, 0, '', 't', 2, 'r', true);
        $this->Ln('7');
        
        
        // Table Content
        $this->SetFont('', '', '');
        
        // Dynamic Items
        $custom_item = additional_items();
        
        if( $custom_item != '' ){
            for ($i = 0; $i < count($custom_item); $i++) {
                
                $this->Cell(40, 10, $custom_item[$i]['patient_fname'], 0, 0, 'L');
                $this->Cell(40, 10, $custom_item[$i]['patient_lname'], 0, 0, 'L');
                $this->Cell(40, 10, $custom_item[$i]['patient_gender'], 0, 0, 'L');
                $this->Cell(30, 10, $custom_item[$i]['patient_dob'], 0, 0, 'L');
                $this->Cell(40, 10, $custom_item[$i]['cell'], 0, 0, 'L');
                $this->Ln('11');
                
                // Output Thick Border
                $this->SetFillColor(204, 204, 204);
                $this->Cell(0, 0, '', 't', 2, 'r', true);
                $this->Ln('5');
            
            }
        }
        
    }
    
}


$pdf = new PDF();

// Set Title
$pdf->SetTitle('Patients Records List');

// Define alias for number of pages
$pdf->AliasNbPages();
$pdf->AddPage();

// Add Content
$pdf->contentTable();

//Output the file as a PDF
$pdf->Output();






    // $custom_item = additional_items();
        
    // if( $custom_item != '' ){
    //     for ($i = 0; $i < count($custom_item); $i++) {
                
    //         // $this->Cell(80, 5, 'No description', 0, 0);
    //         // $this->Cell(45, 5, $custom_item[$i]->patient_fname, 0, 0, 'C');
    //         // $this->Cell(20, 5, $custom_item[$i]->patient_fname, 0, 0, 'C');
    //         // $this->Cell(20, 5, '$00', 0, 0, 'C');
    //         // $this->Cell(25, 5, '$00', 0, 0, 'C');
    //         // $this->Ln('15');
            
    //         echo $custom_item[$i]['patient_fname'];
            
    //     }
    // }






?>