<?php

header('Content-type: application/json');

include('functions.php');

$groupid = get_version();

// Assuming you want to handle pagination and filtering
if( isset($_POST['length']) || isset($_POST['start']) || isset($_POST['search']['value']) ){
    $limit = $_POST['length'];
    $start = $_POST['start'];
    $searchValue = $_POST['search']['value'];
    $draw = $_POST['draw'];
}else{    
    $start = '0';
    $limit = '1000';
    $searchValue = '';
    $draw = 0;
}

if( isset($_GET['month']) && isset($_GET['year']) ){

    $month = $_GET['month'];
    $year = $_GET['year'];

}elseif(isset($_POST['month']) && isset($_POST['year'])) {

    $month = $_POST['month'];
    $year = $_POST['year'];

}else{

    $month = intval(date("n"));
    $year = intval(date("Y"));

}

// Month format MM to MMMM


$sql = "SELECT * FROM cardiowell_users INNER JOIN patients ON cardiowell_users.patient_id = patients.patient_id WHERE cardiowell_users.type = 'bp' AND patients.groupid = '$groupid'";

// Apply search filter if any
if (!empty($searchValue)) {
    $sql .= " AND (patients.patient_fname LIKE '%" . $searchValue . "%' OR patients.patient_lname LIKE '%" . $searchValue . "%')";
}

$sql .= " LIMIT $start, $limit";

$result = ddxrxDBConnect()->query($sql);

$data = array();
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Prepare data
        $data[] = array(
            $row["patient_lname"],
            $row["patient_fname"],
            ($row["patient_gender"] == 'm' || $row["patient_gender"] == 'M') ? 'Male' : 'Female',
            $row["patient_dob"],
            'N/A',
            get_bp_count($row["patient_id"], $month, $year),
            session_time($row["patient_id"], $month, $year, '20min'),
            exceeded_time($row["patient_id"], $month, $year, 'excess')
        );
    }
}

// Get total Record Count
$sqlCount = "SELECT COUNT(*) AS count FROM cardiowell_users INNER JOIN patients ON cardiowell_users.patient_id = patients.patient_id WHERE cardiowell_users.type = 'bp' AND patients.groupid = '$groupid'";
if (!empty($searchValue)) {
    $sqlCount .= " AND (patients.patient_fname LIKE '%" . $searchValue . "%' OR patients.patient_lname LIKE '%" . $searchValue . "%')";
}
$result = ddxrxDBConnect()->query($sqlCount);
if ($result && $row = $result->fetch_assoc()) {
    $totalRecords = $row["count"];
} else {
    $totalRecords = '0';
}
ddxrxDBConnect()->close();

// Prepare response
$response = array(
    "draw" => intval($draw),
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalRecords, // Assuming no filtering at the moment
    "data" => $data,
    "month" => date("F", mktime(0, 0, 0, $month, 1)),
    "year" => $year
);

echo json_encode($response);