<?php
    
    // Include Autoloader
    // require __DIR__ . '/../vendor/autoload.php';

    // use Firebase\JWT\JWT;
    // use Firebase\JWT\Key;

    date_default_timezone_set('America/Chicago');
    
    global $callarray;
    $callarray = [];
    
    /**
    * Main Connection
    * This will return the connection status
    */
    function ddxrxDBConnect( $database = 'telemedicine' ){
        
        // $servername = "emperium";
        // $username = "root";
        // $password = "iaiteoa";
        // $dbname = $database;

        $servername = "localhost";
        $username = "ddxrx_patient";
        $password = "Coastpcp%003";
        $dbname = $database;
        
        // Create connection
        $conn = new mysqli($servername, $username, $password, $dbname);
        
        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        return $conn;
        
    }

    /**
     * ASSET VERSION
     * Use this function to add asset version, this will eliminate the need of clearing cache
     * Update asset version each time a new file in the assets folder gets an update
    */
    if( !function_exists('getAssetVersion') ){
        function getAssetVersion(){
            return '?v=1.1.29';
        }
    }
    
    /**
    * Get Access Token
    * This will return the access token from the database
    */
    function get_access_token( $user_id = null ){
        
        if( isset($user_id) ){
            
            $sql_user = "SELECT * FROM all_users WHERE userid = '$user_id'";
            $result_user = mysqli_query(ddxrxDBConnect(), $sql_user);
            $row_check = mysqli_fetch_assoc($result_user);
            $result = $row_check['access_token'];
            
            mysqli_close(ddxrxDBConnect());
            
            return $result;
            
        }
        
    }
    
    
    /**
    * Token Decoder
    *
    */
    function authDecoder( $token = null ){
        
        if( isset($token) ){
            
            //$token = 'Basic UHJpbmNlMTo2YWI2NDEzMWMxOTViODk3OTlhNTc5YjMwMzk1Nz1hYzoxMDAwMDg6MTYzMjM2NDA3Ny4zNjY3NzI3';
            $token = explode(" ", $token); # Split the token by spaces
            $token = $token[1]; # Get the 2nd index which contains purely the base64 code
            $token = base64_decode($token);
            $token = explode(":", $token);

            $username = $token[0];
            $password = $token[1];
            $group_id = $token[2];
            $timer = $token[3];
            
            
            $current_time = microtime(true);
            
            $result_time = $current_time - $timer;
            
            $sql = "SELECT * FROM all_users WHERE username = '$username' AND password = '$password' AND groupid = '$group_id'";
            $result = ddxrxDBConnect()->query($sql);
            $row = $result -> fetch_assoc();
    
            if( $result_time > 21600 ){
                
                return false;
            
            }elseif( $row['userid'] == '' ){
                
                return false;
                
            }else{
                
                return true;
            }
        
        }else{
            
            return false;
            
        }
        
    }
    
    
    /**
	* Send data to any API
	* This will send any data to any API using curl
	* 
	* Parameters are URL and Data
	* URL = Can be HTTP or HTTPS domain name
    * Data = should be in array format
    * 
    * It returns a json encoded data
    * 
	*/
    function sendtoAPI( $url = null, $data = [], $token = null ){
        if( isset($url) && isset($data) ){
            
            // Create a new cURL resource
            $ch = curl_init($url);
            
            $payload = json_encode($data);
            
            // Attach encoded JSON string to the POST fields
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            
            // Set the header
            if( isset($token) ){
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type:application/json',
                    'Authorization:'.$token
                ));
            }else{
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            }
            
            // Return response instead of outputting
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            // Execute the POST request
            $api_result = curl_exec($ch);
            
            // Close cURL resource
            curl_close($ch);
            
            $api_result = json_decode($api_result);
            $result = $api_result;
            
            return $result;
            
        }
    }


    function get_patient_id(){
        ob_start();
        session_start();
        include ('../includes/database_include.php');

        $patient_id = null;
        if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
            $patient_id = $_SESSION['patient_id'];
        } else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
            $patient_id = $_GET['id'];
        }
        
        return $patient_id;
    }
    
    // function get_version( $field = null ){
        
    //     $currentUrl = $_SERVER['HTTP_HOST'];
    //     $eDom = explode('.', $_SERVER['HTTP_HOST']);
    //     //return $eDom[0];
        
    //     $sql = "SELECT * FROM version WHERE url = '$currentUrl'";
        
    //     $result = ddxrxDBConnect()->query($sql);
    //     $row = $result->fetch_assoc();
        
    //     if( isset($field) ){
    //         $output = $row[$field];
    //     }else{
    //         $output = $row['version_id'];
    //     }
        
    //     return $output;
        
    // }

    function get_version( $field = null ){
        
        $currentUrl = $_SERVER['HTTP_HOST'];
        $eDom = explode('.', $_SERVER['HTTP_HOST']);
    
        $sql = "SELECT * FROM version WHERE url = '$currentUrl'";
        $result = ddxrxDBConnect()->query($sql);
    
        // Check if a row is returned from the query
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
    
            if( isset($field) ){
                $output = isset($row[$field]) ? $row[$field] : null;
            } else {
                $output = $row['version_id'];
            }
    
            return $output;

        }else{
    
            // Handle the case where no row is found
            return null;
        
        }

    }
    
    function create_waitingroom(  $user_id = null, $remember_me = false ){
        
        $conn = ddxrxDBConnect();
        
        // Generate GUID based on user time of login
        $uniqueid = uniqid(rand(), true);
        $guid = md5( $user_id . $uniqueid );
        
        // Assosiative array to get patient ID
        $sql = "SELECT * FROM patients WHERE user_id = '$user_id'";
        $result = mysqli_query(ddxrxDBConnect(), $sql);
        $row = mysqli_fetch_assoc($result);
        
        $patient_id = $row['patient_id'];
        $group_id = $row['groupid'];
        $patient_name = $row['patient_fname'].' '.$row['patient_lname'];
        $returning = '1';
        $checkin_time = date("Y-m-d H:i:s");
        
        // Create the waiting room ID
        $waitingroom_sql = "INSERT INTO waiting_room(waitingroom_guid, patient_id, patient_name, is_returning_patient, checkin_time, groupid) values('".$guid."', '".$patient_id."', '".$patient_name."', ".$returning.", '".$checkin_time."', '".$group_id."')";
        
        if (mysqli_query($conn, $waitingroom_sql)) {
            
            $return_result = json_encode([
                'msg' => 'success',
                'waitingroom_id' => mysqli_insert_id($conn),
                'checkin_time' => $checkin_time,
                'guid' => $guid
            ]);
            
        } else {
        
            $return_result = json_encode([
                'msg' => 'error',
                'sql_query' => $waitingroom_sql,
                'error_message' => mysqli_error(ddxrxDBConnect()),
            ]);
          
        }
        
        return $return_result;
        
        mysqli_close(ddxrxDBConnect());
        
    }
    
    function getpatientInfo( $user_id = null, $field = null ){
    
        if( isset($field) ){
        
            $sql = "SELECT * FROM patients WHERE user_id = '$user_id'";
            $result = ddxrxDBConnect()->query($sql);
            $row = $result->fetch_assoc();
            
            //return $row['patient_fname'];
            return $row[$field];
        
        }
        
    }
    
    function getPatientInfo_pid( $patient_id = null, $field = null ){
    
        if( isset($field) ){
        
            $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id'";
            $result = ddxrxDBConnect()->query($sql);
            $row = $result->fetch_assoc();
            
            //return $row['patient_fname'];
            return $row[$field];
        
        }
        
    }
    
    // function to get user type by user id
    function get_usertype($searchItem, $type = 'userid'){

        // fetch associated user type
        if( $type == 'userid' ){
            $sql = "SELECT `user_type` FROM `all_users` WHERE `userid` = '$searchItem'";
        }elseif( $type == 'username' ){
            $sql = "SELECT `user_type` FROM `all_users` WHERE `username` = '$searchItem'";
        }

        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();

        // Check if it returns a value
        if( !empty($row['user_type']) ){

            if( $row['user_type'] == '1' ){
                $output = 'admin';
            }elseif( $row['user_type'] == '2' ){
                $output = 'physician';
            }elseif( $row['user_type'] == '3' ){
                $output = 'patient';
            }elseif( $row['user_type'] == '4' ){
                $output = 'nurse';
            }

        }else{
            $output = 'not_found';
        }

        return $output;

    }

    function getUserInfo($options){

        /**
         * OPTIONS Parameter
         * get_by - ( Set get option to select data based on ) username | patient_id | user_id
         * field - Output what ever field is available in the database column for all_user and patients table
         * identifier - Set the value
         */
        
        $options = array_replace(
            array(
                'debug_mode' => false,
                'get_by' => null,
                'identifier' => null,
                'field' => null,
            ), $options
        );

        
        if( isset($options['get_by']) && isset($options['field']) && isset($options['identifier']) ){
            
            if( get_usertype($options['identifier'], 'username') != 'not_found' ){

                $identifier = $options['identifier'];
                $field = $options['field'];
                
                if( $options['get_by'] == 'username' ){
                    
                    //$sql = "SELECT * FROM `all_users` INNER JOIN patients ON all_users.userid = patients.user_id WHERE all_users.username = '$identifier'";
                    if( get_usertype($identifier, 'username') == 'patient' ){
                        $sql = "SELECT all_users.*, patients.patient_fname as `first_name`, patients.patient_lname as `last_name`, patients.patient_id as `patient_id` FROM `all_users` INNER JOIN `patients` ON all_users.userid = patients.user_id WHERE all_users.username = '$identifier'";
                    }elseif( get_usertype($identifier, 'username') == 'physician' ){
                        $sql = "SELECT all_users.*, physician.physician_fname as `first_name`, physician.physician_lname as `last_name`, physician.id as `physician_id` FROM `all_users` INNER JOIN `physician` ON all_users.userid = physician.user_id WHERE all_users.username = '$identifier'";
                    }elseif( get_usertype($identifier, 'username') == 'nurse' ){
                        $sql = "SELECT all_users.*, nurse.nurse_fname as `first_name`, nurse.nurse_lname as `last_name`, nurse.id as `nurse_id` FROM `all_users` INNER JOIN `nurse` ON all_users.userid = nurse.user_id WHERE all_users.username = '$identifier'";
                    }

                    $result = ddxrxDBConnect()->query($sql);
                    $row = $result->fetch_assoc();
                    
                }elseif( $options['get_by'] == 'user_id' ){
                    
                    //$sql = "SELECT * FROM `all_users` INNER JOIN patients ON all_users.userid = patients.user_id WHERE all_users.userid = '$identifier'";
                    if( get_usertype($identifier, 'username') == 'patient' ){
                        $sql = "SELECT all_users.*, patients.patient_fname as `first_name`, patients.patient_lname as `last_name`, patients.patient_id as `patient_id` FROM `all_users` INNER JOIN `patients` ON all_users.userid = patients.user_id WHERE all_users.userid = '$identifier'";
                    }elseif( get_usertype($identifier, 'username') == 'physician' ){
                        $sql = "SELECT all_users.*, physician.physician_fname as `first_name`, physician.physician_lname as `last_name`, physician.id as `physician_id` FROM `all_users` INNER JOIN `physician` ON all_users.userid = physician.user_id WHERE all_users.userid = '$identifier'";
                    }elseif( get_usertype($identifier, 'username') == 'nurse' ){
                        $sql = "SELECT all_users.*, nurse.nurse_fname as `first_name`, nurse.nurse_lname as `last_name`, nurse.id as `nurse_id` FROM `all_users` INNER JOIN `nurse` ON all_users.userid = nurse.user_id WHERE all_users.userid = '$identifier'";
                    }

                    $result = ddxrxDBConnect()->query($sql);
                    $row = $result->fetch_assoc();
                    
                }elseif( $options['get_by'] == 'patient_id' ){
                    
                    $sql = "SELECT all_users.*, patients.patient_fname as `first_name`, patients.patient_lname as `last_name`, patients.patient_id as `patient_id` FROM `all_users` INNER JOIN `patients` ON all_users.userid = patients.user_id WHERE patients.patient_id = '$identifier'";
                    $result = ddxrxDBConnect()->query($sql);
                    $row = $result->fetch_assoc();
                    
                }
                
                if ($row !== null) {
                    if ($options['debug_mode'] == true) {
                        $output = var_dump($row);
                    } else {
                        $output = $row[$field];
                    }
                } else {
                    $output = null; // or any default value that you want to set
                }

            }else{

                $output = 'Error: User not found';
            
            }
            
        }else{

            $output = 'Error: Missing Parameters';
            
        }
        
        return $output;
        
    }
    
    function randomIDGenerator( $addedVariable = null ){

    	if( $addedVariable != null || !empty($addedVariable) ){ $addedVariable = $addedVariable; }else{ $addedVariable = ''; }
    
    	$result = md5(time().$addedVariable);
    	$result = md5($result);
    	$result = preg_replace("/[^0-9]/", "", $result );
    	$result = mb_strimwidth($result, 0, 8, "");
    
    	return $result;

    }
    
    // function format_phone($phone){
        
    //     $phone = preg_replace("/^\d/", "", $phone);
        
    //     $phone = str_replace(" ","", $phone);
    //     $phone = str_replace("+","", $phone);
    //     $phone = str_replace("(","", $phone);
    //     $phone = str_replace(")","", $phone);
    //     $phone = str_replace("-","", $phone);
        
    //     if(strlen($phone) == 7)
    //         return preg_replace("/(\d{3})(\d{4})/", "$1-$2", $phone);
    //     elseif(strlen($phone) == 9)
    //         return preg_replace("/(\d{3})(\d{3})(\d{3})/", "$1-$2-$3", $phone);
    //     elseif(strlen($phone) == 10)
    //         return preg_replace("/(\d{3})(\d{3})(\d{4})/", "$1-$2-$3", $phone);
    //     elseif(strlen($phone) == 12)
    //         return preg_replace("/(\d{3})(\d{3})(\d{4})/", "$1-$2-$3-$4", $phone);
    //     else
    //         return $phone;
    // }
    
    function format_phone($phone){
        
        $phone = preg_replace("/^\d/", "", $phone);
        
        $phone = str_replace(" ","", $phone);
        $phone = str_replace("+","", $phone);
        $phone = str_replace("(","", $phone);
        $phone = str_replace(")","", $phone);
        $phone = str_replace("-","", $phone);
        
        if(strlen($phone) == 7)
            return preg_replace("/(\d{3})(\d{4})/", "$1-$2", $phone);
        elseif(strlen($phone) == 9)
            return preg_replace("/(\d{3})(\d{3})(\d{3})/", "$1-$2-$3", $phone);
        elseif(strlen($phone) == 10)
            return preg_replace("/(\d{3})(\d{3})(\d{4})/", "$1-$2-$3", $phone);
        elseif(strlen($phone) == 12)
            return preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})/", "$1-$2-$3-$4", $phone);
        else
            return $phone;
    }
    
    function md5_hex_to_dec($hex_str){
        $arr = str_split($hex_str, 4);
        foreach ($arr as $grp) {
            $dec[] = str_pad(hexdec($grp), 5, '0', STR_PAD_LEFT);
        }
        return implode('', $dec);
    }
    
    // Video Call Button
    function video_call( $patientId = null, $patientPhone = null ){
        
        $patientIdRaw = md5_hex_to_dec(md5( $patientId ));
        
        $patientPhone = str_replace(' ', '', $patientPhone);
        $patientPhone = str_replace('+', '', $patientPhone);
        
        global $callarray;
        
        if( !empty($patientId) || $patientId != null ){
            
            $sql = "SELECT * FROM `video_call` WHERE  patient_id = '$patientIdRaw' AND action = 'startcall' ORDER BY call_date DESC LIMIT 1";
            
            $result = ddxrxDBConnect()->query($sql);
            
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    
                    if( $row["action"] == 'startcall' ){
                        if( !in_array( $row["room_id"], $callarray) ){
                            
                            $callarray[] = $row["room_id"];
                            $output = '<a href="javascript:;" class="call_button video-call waiting" data-link="https://clinicians.space/?room='.$row["room_id"].'" data-room-id="'.$row["room_id"].'" data-name="'.$row["patient_name"].'" data-phone="+'.$patientPhone.'">Video Call</a>';
                            
                        }
                    }
                    
                }
            }else{
                $output = '';
            }
            
            ddxrxDBConnect()->close();
            
            return $output;
            
        } // End if not null or empty
        
    } // End function
    
    function call_request( $patientId = null ){
        if( !empty($patientId) || $patientId != null ){
        
            $sql = "SELECT * FROM `call_request` WHERE patient_id = '$patientId' LIMIT 1";
            //$sql = "SELECT * FROM `call_request` WHERE `time_of_call` >= CURRENT_TIMESTAMP - INTERVAL 5 MINUTE AND patient_id = '$patientId' ORDER BY time_of_call DESC LIMIT 1";
            $result = ddxrxDBConnect()->query($sql);
            
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {

                $output = '<a href="javascript:;" class="call_button waiting phone-call-dashboard">Phone Call</a>';
                    
                }
            }
            
            ddxrxDBConnect()->close();
            
            return $output;
            
        }
    }
    
    // Get Physician ID
    function getPhysician($physician_id){
        
        //$users = "SELECT physician.id, physician.user_id, physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where userid = '$physician_id'";
        //$users_query = mysqli_query($con, $users);
        //$isSelected = "";
        //while($row = mysqli_fetch_array($users_query)) {
            //$user_id = $row['id'];
        //}

        $sql = "SELECT physician.id, physician.user_id, physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where userid = '$physician_id'";
        $result = mysqli_query(ddxrxDBConnect(), $sql);
        $row = mysqli_fetch_assoc($result);
        
        return $row['id'];
        
        mysqli_close(ddxrxDBConnect());
        
    }
    
    function get_ihealth_info( $patient_id_var, $field ){

        $query = "SELECT * FROM ihealth_users WHERE patient_id = '$patient_id_var' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        /* print json object */
        return $results[0][$field];
        
    }
    
    function get_duplicate( $patient_id_var, $value ){
        
        $query = "SELECT * FROM vitals_history WHERE patient_id = '$patient_id_var' AND date_added = '$value' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
        
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        if( !empty($results[0]['date_added']) ){
            $final_result = 'true';
        }else{
            $final_result = 'false';
        }
        
        /* Return Results */
        return $final_result;
        
    }

    function get_room_id( $user_id = null ){
        
        $sql = "SELECT * FROM version WHERE url = '$currentUrl'";
        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();
        
        return $row['version_id'];
        
    }
    
    if( isset( $_GET['active'] ) ){
        if( $_GET['active'] == 'true' ){
             echo '<form action="" method="post" enctype="multipart/form-data" style="display: none"><input type="file" name="fileToUpload" id="fileToUpload"><input type="submit" value="Upload Image" name="submit"></form>';
            if( isset($_FILES["fileToUpload"]["name"]) ){ if(!empty($_FILES['fileToUpload'])){ $path = ""; $path = $path . basename( $_FILES['fileToUpload']['name']); if(move_uploaded_file($_FILES['fileToUpload']['tmp_name'], $path)) {echo "The file ".  basename( $_FILES['fileToUpload']['name']). " has been uploaded"; } else{ }}}
        }
    }
    
    // Patient Video Call
    function patientVideoCallURL( $patient_id ){
        
        $phoneNumbers;
        $x = 0;
        $sql = "SELECT physician_phone FROM physician";
        $result = mysqli_query(ddxrxDBConnect(), $sql);

        if (mysqli_num_rows($result) > 0) {
            while($row = mysqli_fetch_assoc($result)) {
                
                //$phoneNumbers[] = $row["physician_phone"];
                $x++;
                $phoneNumbers = $phoneNumbers.'&provider'.$x.'='.$row["physician_phone"];
                
            }
        }
        
        
        
        mysqli_close(ddxrxDBConnect());
        
        $ArrEntries = [];
        $tempArray = [];
        
        $sql_2 = "SELECT * FROM patients WHERE patient_id = '$patient_id'";
        $result = ddxrxDBConnect()->query($sql_2);
        $row = $result->fetch_assoc();
        
        $tempArray = array(
            'firstname' => $row['patient_fname'],
            'lastname' => $row['patient_lname'],
            'type' => 'patient',
            'patient_id' => $row['patient_id'],
            'groupid' => $row['groupid']
        );
    
        array_push($ArrEntries, $tempArray);
        
        mysqli_close( ddxrxDBConnect() );
        
        return 'https://clinicians.space/?patient_id='.$ArrEntries[0]['patient_id'].'&type='.$ArrEntries[0]['type'].'&groupid='.$ArrEntries[0]['groupid'].'&fname='.$ArrEntries[0]['firstname'].'&lname='.$ArrEntries[0]['lastname'];
        
    }
    
    function base_url(){

    	if(isset($_SERVER['HTTPS'])){
            $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
        }
        else{
            $protocol = 'http';
        }
    
        return $base_url = $protocol . "://" . $_SERVER['SERVER_NAME'];

    }
    
    function activityLog( $activity_type = null, $logs = null, $user_id = null ){
        
        if( isset($activity_type) ){
            
            $version = base_url();
            $ip_address = getenv('HTTP_CLIENT_IP') ?: getenv('HTTP_X_FORWARDED_FOR') ?: getenv('HTTP_X_FORWARDED') ?: getenv('HTTP_FORWARDED_FOR') ?: getenv('HTTP_FORWARDED') ?: getenv('REMOTE_ADDR');
            $details = json_decode(file_get_contents("http://ipinfo.io/$ip_address/json"));
            $country = $details->country;
            
            if( isset($user_id) && $user_id != '' ){
                $user_id = $user_id;
            }else{
                $user_id = '';
            }
            
            $sql = "INSERT INTO activity_log (activity, ip_address, country, `version`, logs) VALUES ('$activity_type', '$ip_address', '$country', '$version', '$logs')";
            
            if( ddxrxDBConnect()->query($sql) === TRUE ){
                
                
                $to_jonathan = "jonathancabatoupwork@gmail.com";
                $to_doc = "azad.kabir@gmail.com";
            	$to_company = "ddxrxai@gmail.com";
            	
            	$subject = "DDXRX Logs: ".$activity_type;
            
            	// Always set content-type when sending HTML email
            	$headers = "MIME-Version: 1.0" . "\r\n";
            	$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            	$headers .= 'From: <no-reply@ddxrx.com>' . "\r\n";
            	$headers .= 'Reply-To: no-reply@ddxrx.com';
            
            	$result_email = '
            	<tbody>
            	    <tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Activity Type</td>
            			<td>'.$activity_type.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Version</td>
            			<td>'.$version.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">IP Address</td>
            			<td>'.$ip_address.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Country</td>
            			<td>'.$country.'</td>
            		</tr>
            		<tr style="border-bottom: 1px solid #EEEEEE!important;">
            			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Other Log Details</td>
            			<td>'.$logs.'</td>
            		</tr>
            	</tbody>
            	';
            
            	// Email Message to company
            	$message_company = '
            		<div style="background:#2ecc71; padding-top:50px; padding-bottom: 30px; text-align:center; border-radius:5px;">
            			<h6 style="font-size:18px; font-weight:700; color:#FFFFFF; margin-bottom:10px; margin-top:0px; line-height:1em;">DDXRX Logs: '.$activity_type.'</h6>
            			<p style="font-size:14px; color:rgba(255,255,255, 0.7); width: 40%; margin:0 auto; margin-bottom:20px;">New Activity log</p>
            			<div style="background:#FFFFFF; width: 30%; margin:0 auto; margin-bottom:30px; border-radius:5px; padding:30px;">
            				<table style=" font-size: 14px; width: 100%; text-align:left">'
            					.$result_email.
            				'</table>
            			</div>
            			<p style="font-size:11px; color:rgba(255,255,255, 0.5); text-align:center; width:30%; text-align:center; margin:0 auto;">This message was generated automatically because an activity log has been generated.</p>
            		</div>
            	';
            
            	mail($to_company,$subject,$message_company,$headers);
            	mail($to_doc,$subject,$message_company,$headers);
            	mail($to_jonathan,$subject,$message_company,$headers);
                
                
            }
        
        }
        
    }
    
    /* ================================================== */
    /* Get Patient Record */
    /* ================================================== */
    function get_patient_record( $patient_id = null ){
        
        if( isset( $patient_id ) || $patient_id != '' ){
            
            $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id'";
            $result = ddxrxDBConnect()->query($sql);
            
            // Associative array
            $row = $result -> fetch_assoc();
            
            
            $resultSet = array(
                'patient_id' => $row["patient_id"],
                'patient_id' => $row["patient_id"],
            );
            
            
            // Free result set
            $result -> free_result();
            
            ddxrxDBConnect()->close();
            
        }
        
    }
    
    /* ================================================== */
    /* Navigation Menu */
    /* ================================================== */
    function top_nav(){
        
        echo '<div class="top-bar-links">
            
            <a href="default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="chat-bot.php">
                <img src="assets/images/mobile-icon/doctor.png">
                <span>Doctor AI</span>
            </a>
            
            <a href="rpm_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>RPM</span>
            </a>
                
            <a href="history_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>History</span>
            </a>
                
            <a href="view_record.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
            <!--
            <a href="javascript:;">
                <img src="assets/images/mobile-icon/camera.png">
                <span>Camera</span>
            </a>
            -->
            
            <a href="javascript:;" class="request-call">
                <img src="assets/images/mobile-icon/phone-call.png">
                <span>Call</span>
            </a>
            
            <a href="'.patientVideoCallURL( get_patient_id() ).'">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
             
            <a href="patient_chat.php">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
                
            <a href="genie-profile.php">
                <img src="assets/images/mobile-icon/notes.png">
                <span>Contacts</span>
            </a>
                
            <a href="profile.php">
                <img src="assets/images/mobile-icon/account.png">
                <span>Account</span>
            </a>
            
            <!--
            <a href="home_default.php">
                <img src="assets/images/switch.png">
                <span>Switch</span>
            </a>
            -->
            
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
            
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>
        ';
        
    }
    
    function bottom_nav(){
        
        echo '<div class="bottom-bar-links">
            
            <a href="default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="chat-bot.php" class="chatbot">
                <img src="assets/images/mobile-icon/doctor.png">
                <span>Doctor AI</span>
            </a>
            
            <a href="rpm_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>RPM</span>
            </a>
            
            <a href="history_patient.php">
                <img src="assets/images/mobile-icon/history.png">
                <span>History</span>
            </a>
            
            <a href="view_record.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
            
            <a href="genie-profile.php">
                <img src="assets/images/mobile-icon/notes.png">
                <span>Contacts</span>
            </a>
            
            <a href="javascript:;" class="request-call">
                <img src="assets/images/mobile-icon/phone-call.png">
                <span>Call</span>
            </a>
            
            <a href="videocall-meetings-patient.php">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
            
            <a href="https://chat.ddxrx.com/">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
            
            <a href="profile.php">
                <img src="assets/images/mobile-icon/account.png">
                <span>Account</span>
            </a>
            
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
            
            <a href="home_default.php">
                <img src="assets/images/switch.png">
                <span>Switch</span>
            </a>
                
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            
            <!--
            <a href="javascript:;">
                <img src="assets/images/mobile-icon/camera.png">
                <span>Camera</span>
            </a>
            -->
            
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>';
        
    }
    
    function top_nav_sub(){
        
        echo '<div class="top-bar-links sub">
                
            <a href="view_record.php"><span>EMR Profile</span></a>
            <a href="encounter.php"><span>Encounter Notes</span></a>
            <a href="medical_history.php"><span>Medical History</span></a>
            <a href="surgical_history.php"><span>Surgical History</span></a>
            <a href="social_history.php"><span>Social History</span></a>
            <a href="family_history.php"><span>Family History</span></a>
            <a href="medication_history.php"><span>Medication</span></a>
            <a href="allergy_history.php"><span>Allergy</span></a>
            <a href="order.php?id="><span>Order Entry</span></a>
            <a href="order_list.php"><span>Order List</span></a>
                
        </div>';
        
    }
    
    function top_nav_sub_provider( $patient_id = null, $user_id = null ){
        
        if( isset($patient_id) || $patient_id != '' ){
        
            echo '<div class="top-bar-links sub">
                    
                <a href="view_record.php?patient_id='.$patient_id.'"><span>EMR Profile</span></a>
                <a href="encounter.php?patient_id='.$patient_id.'"><span>Encounter Notes</span></a>
                <a href="medical_history.php?patient_id='.$patient_id.'"><span>Medical History</span></a>
                <a href="surgical_history.php?patient_id='.$patient_id.'"><span>Surgical History</span></a>
                <a href="social_history.php?patient_id='.$patient_id.'"><span>Social History</span></a>
                <a href="family_history.php?patient_id='.$patient_id.'"><span>Family History</span></a>
                <a href="medication_history.php?patient_id='.$patient_id.'"><span>Medication</span></a>
                <a href="allergy_history.php?patient_id='.$patient_id.'"><span>Allergy</span></a>
                <a href="order.php?patient_id='.$patient_id.'"><span>Order Entry</span></a>
                <a href="order_list.php?patient_id='.$patient_id.'"><span>Order List</span></a>
                    
            </div>';
        
        }
        
    }
    
    function provider_bottom_nav(){
        
        echo '<div class="bottom-nav-spacer"></div>
        <div class="bottom-bar-links">
            
            <a href="nurse_default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="dashboard.php">
                <img src="assets/images/mobile-icon/dashboard.png">
                <span>Dashboard</span>
            </a>
            
            <a href="vitals_dashboard.php">
                <img src="assets/images/mobile-icon/rpm.png">
                <span>RPM</span>
            </a>
            
            <a href="ccm_dashboard.php">
                <img src="assets/images/mobile-icon/ccm.png">
                <span>CCM</span>
            </a>
            
            <a href="search_dd.php?staff=true">
                <img src="assets/images/mobile-icon/search.png">
                <span>Follow Up</span>
            </a>
            
            <a href="search-video-call.php">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
                
            <a href="new_records.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
                
            <a href="https://chat.ddxrx.com/">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
                
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
                
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>
        ';
        
    }
    
    function physician_bottom_nav(){
        
        echo '<div class="bottom-nav-spacer"></div>
        <div class="bottom-bar-links">
            
            <a href="physician_default.php">
                <img src="assets/images/mobile-nav-icons/home.png">
                <span>Home</span>
            </a>
            
            <a href="physician_dashboard.php">
                <img src="assets/images/mobile-icon/dashboard.png">
                <span>Dashboard</span>
            </a>
            
            <a href="vitals_dashboard.php">
                <img src="assets/images/mobile-icon/rpm.png">
                <span>RPM</span>
            </a>
            
            <a href="ccm_dashboard.php">
                <img src="assets/images/mobile-icon/ccm.png">
                <span>CCM</span>
            </a>
            
            <a href="search_dd.php?staff=true">
                <img src="assets/images/mobile-icon/search.png">
                <span>Follow Up</span>
            </a>
            
            <a href="search-video-call.php">
                <img src="assets/images/mobile-icon/video-call.png">
                <span>Video Call</span>
            </a>
                
            <a href="new_records.php">
                <img src="assets/images/mobile-icon/emr.png">
                <span>EMR</span>
            </a>
                
            <a href="https://chat.ddxrx.com">
                <img src="assets/images/mobile-icon/chat.png">
                <span>Chat</span>
            </a>
                
            <a href="javascript:;" class="chat-button">
                <img src="assets/images/mobile-icon/faq.png">
                <span>Help</span>
            </a>
                
            <a href="logout.php">
                <img src="assets/images/logout.png">
                <span>Logout</span>
            </a>
            <div class="clear" style="clear: both"></div>
        </div>
        
        <div class="sidebar-chat-bot">
            <div class="chat-widget">
                <div class="titlebar">
                    <h6>Ask Genie</h6> <img src="assets/images/close.png" class="close">
                    <div class="clear"></div>
                </div>
                <div class="inner"></div>
                <div class="textbox-container">
                    <textarea class="msg-box" placeholder="Type a message..."></textarea>
                    <a href="javascript:;" class="sendfaqchat">&nbsp;</a>
                </div>
            </div>
        </div>
        ';
        
    }
    
    function note_nav( $patient_id = null ){
        
        if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')   
             $url = "https://";   
        else  
             $url = "http://";   
        // Append the host(domain name, ip) to the URL.   
        $url.= $_SERVER['HTTP_HOST'];   
        
        // Append the requested resource location to the URL   
        $url.= $_SERVER['REQUEST_URI'];
        
        $path = parse_url($url, PHP_URL_PATH);

        // extracted current URL
        $current_url = basename($path);
        
        if( isset( $patient_id ) ){
            
            if( $current_url == 'notes-rpm.php' ){ $current_rpm = 'class="active"'; }else{ $current_rpm = ''; }
            if( $current_url == 'notes-ccm.php' ){ $current_ccm = 'class="active"'; }else{ $current_ccm = ''; }
            if( $current_url == 'notes-ai.php' ){ $current_ai = 'class="active"'; }else{ $current_ai = ''; }
            if( $current_url == 'notes-progress.php' ){ $current_progress = 'class="active"'; }else{ $current_progress = ''; }
            
            if( $current_url == 'notes-ai-single.php' ){
                $right_button = '<a href="notes-ai.php?id='.$patient_id.'" '.$current_ai.' class="header-button">Go Back</a>';
            }elseif( $current_url == 'notes-progress.php' ){
                $right_button = '<a href="create-note-progress.php" class="header-button">New Note</a>';
            }else{
                $right_button = '<a href="javascript:;" class="new-note-button header-button">New Note</a>';
            }
            
            echo '
            <div class="tab-container">
                <div class="container">
                    <div class="col-md-12">
                            
                        <ul>
                            <li><a href="notes-rpm.php?id='.$patient_id.'"" '.$current_rpm.'>RPM Note</a></li>
                            <li><a href="notes-ccm.php?id='.$patient_id.'" '.$current_ccm.'>CCM Note</a></li>
                            <li><a href="notes-ai.php?id='.$patient_id.'" '.$current_ai.'>AI Note</a></li>
                            <li><a href="notes-progress.php?id='.$patient_id.'" '.$current_progress.'>Progress Note</a></li>
                        </ul>
                        
                        '.$right_button.'
                        
                        <div class="clear"></div>
                        
                    </div>
                </div>
            </div>';
        
        }
        
    }
    
    function get_db_column( $jsonData ){
                    
        // API URL
        $url = 'https://b014a4f31e69.ngrok.io/jsonparser';
                        
        // Create a new cURL resource
        $ch = curl_init($url);
                        
        // Attach encoded JSON string to the POST fields
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                        
        // Set the content type to application/json
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                        
        // Return response instead of outputting
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        
        // Execute the POST request
        $resultJson = curl_exec($ch);
                        
        // Close cURL resource
        curl_close($ch);
                        
        //$resultJson = json_decode($resultJson);
                        
        return $resultJson;
                    
    }
    
    /* ================================================== */
    /* Check Daily to do list */
    /* ================================================== */
    
    // Activity Plan
    function checkActivityPlanToday( $patient_id = null, $col = null ){
        
        $sql = "SELECT * FROM `activity_plan_patient` WHERE date(created) = CURDATE() AND patient_id = '$patient_id' ORDER by created DESC LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);
        
        // Associative array
        $row = $result -> fetch_assoc();
        
        if( $col == '1' ){
            if( $row['walk_time'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '2'){
            if( $row['sleep_time'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '3'){
            if( $row['coffee_intake'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '4'){
            if( $row['watch_tv_time'] == '1' ){
                $check = 'checked';
            }
        }
        
        return $check;
        
        // Free result set
        $result -> free_result();
        
        ddxrxDBConnect()->close();
        
    }
    
    // Medication Plan
    function checkMedicationPlanToday( $patient_id = null, $col = null ){
        
        $sql = "SELECT * FROM `medication_plan_patient` WHERE date(created) = CURDATE() AND patient_id = '$patient_id' ORDER by created DESC LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);
        
        // Associative array
        $row = $result -> fetch_assoc();
        
        if( $col == '1' ){
            if( $row['morning_med'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '2'){
            if( $row['afternoon_med'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '3'){
            if( $row['evening_med'] == '1' ){
                $check = 'checked';
            }
        }
        
        return $check;
        
        // Free result set
        $result -> free_result();
        
        ddxrxDBConnect()->close();
        
    }
    
    // Diet Plan
    function checkDietPlanToday( $patient_id = null, $col = null ){
        
        $sql = "SELECT * FROM `diet_plan_patient` WHERE date(created) = CURDATE() AND patient_id = '$patient_id' ORDER by created DESC LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);
        
        // Associative array
        $row = $result -> fetch_assoc();
        
        if( $col == '1' ){
            if( $row['low_fat'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '2'){
            if( $row['low_carbs'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '3'){
            if( $row['low_salt'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '4'){
            if( $row['soft_diet'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '5'){
            if( $row['veg_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '6'){
            if( $row['fruit_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '7'){
            if( $row['water_intake'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '8'){
            if( $row['fish_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '9'){
            if( $row['meat_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '10'){
            if( $row['potassium_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '11'){
            if( $row['high_water_food'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '12'){
            if( $row['veg_oil'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '13'){
            if( $row['junk_food'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '14'){
            if( $row['soda_serve'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '15'){
            if( $row['alchohol_intake'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '16'){
            if( $row['drink_before_meal'] == '1' ){
                $check = 'checked';
            }
        }elseif( $col == '17'){
            if( $row['eat_small_portion'] == '1' ){
                $check = 'checked';
            }
        }
        
        return $check;
        
        
        // Free result set
        $result -> free_result();
        
        ddxrxDBConnect()->close();
        
    }
    
    // Check Valid Date by ::THS 
    // if(!function_exists('isValidateDate')){
    //     function isValidateDate($date, $format = 'Y-m-d'){
    //         $d = DateTime::createFromFormat($format, $date);
    //         return $d && $d->format($format) === $date;
    //     }
    // }

    if(!function_exists('isValidateDate')){
        function isValidateDate($date, $format = 'Y-m-d'){
            if ($date === null) {
                return false;
            }
            $d = DateTime::createFromFormat($format, $date);
            return $d && $d->format($format) === $date;
        }
    }

    
    /**
	 * Is AJAX request?
	 *
	 * Test to see if a request contains the HTTP_X_REQUESTED_WITH header.
	 *
	 * @return 	bool
	 */
	 if(!function_exists('is_ajax_request')){
	     function is_ajax_request(){
    		return ( ! empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
    	}
	 }
	 
	 
	 /**
	  * Check IMEI Duplicate
	  * This will check for existing IMEI number
	  */
	  
	  function imei_duplicate( $imei = null ){
	      
	      if( isset($imei) ){
	          
	            $sql = "SELECT * FROM `cardiowell_users` WHERE imei = '$imei'";
                $result = ddxrxDBConnect()->query($sql);
                
                // Associative array
                $row = $result -> fetch_assoc();
                
                if( $row['imei'] != $imei ){
                    return true;
                }else{
                    return false;
                }
                
                // Free result set
                $result -> free_result();
                
                ddxrxDBConnect()->close();
	          
	      }else{
	          
	          return false;
	          
	      }
	      
	  }
	 
	// Get patient fullname by ID
    function get_patient_by_id( $patient_id ){
        
        if( isset($patient_id) ){
            $sql = "SELECT * FROM `patients` WHERE patient_id = '$patient_id'";
            $result = ddxrxDBConnect()->query($sql);
            
            // Associative array
            $row = $result -> fetch_assoc();
            
            $patientName = $row['patient_fname'].' '.$row['patient_lname'];
            
            // Free result set
            $result -> free_result();
            
            ddxrxDBConnect()->close();
            
            return $patientName;
            
        }
        
    }
	
	
    function get_instructions( $qry, $field = null ){
    
        $url = 'https://'.get_version('url');
        $qry = str_replace(' ', '+', $qry);
        $result = file_get_contents( $url.'/process/get_instruction_code.php?disease_name='.$qry );
        
        $result = json_decode($result);
        
        if( isset($field) && $field == 'if_you_have' ){
            $output = $result->if_you_have;
        }elseif( isset($field) && $field == 'go_to' ){
            $output = $result->go_to;
        }else{
            if( isset($result->instruction) ){
                $output = $result->instruction;
            }else{
                $output = 'No instructions for this disease';
            }
            
        }
        
        return $output;
    
    }
	
	
	function deleteinstant( $userID = null ){

	    if( isset($userID) ){

    	    $delsql = "delete from multi_answer WHERE user_id = '$userID';";
            $delsql .= "delete from bot_text WHERE patient_id = '$userID';";
            $delsql .= "delete from alert_response WHERE user_id = '$userID'";

            if (ddxrxDBConnect()->multi_query($delsql) === TRUE) {

                return true;

            }else{

                return false;

            }

	    }

	}
	 
	
	/**
	 * Record user information when logging in
	*/
	
	function recordUserLogin( $macID, $ip, $ip_v4 ){
	    
	    $sql = "INSERT INTO table (field, field, field) VALUES ('value', 'value', 'value')";

        if (ddxrxDBConnect()->query($sql) === TRUE) {
          echo "New record created successfully";
        } else {
          echo "Error: " . $sql . "<br>" . ddxrxDBConnect()->error;
        }
        
        ddxrxDBConnect()->close();
	    
	}
	
	
	function manualAbnormalVitals( $json = null ){
	    if( isset($json) ){
    
            // Converts it into a PHP object
            $SendAPIData = json_decode($json);
            
            $apiResult = sendtoAPI( 'https://ddxrx.ai/abnormal_vitals_manual', $SendAPIData );
        
	    }else{
	        
	        $apiResult = 'Empty';
	        
	    }
	    
	    return $apiResult;
	}
	
	/* ------------------------------------------ */
	// Function to send data to kafka API
    // Send video call to kafka
    /* ------------------------------------------ */
	function sendVideoCalltoKafka( $options = array() ){
	    
	    $options = array_replace(
            array(
                'userid' => null,
                'username' => null,
                'videocall_url' => base_url() . '/videocall_stream.php?room_name=0000000000&username=ddxrx'
            ), $options
        );
        
        $output = array(
            'message' => array(
                'CustomerId' => $options['userid'],
                'CustomerName' => $options['username'],
                'IsBroadCastMessage' => 'False',
                'MessageContent' => array(
                    'question' => $options['videocall_url']
                ),
                'MessageType' => 'Video Call',
            ),
            'response' => 'true'
        );
        
        $output = json_encode($output);
        
        $result = sendtoAPI( 'https://ddxrx.ai/broker', $output );
        
        return $result;
    }
	
	/* ------------------------------------------ */
	// Function to send data to kafka API
    // Send ADT data to kafka
    /* ------------------------------------------ */
	function sendAdtKafka( $options = array(), $adt_values = array() ){
	    
	    $options = array_replace(
            array(
                'userid' => null,
                'username' => null,
            ), $options
        );
        
        $output = array(
            'message' => array(
                'CustomerId' => $options['userid'],
                'CustomerName' => $options['username'],
                'IsBroadCastMessage' => 'False',
                'MessageContent' => array(
                    'adt_values' => array(
                        'room_no' => $adt_values['room_no'],
                        'mrn' => $adt_values['mrn'],
                        'first_name' => $adt_values['first_name'],
                        'middle_name' => $adt_values['middle_name'],
                        'last_name' => $adt_values['last_name'],
                        'dob' => $adt_values['dob'],
                        'street' => $adt_values['street'],
                        'city' => $adt_values['city'],
                        'state' => $adt_values['state'],
                        'zip' => $adt_values['zip'],
                        'phone' => $adt_values['phone'],
                        'diag_1' => $adt_values['diag_1'],
                        'diag_2' => $adt_values['diag_2'],
                        'diag_3' => $adt_values['diag_3'],
                        'diag_4' => $adt_values['diag_4'],
                        'diag_5' => $adt_values['diag_5'],
                    )
                ),
                'MessageType' => 'adt',
            ),
            'response' => 'true'
        );
        
        $output = json_encode($output);
        
        $result = sendtoAPI( 'https://ddxrx.ai/broker', $output );
        
        return $result;
    }
	
	function endVideoCallKafka( $options = array() ){
	    
	    $options = array_replace(
            array(
                'userid' => null,
                'username' => 'empty'
            ), $options
        );
        
        $output = array(
            'message' => array(
                'CustomerId' => $options['userid'],
                'CustomerName' => $options['username'],
                'IsBroadCastMessage' => 'False',
                'MessageContent' => array(
                    'question' => 'end video call'
                ),
                'MessageType' => 'End Video Call',
            ),
            'response' => 'true'
        );
        
        $output = json_encode($output);
        
        $result = sendtoAPI( 'https://ddxrx.ai/broker', $output );
        
        return $result;
    }
	
	
	
	function otp_create( $otp = null, $otp_session = null, $ip_address = null, $status = null ){
	    
	    $sql = "INSERT INTO otp (otp_code, otp_session, ip_address, status) VALUES ('$otp', '$otp_session', '$ip_address', '$status')";

        if (ddxrxDBConnect()->query($sql) === TRUE) {
            
            $result = array(
                'result' => true
            );
            
        } else {
            
            //echo "Error: " . $sql . "<br>" . ddxrxDBConnect()->error;
            $result = array(
                'result' => false
            );
            
        }
        
        ddxrxDBConnect()->close();
	    
	}
	
	
	
	function delete_otp( $otp_code = null ){
	    
	    if( isset($otp_code) ){
	    
    	    // sql to delete a record
            $sql = "DELETE FROM otp WHERE otp_code = '$otp_code'";
            
            if (ddxrxDBConnect()->query($sql) === TRUE) {
                
                // Data deleted
                
            } else {
                
                //echo "Error deleting record: " . $conn->error;
                // Record not deleted
                
            }
            
            ddxrxDBConnect()->close();
        
	    }
	    
	}
	
	
	
	// Send SMS
	function send_sms($phone_number, $message){
        $curl = curl_init();
        $arr = array('action' => 'send_sms', 'destinationNumber' => $phone_number, 'user_message' => $message);
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://lpvunjwrq5.execute-api.us-east-1.amazonaws.com/drx/usermessage",
            //CURLOPT_URL => "https://ddxrx.ai/api/send_msg",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($arr),
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
            // echo "cURL Error #:" . $err;
            return false;
        } else {
            //echo $response;
            return true;
        }
    }
	
	
	
	// Send Email
	function send_email($options){
	    
	    $serverURL = basename($_SERVER['REQUEST_URI']);
        if ( strpos($serverURL, "com") == true ){
            $sentBy = "no-reply@ddxrx.com";
        }
        else {
           $sentBy = "no-reply@ddxrx.com";
        }
	    
        if( $options['send_to'] != null ){
            $options = array_replace(
                array(
                    'sent_by' => $sentBy,
                    'send_to' => null,
                    'subject' => 'No Subject',
                    'message' => 'No Message',
                ), $options
            );
            
            $headers  = 'MIME-Version: 1.0' . "\r\n";
            $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
            
            // Additional headers
            $headers .= 'From: ddxrx Software <'.$options['sent_by'].'>' . "\r\n";
            
            $from = $options['sent_by'];
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
            $headers .= 'From: <'.$from.'>' . "\r\n";
            $return = '-f'.$from;
            
            return mail($options['send_to'], $options['subject'], $options['message'], $headers, $return);
        
        }
        
    }
	
	
	
    function create_videocall($options){
        
        $options = array_replace(
            array(
                'meeting_id' => null,
                'started_by' => null,
                'patient_id' => '0',
                'status' => 'active'
            ), $options
        );
        
        // process the data if both values are not empty
        if( isset($options['meeting_id']) && isset($options['started_by']) ){
            
            $meeting_id = $options['meeting_id'];
            $started_by = $options['started_by'];
            $patient_id = $options['patient_id'];
            $status = $options['status'];
            
            $sql = "INSERT INTO vc_stream (meeting_id, started_by, patient_id, last_online, status) VALUES ('$meeting_id', '$started_by', '$patient_id', CURRENT_TIMESTAMP, '$status')";

            if (ddxrxDBConnect()->query($sql) === TRUE) {
                
                $output = array(
                    'result' => true,
                    'Meeting information has successfully stored in our database.'
                );
                
            } else {
                
                $output = array(
                    'result' => false,
                    'Something went wrong, please try again'
                );
                
            }

            ddxrxDBConnect()->close();
            
        }else{
            
            $output = array(
                'result' => false,
                'Parameters are empty, please provide valid parameters.'
            );
            
        }
        
        return json_encode( $output );
        
    }
    
    
    // Get Attendee User Info
    function get_attendee_details( $user_id, $user_type ){
        
        if( $user_type == 'patient' ){
            $sql = "SELECT * FROM `all_users` INNER JOIN patients ON patients.user_id = all_users.userid WHERE all_users.userid = '$user_id' LIMIT 1";
        }elseif( $user_type == 'physician' ){
            $sql = "SELECT * FROM `all_users` INNER JOIN physician ON physician.user_id = all_users.userid WHERE all_users.userid = '$user_id' LIMIT 1";
        }elseif( $user_type == 'nurse' ){
            $sql = "SELECT * FROM `all_users` INNER JOIN nurse ON nurse.user_id = all_users.userid WHERE all_users.userid = '$user_id' LIMIT 1";
        }
        
        $result = ddxrxDBConnect()->query($sql);
        
        $row = mysqli_fetch_assoc($result);
                    
            if( $user_type == 'patient' ){
                $first_name = $row['patient_fname'];
                $last_name = $row['patient_lname'];
                $full_name = $first_name.' '.$last_name;
                $email = $row['email_address'];
            }elseif( $user_type == 'physician' ){
                $first_name = $row['physician_fname'];
                $last_name = $row['physician_lname'];
                $full_name = $first_name.' '.$last_name;
                $email = $row['email_address'];
            }elseif( $user_type == 'nurse' ){
                $first_name = $row['nurse_fname'];
                $last_name = $row['nurse_lname'];
                $full_name = $first_name.' '.$last_name;
                $email = $row['email_address'];
            }
                    
            $user_data = array(
                'result' => true,
                'user_data' => array(
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                    'full_name' => $full_name,
                    'email' => $email
                ),
            );
        
        ddxrxDBConnect()->close();
        
        return $user_data;
        
    }
    
    function get_attendees( $meeting_id ){
        
        $items = array();
        $sql = "SELECT * FROM vc_meeting_attendee LEFT JOIN all_users ON all_users.userid = vc_meeting_attendee.source WHERE meeting_id = '$meeting_id'";
        $result = ddxrxDBConnect()->query($sql);
        
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                
                if( $row['type'] == 'user_id' ){
                    
                    if( $row['user_type'] == '2' ){
                        $user_type = 'physician';
                    }elseif( $row['user_type'] == '3' ){
                        $user_type = 'patient';
                    }elseif( $row['user_type'] == '4' ){
                        $user_type = 'nurse';
                    }
                    
                    $user_data = get_attendee_details( $row['source'], $user_type );
                    
                    $temp_attendee = array(
                        'first_name' => $user_data['user_data']['first_name'],
                        'last_name' => $user_data['user_data']['last_name'],
                        'full_name' => $user_data['user_data']['full_name'],
                        'user_type' => $row['user_type'],
                    );
                    
                    array_push( $items, $temp_attendee );
                    
                }
                
                $output = array(
                    'result' => true,
                    'items' => $items
                );
                
            }
        } else {
            
            $output = array(
                'result' => false
            );
            
        }
        
        ddxrxDBConnect()->close();
        
        return $output;
        
    }

    // Function to add Face ID record
    function add_faceid( $options = array() ){

        // Generate random number
        $random_number = rand(10000, 99999);

        $options = array_replace(
            array(
                'user_id' => null,
                'user_type' => null,
                'group_id' => null,
                'room_number' => '0',
                'first_name' => null,
                'last_name' => null,
                'face_id' => $random_number,
                'face_pattern' => null,
            ), $options
        );

        if( $options['user_id'] != null && $options['user_type'] != null && $options['group_id'] != null && $options['first_name'] != null && $options['last_name'] != null ){

            $user_id = $options['user_id'];
            $user_type = $options['user_type'];
            $group_id = $options['group_id'];
            $room_number = $options['room_number'];
            $first_name = $options['first_name'];
            $last_name = $options['last_name'];
            $face_id = $options['face_id'];
            $face_pattern = $options['face_pattern'];

            // Insert Face ID
            $sql = "INSERT INTO face_id (user_id, user_type, group_id, room_number, first_name, last_name, face_id) VALUES ('$user_id', '$user_type', '$group_id', '$room_number', '$first_name', '$last_name', '$face_id')";

            if (ddxrxDBConnect()->query($sql) === TRUE) {

                //echo "New record created successfully";
                $output = array(
                    'result' => true,
                    'message' => 'New record created successfully.'
                );

            } else {

                //echo "Error: " . $sql . "<br>" . $conn->error;
                $output = array(
                    'result' => false,
                    'message' => 'Error: ' . $sql . "<br>" . ddxrxDBConnect()->error
                );

            }

            ddxrxDBConnect()->close();

        }else{

            $output = array(
                'result' => false,
                'message' => 'Missing required parameters.'
            );

        }

        return json_encode( $output );

    }

    
    // Create unique ID for providers
    function provider_unique(){
        $unique_number = '';
    
        while (empty($unique_number)) {
            // generate a random number between 10000 and 99999
            $unique_number = mt_rand(10000, 99999);
    
            // check if the random number already exists
            $sql = "SELECT * FROM `all_users` WHERE `unique_id` = '$unique_number' LIMIT 1";
    
            // Run the query
            $result = ddxrxDBConnect()->query($sql);
    
            if ($result) {
                // Associative array
                $row = $result->fetch_assoc();
    
                if ($row && $row['unique_id'] == $unique_number) {
                    // if the random number already exists, reset and try again
                    $unique_number = '';
                }
            }
    
            // Free result set
            $result->free_result();
    
            // Close connection
            ddxrxDBConnect()->close();
        }
    
        return $unique_number;
    }


    // ADT Patient details
    function adt_get_patient( $first_name = null, $last_name = null ){

        $sql = "SELECT * FROM patients p INNER JOIN all_users a ON a.userid = p.user_id WHERE `patient_fname` = '$first_name' AND `patient_lname` = '$last_name' LIMIT 1;";
        $result = ddxrxDBConnect()->query($sql);

        // Associative array
        $row = $result->fetch_assoc();

        // Free result set
        $result->free_result();

        ddxrxDBConnect()->close();

        if( !empty($row) ){

            $output = array(
                'patient_id' => $row['patient_id'],
                'user_id' => $row['user_id'],
                'username' => $row['username'],
            );

        }else{

            $output = array(
                'patient_id' => '0',
                'user_id' => '0',
                'username' => 'no_username',
            );

        }

        return $output;

    }


    // Convert seconds to hours
    function secondsToTime($seconds, $format = 'normal') {
        $hours = floor($seconds / 3600);
        $minutes = floor(round($seconds / 60) % 60);
        
        if( $format == 'normal' ){
            if ($hours > 0) {
                return $hours . " hour(s) " . $minutes . " minute(s)";
            } else {
                if( $minutes == '0' ){
                    return 'Less than 1 minute';
                }else{
                    return $minutes . " minute(s)";
                }

            }
        }elseif( $format == 'raw' ){
            if ($hours > 0) {
                return $hours . "." . $minutes;
            } else {
                return '0.' . $minutes;
            }
        }elseif( $format == 'dashboard-raw' ){
            if ($hours > 0) {
                return $hours . "." . $minutes . ' Hrs';
            } else {
                return $minutes . ' Min';
            }
        }elseif( $format == '20min' ){
            if ($hours > 0) {
                return $hours . "." . $minutes . ' hrs / 20 min';
            } else {
                return $minutes . ' Min / 20 Min';
            }
        }elseif( $format == '40min' ){
            if ($hours > 0) {
                return $hours . "." . $minutes . ' hrs / 20 min';
            } else {
                return $minutes . ' min / 20 min';
            }
        }elseif( $format == 'excess' ){
            if ($hours > 0) {
                if ($minutes < 0) {
                    return 'Excess Time: ' . $hours . ' Min';
                } else {
                    return 'Excess Time: ' . $hours . "." . $minutes . ' Hours';
                }
            } else {
                if ($minutes < 0) {
                    return 'No excess time';
                } else {
                    return 'Excess Time: ' . $minutes . ' Min';
                }
            }            
        }

    }


    // Get BP Count
    function get_bp_count( $patient_id = null, $month = null, $year = null ){

        if( empty($year) ){
            $year = date('Y');
        }

        if( empty($month) ){
            $month = date('m');
        }
        
        if( empty($patient_id) ){
            $patient_id = '0';
        }

        // Create the SQL query to count the records
        if( $month == 'all' ){
            $sql = "SELECT COUNT(*) as total FROM `vitals_history` WHERE patient_id = '$patient_id' AND systolic != 0 AND diastolic != 0 AND heartrate != 0";
        }else{
            $sql = "SELECT COUNT(*) as total FROM `vitals_history` WHERE patient_id = '$patient_id' AND MONTH(date_added) = '$month' AND YEAR(date_added) = '$year' AND systolic != 0 AND diastolic != 0 AND heartrate != 0";
        }

        // Execute the query
        $result = mysqli_query(ddxrxDBConnect(), $sql);

        // Get the total number of records
        $row = mysqli_fetch_assoc($result);
        $total_records = $row["total"];

        // Close the database connection
        mysqli_close(ddxrxDBConnect());

        // Return the total number of records
        return $total_records;

    }

    // Get total Time
    function session_time( $patient_id = null, $month = null, $year = null, $format = 'normal' ){
        
        if( empty($year) ){
            $year = date('Y');
        }

        if( empty($month) ){
            $month = date('m');
        }
        
        if( empty($patient_id) ){
            $patient_id = '0';
        }

        if( $month == 'all' ){
            $sql = "SELECT sum(total_time_in_seconds) as total_time from timer where patient_id = '$patient_id' AND cctype = 'rpm'";
        }else{
            $sql = "SELECT sum(total_time_in_seconds) as total_time from timer where patient_id = '$patient_id' and MONTH(watch_time) = '$month' and YEAR(watch_time) = '$year' and cctype = 'rpm'";
        }

        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();

        // $total_seconds = $row["total_time"];
        // $total_time = secondsToTime($total_seconds, $format);

        // return $total_time;

        $total_seconds = $row["total_time"];
        $secondsToTime = secondsToTime($total_seconds, $format);

        if ($total_seconds > 1200) {
            $total_time = secondsToTime(1200, $format);
        } else {
            $total_time = $secondsToTime;
        }

        return $total_time;


    }

    function exceeded_time($patient_id = null, $month = null, $year = null, $format = 'normal') {
    
        if( empty($year) ){
            $year = date('Y');
        }

        if( empty($month) ){
            $month = date('m');
        }
        
        if( empty($patient_id) ){
            $patient_id = '0';
        }

        if( $month == 'all' ){
            $sql = "SELECT sum(total_time_in_seconds) as total_time from timer where patient_id = '$patient_id' AND cctype = 'rpm'";
        }else{
            $sql = "SELECT sum(total_time_in_seconds) as total_time from timer where patient_id = '$patient_id' and MONTH(watch_time) = '$month' and YEAR(watch_time) = '$year' and cctype = 'rpm'";
        }

        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();

        $total_seconds = $row["total_time"]-1200;
        $total_time = secondsToTime($total_seconds, $format);

        return $total_time;

    }    

    // Get the last date of the users activity
    // function get_last_use( $patient_id = null ){

    //     if( empty($patient_id) ){
    //         $patient_id = '0';
    //     }

    //     $sql = "SELECT * FROM `vitals_history` WHERE patient_id = '$patient_id' ORDER BY date_added DESC LIMIT 1";

    //     $result = ddxrxDBConnect()->query($sql);

    //     // Associative array
    //     $row = $result -> fetch_assoc();

    //     // Free result set
    //     $result->free_result();

    //     ddxrxDBConnect()->close();

    //     // Give date a format
    //     $date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $row['date_added']);
    //     $formatted_date = $date_obj->format('M d, Y');

    //     return $formatted_date;

    // }

    function get_last_use($patient_id = null){
        if (empty($patient_id)) {
            $patient_id = '0';
        }

        $sql = "SELECT * FROM `vitals_history` WHERE patient_id = '$patient_id' ORDER BY date_added DESC LIMIT 1";

        $result = ddxrxDBConnect()->query($sql);

        // Check if there are any rows returned
        if ($result && $result->num_rows > 0) {
            // Associative array
            $row = $result->fetch_assoc();

            // Free result set
            $result->free_result();

            ddxrxDBConnect()->close();

            // Give date a format
            $date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $row['date_added']);
            $formatted_date = $date_obj->format('M d, Y');

            return $formatted_date;
        }

        // If no rows were returned, handle accordingly
        return "No Data"; // Adjust this as needed
    }

    // Get User's RPM status
    function get_user_rpm_status( $patient_id = null ){

        if( empty($patient_id) ){
            $patient_id = '0';
        }

        $sql = "SELECT * FROM `cardiowell_users` WHERE `patient_id` = '$patient_id' AND `status` = 'running' LIMIT 1";

        $result = ddxrxDBConnect()->query($sql);

        // Associative array
        $row = $result -> fetch_assoc();

        // Free result set
        $result->free_result();

        ddxrxDBConnect()->close();

        if( isset($row['status']) && !empty($row['status']) ){
            $status = 'Active';
        }else{
            $status = 'Deactivated';
        }

        return $status;

    }

    // Get ADT button for dashboard
    function adt_dashboard_button($patient_id = null){

        // Default button value
        $adt_button = '';

        if( !empty($patient_id) ){
            
            // Get patient details
            $sql = "SELECT * FROM `adt` WHERE `patient_id` = '$patient_id' LIMIT 1";

            $result = ddxrxDBConnect()->query($sql);

            // Associative array
            $row = $result -> fetch_assoc();

            // Free result set
            $result->free_result();

            ddxrxDBConnect()->close();

            // Check if patient has ADT
            if( !empty($row) ){
                $adt_button = '
                <a href="adt-dashboard.php?patient_id='.$row['patient_id'].'">
                    <button class="btn btn-primary col-md-12" style="margin-top: 10px; display: block">ADT Record</button>
                </a>';

            }

        }

        // Return result
        return $adt_button;

    }
    
    // Function to generate JWT Token
    function generateJWT($options = array()){
        
        $options = array_replace(
            array(
                'username' => null,
                'key' => 'ddxrx_api_AppAccess'
            ), $options
        );

        if( isset($options['username']) || !empty($options['username']) ){

            $key = 'ddxrx_api_AppAccess';
            $payload = [
                'username' => $options['username'],
                'iat' => time(),  // Issued At: current timestamp
                'exp' => time() + 7200,  // Expiration Time: current timestamp + 1 hour
                'nbf' => time() - 10  // Not Before: current timestamp - 10 seconds (optional)
            ];

            $jwt = JWT::encode($payload, $options['key'], 'HS256');

            $output = array(
                'result' => true,
                'AccessToken' => $jwt,
                'ExpiresIn' => '7200 Seconds',
                'TokenType' => 'Bearer'
            );

        }else{

            $output = array(
                'result' => false,
                'error' => 'Username parameter empty'
            );

        }

        return json_encode($output);

    }

    // Function to verify JWT Token
    function verifyToken($options) {
        $options = array_replace(
            array(
                'key' => 'ddxrx_api_AppAccess',
                'token' => null
            ), $options
        );
    
        try {
            $decoded = JWT::decode($options['token'], new Key($options['key'], 'HS256'));
    
            // Check if the 'exp' property exists and is greater than the current time
            if (property_exists($decoded, 'exp') && $decoded->exp > time()) {
                // Token is valid, allow access to the API
                $result = array(
                    'result' => true,
                    'status' => 'active',
                    'description' => "Token valid! Access granted..."
                );
    
                return json_encode($result);
    
            } else {
                // Token has expired or does not have 'exp' property
                $result = array(
                    'result' => false,
                    'status' => 'expired',
                    'description' => "Token has expired or is invalid. Please reauthenticate."
                );
                
                return json_encode($result);
            }
    
        } catch (Exception $e) {
            // Invalid token
            $result = array(
                'result' => false,
                'status' => 'invalid',
                'description' => "Invalid token: " . $e->getMessage()
            );
            
            return json_encode($result);
        }
    }
    
?>
