<?php

    date_default_timezone_set('America/Chicago');
    include('functions.php');

    global $callarray;
    $callarray = [];
    
?>

<?php
    $version = get_version();
    
    $vitals = [];
    $vitals[] = ['fieldName' => 'systolic', 'fieldLable' => 'Systolic BP', 'min' => 90, 'max' => 200];
    $vitals[] = ['fieldName' => 'diastolic', 'fieldLable' => 'Diastolic BP', 'min' => 50, 'max' => 100];
    $vitals[] = ['fieldName' => 'heartrate', 'fieldLable' => 'Heart Rate', 'min' => 50, 'max' => 100];
    $vitals[] = ['fieldName' => 'respiratory', 'fieldLable' => 'Respiratory Rate', 'min' => 10, 'max' => 22];
    $vitals[] = ['fieldName' => 'pulseox', 'fieldLable' => 'Pulse Ox', 'min' => 88, 'max' => 100];
    $vitals[] = ['fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 95, 'max' => 99];
    $vitals[] = ['fieldName' => 'glucose', 'fieldLable' => 'Temperature', 'min' => 90, 'max' => 300];
    
    // All
    if( $_GET['filter'] == 'all' ){
        //$sql = "SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 48 HOUR) AND groupid = '$version' ORDER BY checkin_time DESC";
        $sql = "SELECT * FROM waiting_room WHERE checkin_time >= (NOW() - INTERVAL 7 DAY) AND groupid = '$version' ORDER BY checkin_time DESC";
    }
    
    // Confirmed Diagnosis
    if( $_GET['filter'] == 'confirmed' ){
        //$sql ="SELECT * FROM waiting_room inner join (select patient_id, MAX(date_added) as MaxDate from `vitals_history` group by patient_id) as `max_dates` on `waiting_room`.patient_id = `max_dates`.patient_id inner join vitals_history on max_dates.patient_id = vitals_history.patient_id and max_dates.MaxDate = vitals_history.date_added where checkin_time >= (NOW() - INTERVAL 48 HOUR) AND groupid = '$version' AND chief_complaints IS NOT NULL ORDER BY checkin_time DESC";
        $sql = "SELECT * FROM `waiting_room` INNER JOIN (SELECT `patient_id`, MAX(date_added) AS `MaxDate` FROM `vitals_history` GROUP BY `patient_id`) AS `max_dates` ON `waiting_room`.`patient_id` = `max_dates`.`patient_id` INNER JOIN `vitals_history` ON `max_dates`.`patient_id` = `vitals_history`.`patient_id` AND `max_dates`.`MaxDate` = `vitals_history`.`date_added` WHERE `checkin_time` >= (NOW() - INTERVAL 7 DAY) AND `groupid` = '$version' AND `chief_complaints` IS NOT NULL ORDER BY `checkin_time` DESC";
    }
    
    // Awaiting Symptoms
    if( $_GET['filter'] == 'waiting' ){
        //$sql ="SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 48 HOUR) AND groupid = '$version' AND chief_complaints IS NULL ORDER BY checkin_time DESC";
        $sql = "SELECT * FROM `waiting_room` WHERE `checkin_time` >= (NOW() - INTERVAL 7 DAY) AND groupid = '$version' AND `chief_complaints` IS NULL ORDER BY `checkin_time` DESC";
    }
    
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    
    if (mysqli_num_rows($result) > 0) {
        while($data = mysqli_fetch_assoc($result)) {
?>

    <div class="tr" id="<?php echo $data['waitingroom_guid']; ?>" data-user-id="<?php echo $data['patient_id']; ?>">
                        
        <input type="hidden" id="waitingEntryID" value="<?php echo $data['waitingroom_id']; ?>">
                        
                        <!-- Name -->
                        <div class="td patient_info">
                            <strong><?php echo ucwords($data['patient_name']); ?></strong>
                            <?php
                                $pid = $data['patient_id'];
                                $p_query = "SELECT patient_dob, cell FROM patients WHERE patient_id='".$pid."' ";
                                $run_p_query = mysqli_query(ddxrxDBConnect(), $p_query);
                                while($p_data = mysqli_fetch_array($run_p_query)) {
                                    $DOB = $p_data['patient_dob'];
                                    $today = date("Y-m-d");
                                    $diff = date_diff(date_create($DOB), date_create($today));
                                    //echo "<span class='phone'>".format_phone($p_data['cell'])."</span>";
                                    echo "<span class='phone'>".$p_data['cell']."</span>";
                                    echo '<span class="age">'.$diff->format('%y').' yrs</span>';
                                    
                                    $phoneNumber = $p_data['cell'];
                                    
                                }
                            ?>
                        </div>
                        <!-- Name -->

                        <!-- Diagnosis -->
                        <div class="td patient_symptoms">
                            <?php
                                echo $data['diagnosis']!="" ? $data['diagnosis'] : ($data['symptoms']=="" ? "Awaiting chief complaint" : "No diagnosis matched");
                                if((int)$data['is_SEPSIS'] == 1 && ($data['acuity']!="" && ((int) $data['acuity'] >= 5))) {
                                    echo " (SEPSIS)";
                                } else if ((int)$data['is_SIRS'] == 1) {
                                    echo " (SIRS)";
                                }
                            ?>
                            <strong><?php echo $data['symptoms']!="" ? $data['symptoms'] : "Awaiting symptoms"; ?></strong>
                            <?php
                                if (!empty($data['diagnosis']) && $data['diagnosis'] != '') {
                                    $string = trim($data['diagnosis']);
                                    if ((string)$string != "Awaiting chief complaint") {

                                    }
                                }
                            ?>
                                        
                            <?php if( $data['symptom_photo'] != '' ){ ?><a href="<?php echo $data['symptom_photo']; ?>" class="symptom_photo" data-fancybox data-caption="<?php echo $data['symptoms']; ?>">View Photo</a><?php } ?>
                                        
                        </div>
                        <!-- Diagnosis -->

                        <!-- Assign To -->
                        <div class="td patient_assign">
                                        <select class="btn btn-primary col-md-12 physician-dropdown" for="<?php echo $data['waitingroom_id']; ?>">
                                        <option>Assign Physician</option>
                                        <?php
                                            $version = get_version();
                                            $users = "SELECT physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where user_type = 2 and location_id =1 and physician.groupid = '$version'";
                                            $users_query = mysqli_query(ddxrxDBConnect(), $users);
                                            $isSelected = "";
                                                 
                                            while($row = mysqli_fetch_array($users_query)) {
                                            $name = "Dr. ".$row['physician_fname']." ".$row['physician_lname'];
                                        ?>
                                            <option <?php if($data['physician_id']!=0 && $data['physician_id'] == $row['id']){ echo "selected";} ?> value="<?php echo $row['id'] ?>"><?php echo $name; ?></option>
                                        <?php } ?>
                                        </select>
                                        <a target="_blank" href="view_patient.php?wID=<?php echo $data['waitingroom_id'];?>">
                                            <button class="btn btn-primary col-md-12 view_notes">View Notes</button>
                                        </a>
                                    </div>
                        <!-- Assign To -->
                        <?php
                            // $diagnosis = $data['diagnosis'];
                            // $acuity = 0;
                            // $is_SEPSIS = 0;
                            // if($diagnosis != "") $acuity = 2;
    
                            // $sepsis_diseases = ["pneumonia","urinary tract infection (UTI)", "bacteraemia", "meningitis", "influenza", "bronchitis", "asthma", "chronic obstructive pulmonary disease", "appendicitis", "diverticulitis", "cellulitis", "orchitis", "pelvic inflammatory disease", "Pyelonephritis","Viral Syndrome","sinusitis","HIV","Ebola","Infectious Mononucleosis","Dengue Fever","Strep Throat","Pharyngitis","Cerebral abscess","Endocarditis","Osteomyelitis","Diverticulitis","Tuberculosis","Lyme Disease","Fungal Infection","Billiary tract infection","C. Difficile Colitis","Liver abscess","Sepsis","Pelvic Inflammatory Disease (PID)","Typhoid Fever","Septic Arthritis"];
                            // //$sepsis_diseases = ["pneumonia","urinary tract infection", "bacteraemia", "meningitis", "influenza", "bronchitis", "asthma", "chronic obstructive pulmonary disease", "appendicitis", "diverticulitis", "cellulitis", "orchitis", "pelvic inflammatory disease", "Pyelonephritis"];
                        
                            // foreach ($sepsis_diseases as $key => $item) {
                            //     if (stripos($diagnosis, $item) !== false) {
                            //         $is_SEPSIS = 1;
                            //         $acuity = 3;
                            //     }
                            // }
                            
                            // if(strpos($diagnosis,"Myocardial Ischemia") || strpos($diagnosis,"Seizure") || strpos($diagnosis,"Cerebrovascular accident")) {
                            //     $acuity = 3;
                            // }
                        	
                            // if(strpos($diagnosis,"Appendicitis") || strpos($diagnosis,"Cholecystitis") || strpos($diagnosis,"Subaracnoid Hemohhrage")
                            //     || strpos($diagnosis,"Cerebrovascular accident (CVA)") || strpos($diagnosis,"Meningitis" )) {
                            //     $acuity = 4;
                            // }
                            // for($x = 0; $x < count($vitals); $x++) {
                            //     if($data[$vitals[$x]['fieldName']] != 0) {
                            //         if($data[$vitals[$x]['fieldName']] < $vitals[$x]['min'] || $data[$vitals[$x]['fieldName']] > $vitals[$x]['max']) {
                            //             $acuity++;
                            //         }
                            //     }
                            // }

                            $diagnosis = $data['diagnosis'];
                            $acuity = 0;
                            $is_SEPSIS = 0;

                            if (!empty($diagnosis)) {
                                $acuity = 2;

                                $sepsis_diseases = ["pneumonia","urinary tract infection (UTI)", "bacteraemia", "meningitis", "influenza", "bronchitis", "asthma", "chronic obstructive pulmonary disease", "appendicitis", "diverticulitis", "cellulitis", "orchitis", "pelvic inflammatory disease", "Pyelonephritis","Viral Syndrome","sinusitis","HIV","Ebola","Infectious Mononucleosis","Dengue Fever","Strep Throat","Pharyngitis","Cerebral abscess","Endocarditis","Osteomyelitis","Diverticulitis","Tuberculosis","Lyme Disease","Fungal Infection","Billiary tract infection","C. Difficile Colitis","Liver abscess","Sepsis","Pelvic Inflammatory Disease (PID)","Typhoid Fever","Septic Arthritis"];

                                foreach ($sepsis_diseases as $key => $item) {
                                    if (stripos($diagnosis, $item) !== false) {
                                        $is_SEPSIS = 1;
                                        $acuity = 3;
                                    }
                                }

                                
                                if(strpos($diagnosis,"Myocardial Ischemia") || strpos($diagnosis,"Seizure") || strpos($diagnosis,"Cerebrovascular accident")) {
                                    $acuity = 3;
                                }
                                    
                                if(strpos($diagnosis,"Appendicitis") || strpos($diagnosis,"Cholecystitis") || strpos($diagnosis,"Subaracnoid Hemohhrage")
                                    || strpos($diagnosis,"Cerebrovascular accident (CVA)") || strpos($diagnosis,"Meningitis" )) {
                                    $acuity = 4;
                                }
                                for($x = 0; $x < count($vitals); $x++) {
                                    if($data[$vitals[$x]['fieldName']] != 0) {
                                        if($data[$vitals[$x]['fieldName']] < $vitals[$x]['min'] || $data[$vitals[$x]['fieldName']] > $vitals[$x]['max']) {
                                            $acuity++;
                                        }
                                    }
                                }

                            }

                        ?>

                        <!-- Status -->
                        <?php
                        if($acuity != "" && ((int) $acuity >= 4)) {
                            $inOut = "Inpatient";
                            if($is_SEPSIS == 1) $inOut .= "<br/>Sepsis";
                            $class = "text-danger";
                        } else if($acuity != "" && ((int) $acuity == 3)) {
                            $inOut = "Undecided";
                            $class = "text-muted";
                        } else {
                            $inOut = "Outpatient";
                            $class = "text-success";
                        }
                        ?>
                        <div class="td patient_status <?php echo $class; ?>" style="text-align: center;">
                            <b class="inOutText"><?php echo $inOut; ?></b>
                        </div>
                        <!-- Satus -->

                        <!-- Acuity -->
                        <div class="td patient_acuity" style="text-align: center;">
                            <input type="hidden" id="acuityValue" value="<?php echo $acuity != "" ? $acuity : "0"; ?>">
                            <h3 class="card-subtitle mb-2 <?php echo $class; ?>">
                                <b class="acuityText">
                                    <?php echo $acuity!="" ? $acuity : "0"; ?>/10
                                </b>
                            </h3>
                        </div>
                        <!-- Acuity -->

                        <!-- Vitals -->
                        <div class="td patient_vitals">
                        <button class="btn btn-primary col-md-12 addVitals" data-toggle="modal" represents="<?php echo $data['waitingroom_guid']; ?>" data-target="#vitals" style="margin-bottom: 10px;" data-patient-id="<?php echo $data['patient_id']; ?>">
                            <?php //echo $data['vital_json'] == '' ? 'Add' : 'View'; ?>Add</button>
                            <a href="patient_vitals.php?patient_id=<?php echo $data['patient_id']; ?>" class="btn btn-primary addVitals" data-patient-id="<?php echo $data['patient_id']; ?>">View</a>
                        </div>
                        <!-- Vitals -->

                        <!-- Wait Time -->
                        <div class="td patient_waitTime">
                            <h3 class="card-subtitle mb-2 text-muted">
                            <?php
                                $rawtime = $data['checkin_time'];
                                $sqlTime = "SELECT FLOOR((UNIX_TIMESTAMP(NOW()) - 3600 - UNIX_TIMESTAMP(checkin_time))/86400) as day, FLOOR((UNIX_TIMESTAMP(NOW()) - 3600 - UNIX_TIMESTAMP(checkin_time))/3600)%24 as hour, FLOOR((UNIX_TIMESTAMP(NOW()) - 3600 - UNIX_TIMESTAMP(checkin_time))/60)%60 as minute FROM `waiting_room` WHERE checkin_time = '$rawtime'";
                                $resultTime = ddxrxDBConnect()->query($sqlTime);
                                
                                // Associative array
                                $rowTime = $resultTime->fetch_assoc();
                                
                                if( $rowTime['day'] == '0' ){
                                    $days = '00';
                                }elseif( $rowTime['day'] <= 9 ){
                                    $days = '0'.$rowTime['day'];
                                }else{
                                    $days = $rowTime['day'];
                                }
                                
                                if( $rowTime['hour'] == '0' ){
                                    $hours = '00';
                                }elseif( $rowTime['hour'] <= 9 ){
                                    $hours = '0'.$rowTime['hour'];
                                }else{
                                    $hours = $rowTime['hour'];
                                }
                                
                                if( $rowTime['minute'] == '0' ){
                                    $minutes = '00';
                                }elseif( $rowTime['minute'] <= 9 ){
                                    $minutes = '0'.$rowTime['minute'];
                                }else{
                                    $minutes = $rowTime['minute'];
                                }
                                
                                echo "<input type='hidden' id='checkinTime' value='".$data['checkin_time']."'>";
                                echo "<input type='hidden' id='hrs' value='".$hours."'>";
                                echo "<input type='hidden' id='mins' value='".$minutes."'>";
                                
                                echo "<b> ".$days." : ".$hours." : ".$minutes." </b>";
                                
                            ?>
                            </h3>
                            <h6 class="card-subtitle mb-2 text-muted"><b>DD:HH:MM</b></h6>
                        </div>
                        <!-- Wait Time -->
                                    
                        <!-- Action -->
                        <div class="td patient_action">
                            <a href="waitingroom_delete.php?wID=<?php echo $data['waitingroom_id'];?>&request_from=nurse">
                                <button class="btn btn-danger col-md-12" style="margin-bottom: 10px; display: block">Delete</button>
                            </a>
                                        
                            <a href="order.php?id=<?php echo $data['patient_id']; ?>">
                                <button class="btn btn-primary col-md-12">Order</button>
                            </a>

                            <?php echo adt_dashboard_button($data['patient_id']); ?>          
                            <?php echo video_call( $data['patient_id'], $phoneNumber ); ?>
                            <?php echo call_request( $data['patient_id'] ); ?>
                        </div>
                        <!-- Action -->

                        <div class="clear"></div>
                    </div>
                    
    <div class="clear"></div>

<?php } } else { echo '<div style="text-align:center; margin-top: 50px; font-size: 30px;">No patients in queue at this time</div>'; } ?>
<?php mysqli_close(ddxrxDBConnect()); ?>