<?php

    session_start();
    
    include('../process/functions.php');

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: ../provider_login.php");
        die();
    }
    if($_SESSION['userType'] != 'nurse') {
        header("Location: view_record.php");
        die();
    }
    
    $version = get_version();
    $patientsResult = mysqli_query(ddxrxDBConnect(), "SELECT * FROM patients WHERE user_id != 0 AND active = 1 AND groupid = '$version' ORDER BY patient_id DESC");

    function get_page_name() {
        return substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
    }
    function check_page_data(){
        
        // Check if page is available in database
        $page = substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
        $sql = "SELECT * FROM `sitter` WHERE `pageName` ='$page'";
        $result = mysqli_query(ddxrxDBConnect(), $sql);
        $row = mysqli_fetch_assoc($result);

        if( isset($row['pageName']) ){
            return true;
        } else {
            return false;
        }

    }
    
?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Start Video Call - DDXRX</title>
        
        <link rel="stylesheet" type="text/css" href="../assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="../assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="../css/jquery.dataTables.min.css">
        <link rel="stylesheet" type="text/css" href="../assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="../assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="../assets/css/videocall.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script src="../assets/js/sitter.js" type="text/javascript"></script>

    </head>
    <body class="nooverflow">

        <div class="container">
            <div class="iframeContainer">

                <!-- Select Page Navigation -->
                <div class="col-md-12">
                    <span class="navlabel">Select To Navigate Floors</span>
                    <select class="selectbox">
                        <option>Select Page</option>
                        <option value="6west.php" <?php if(get_page_name() == '6west.php'){ echo 'selected'; } ?>>6 West</option>
                        <option value="6east.php" <?php if(get_page_name() == '6east.php'){ echo 'selected'; } ?>>6 East</option>
                        <option value="6north.php" <?php if(get_page_name() == '6north.php'){ echo 'selected'; } ?>>6 North</option>
                        <option value="6south.php" <?php if(get_page_name() == '6south.php'){ echo 'selected'; } ?>>6 South</option>
                        <option value="er.php" <?php if(get_page_name() == 'er.php'){ echo 'selected'; } ?>>Emergency Room</option>
                    </select>
                </div>
                <div class="clear"></div>
                <div class="spacer"></div>
                <!-- Select Page Navigation -->

                <?php                
                if( check_page_data() == true ){
                   
                    // Generate
                    $counter = 0;
                    $page = substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
                    $sql = "SELECT * FROM `sitter` WHERE `pageName` ='$page'";
                    $result = mysqli_query(ddxrxDBConnect(), $sql);
                    $row = mysqli_fetch_assoc($result);

                    $iframeData = json_decode($row['iframeData'], true);

                    foreach($iframeData as $iframe){

                        $counter++;
                        if( $iframe['source'] != '' ){ $closeBtn = '<ion-icon name="close-circle" class="remove"></ion-icon>'; }else{ $closeBtn = ''; }
                        echo '<div class="col-md-3"><div class="item" data-frame="'.$iframe['frame'].'" data-room="'.$iframe['room'].'" data-source="'.$iframe['source'].'"><ion-icon name="add-circle" class="add"></ion-icon>'.$closeBtn.'<div class="channel-label">'.$iframe['room'].'</div><iframe src="'.$iframe['source'].'" name="'.$iframe['frame'].'" class="iframe '.$iframe['frame'].'"></iframe></div></div>';
                        
                        if( $counter == 4 ){
                            echo '<div class="clear"></div><div class="spacer"></div>';
                            $counter = 0;
                        }

                    }

                }else{ ?>

                <div class="col-md-3"><div class="item" data-frame="iframe_1" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_1" class="iframe iframe_1"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_2" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_2" class="iframe iframe_2"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_3" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_3" class="iframe iframe_3"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_4" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_4" class="iframe iframe_4"></iframe></div></div>
                <div class="clear"></div>
                <div class="spacer"></div>

                <div class="col-md-3"><div class="item" data-frame="iframe_5" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_5" class="iframe iframe_5"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_6" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_6" class="iframe iframe_6"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_7" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_7" class="iframe iframe_7"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_8" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_8" class="iframe iframe_8"></iframe></div></div>
                <div class="clear"></div>
                <div class="spacer"></div>

                <div class="col-md-3"><div class="item" data-frame="iframe_9" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_9" class="iframe iframe_9"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_10" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_10" class="iframe iframe_10"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_11" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_11" class="iframe iframe_11"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_12" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_12" class="iframe iframe_12"></iframe></div></div>
                <div class="clear"></div>
                <div class="spacer"></div>

                <div class="col-md-3"><div class="item" data-frame="iframe_13" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_13" class="iframe iframe_13"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_14" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_14" class="iframe iframe_14"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_15" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_15" class="iframe iframe_15"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_16" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_16" class="iframe iframe_16"></iframe></div></div>
                <div class="clear"></div>
                <div class="spacer"></div>

                <div class="col-md-3"><div class="item" data-frame="iframe_17" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_17" class="iframe iframe_17"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_18" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_18" class="iframe iframe_18"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_19" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_19" class="iframe iframe_19"></iframe></div></div>
                <div class="col-md-3"><div class="item" data-frame="iframe_20" data-room="" data-source=""><ion-icon name="add-circle" class="add"></ion-icon><div class="channel-label"></div><iframe src="" name="iframe_20" class="iframe iframe_20"></iframe></div></div>
                <div class="clear"></div>
                <div class="spacer"></div>
                
                <?php } ?>

            </div>
        </div>
        
        <div class="sitterContainer">
            <ion-icon name="close" class="closeSitter"></ion-icon>
            <div class="container optimized-container" id="sitterContainer" data-current-frame="0">
                <div class="col-md-12">
                    
                    <div class="row">
                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=659" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>659</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=660" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>660</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=661" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>661</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                        <a href="../sitter_stream.php?room_name=662" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>662</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=663" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>663</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=664" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>664</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->
                        <div class="clear"></div>
                        <div class="spacer"></div>
                    </div>

                    <div class="row">
                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=665" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>665</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=666" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>666</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=667" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>667</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=668" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>668</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=669" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>669</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=670" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>670</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->
                        <div class="clear"></div>
                        <div class="spacer"></div>
                    </div>

                    <div class="row">
                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=671" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>671</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=672" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>672</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=673" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>673</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=674" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>674</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=675" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>675</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=676" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>676</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->
                        <div class="clear"></div>
                        <div class="spacer"></div>
                    </div>

                    <div class="row">
                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=677" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>677</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->

                        <!-- Item -->
                        <div class="col-md-2">
                            <a href="../sitter_stream.php?room_name=678" class="target" target="iframe_1">
                                <div class="item">
                                    <h6>View Room<span>678</span></h6>
                                </div>
                            </a>
                        </div>
                        <!-- Item -->
                        <div class="clear"></div>
                        <div class="spacer"></div>
                    </div>
                    
                </div>
            </div>
        </div>

    </body>
</html>
