<?php

    session_start();

    if( !isset($_SESSION["username"]) && !isset($_GET['noforce']) ){
        
       header( 'location: auth_videocall.php?callid='.$_GET['room_name'] );
        
    }

    function generateRandomString($length = 10) {
    
        //$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $characters = '0123456789';
            
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
        
    if( isset($_SESSION["username"]) ){
            
        $username = $_SESSION["username"];
        
    }else{
        
        if( isset($_GET['username']) ){
            $username = $_GET['username'];
        }else{
            $username = 'User_'.generateRandomString('5');
        }
        
    }
        
?>
<!DOCTYPE html>
<html>
<head>
    
    <title>Doctor Ai - Video Call</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/transcribe.css">

    <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="assets/js/video_call.js"></script>
    <script src="assets/js/webclient.js?1=238080"></script>

</head>
<body data-meeting-id="<?php echo $_GET['room_name']; ?>">
    
    <script src='https://clinicians.space/external_api.js'></script>
    <!-- <script src='https://ddxrx.tv/external_api.js'></script> -->
   
    <section id="main-content">

         <div class="transcribe-tool-bar">

            <div class="inner">
                <h5 class="indicator">Transcription In Progress</h5>
                <div class="transcription_controls">
                    <!--<a href="javascript:;" class="pause"><ion-icon name="pause-circle-outline"></ion-icon></a>-->
                    <a href="javascript:;" onclick="javascript: return closeTranscriber();" class="stop"><ion-icon name="stop-circle-outline"></ion-icon></a>
                    <!--<a href="javascript:;" class="play"><ion-icon name="play-circle-outline"></ion-icon></a>-->
                </div>
            </div>
            
        </div>

        <section class="wrapper">
            <div class="row">
                <div id="meeting"></div>
            </div>
        </section>
    </section>

    <script>
     var isTrasncriberisON= false;
    var chatMessage= '';
    var objTranscriber;
    var objTranscriber1;
    $(document).ready(function() {
       
        const screenHeight = jQuery(window).height();
        const domain = 'clinicians.space';
        // const domain = 'ddxrx.tv';
        const options = {
            roomName: '<?php echo $_GET['room_name']; ?>',
            //height: 700,
            height: screenHeight,
            parentNode: document.querySelector('#meeting'),
            userInfo: {
                displayName: '<?php echo $username; ?>'
            },
            overwriteConfig: {
              disableNS: true,
              toolbarButtons: ['chat']
            }
        };
        const api = new JitsiMeetExternalAPI(domain, options);
    
        api.on('videoConferenceLeft', (user) => {
            closeTranscriber();
            location.href = "https://www.ddxrx.net"
        });
        
        api.on('videoConferenceJoined', (user) => {
            console.log('videoConferenceJoined');
            console.log(user);
        });
        api.addListener( 'toolbarButtonClicked', async (data) => {
            console.log('toolbarButtonClicked');
            closeTranscriber()
            $(".transcribe-tool-bar").show();
            objTranscriber = await doctorAiStartSTT(function(detectedText){
                console.log(detectedText)

                chatMessage +=detectedText+'\n';
                api.executeCommand('sendChatMessage', detectedText, '')
            });
            //console.log("audioOutputId",audioOutputId)
             objTranscriber1 = await doctorAiStartSTTNew(function(detectedText){
                console.log(detectedText)

                chatMessage +=detectedText+'\n';
                api.executeCommand('sendChatMessage', detectedText, '')
            }); 
        });
        //api.executeCommand('sendEndpointTextMessage', 'receiverParticipantId', 'text'); 
        
    });

    function closeTranscriber() {
        console.log("closeTranscriber triggered");
            $(".transcribe-tool-bar").hide();
            if(objTranscriber) {
                objTranscriber();
            }
            if(objTranscriber1) {
                objTranscriber1();
            }
           
            if(chatMessage && chatMessage!=='') {
                let json = {
                    "dictation_id": Math.floor(Math.random() * 1000000000), // 9 digit
                    "patient_id": "38",
                    "unique_id": "5347", // 4 digit
                    "message": chatMessage
                };

                $.ajax({
                    method: "POST",
                    url: "https://patient.ddxrx.com/api/dictation-notes.php",
                    contentType: "application/json",
                    data: JSON.stringify(json)
                })
                .done(function( msg ) {
                    chatMessage='';
                    alert( "Data Saved: " + msg );
                });
            }

        }
    </script> 
    
</body>
</html>
