<?php
session_start();
if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}
if(isset($_GET['id'])) {
    include('conn.php');
    $nurse_id = $_GET['id'];

    $query=mysqli_query($conn, "SELECT * FROM all_users as au join nurse as n on au.userid = n.user_id WHERE n.id=".$nurse_id);
    $row=mysqli_fetch_array($query);
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Edit <?php echo $row['nurse_fname']." ".$row['nurse_lname']; ?> - DDxRx Admin Panel | Dashboard</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <!-- Morris chart -->
    <link rel="stylesheet" href="bower_components/morris.js/morris.css">
    <!-- jvectormap -->
    <link rel="stylesheet" href="bower_components/jvectormap/jquery-jvectormap.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- bootstrap wysihtml5 - text editor -->
    <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    
    <style type="text/css">
		form .error {
		  color: #ff0000;
		  text-align: left !important;
		}

	</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php
    include('includes/header.php');
    include('includes/sidebar.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Edit nurse
                <small>Nurse</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Edit Nurse</li>
            </ol>
        </section>
        
        <!-- Main content -->
        <section class="content">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-primary">
                        <form method="POST" action="addNurse.php" name="edit_nurse_form" id="edit_nurse_form">
                            <input type="hidden" name="nurse_id" value="<?php echo $row['id']; ?>">
                            <div class="container-fluid">
                                <br>
                                Login Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>Username:</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" name="username" value="<?php echo $row['username']; ?>" disabled class="form-control">
                                    </div>
                                    <div class="col-md-2">
                                        <label>Password:</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="password" name="password" class="form-control">
                                    </div>
                                </div>
                                Personal Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>First Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="nurse_fname" value="<?php echo $row['nurse_fname']; ?>" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Last Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="nurse_lname" value="<?php echo $row['nurse_lname']; ?>" class="form-control" required>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label for="email">Email:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="email" name="nurse_email" value="<?php echo $row['nurse_email']; ?>" id="email" Placeholder="nurse@email.com" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Date of Birth:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="date" name="nurse_dob" value="<?php echo $row['nurse_dob']; ?>" class="form-control" required>
                                    </div>
                                    
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>Qualification:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <select class="form-control" name="nurse_degree" required>
                                            <option <?php if($row['nurse_degree']=="RN") echo "selected"; ?> value="RN">RN</option>
                                            <option <?php if($row['nurse_degree']=="LPN") echo "selected"; ?> value="LPN">LPN</option>
                                            <option <?php if($row['nurse_degree']=="MA") echo "selected"; ?> value="MA">MA</option>
                                            <option <?php if($row['nurse_degree']=="Manager") echo "selected"; ?> value="Manager">Manager</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Mobile Number:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="mobile_phone" value="<?php echo $row['mobile_phone']; ?>" class="form-control" required>
                                    </div>
                                    
                                    <!--<div class="col-md-2">-->
                                    <!--    <label>Speciality:</label>-->
                                    <!--</div>-->
                                    <!--<div class="col-md-4">-->
                                    <!--    <select class="form-control" name="nurse_speciality">-->
                                    <!--    <option <?php //if($row['nurse_speciality']=="cardiologist") echo "selected"; ?> value="cardiologist">Cardiologist</option>-->
                                    <!--    <option <?php //if($row['nurse_speciality']=="inernalMedicine") echo "selected"; ?> value="inernalMedicine">Internal Medicine</option>-->
                                    <!--    <option <?php //if($row['nurse_speciality']=="Hospitalist") echo "selected"; ?> value="Hospitalist">Hospitalist</option>-->
                                    <!--</select>-->
                                    <!--</div>-->
                                </div>
                                <div class="row form-group">
                                    <div class="col-md-4 col-md-offset-4">
                                        <button class="btn btn-primary col-md-12">Update Nurse</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer">
        <div class="pull-right hidden-xs">
            <b>Version</b> 2.4.0
        </div>
        <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
        reserved.
    </footer>
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
<!--<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>-->

<!-- jQuery UI 1.11.4 -->
<script src="bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
    $.widget.bridge('uibutton', $.ui.button);
</script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- Morris.js charts -->
<script src="bower_components/raphael/raphael.min.js"></script>
<script src="bower_components/morris.js/morris.min.js"></script>
<!-- Sparkline -->
<script src="bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<!-- jQuery Knob Chart -->
<script src="bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="bower_components/moment/min/moment.min.js"></script>
<script src="bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<!-- datepicker -->
<script src="bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Slimscroll -->
<script src="bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>



<script>

$.validator.addMethod("allowOnlyTextAndNumber", function (value) {
        return /^[a-zA-Z0-9_\-\.\@\/]*$/.test(value) // has only allowed chars letter
    }, "The username contains non-admitted characters");
    
$.validator.addMethod("hasAlphabet", function(value, element) {
		if (this.optional(element)) {
			return true;
		}
		
	    return /[a-zA-Z]/.test(value);
	}, "Your username or email have to must be at least 1 a to z alphabet character.");

  // Wait for the DOM to be ready || .-_@
$(function() {

  // Initialize form validation on the edit_nurse_form form.
  // It has the name attribute "edit_nurse_form"
  $("form[name='edit_nurse_form']").validate({
    // Specify validation rules
    rules: {
		// The key name on the left side is the name attribute
		// of an input field. Validation rules are defined
		// on the right side
		username: {
	        required: true,
	        allowOnlyTextAndNumber: true,
	        hasAlphabet: true,
	        minlength: 6,
	        maxlength: 20,
	        // Using the normalizer to trim the value of the element
	        // before validating it.
	        //
	        // The value of `this` inside the `normalizer` is the corresponding
	        // DOMElement. In this example, `this` references the `username` element.
	        normalizer: function(value) {
	          return $.trim(value);
	        },
		},
		nurse_fname:{
		    required: true
		},
		nurse_lname:{
		    required: true
		},
		nurse_dob:{
		    required: true
		},
		nurse_degree:{
		    required: true
		},
		mobile_phone:{
		    required: true,
		},
		password: {
			required: false,
			minlength: 6
		}
    },
    // Specify validation error messages
    messages: {
      password: {
        required: "Please provide a password",
        minlength: "Your password must be at least 6 characters long"
      }, 
      
      username: {
          minlength: "Your username must be at least 6 characters long"
      }
    },
    // Make sure the form is submitted to the destination defined
    // in the "action" attribute of the form when valid
    submitHandler: function(form) {
       form.submit();
    }
  });
});
</script>
</body>
</html>
