<?php
include ('./includes/database_include.php');
require_once './IP2Location.php';
$locations = array();
// Standard lookup with no cache
$loc = new IP2Location('databases/IP-COUNTRY-SAMPLE.BIN', IP2Location::FILE_IO);

$perpage = 15;
$tresult = mysqli_query($con, "SELECT DISTINCT visitor_session as session_id FROM visitor_info order by id desc");
$totalcount = mysqli_num_rows($tresult);
$totalpage = ceil($totalcount/$perpage);

$page = 0;
if(isset($_GET['p']) && $_GET['p']!=''){
	$page = (int)$_GET['p'];
}

if($page<1 || $page>$totalpage){
	$page = 1;
}

$limit1 = $perpage*$page-$perpage;
$limit2 = $perpage;


$result = mysqli_query($con, "SELECT DISTINCT visitor_session as session_id FROM visitor_info order by id desc limit ".$limit1.", ".$limit2);
?>
<!DOCTYPE html>
<html>
<head>
<title>The EDDM</title>
<link rel="stylesheet" type="text/css" href="css/css_structure.css">
<?php include ('header_tag.php');?>
<script>
function go_to_page(){
	var page_no = document.getElementById('pageno').value;
	if(page_no!=''){
		top.location = '?p='+page_no;
		return;
	}
}
</script>
</head>
<body>
<div id="maincontainer">
  <?php include ('header_view.php');
$i=1;
$j=0;?>
  <div id="contentwrapper">
    <div id="centercolumn">
      <div id="content"><span class="textbox">
        <h2>All Sessions of Analytics</h2>
        <div class="form">
          <div class="form-container">
            <table width="100%" align="center" class="blue">
              <thead>
                <tr>
                  <th>Sl.</th>
                  <th>Start Time</th>
                  <th>User</th>
                  <th>Location</th>
                  <th>-</th>
                </tr>
              </thead>
              <tbody>
                <?PHP
                while($row = mysqli_fetch_array( $result )) {

				$i=$i*-1;
				$j=$j+1;
                ?>
                <tr <?php if ($i==1)  echo "class='odd'"; ?>>
                  <td valign="top"><strong><?PHP echo $j; ?></strong></td>
                  <td valign="top">
                  <?php
				  echo mysqli_fetch_object(mysqli_query($con, "select MIN(visitor_time) as starttime from visitor_info where visitor_session = '".$row['session_id']."'"))->starttime;
				  ?>
                  </td>
                  <td valign="top">
                  <?php
				  $ures = mysqli_query($con, "select DISTINCT visitor_userid as userid from visitor_info where visitor_session = '".$row['session_id']."' and visitor_userid !='' and visitor_userid IS NOT NULL limit 1");
				  if(mysqli_num_rows($ures)){
					  	$uid =  mysqli_fetch_object($ures)->userid;
					  
					 	if($uid!='' && $uid!=NULL){
							$tresult = mysqli_query($con, "SELECT first_name, last_name FROM theeddm_users WHERE id='".$uid."' limit 1");
							if(mysqli_num_rows($tresult)){
								$udata = mysqli_fetch_array($tresult);
								echo '<strong>'.$udata['first_name'].'</strong>';
							}
						}
					  
				  } else {
					  echo '<i>unknown</i>';  
				  }
				  ?>
                  </td>
                  <td valign="top">
				  <?PHP 
				  $ures = mysqli_query($con, "select DISTINCT visitor_ip as ip from visitor_info where visitor_session = '".$row['session_id']."' and visitor_ip !='' and visitor_ip IS NOT NULL limit 1");
				  if(mysqli_num_rows($ures)){
					$ip =  mysqli_fetch_object($ures)->ip;	
					if($ip!=''){
						echo ucwords(strtolower($loc->lookup($ip, IP2Location::COUNTRY_NAME))) . ' ( ' . $ip . ' )';
					}	
				  }
				  ?>
				  </td>
                  <td valign="top">
                    <a href="./session_details.php?si=<?php echo $row['session_id']; ?>" target="_blank">Detail</a>
                  </td>
                </tr>
                <?PHP }?>
				
				
				<?php if($totalcount){ ?>
				<tr>
                  <td valign="top" colspan="7" bgcolor="white" style="text-align:right;">
						Page <select id="pageno" name="pageno" onchange="javascript: go_to_page()">
							<?php for($pc = 1; $pc<=$totalpage; $pc++){ ?>
							<option value="<?php echo $pc; ?>"<?php if($pc==$page){ ?> selected<?php } ?>><?php echo $pc; ?></option>
							<?php } ?>
						</select> of <?php echo $totalpage; ?>
				  </td>
                </tr>
				<?php } ?>
				
              </tbody>
            </table>
          </div>
        </div>
        </span></div>
    </div>
  </div>
  <?php include ('footer_view.php');?>
</div>
</body>
</html>
