$(document).ready(function(){
    
    // Global Variables
    var patient_id = $('body').data('patient-id');
    
    
    // Get Recent Vitals
    function get_recent_vitals(patient_id){
        
        $.ajax({
            type: 'POST',
            url: 'process/get_recent_vitals.php',
                
            data: {
            	patient_id:patient_id
            },

            success: function(response) {
                
                // Do something
                $('table.single_user_data tbody').html(response);
                
            },
            
            fail: function(response){
            	Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
            }
        });
        
    }
    
    
    $('body').on('click', '.addVitals', function() {
        var patient_id = $(this).data('patient-id');
        $('#hidden_patient_id').val( patient_id );
    });
    
    $('body').on('click', '.popup_vitals', function() {
        $('.popup-container').fadeIn();
    });
    
    $('body').on('click', '.addVitals', function() {
        $('.popup-container').fadeIn();
    });
    
    $('body').on('click', '.popup-container .button.cancel', function() {
        $('.popup-container').fadeOut();
    });
            
    $('body').on('click', '.add_vitals', function() {
                    
        var patient_id = $('#hidden_patient_id').val();
        var systolicBP = $('#systolicBP').val();
        var diastolicBP = $('#diastolicBP').val();
        var heartRate = $('#heartRate').val();
        var respRate = $('#respRate').val();
        var pulseOX = $('#pulseOX').val();
        var temp = $('#temp').val();
        var glucose = $('#glucose').val();
        var weight = $('#weight').val();
                    
        $.ajax({
            type: 'POST',
            url: 'process/save_vital_history.php',
            
            data: {
            	patient_id:patient_id,
            	systolicBP:systolicBP,
            	diastolicBP:diastolicBP,
            	heartRate:heartRate,
            	respRate:respRate,
            	pulseOX:pulseOX,
            	temp:temp,
            	glucose:glucose,
            	weight:weight
            },
            
            beforeSend: function() {
            					
            },
            success: function(response) {
                
                $('.textbox').val();
                $('.popup-container').fadeOut();
                            
                Swal.fire({
                    icon: 'success',
                    title: 'Data Saved',
                    text: "The vitals data have been saved",
                });
                
                get_recent_vitals(patient_id);             
                                
            },	
            fail: function(response){
            	// Do Something
            }
            
        });
                     
    });
    
    

    
    
    // Auto Sync on load
    /*
    $.ajax({
        type: 'POST',
        url: 'process/syncvitals.php',
            
        data: {
        	patient_id:patient_id
        },
            
        beforeSend: function() {
            
            $('.syncContainer').fadeIn();
            					
        },
        
        success: function(response) {
            
            get_recent_vitals(patient_id);
            $('.syncContainer').fadeOut();
            
        },
        
        fail: function(response){
        	Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Something went wrong!',
            });
        }
            
    });
    */
    
    $('#stopTime').click(function(){
        $('#time-counter').attr('data-seconds', '0');
    });
    
    
    $('.total-time .selectbox').on('change', function (e) {
        var optionSelected = $("option:selected", this).data('target');
        var valueSelected = this.value;
        
        $.get(optionSelected, function(data, status){
            $('.total-time span').html(data);
        });
        
    });
    
    
    /* Show Billing Codes */
    $('.popup_billing_codes').click(function(){
        $('.billing-code-popup').css("display", "flex");
    });
    
    // Close Button
    $('.billing-code-popup .close').click(function(){
        $('.billing-code-popup').fadeOut();
    });
    
    // Submit CPT codes
    $('.billing-code-popup .button').click(function(){
        
        var cpt_codes = [];
        var patient_id = $('body').data('patient-id');
        var user_type = $('body').data('user-type');
        
        if( user_type == 'nurse' ){
            var provider_id = $('body').data('nurse-id');
        }else if( user_type == 'doctor' ){
            var provider_id = $('body').data('physician-id');
        }
        
        $(".billing-code-popup .checkbox").each(function(){
            
            if( $(this).is(':checked') === true ){
                cpt_codes.push( $(this).val() );
            }
            
        });
        
        var sendData = {
            "user_type" : user_type,
            "provider_id" : provider_id,
            "patient_id" : patient_id,
            "cpt_code" : cpt_codes
        };
        
        $.ajax({
            type: 'POST',
            url: 'process/submit_cpt_code.php',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                
            beforeSend: function() {
                    					
            },
                
            success: function(response) {
                    
                $('.billing-code-popup').hide();
                    
                if( response.result === true ){
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'CPT code sent',
                    });
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',
                    });
                }
                    
            },
                
            fail: function(response){
                    
                $('.billing-code-popup').hide();
                    
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
                    
            }
                    
        });
        
    });
    
    

    // Create the note
    $('.popup_new_notes').click(function(){
        
        var cctype = $('body').data('cctype');
        var NoteTitle = '';
        
        if( cctype == 'rpm' ){
            NoteTitle = 'RPM Note';
        }else if( cctype == 'cpm' ){
            NoteTitle = 'CPM Note';
        }
        
        $('body').prepend('<div class="floating-notes rpm-notes"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title" value="'+NoteTitle+'"><textarea class="resizable-editor" placeholder="Start Typing Notes here..."></textarea><div class="status"></div></div>');
        
        // Resizable
        $( ".floating-notes" ).resizable({
           //alsoResize: ".resizable-editor"
        });
        
        // Drag and drop
        $( ".floating-notes" ).draggable();
        
    });
    
    // Note PLUS Button
    $('body').on('click', '.floating-notes .add', function() {
        
        if( cctype == 'rpm' ){
            NoteTitle = 'RPM Note';
        }else if( cctype == 'cpm' ){
            NoteTitle = 'CPM Note';
        }
        
        $('body').prepend('<div class="floating-notes rpm-notes"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title" value="'+NoteTitle+'"><textarea class="resizable-editor" placeholder="Start Typing Notes here..."></textarea><div class="status"></div></div>');
        
        // Resizable
        $( ".floating-notes" ).resizable({
           //alsoResize: ".resizable-editor"
        });
        
        // Drag and drop
        $( ".floating-notes" ).draggable();
        
    });
    
    // Close Button
    $('body').on('click', '.floating-notes .close', function() {
        
        $(this).parent().parent().remove();
        
    });
    
    
    // Save notes for RPM
    $('body').on('click', '.floating-notes.rpm-notes .save', function(){
        
        var user_type = $('body').data('user-type');
        
        var provider_id = '';
        if( user_type == 'doctor' ){
            provider_id = $('body').data('physician-id');
        }else if( user_type == 'nurse' ){
            provider_id = $('body').data('nurse-id');
        }
        
        var save_type = 'new';
        var note_type = $('body').data('cctype');
        var created_by = provider_id;
        var patient_id = $('body').data('patient-id');
        var note_title = $('.resizable-title-bar').val();
        var note_text = $('.resizable-editor').val();
        
        $.ajax({
            type: "POST",
            url: 'process/save_note.php',
            
            data:{
                patient_id:patient_id,
                save_type: save_type,
                note_type: note_type,
                created_by : created_by,
                note_title: note_title,
                note_text: note_text
            },
            
            success: function(data){
                
                //$('.floating-notes .status').html('<div class="saved">Note Saved</div>');
                $('.floating-notes').remove();
            },
            
            fail: function(response){
            
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
                        
            }
        
        });
        
    });
    
    
    // Yes/No CCM Button
    $('body').on('click', '.toggle', function(){
        
        var answer = '';
        var patient_id = $(this).data('patient-id');
        
        if( $(this).hasClass('yes') === true ){
            
            answer = 'no';
            
            Swal.fire({
                title: 'Agreement',
                text: "I certify that patient do not want to continue the CCM program.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Agree'
            }).then((result) => {
                if (result.isConfirmed) {
                    
                    $('#ccm_id_'+patient_id).removeClass('yes');
                    $('#ccm_id_'+patient_id).addClass('no');
                    
                }
            });
            
            
        }else if( $(this).hasClass('no') === true ){
            
            answer = 'yes';
            
            Swal.fire({
                title: 'Agreement',
                text: "I certify that the patient have multiple (two or more) chronic conditions expected to last at least 12 months and I have obtained verbal consent prior to enrolling the patient into the CCM program.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Agree'
            }).then((result) => {
                if (result.isConfirmed) {
                    
                    $('#ccm_id_'+patient_id).removeClass('no');
                    $('#ccm_id_'+patient_id).addClass('yes');
                    
                }
            });
            
        }
        

        $.ajax({
            type: "POST",
            url: 'process/save_ccm.php',
            
            data:{
                patient_id:patient_id,
                answer: answer,
            },
            
            success: function(data){
                
            },
            
            fail: function(response){
            
                Swal.fire({
                    icon: 'success',
                    title: 'Saved',
                    text: 'CCM Saved',
                });
                        
            }
        
        });
        
    });
    
    
    // Redirect On Click
    // $('body').on('click', '#myTable tbody tr td.enabled', function() {
    //     var patientId = $(this).parent().data('patient-id');
    //     window.location.replace("patient_vitals.php?patient_id="+patientId+"&cctype=rpm");
    // });
    
    
    
    
    
    $('body').on('click', '#myTable tbody tr', function() {
        
        // Register patiend ID into variable
        var table_patient_id = $(this).attr('id');
        
        // Add Highlight Class
        $(this).addClass('highlighted');
        
        var patientArray = [];
        
        $("#myTable tbody tr").each(function(){
            if( $(this).hasClass("highlighted") ){
                patientArray.push($(this).attr('id'));
            }
        });
        
        var patientOBJ = JSON.stringify(patientArray);
        
        // Store in cookie
        Cookies.set('highlightHistory', patientOBJ, { expires: 7 });
        
    });
    
    $("#myTable tbody tr").dblclick(function(){
        
        // Register patiend ID into variable
        var table_patient_id = $(this).attr('id');
        
        window.location.replace("patient_vitals.php?patient_id="+table_patient_id+"&cctype=rpm");
        
    });
    
    
    // Highlight all clicked entries from cookies
    var highlightJson = Cookies.get('highlightHistory');
    var highlightArray = JSON.parse(highlightJson);
        
    for (let i = 0; i < highlightArray.length; ++i) {
        $('#'+highlightArray[i]).addClass('highlighted');
        $('.'+highlightArray[i]).addClass('highlighted');
        console.log('.'+highlightArray[i]);
    }
    
    
});