$(document).ready(function(){
    
    localStorage.setItem("entity", "");
    
    $('body').on('click', '.common-symptoms a', function() {
        var symptom = $(this).attr('data-symptoms');
        $('.textbox.search_phrase').val(symptom);
    });
    
    // Send Symptoms
    $('body').on('click', '.form-container .button', function() {
        
        var user_id = '1';
        var userInput = $('.search_phrase').val();
        var entity = localStorage.getItem("entity");
        
        var sendData = {
            "user_id" : user_id,
            "question" : userInput,
            "entity" : entity
        };
        
        $.ajax({
            type: "POST",
            url: 'https://ddxrx.ai',

            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            beforeSend: function() {
                $('.response-container h1').text('Thinking . . .');
                $('.response-container h1').addClass('thinking');
                $('.bot-reaction').removeClass('idle');
                $('.bot-reaction').addClass('thinking'); 
                $('.form-container .textbox').addClass('thinking');
                $('.common-symptoms h6').addClass('thinking');
            },

            success: function(data){
                
                if( data.response == 'success' || data.response == 'Success' ){
                    
                    $('.response-container h1').text('Please choose one of the following symptoms');
                    //$('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                    
                    $('.option_symptoms').fadeIn();
                    $('.common-symptoms').remove();
                    
                    let result = data.symptoms_data;
    			    for (let user_options of result) {
        			    //console.log( user_options.option.Question );
        			    $('.option_symptoms ul').append('<li>'+user_options.option.Question+'</li>');
    			    }
        			
                    
                }else{
                    
                    setTimeout(function(){
                        
                        $('.response-container h1').text(data.response);
                        //$('.response-container h6').text(' ');
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        
                    }, 1000);
                    
                    // Set The Entity Value In storage
                    localStorage.setItem("entity", data.intent);
                    
                }

            },
            
            failure: function(errMsg) {
                
                $('.response-container h1').text('I am malfunctioning! Try again later.');
                $('.bot-reaction').removeClass('thinking');
                $('.bot-reaction').addClass('angry');

            }
            
        });
        
        
    });
    
    
    
    $('body').on('click', '.option_symptoms li', function() {
        
        var question = $(this).text();
        
        var sendData = {
            "question" : question,
        };
        
        $.ajax({
            type: "POST",
            url: 'https://ddxrx.ai/questionSearch',
        
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                    
            beforeSend: function() {
                $('.response-container h1').text('Thinking . . .');
                $('.response-container h1').addClass('thinking');
                $('.bot-reaction').removeClass('idle');
                $('.bot-reaction').addClass('thinking'); 
                $('.form-container .textbox').addClass('thinking');
                $('.common-symptoms h6').addClass('thinking');
                
                $('.option_symptoms').fadeOut();
                $('.option_symptoms ul').html('');
            },
        
            success: function(data){
                
                setTimeout(function(){
                    $('.response-container h1').text(data.symptoms);
                    //$('.response-container h6').text(data.symptoms);
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                    
                    Swal.fire({
                      title: 'Symptoms Added',
                      text: "Would you like to add more symptoms? Or want to see results?",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Results',
                      cancelButtonText: 'Add More',
                      
                    }).then((result) => {
                      if (result.value) {
                        Swal.fire(
                          'Deleted!',
                          'Your file has been deleted.',
                          'success'
                        )
                      }
                    })
                    
                }, 1000);
                
            },
                    
            failure: function(errMsg) {
        
            }
        });
        
    });
    
    
    /* ==================================================== */
    /* Navigation Menu */
    /* ==================================================== */
    $('body').on('click', '.nav-menu.open', function() {
        
        $('.wrapper').addClass('blur');
        $('#particles-js').addClass('blur');
        $('.nav-container').addClass('show');
        
        $('.nav-menu.open').addClass('close');
        $('.nav-menu.open').removeClass('open');
        
    });
    
    //$('.nav-menu.close').click(function(){
    $('body').on('click', '.nav-menu.close', function() {
        
        $('.wrapper').removeClass('blur');
        $('#particles-js').removeClass('blur');
        $('.nav-container').removeClass('show');
        
        $('.nav-menu.close').addClass('open');
        $('.nav-menu.close').removeClass('close');
        
    });
});