jQuery(document).ready(function($){
    
    $('.imagegallery .delete').click(function(){
        
        var image_id = $(this).data('image-id');
        var row = 'row_'+image_id;
        
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {



                    // Ajax Start
                    $.ajax({
            			type: 'POST',
            			url: 'process/deletegallery.php',
            
            			data: {
            				image_id:image_id
            			},
            
            			beforeSend: function() {
            				// Do Something
            			},
            			success: function(data) {
            				Swal.fire({
                                icon: data.type,
                                title: data.rstatus,
                                text: data.desc
                            });
                            $('#'+row).hide();
            			}
            			
            		});
            		// Ajax End
                    
                    
                    
                }
            })
        });

});