jQuery(document).ready(function($){
    
    // Set Height
    var bodyHeight = $(window).height();
    var controlsHeight = $('.patient-chat-container .chat-controls').innerHeight();
    var messageList = bodyHeight-controlsHeight-55;
    
    $('.message-list-container').css('height',messageList);
    
    // Get Initial Messages
    var user_id = $('.message-list-container').data('patient-id');
        
    $.ajax({
		type: 'POST',
		url: 'process/chat/show_room_patient.php',
            
		data: {
			user_id:user_id
		},

		beforeSend: function() {
		    // Do Something
			$('.message-list-container .message-list').html('');
		},
		success: function(response) {
            // Do something
            
            if( response[0].response_status == 'refresh' ){
                
                //alert('should redirect');
                window.location.reload();
                
            }else{
             
                $('.message-list-container').attr('data-room-id', response[0].room_id);
                $('.message-list-container').attr('data-total-msg', response.length);
                
                let result = response;
    			for (let messenger of result) {
        			
        		    $('.message-list-container .message-list').append('<li><div class="avatar"><i class="flaticon-user"></i></div><div class="desc"><strong>'+messenger.user_profile.full_name+'</strong><p>'+messenger.message+'</p></div><span class="datetime">'+messenger.message_date+'</span></li>');
        			
    			}
    			
                $('.message-list-container').animate({ scrollTop: $('.message-list-container')[0].scrollHeight}, 30);
            
            } // End if

		},
			
		fail: function(response){
			//alert('Update Failed!');
		}

	});
        
    
    
    // Update Chat
    function update_chat(){
        
        var user_id = $('.message-list-container').data('patient-id');
        var room_id = $('.user-meta').attr('data-room-id');
        var total_msg = $('.message-list-container').attr('data-total-msg');
        
        $.ajax({
    		type: 'POST',
    		url: 'process/chat/get_messages.php',
                
    		data: {
    			user_id:user_id,
    			room_id:room_id,
    		},
    
    		beforeSend: function() {
    		    // Do Something
    		},
    		success: function(response) {
    		    
    		    var last_item = response.length-1;
    		    var total_msg = parseInt($('.message-list-container').attr('data-total-msg'));
    		    
    		    console.log(total_msg);
    		    
    		    if( response.length > total_msg ){
        	        $('.message-list-container .message-list').append('<li><div class="avatar"><i class="flaticon-user"></i></div><div class="desc"><strong>'+response[last_item].user_profile.full_name+'</strong><p>'+response[last_item].message+'</p></div><span class="datetime">'+response[last_item].message_date+'</span></li>');
    		        total_msg = total_msg+1;
    		        $('.message-list-container').attr('data-total-msg', total_msg);
    		        $('.message-list-container').animate({ scrollTop: $('.message-list-container')[0].scrollHeight}, 500);
    		    }
    		    
    		},
    			
    		fail: function(response){
    			//alert('Update Failed!');
    		}
    
    	});
        
    }
    
    
    
    
    // Send Message
    var txtMessageBlock = $('.chat-controls textarea').val();
    
    $('.chat-controls').on('click', '.send-message', function() {
        //if( txtMessageBlock != '' ){
        if ($('.chat-controls textarea').val().length){
            
            var room_id = $('.message-list-container').attr('data-room-id');
            var sent_by = $('.message-list-container').attr('data-patient-id');
            var sent_to = $('.user-meta').attr('data-user-id');
            var sender_type = '3';
            var message = $('.chat-controls textarea').val();
            var message_type = 'text';
            
            $.ajax({
    			type: 'POST',
    			url: 'process/chat/send_message.php',
                
    			data: {
    				room_id:room_id,
    				sent_by:sent_by,
    				sent_to:sent_to,
    				sender_type:sender_type,
    				message:message,
    				message_type:message_type
    			},
    
    			beforeSend: function() {
    			    // Do Something
    			},
    			success: function(response) {
    			    $('.chat-controls textarea').val('');
    			    
    			    if( response == 'true' ){
    			        
    			        update_chat();
    			    }
    			},
    			
    			fail: function(response){
    				//alert('Update Failed!');
    			}
    
    		});
            
        } 
    });
    
    
    // Check messages every 5 seconds
    window.setInterval(function(){
        update_chat();
    }, 5000);
    
    
    
    
    $('.chat-controls').on('click', '.close-message', function() {
        //window.history.back();
        //$('.patient_chat_widget').removeClass('show');
        window.parent.$(".patient_chat_widget").removeClass('show');
    });
    
    
});