jQuery(document).ready(function($){
	//$('.delete-note').click(function(){
	$('.patient-notes').on('click', '.duplicate-note', function() {
		
		var note_id = $(this).data('id');

		// Trigger dialog box
		Swal.fire({
			title: 'Duplicate This Note?',
		  	text: "Are you sure you want to duplicate this progress note?",
		  	type: 'warning',
		  	showCancelButton: true,
		  	confirmButtonColor: '#3085d6',
		  	cancelButtonColor: '#d33',
		  	confirmButtonText: 'Copy'
		}).then((result) => {
			if (result.value) {

				// Start Ajax
				$.ajax({
					type: 'POST',
					url: 'process/duplicate_progress_note.php',

					data: {
						note_id:note_id
					},

					beforeSend: function() {
					    // Do Something
					},
					success: function(response) {
						
						if( response == 'true' ){

							console.log('True: '+response);

							// Show Dialog Box
							Swal.fire({
							  	position: 'top-center',
							  	type: 'success',
							  	title: 'Progress Note has been duplicated',
							  	showConfirmButton: false,
							  	timer: 2500
							});

							// Delete Row
							//$(this).closest('tr').clone().prepend('.patient-notes tbody');
							//$('#record_'+$(this).data('id')).clone().appendTo('body');
							$('#record_'+note_id).clone().prependTo('.patient-notes tbody');
							//alert( 'record_'+$(this).data('id') );
							console.log(response);

						}else{

							console.log('False: '+response);

							// Show Dialog Box
							Swal.fire({
							  	position: 'top-center',
							  	type: 'warning',
							  	title: 'Opps, Something went wrong! Please try again.',
							  	showConfirmButton: false,
							  	timer: 2500
							});

						}

					},
					
					fail: function(response){
						
						console.log('Fail: '+response);

						Swal.fire({
						  	position: 'top-center',
						  	type: 'warning',
						  	title: 'Opps, Something went wrong! Please try again.',
						  	showConfirmButton: false,
						  	timer: 2500
						});

					}

				});
				// End Ajax
			    
			}
		});

	});
});