<?php
session_start();

include('process/functions.php');
include('includes/database_include.php');

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: provider_login.php");
    die();
}

$patient_id = null;
if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
    $patient_id = $_SESSION['patient_id'];
} else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
    $patient_id = $_GET['id'];
}
if($patient_id != null) {
    
    $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id' LIMIT 1";
    $result = mysqli_query($con, $sql) or die('SQL Error :: '.mysqli_error());
    $user = mysqli_fetch_assoc($result);
    
    function progress_notes($patient_id) {
    	$sql = "SELECT * FROM waiting_room left join patients ON waiting_room.patient_id = patients.patient_id left join physician ON waiting_room.physician_id = physician.id WHERE patients.patient_id = '$patient_id' AND waiting_room.note_selection_json != '' ORDER BY waiting_room.checkin_time desc";
    	$result = mysqli_query($con, $sql);
        
    	echo '
    	<table class="patient-notes">
    		<thead>
    			<tr>
    				<td>Type</td>
    				<td>Provider</td>
    				<td>Date of Service</td>
    			</tr>
    		</thead>
    									  
    		<tbody>
    	';
    	if (mysqli_num_rows($result) > 0) {
    	    // output data of each row
    	    while($row = mysqli_fetch_array($result)) {
    	    	echo '<tr id="record_'.$row["id"].'">';
    	        echo '<td><a target="_blank" href="view_saved_note.php?wID='.$row["waitingroom_id"].'&pID='.$patient_id.'">Progress Note</a></td>';
    			echo '<td>'.$row["physician_fname"].' '.$row["physician_lname"].'</td>';
    			echo '<td>'.date_format(date_create($row['checkin_time']),"M/d/Y").'</td>';
    			echo '</tr>';
    	    }
    
    	echo '
    		</tbody>
    	</table>
    	';
    
    	} else {
    	    echo '<p style="margin-top: 50px;">0 results</p>';
    	}
    }
    ?>
    
    <!DOCTYPE html>
    <html class="ui-mobile">
        
        <head>
            <title>DDXRX - Encounter</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css">
            <link rel="stylesheet" type="text/css" href="assets/css/jquery-ui.min.css">
            <link rel="stylesheet" type="text/css" href="assets/css/encounter.css">
            
            <link rel="stylesheet" type="text/css" href="assets/css/quill.bubble.css">
            <link rel="stylesheet" type="text/css" href="assets/css/quill.bubble.css">
            <link rel="stylesheet" type="text/css" href="assets/css/quill.snow.css">
            <link rel="stylesheet" type="text/css" href="assets/css/quill.core.css">
            <link rel="stylesheet" type="text/css" href="assets/css/quill.custom.css">

            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
            <script type="text/javascript" src="//cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
            <script type="text/javascript" src="assets/js/jquery-ui-drag-and-drop.min.js"></script>
            

        </head>
        
        <body data-patient-id="<?php if( isset($_GET['id']) ){ echo $_GET['id']; } ?>" data-user-type="<?php echo $_SESSION['user_type']; ?>" <?php if( $_SESSION['user_type'] == 'nurse' ){ echo 'data-nurse-id="'.$_SESSION['userid'].'"'; } ?> <?php if( $_SESSION['user_type'] == 'doctor' ){ echo 'data-physician-id="'.$_SESSION['userid'].'"'; } ?> data-cctype="ccm">
            
            <?php note_nav( $_GET['id'] ); ?>
            
            <div class="container">
                <div class="col-md-12">
                    
                    <table id="notes-table">
                        <thead>
                            <tr>
                                <td>Title</td>
                                <td>Date</td>
                                <td>Action</td>
                            </tr>
                        </thead>
                        <tbody>
                            
                            <?php
                            $conn = ddxrxDBConnect();
                            $patient_id = $_GET['id'];
                            $sql = "SELECT * FROM `encounter_note` WHERE patient_id = '$patient_id' AND note_type = 'ccm'";
                            $result = $conn->query($sql);
                            
                            if ($result->num_rows > 0) {
                              // output data of each row
                              while($row = $result->fetch_assoc()) {
                            ?>
                            
                                <tr>
                                    <td><?php echo $row['note_title']; ?></td>
                                    <td><?php echo $row['date_created']; ?></td>
                                    <td><a href="javascript:;" class="open-note" data-note-id="<?php echo $row['note_id']; ?>">Open Note</a></td>
                                </tr>
                            
                            <?php
                                }
                            } else {
                                //echo "0 results";
                            }
                            $conn->close();
                            ?>

                        </tbody>
                    </table>
                    
                </div>
            </div>
            
            <?php bottom_nav(); ?>
            
            <script>
                $(document).ready( function () {
                    $('#notes-table').DataTable();
                });
            </script>
            
            <script type="text/javascript" src="assets/js/quill.min.js"></script>
            <script type="text/javascript" src="assets/js/progress_note.js"></script>
            
        </body>
    </html>

<?php } ?>