<?php 

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once (__DIR__ . '/../../includes/database_include.php');
require_once(__DIR__.'/../stripe/init.php');

$stripe_config_path = __DIR__.'/../stripe_config.php';

// echo '<pre>';
// print_r($conn);
// echo '<hr>';
// print_r($con);
// exit();

// You can find your endpoint's secret in your webhook settings
$endpoint_secret = 'whsec_FNiHF7vu8gCvQzLgn4DfKmk9NxC3ftkt';

$payload = @file_get_contents('php://input');
$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
$event = null;

// Write Flat Text Log File
$logDirectory = './logs/';

if (!is_dir($logDirectory)){
    mkdir($logDirectory, 0777);
}

$logFileName= $logDirectory . date('m-d-Y_hia').'.txt';

$flatTextLogFile = fopen("$logFileName", "w") or die("Unable to open file!");

$dataTime = "date('m-d-Y_h:i:a') =>=>=>=>=>=>=>=>=>=>=>=>=>=>=> \n";

fwrite($flatTextLogFile, $dataTime);

$input_menually = '
{
  "id": "evt_1IuT0YFE5YTI8l26i2rP0weY",
  "object": "event",
  "api_version": "2020-08-27",
  "created": 1621821306,
  "data": {
    "object": {
      "id": "sub_JXY6AbEqjijLQv",
      "object": "subscription",
      "application_fee_percent": null,
      "billing_cycle_anchor": 1621821304,
      "billing_thresholds": null,
      "cancel_at": null,
      "cancel_at_period_end": false,
      "canceled_at": null,
      "collection_method": "charge_automatically",
      "created": 1621821304,
      "current_period_end": 1624499704,
      "current_period_start": 1621821304,
      "customer": "cus_JXY6QNmfiHEnSU",
      "days_until_due": null,
      "default_payment_method": null,
      "default_source": null,
      "default_tax_rates": [
      ],
      "discount": null,
      "ended_at": null,
      "items": {
        "object": "list",
        "data": [
          {
            "id": "si_JXY6wrJCB7VoYx",
            "object": "subscription_item",
            "billing_thresholds": null,
            "created": 1621821305,
            "metadata": {
            },
            "plan": {
              "id": "price_1IfJXCFE5YTI8l26Q4U8YY3M",
              "object": "plan",
              "active": true,
              "aggregate_usage": null,
              "amount": 2000,
              "amount_decimal": "2000",
              "billing_scheme": "per_unit",
              "created": 1618209970,
              "currency": "usd",
              "interval": "month",
              "interval_count": 1,
              "livemode": false,
              "metadata": {
              },
              "nickname": "20USD - Month with 30to1 days free trial",
              "product": "prod_JHtIJ2juIIeGLf",
              "tiers_mode": null,
              "transform_usage": null,
              "trial_period_days": 1,
              "usage_type": "licensed"
            },
            "price": {
              "id": "price_1IfJXCFE5YTI8l26Q4U8YY3M",
              "object": "price",
              "active": true,
              "billing_scheme": "per_unit",
              "created": 1618209970,
              "currency": "usd",
              "livemode": false,
              "lookup_key": null,
              "metadata": {
              },
              "nickname": "20USD - Month with 30to1 days free trial",
              "product": "prod_JHtIJ2juIIeGLf",
              "recurring": {
                "aggregate_usage": null,
                "interval": "month",
                "interval_count": 1,
                "trial_period_days": 1,
                "usage_type": "licensed"
              },
              "tiers_mode": null,
              "transform_quantity": null,
              "type": "recurring",
              "unit_amount": 2000,
              "unit_amount_decimal": "2000"
            },
            "quantity": 1,
            "subscription": "sub_JXY6AbEqjijLQv",
            "tax_rates": [
            ]
          }
        ],
        "has_more": false,
        "total_count": 1,
        "url": "/v1/subscription_items?subscription=sub_JXY6AbEqjijLQv"
      },
      "latest_invoice": "in_1IuT0WFE5YTI8l26gTL67jQ7",
      "livemode": false,
      "metadata": {
      },
      "next_pending_invoice_item_invoice": null,
      "pause_collection": null,
      "pending_invoice_item_interval": null,
      "pending_setup_intent": null,
      "pending_update": null,
      "plan": {
        "id": "price_1IfJXCFE5YTI8l26Q4U8YY3M",
        "object": "plan",
        "active": true,
        "aggregate_usage": null,
        "amount": 2000,
        "amount_decimal": "2000",
        "billing_scheme": "per_unit",
        "created": 1618209970,
        "currency": "usd",
        "interval": "month",
        "interval_count": 1,
        "livemode": false,
        "metadata": {
        },
        "nickname": "20USD - Month with 30to1 days free trial",
        "product": "prod_JHtIJ2juIIeGLf",
        "tiers_mode": null,
        "transform_usage": null,
        "trial_period_days": 1,
        "usage_type": "licensed"
      },
      "quantity": 1,
      "schedule": null,
      "start_date": 1621821304,
      "status": "active",
      "transfer_data": null,
      "trial_end": null,
      "trial_start": null
    }
  },
  "livemode": false,
  "pending_webhooks": 1,
  "request": {
    "id": "req_YMpKPACkHMIkEx",
    "idempotency_key": null
  },
  "type": "customer.subscription.created"
}
';

$response = json_decode($payload);
// $response = json_decode($input_menually);

// echo '<pre>';
// print_r($response);
// exit();

$data = json_encode($response, JSON_PRETTY_PRINT|JSON_FORCE_OBJECT);

fwrite($flatTextLogFile, print_r($response, TRUE));
fclose($flatTextLogFile);
// ------------------------------------------------------------------------------------

try {
    $event = \Stripe\Webhook::constructEvent(
        $payload, $sig_header, $endpoint_secret
    );
} catch(\UnexpectedValueException $e) {
    // Invalid payload
    http_response_code(400);
    exit();
} catch(\Stripe\Exception\SignatureVerificationException $e) {
    // Invalid signature
    http_response_code(400);
    exit();
}

if ($event->type == "payment_intent.succeeded") {
    $intent = $event->data->object;
    printf("Succeeded: %s", $intent->id);
    http_response_code(200);
    exit();
} elseif ($event->type == "payment_intent.payment_failed") {
    $intent = $event->data->object;
    $error_message = $intent->last_payment_error ? $intent->last_payment_error->message : "";
    printf("Failed: %s, %s", $intent->id, $error_message);
    http_response_code(200);
    exit();
}

if($response->type == 'customer.subscription.updated'){
    
    $data_object = $response->data->object;
    $plan = $data_object->plan;
    $items = $data_object->items;
    
    $customer_id = $data_object->customer;
    $subscription_id = $data_object->id;
    
    $current_period_end = $data_object->current_period_end; // it is a expired date in timestamp format.
    
    $payment_status = $data_object->status; // success value is "active" and failed status will be "incomplete"
    
    $charge_amount = '';
    
    $sql_query = "SELECT * FROM patients WHERE stripe_customer_id = '$customer_id' AND stripe_subscription_id = '$subscription_id'";
    $run_query = mysqli_query($con, $sql_query);
    
    $patientInfo = mysqli_fetch_array($run_query);
    $patient_id = $patientInfo['patient_id'];
    
    $patient_id = $patientInfo['patient_id'];
    
    if($run_query && mysqli_num_rows($run_query)==1) {
		// 
		$expired_date = date('Y-m-d', $current_period_end);
		
		
		
		$stripe_subscription_isactive = ($payment_status=='active') ? 1 : 0;
		
		$update_sql = "UPDATE patients SET subscription_expired_date = '$expired_date', stripe_subscription_isactive = '$stripe_subscription_isactive' WHERE patient_id = '$patient_id'";
		
		if($data_object->object=='subscription' && $payment_status=='active' && mysqli_query($con, $update_sql)){
		    
		    // Write charge/invoice history with payment status success on our database 
		    
		    
		    // Sent Success email to patient for successfully charged
		    
		    $email_address = 'tasfirsuman@gmail.com';
		    
		    $stripe_currency = 'usd';
		    $subscription_charge_amount = 15;
		    
            $message_contents = '<!DOCTYPE html>
            <html lang="en">
        
            <head>
              <meta charset="UTF-8">
              <title>Verification Email</title>
              <style>
                .wrapper {
                  padding: 20px;
                  color: #444;
                  font-size: 1.3em;
                }
                a {
                  background: #027eff;
                  text-decoration: none;
                  padding: 8px 15px;
                  border-radius: 5px;
                  color: #fff;
                }
              </style>
            </head>
        
            <body>
              <div class="wrapper">
                <p>Welcome to Doctor Ai.</p>
                <p>Thank you very much for payment of subcription on Doctor Ai. {$subscription_charge_amount} {$stripe_currency} is successfully charged from your credit card :.</p>
                
                <br>
                <p>Doctor Ai Support Team.</p>
                <p>Phone: (228) 342 6278</p>
              </div>
            </body>
        
            </html>';
            
            
            $from="support@ddxrx.com";
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
            
            // Additional headers
            $headers .= 'From: <'.$from.'>' . "\r\n";
            $return = '-f'.$from;
            
            $subject = "Doctor Ai Subcription Payment!";
            
            $mail_sent_result = mail($email_address, $subject, $message_contents, $headers, $return);
		}else if($data_object->object=='subscription' && $payment_status=='incomplete'){
		    // Write charge/invoice history with payment status failed on our database 
		    
		    // Sent email to patients for unable to charge his/her payment method.
		    $email_address = 'tasfirsuman@gmail.com';
		    
		    $stripe_currency = 'usd';
		    $subscription_charge_amount = 15;
		    
            $message_contents = '<!DOCTYPE html>
            <html lang="en">
        
            <head>
              <meta charset="UTF-8">
              <title>Verification Email</title>
              <style>
                .wrapper {
                  padding: 20px;
                  color: #444;
                  font-size: 1.3em;
                }
                a {
                  background: #027eff;
                  text-decoration: none;
                  padding: 8px 15px;
                  border-radius: 5px;
                  color: #fff;
                }
              </style>
            </head>
        
            <body>
              <div class="wrapper">
                <p>Welcome to Doctor Ai.</p>
                <p>We are trying to charged a payment of subcription on Doctor Ai. But your payment is failed from your credit card :.</p>
                
                <br>
                <p>Doctor Ai Support Team.</p>
                <p>Phone: (228) 342 6278</p>
              </div>
            </body>
        
            </html>';
            
            
            $from="support@ddxrx.com";
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
            
            // Additional headers
            $headers .= 'From: <'.$from.'>' . "\r\n";
            $return = '-f'.$from;
            
            $subject = "Doctor Ai Subcription Payment!";
            
            $mail_sent_result = mail($email_address, $subject, $message_contents, $headers, $return);
		}else{
		    //echo "Error: " . $sql . "<br>" . mysqli_error($con);
		}
    } else {
        
    }
} else if($response->type == 'customer.subscription.created'){
    $data_object = $response->data->object;
    $plan = $data_object->plan;
    $items = $data_object->items;
    
    $customer_id = $data_object->customer;
    $subscription_id = $data_object->id;
    
    $current_period_end = $data_object->current_period_end; // it is a expired date in timestamp format.
    
    $payment_status = $data_object->status; // success value is "active" and failed status will be "incomplete"
    
    $charge_amount = '';
    
    $sql_query = "SELECT * FROM patients WHERE stripe_customer_id = '$customer_id' AND stripe_subscription_id = '$subscription_id'";
    $run_query = mysqli_query($con, $sql_query);
    
    $patientInfo = mysqli_fetch_array($run_query);
    $patient_id = $patientInfo['patient_id'];
    
    $patient_id = $patientInfo['patient_id'];
    
    if($run_query && mysqli_num_rows($run_query)==1) {
		// 
		$expired_date = date('Y-m-d', $current_period_end);
		
		$stripe_subscription_isactive = ($payment_status=='active') ? 1 : 0;
		
		$update_sql = "UPDATE patients SET subscription_expired_date = '$expired_date', stripe_subscription_isactive = '$stripe_subscription_isactive' WHERE patient_id = '$patient_id'";
		
		
		if($data_object->object=='subscription' && $payment_status=='active' && mysqli_query($con, $update_sql)){
		    
		    // Write charge/invoice history with payment status success on our database 
		    
		    
		    // Sent Success email to patient for successfully charged
		    
		    $email_address = 'tasfirsuman@gmail.com';
		    
		    $stripe_currency = 'usd';
		    $subscription_charge_amount = 15;
		    
            $message_contents = '<!DOCTYPE html>
            <html lang="en">
        
            <head>
              <meta charset="UTF-8">
              <title>Verification Email</title>
              <style>
                .wrapper {
                  padding: 20px;
                  color: #444;
                  font-size: 1.3em;
                }
                a {
                  background: #027eff;
                  text-decoration: none;
                  padding: 8px 15px;
                  border-radius: 5px;
                  color: #fff;
                }
              </style>
            </head>
        
            <body>
              <div class="wrapper">
                <p>Welcome to Doctor Ai.</p>
                <p>Thank you very much for payment of new subcription on Doctor Ai. {$subscription_charge_amount} {$stripe_currency} is successfully charged from your credit card :.</p>
                
                <br>
                <p>Doctor Ai Support Team.</p>
                <p>Phone: (228) 342 6278</p>
              </div>
            </body>
        
            </html>';
            
            
            $from="support@ddxrx.com";
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
            
            // Additional headers
            $headers .= 'From: <'.$from.'>' . "\r\n";
            $return = '-f'.$from;
            
            $subject = "Doctor Ai Subcription Payment!";
            
            $mail_sent_result = mail($email_address, $subject, $message_contents, $headers, $return);
		}
    }
}