<?php

    session_start();
    
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'doctor') {
        header("Location: provider_login.php");
        die();
    }

    date_default_timezone_set('America/Chicago');
    include('../includes/database_include.php');
    include('functions.php');
    
    global $callarray;
    $callarray = [];
    
?>

<?php
$physician_id = getPhysician( $_SESSION['userid'] );
//$query = "SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 48 HOUR) ORDER BY checkin_time DESC";
$query = "SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 48 HOUR) AND physician_id = '$physician_id' ORDER BY checkin_time DESC";
$run_query = mysqli_query($con, $query);
while($data = mysqli_fetch_array($run_query)) {
?>


                                <div class="tr" id="<?php echo $data['waitingroom_guid']; ?>" data-user-id="<?php echo $data['patient_id']; ?>">
                            <input type="hidden" id="waitingEntryID" value="<?php echo $data['waitingroom_id']; ?>">
                        <!-- Name -->
                        <div class="td patient_info">
                            <strong><?php echo ucwords($data['patient_name']); ?></strong>
                            <?php
                                $pid = $data['patient_id'];
                                $p_query = "SELECT patient_dob, cell FROM patients WHERE patient_id='".$pid."' ";
                                $run_p_query = mysqli_query($con, $p_query);
                                while($p_data = mysqli_fetch_array($run_p_query)) {
                                    $DOB = $p_data['patient_dob'];
                                    $today = date("Y-m-d");
                                    $diff = date_diff(date_create($DOB), date_create($today));
                                    //echo "<span class='phone'>".format_phone($p_data['cell'])."</span>";
                                    echo "<span class='phone'>".$p_data['cell']."</span>";
                                    echo '<span class="age">'.$diff->format('%y').' yrs</span>';
                                    
                                    $phoneNumber = $p_data['cell'];
                                    
                                }
                            ?>
                            <span class="returning"><?php echo $data['is_returning_patient'] == 1 ? "Returning Patient" : "New Patient"; ?></span>
                        </div>
                        <!-- Name -->

                        <!-- Diagnosis -->
                        <div class="td patient_symptoms">
                            <?php
                                echo $data['diagnosis']!="" ? $data['diagnosis'] : ($data['symptoms']=="" ? "Awaiting chief complaint" : "No diagnosis matched");
                                if((int)$data['is_SEPSIS'] == 1 && ($data['acuity']!="" && ((int) $data['acuity'] >= 5))) {
                                    echo " (SEPSIS)";
                                } else if ((int)$data['is_SIRS'] == 1) {
                                    echo " (SIRS)";
                                }
                            ?>
                            <strong><?php echo $data['symptoms']!="" ? $data['symptoms'] : "Awaiting symptoms"; ?></strong>
                            <?php
                                if (!empty($data['diagnosis']) && $data['diagnosis'] != '') {
                                    $string = trim($data['diagnosis']);
                                    if ((string)$string != "Awaiting chief complaint") {

                                    }
                                }
                            ?>
                                        
                            <?php if( $data['symptom_photo'] != '' ){ ?><a href="<?php echo $data['symptom_photo']; ?>" class="symptom_photo" data-fancybox data-caption="<?php echo $data['symptoms']; ?>">View Photo</a><?php } ?>
                                        
                        </div>
                        <!-- Diagnosis -->

                                    <!-- Assign To -->
                                    <div class="td patient_assign">
                                        <select class="btn btn-primary col-md-12 physician-dropdown" for="<?php echo $data['waitingroom_id']; ?>">
                                        <option>Assign Physician</option>
                                        <?php
                                            $version = get_version();
                                            $users = "SELECT physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where user_type = 2 and location_id =1 and physician.groupid = '$version'";
                                            $users_query = mysqli_query($con, $users);
                                                 $isSelected = "";
                                            while($row = mysqli_fetch_array($users_query)) {
                                            $name = "Dr. ".$row['physician_fname']." ".$row['physician_lname'];
                                        ?>
                                            <option <?php if($data['physician_id']!=0 && $data['physician_id'] == $row['id']){ echo "selected";} ?> value="<?php echo $row['id'] ?>"><?php echo $name; ?></option>
                                        <?php } ?>
                                        </select>
                                        <a target="_blank" href="view_patient.php?wID=<?php echo $data['waitingroom_id'];?>">
                                            <button class="btn btn-primary col-md-12 view_notes">View Notes</button>
                                        </a>
                                    </div>
                                    <!-- Assign To -->

                                    <!-- Status -->
                                    <div class="td patient_status <?php echo $class; ?>" style="text-align: center;">
                                        <?php
                                            if($data['acuity']!="" && ((int) $data['acuity'] >= 4)) {
                                                $inOut = "Inpatient";
                                                $class = "text-danger";
                                            } else if($data['acuity']!="" && ((int) $data['acuity'] == 3)) {
                                                $inOut = "Undecided";
                                                $class = "text-muted";
                                            } else {
                                                $inOut = "Outpatient";
                                                $class = "text-success";
                                            }
                                        ?>
                                        <b class="inOutText"><?php echo $inOut; ?></b>
                                    </div>
                                    <!-- Satus -->

                                    <!-- Acuity -->
                                    <div class="td patient_acuity" style="text-align: center;">
                                    <input type="hidden" id="acuityValue" value="<?php echo $data['acuity']!="" ? $data['acuity'] : "0"; ?>">
                                        <h3 class="card-subtitle mb-2 <?php echo $class; ?>">
                                            <b class="acuityText"><?php echo $data['acuity']!="" ? $data['acuity'] : "0"; ?>/10</b>
                                        </h3>
                                    </div>
                                    <!-- Acuity -->

                                    <!-- Vitals -->
                                    <div class="td patient_vitals">
                                        <button class="btn btn-primary col-md-12 addVitals" data-toggle="modal" represents="<?php echo $data['waitingroom_guid']; ?>" data-target="#vitals" style="margin-bottom: 10px;" data-patient-id="<?php echo $data['patient_id']; ?>">
                                            <?php //echo $data['vital_json'] == '' ? 'Add' : 'View'; ?>
                                            Add
                                        </button>
                                        <a href="patient_vitals.php?patient_id=<?php echo $data['patient_id']; ?>" class="btn btn-primary addVitals" data-patient-id="<?php echo $data['patient_id']; ?>">View</a>
                                    </div>
                                    <!-- Vitals -->

                                    <!-- Wait Time -->
                                    <div class="td patient_waitTime">
                                        <h3 class="card-subtitle mb-2 text-muted">
                                        <?php
                                            // echo $data['checkin_time'];
                                            $datetime1 = new DateTime($data['checkin_time']);
                                            // var_dump($datetime1);
                                            $datetime2 = new DateTime();
                                            // var_dump($datetime2);
                                            $interval = $datetime1->diff($datetime2);
                                            // print_r($interval);
                                            $hrs = ($interval->format('%d') * 24) + $interval->format('%h');
                                            $mins = $interval->format('%i');
                                            echo "<input type='hidden' id='checkinTime' value='".$data['checkin_time']."'>";
                                            echo "<input type='hidden' id='hrs' value='".$hrs."'>";
                                            echo "<input type='hidden' id='mins' value='".$mins."'>";
                                            $hrs = $hrs < 10 ? "0".$hrs : $hrs;
                                            $mins = $mins < 10 ? "0".$mins : $mins;
                                            echo "<b>". $hrs .":".$mins."</b>";
                                        ?>
                                        </h3>
                                        <h6 class="card-subtitle mb-2 text-muted"><b>HH:MM</b></h6>
                                    </div>
                                    <!-- Wait Time -->
                                    
                                    <!-- Action -->
                                    <div class="td patient_action">
                                        <a href="waitingroom_delete.php?wID=<?php echo $data['waitingroom_id'];?>&request_from=nurse">
                                            <button class="btn btn-danger col-md-12" style="margin-bottom: 10px; display: block">Delete</button>
                                        </a>
                                        
                                        <a href="order.php?id=<?php echo $data['patient_id']; ?>">
                                            <button class="btn btn-primary col-md-12">Order</button>
                                        </a>
                                        
                                        <?php echo video_call( $data['patient_id'], $phoneNumber ); ?>
                                        <?php echo call_request( $data['patient_id'] ); ?>
                                        
                                    </div>
                                    <!-- Action -->

                                    <div class="clear"></div>
                                </div>
                                <div class="clear"></div>

<?php } ?>