

<html>
    <head>
        <title>Remote Patient Monitoring With Genie</title>
        
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
    	<script type="text/javascript" src="assets/js/genie.js"></script>
    	
    	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    	<link rel="stylesheet" type="text/css" href="assets/css/style.css">
    	<link rel="stylesheet" type="text/css" href="assets/css/genie.css">
        
    </head>
    
    <body>
       
    <div class="header-bar">
		<div class="container">

			<!-- Contacts -->
			<div class="col-md-7">
				<div class="contact">
					<span><img src="assets/images/icons/mail.svg"><strong>contact@ddxrx.com</strong></span>
					<span><img src="assets/images/icons/phone.svg"><strong>(228) 806 7777</strong></span>
					<div class="clear"></div>
				</div>
			</div>
			<!-- Contacts -->

			<!-- Buttons -->
			<div class="col-md-5 user-buttons">
				<!--<a href="https://patient.ddxrx.com/provider_login.php" class="button medium border rounded white provider_login">Provider Login</a>-->
				<a href="https://patient.ddxrx.com" class="button medium solid rounded yellow patient_login" style="background:#f1c40f">Go Back</a>
			</div>
			<!-- Buttons -->

		</div>
	</div>
       
        <div class="genie-container">
       
            <div class="container">
                
                
                <!-- Steps Navigation -->
                <ul class="stepnav">
                    
                    <li data-step="1" class="active"><a href="#"><span>1</span></a></li>
                    <li data-step="2"><a href="#"><span>2</span></a><div class="separator"></div></li>
                    <li data-step="3"><a href="#"><span>3</span></a><div class="separator"></div></li>
                    <li data-step="4"><a href="#"><span>4</span></a><div class="separator"></div></li>
                    <li data-step="5"><a href="#"><span>5</span></a><div class="separator"></div></li>
                    <li data-step="6"><a href="#"><span>6</span></a><div class="separator"></div></li>
                    
                </ul>
                <!-- Steps Navigation -->
               
               <!-- Content -->
               <div class="step-content">
                   
                    <!-- Item -->
                    <div class="item active" id="content_1">
                        
                        <h1 class="title" style="margin-bottom: 0px; line-height: 1em;">Remote Patient Monitoring (RPM) with Genie</h1>
                        
                        <img src="assets/images/genie-bubble.png" style="margin-bottom: 30px;">
                                    
                        <p class="pricing">1. Simple, easy to use, always connected, one touch Doctor Ai&#174; device </span></p>
                        <p class="pricing">2. The patient doesn't need to own a smartphone as devices are cellular-connected</a> </span></p>
                        <p class="pricing">3. Genie, the virtual medical assistant, monitors patients symptoms and sends alerts</span></p>
                        <p class="pricing">4. Prevent hospitalization, monitor COVID-19 patients at home, improve patient safety and reduce readmission </span></p>
                        <p class="pricing">5. Potentially, you can earn up to $100 per patient per month </span></p>
                        <p class="pricing">6. Get your own Telemedicine platform and utilize the Hippa compliant chat system to earn additional revenue </span></p>
                        <p class="pricing">7. Subscribe to the cheapest program in the market (monthly subscription fee $20 per month per patients) </span></p>
                        
                        <div class="clear"></div>
                    </div>
                    <!-- Item -->
                    
                    <!-- Item -->
                    <div class="item" id="content_2">
                        
                        <h1 class="title" style="margin-bottom: 0px; line-height: 1em;">Talk to Your Virtual Medical Assistant</h1>
                        
                        <img src="assets/images/genie-bubble.png" style="margin-bottom: 30px;">
                        
                        <p style="margin-bottom: 40px;">Start by saying "Hi Genie". It will start executing your wish as your virtual medical assisstant. 
                        Genie can address most of the common medical needs by analyzing your symptoms. Usually, diseases develop gradually and all its symptoms do not appear 
                        at the same time. Unlimited access to Genie will allow patients to test their symptoms multiple times during 
                        the course of a certain disease development process. In addition, Genie can perform many task including 
                        connecting you with physician, pharmacies, relatives and many more.  While combined with Remote Patient Monitoring devices, 
                        Genie can improve patients safety while monitoring patients at the comfort of home. However, we strongly encourage patient 
                        to consult with physicians and not to depend on unsupervised Ai recommendations. Please call 911 for emergency situations. <br> </p>
                        
                        <h6 style="color: #FFFFFF; font-size: 19.5px;">For windows operating system</h6>
                        <a href="installer/DoctorAi.exe" class="action-button" style="margin-bottom: 25px;">
                            <img src="assets/images/windows.png">
                            <span>Download Genie</span>
                        </a>
                        
                        <div class="clear"></div>
                    </div>
                    <!-- Item -->
                    
                    <!-- Item -->
                    <div class="item" id="content_3">
                        <h1 class="title big">Talk to Genie</h1>
                        <img src="assets/images/chat-bubble.png" style="width: 300px; max-width: 100%; height: auto;  display: block">
                    </div>
                    <!-- Item -->
                    
                    <!-- Item -->
                    <div class="item" id="content_4">
                        <h1 class="title big">How to get Genie?</h1>
                        <p class="pricing">1. Get a Laptop or Desktop Computer </span></p>
                            <p class="pricing">2. Visit <a href="http://higenie.io" style="font-weight: 500; background-color: #f1c40f; color: #FFFFFF; display: inline-block; padding: 8px; padding-left: 13px; padding-right: 13px; border-radius: 5px">hiGenie.io</a> </span></p>
                            <p class="pricing">3. Download Genie for Windows OS</span></p>
                            <p class="pricing">4. Sign-up for $5 per month </span></p>
                        <p class="pricing">5. Get Genie for FREE if sign up for Remote Patient Monitoring (RPM) program </span></p>
                        <p class="pricing">6. Contact us to subscribe into our RPM program </span></p>
                        <a href="https://patient.ddxrx.com/signUpPatient.php?plan=0" class="action-button">Sign Up</a> <a href="https://ddxrx.com/contact.php" class="action-button">Contact Us</a>
                    </div>
                    <!-- Item -->
                    
                    <!-- Item -->
                   <div class="item" id="content_5">
                        <h1 class="title big">Features of RPM with Genie</h1>
                        <p class="pricing">1. Get Genie, your virtual medical assistant </span></p>
                        <p class="pricing">2. Get robot triage tool, Doctor Ai&#174; app for 400 plus medical diagnoses</span></p>
                        <p class="pricing">3.  Get Doctor Ai&#174; Telemedicine Platform</span></p>
                        <p class="pricing">4. Get Doctor Ai&#174; electronic medical record for your patient </span></p>
                        <p class="pricing">5. Get Doctor Ai&#174; Chat tool for patient support </span></p>
                        <p class="pricing">6. Track and monitor patients using Doctor Ai&#174; dashboard </span></p>
                        <p class="pricing">7. Ask us about lucrative referral bonus </span></p>
                        <div class="clear"></div>
                        <a href="https://play.google.com/store/apps/details?id=com.doctor.ai"><img src="https://ddxrx.com/assets/images/app-download-playstore.png"></a>
                        <a href="https://apps.apple.com/ph/app/doctor-ai/id1485841411"><img src="https://ddxrx.com/assets/images/app-download-apple-store.png"></a>
                        <a href="https://lighthouse.ddxrx.com/"><img src="https://ddxrx.com/assets/images/desktop-download.png"></a>
                    </div>
                    <!-- Item -->
                    
                    <!-- Item -->
                   <div class="item" id="content_6">
                        <h1 class="title big">Share "RPM with Genie"</h1>
                        <p>Both Remote Patient Monitoring and Genie is powered by "Doctor Ai&#174;" </p>
                        <div class="front-social-media">
                            <ul style="margin-bottom: 30px;">
                                <li><a href="https://www.facebook.com/sharer/sharer.php?u=https://doctorai.ddxrx.com" target="_blank"><img src="assets/images/boticon/facebook.png"></a></li>
                                <li><a href="http://twitter.com/home?status=Doctor AI health bot&nbsp;https://doctorai.ddxrx.com" target="_blank"><img src="assets/images/boticon/twitter.png"></a></li>
                                <li><a href="http://www.pinterest.com/pin/create/button/?url=https://doctorai.ddxrx.com" target="_blank"><img src="assets/images/boticon/pinterest.png"></a></li>
                                <li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=https://doctorai.ddxrx.com" target="_blank"><img src="assets/images/boticon/linkedin.png"></a></li>
                            </ul>
                            <div class="clear"></div>
                            <a href="https://patient.ddxrx.com/signUpPatient.php?plan=0" class="action-button">Sign Up</a> <a href="https://ddxrx.com/contact.php" class="action-button">Contact Us</a>
                        </div>
                    </div>
                    <!-- Item -->
                    
               </div>
               <!-- Content -->
            </div>
        
        </div>
        
    </body>
</html>