$(document).ready(function(){
    
    function randomString(length, chars) {
        var result = '';
        for (var i = length; i > 0; --i) result += chars[Math.floor(Math.random() * chars.length)];
        return result;
    }
    
    /* ================================ */
    // FRONT/BACK Login
    /* ================================ */
    $('.loginfront').click(function(e){
        e.preventDefault();
        $('.loginback').click();
    });
    
    /* ================================ */
    // Provider login
    /* ================================ */
    $('#provider_login').click(function(){

		var user = $('#user').val();
		var pass = $('#pass').val();
		var user_type = $('input[name=user_type]:checked').val();
		
		if ( $('#remember').prop( "checked" ) ) {
		    var remember = $('#remember').val();
		}else{
		    var remember = 'false';
		}
        
		$.ajax({
			url: 'check_login.php',
			data : {'user': user, 'pass': pass, 'user_type': user_type, 'remember' : remember },
			type: 'POST',
			dataType: 'json',
			success: function success(msg) {
				if(msg.success === true) {
					// alert(msg.msg);
					if(msg.userType == '2') {
						//window.location = "physician_dashboard.php";
						window.location = "physician_default.php";
					} else if(msg.userType == '4') {
						//window.location = "dashboard.php";
						window.location = "nurse_default.php";
					}
				} else {
					alert(msg.msg);
					return false;
				}
			},
			error: function error(msg) {
				alert(msg.msg);
				console.log('error:', msg);
			},
		});
    });
	
	
	/* ================================ */
    // Patient login
    /* ================================ */
	$('#patient_login').click(function(){
	    
	    var patient_redirect = $('body').data('redirect');
	    
	    $('.loading-screen').fadeIn();
	    
		var user = $('#email').val();
		
		if(user == 'undefined' ){
		    user = $('#username').val();
		}
		
		var pass = $('#password').val();
		
		var remember = 'false';
		
		if ( $('#remember').prop( "checked" ) ) {
		    remember = $('#remember').val();
		}
        
		$.ajax({
		    url: '/check_login.php',
		    data : {
			   'user': user,
			   'pass': pass,
			   'user_type': 3,
			   'remember' : remember
		    },
			type: 'POST',
			dataType: 'json',
			success: function success(msg) {
				if(msg.success === true) {
					// alert(msg.msg);
                    var patient = {};
                    patient.idKey = randomString(32, '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
                    patient.checkInTime = Date.now();
                    
                    var patient_id = msg.user_id;
                    
                    if(msg.redirect==true){
                        window.location.href = msg.redirect_url;
                        return false;
                    }
                    
                    $.ajax({
                        //url: 'save_search_entry.php',
                        url: 'process/create_waitingroom.php',
                        data: {'guid': patient.idKey, 'user_id':patient_id},
                        type: 'POST',
                        dataType: 'json',
                        success: function success(msg) {
                            patient.waitingroom_id = msg.waitingroom_id;
                            localStorage.setItem("patient", JSON.stringify(patient));
                            
                            if( patient_redirect == false ){
					            window.location.href = "/default.php";
                            }else{
                                window.location.href = patient_redirect;
                            }
                            
                        },
                        error: function error(msg) {
                            console.log('error');
                        },
                    });
				} else {
				    $('#login-content').show();
				    $('.disclaimer-popup-container').fadeOut();
				    $('.loading-screen').fadeOut();
				    
					//alert(msg.msg);
					Swal.fire({
                        icon: 'warning',
                        title: 'Invalid Login',
                        text: msg.msg,
                    });
					return false;
				}
			},
			error: function error(msg) {
				alert(msg.msg);
				console.log('error:', msg);
			},
		});
    });
    
    
    // Radio Button
    $('.login-container .radio-group label').click(function(){
        $('.login-container .radio-group label img').attr("src","assets/images/radio-gray.svg");
        $('img', this).attr("src","assets/images/radio-green.svg");
        $('input:radio[name="type"]', this).prop("checked", true);
    });
    
    
    // Send OTP
    $('.sendOTP.enabled').click(function(){
        
        var otp_session = randomString(32, '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
        var otpPhoneNumber = $('.otpPhoneNumber').val();
        var countryCode = $( "#countryCode option:selected" ).val();
        var sendOTPNumber = countryCode+otpPhoneNumber;
        
        if( otpPhoneNumber != '' && countryCode != ''){
                
            $.ajax({
                url: 'process/otp.php',
                data : {
                        'number': sendOTPNumber, 
                        'otp_session': otp_session
                },
			    type: 'POST',
                                    
                beforeSend: function() {
                    
                    sessionStorage.setItem("otp_session", otp_session);
                    $('.otpForm').addClass('disabled');
                    $('.sendOTP').removeClass('enabled');
                    $('.sendOTP').addClass('disabled');
                    $(".otp-popup .otpForm.disabled .textbox").attr("disabled", "disabled");
                    
                },
                success: function(data){
                    
                    if( data.rstatus == 'success' ){
                        
                        $('.otpForm').removeClass('disabled');
                        
                        $('.otpForm .desc').html('<h5 style="font-size: 16px;">Enter Verification Code</h5><p>Your IP address will be collected when you verify the cell phone number.</p><input type="text" class="textbox verifyotp" placeholder="Enter Verification Code" value=""><a href="javascript:;" class="button verify enabled">Verify Code</a>');
                           
                    }else{
                        
                        $('.otpForm').removeClass('disabled');
                        $('.sendOTP').addClass('enabled');
                        $('.sendOTP').removeClass('disabled');
                        
                    }
                    
                },               
                failure: function(errMsg) {}
            });
        
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Empty Fields',
                text: 'Fields cannot be empty please fill up all details before submitting.'
            })
            
        }
        
    });
    
    
    // Verify OTP
    $('body').on('click tap', '.button.verify', function() {
                            
        var otpinput = $('.verifyotp').val();
        var otp_session = sessionStorage.getItem("otp_session");
        
        $.ajax({
            url: 'process/otp_checker.php',
            data : {
                'otpinput': otpinput, 
                'otp_session': otp_session
            },
			type: 'POST',
            beforeSend: function() {},
            success: function(data){
                
                if( data.rstatus == 'success' ){
                    
                    // Remove Popup
                    $('.otp-popup').remove();
                    
                    // Clear Session
                    sessionStorage.removeItem("otp_session");
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'Verified ',
                        text: 'Your OTP has been verified, you can now continue to register an account.'
                    });
                }else{
                   
                    Swal.fire({
                        icon: 'error',
                        title: 'Invalid ',
                        text: 'The OTP you entered is invalid, please try again.'
                    });
                    
                }
                
            },               
            failure: function(errMsg) {}
        });
                            
    });
    
});




            


















