$(document).ready(function(){
    
    $('.order-list .selectAll').click(function(){
        var selectedArea = $(this).parent().parent().attr('class');
        selectedArea = selectedArea.replace(/\s/g, '.');
        
        $('.'+selectedArea+' .checkbox').addClass('checked');
        
    });
    
    
    $('.checkbox').click(function(){
        
        if( $(this).hasClass('checked') === true ){
        
            $(this).removeClass('checked');
        
        }else{
            
            $(this).addClass('checked');
            
        }
        
    });
    
    
    $('.button.saveData').click(function(){
        
        // Patient ID
        var patient_id = $('body').data('patient-id');
        
        // Variables for diet
        var diet = [];
        var diet_item;
        
        // Variables for activity
        var activity = [];
        var activity_item;
        
        // Variables for medication
        var medication = [];
        var medication_item;
        
        // Store selected values in array for diet plat
        $('.order-list.diet .checkbox.checked').each(function(){
            
            diet_item = $(this).data('checboxvalue');
            diet.push(diet_item);
            
        });
        
        // Store selected values in array for activity plan
        $('.order-list.activity .checkbox.checked').each(function(){
                
            activity_item = $(this).data('checboxvalue');
            activity.push(activity_item);
            
        });
        
        // Store selected values in array for medication plan
        $('.order-list.medication .checkbox.checked').each(function(){
            
            medication_item = $(this).data('checboxvalue');
            medication.push(medication_item);
            
        });
        
        var obj = { patient_id, diet, activity, medication }
        var JsonResult = JSON.stringify(obj);
        
        $.ajax({
            type: "POST",
            url: 'process/save_order_patient.php',
                    
            data: JsonResult,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                                
            beforeSend: function() {},
            success: function(data){
                
                Swal.fire({
                    icon: data.result_status,
                    title: data.result_status,
                    text: data.result_desc,
                });
                
            },               
            failure: function(errMsg) {}
            
        });
        
    });
    
    
    $('.ai-button').click(function(){
        window.location.replace("chat-bot.php"); 
    });
    
});