<?php
    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    include('includes/database_include.php');
    
    $vitalFields = [];
    $vitalFields[] = ['fieldName' => 'systolicBP', 'fieldLable' => 'Systolic BP', 'min' => 90, 'max' => 190];
    $vitalFields[] = ['fieldName' => 'diastolicBP', 'fieldLable' => 'Diastolic BP', 'min' => 70, 'max' => 100];
    $vitalFields[] = ['fieldName' => 'heartRate', 'fieldLable' => 'Heart Rate', 'min' => 0, 'max' => 90];
    $vitalFields[] = ['fieldName' => 'respRate', 'fieldLable' => 'Respiratory Rate', 'min' => 0, 'max' => 20];
    $vitalFields[] = ['fieldName' => 'pulseOX', 'fieldLable' => 'Pulse Ox', 'min' => 90, 'max' => 0];
    $vitalFields[] = ['fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 96.8, 'max' => 100.4];
    
    $labFields = [];
    $labFields[] = ['fieldName' => 'lacticAcid', 'fieldLable' => 'Lactic Acid'];
    $labFields[] = ['fieldName' => 'wbc', 'fieldLable' => 'WBC'];
    $labFields[] = ['fieldName' => 'hb', 'fieldLable' => 'Haemoglobin'];
    $labFields[] = ['fieldName' => 'platelet', 'fieldLable' => 'Platelet count'];
    $labFields[] = ['fieldName' => 'pco2', 'fieldLable' => 'PCO2'];
    $labFields[] = ['fieldName' => 'po2', 'fieldLable' => 'PO2'];
    $labFields[] = ['fieldName' => 'ph', 'fieldLable' => 'Ph'];
    
    /*
    function phonenumber_format( $datanumber ){
        $datanumber = preg_replace('/[^0-9]/', '', $datanumber);
        $len = strlen($datanumber);
    
        if($len == 7) $datanumber = preg_replace('/([0-9]{2})([0-9]{2})([0-9]{3})/', '$1 $2 $3', $datanumber);
        elseif($len == 8) $datanumber = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})/', '$1 $2 $3', $datanumber);
        elseif($len == 9) $datanumber = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{2})([0-9]{2})/', '$1 $2 $3 $4', $datanumber);
        elseif($len == 10) $datanumber = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{2})([0-9]{3})/', '$1 $2 $3 $4', $datanumber);
    
        return $datanumber;
    }
    */
    
    function format_phone($phone){
    $phone = preg_replace("/^\d/", "", $phone);

    if(strlen($phone) == 7)
        return preg_replace("/(\d{3})(\d{4})/", "$1-$2", $phone);
    elseif(strlen($phone) == 10)
        return preg_replace("/(\d{3})(\d{3})(\d{4})/", "($1) $2-$3", $phone);
    else
        return $phone;
    }
    
?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Nurse Dashboard</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
        <link rel="stylesheet" type="text/css" href="assets/css/slicknav.css">
        <link rel="stylesheet" type="text/css" href="assets/css/jquery.fancybox.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/easy-autocomplete.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/easy-autocomplete.themes.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
        <link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">

        <style>
            .input-group-addon {
                padding:0px !important;
            }
            button i.glyphicon {
                padding : 3px;
            }
            button.view_notes {
                margin-top:10px !important;
            }
            .form-inline .row {
                padding-bottom:15px;
            }
            .panel {
                margin-bottom: 10px;
                background-color: #fff;
                border: 1px solid #eee;
                border-radius: 2px;
                -webkit-box-shadow: 2px 2px 5px rgba(0,0,0,.05);
                box-shadow: 2px 2px 5px rgba(0,0,0,.05);
                padding: 8px;
                position:relative;
            }
            hr.divider {
                margin:0px;
            }
            .wait_time h3 {
                margin-top:5px;
                margin-bottom:5px;
            }
            .inOut h4 {
                margin-top:25px;
            }
            .acuity h3 {
                margin-top:23px;
            }
            #template {
                display:none;
            }
            .panel .patient {
                position:relative;
                /*height:85px;*/
            }
            .hoverOptions {
                display:none;
            }
            .patient button, select {
                margin-top:20px;
            }
            .hoverOptions button {
                margin-top:20px;
            }
            .panel:hover .hoverOptions {
                width:100%;
                background:rgba(0,0,0,.5);
                position:absolute;
                top:0;
                left:0;
                /*display:inline-block;*/
                color:white;
                padding:12px;
                height:100px;
            }
            .box-vertical-center {
                top:13px;
            }
            .patient-header h5 {
                font-weight : bold;
                margin-top: 5px;
                margin-bottom: 5px;
            }
            .patient-header-panel {
                padding:5px 8px ;
            }
            .patient .patient-name {
                height:85px;
            }
            .patient .patient-name span.phone{
                color:#AAAAAA;
                font-size: 13px;
            }
            .patient .diag {
                /*height:85px;*/
				height:105px;
            }
            .patient .assign-div {
                height:85px;
            }
            
            body{
                top: 0px!important;
            }
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }
            #goog-gt-tt{
                display:none!important;
            }
            #google_translate_element{
                position: fixed; left:20px; top: 20px; z-index: 9999999;
            }
        </style>
        
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', 
            layout:     google.translate.TranslateElement.InlineLayout.SIMPLE,
            autoDisplay: false, 
            includedLanguages: ''}, 'google_translate_element');}
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        
        <script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
        <!--<script type="text/javascript" src="assets/js/dahsboar_auto_refresh.js"></script>-->
        
        <?php
        $query = "SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 48 HOUR) ORDER BY checkin_time DESC";
        $run_query = mysqli_query($con, $query);
        $numberOfRows = mysqli_num_rows($run_query);
        ?>
        
    </head>
    <body class="patien-data-table dashboard-area" data-total-symptoms="<?php echo $numberOfRows; ?>">
        
        <audio id="new_patient" src="assets/audio/notification.ogg" autoplay="false" ></audio>
        
        <?php include('dashboard_menu.php'); ?>
        
        <div id="google_translate_element" data-step="1" data-position="bottom"></div>
        
        <div class="container">
            
            <!-- Add Vitals Modal -->
            <div id="vitals" class="modal fade" role="dialog" style="margin-top: 50px;">
                <div class="modal-dialog modal-md">
                    <!-- Modal content-->
                    <div class="modal-content">
                        
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">Add Vital Information</h4>
                        </div>
                        
                        <div class="modal-body">
                            <div class="row">
                                <input type="hidden" id="guidInVitalForm" value="">
                                <input type="hidden" id="hidden_patient_id" value="">
                                <div class="col-md-6">
                                    <h4 class="text-center">Lab Results</h4>
                                    <?php foreach($labFields as $field) { ?>
                                    <?php $label = $field['fieldLable']; ?>
                                    <?php $name = $field['fieldName']; ?>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-5">
                                                    <label for="<?php echo $name; ?>"><?php echo $label; ?>:</label>
                                                </div>
                                                <div class="col-md-7">
                                                    <input type="text" class="form-control" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="col-md-6">
                                    <h4 class="text-center">Vitals</h4>
                                    <?php foreach($vitalFields as $field) { ?>
                                    <?php $label = $field['fieldLable']; ?>
                                    <?php $name = $field['fieldName']; ?>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-5">
                                                    <label for="<?php echo $name; ?>"><?php echo $label; ?>:</label>
                                                </div>
                                                <div class="col-md-7">
                                                    <input type="text" class="form-control" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-success" data-dismiss="modal" id="calculateAcuity">Save</button>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Add Vitals Modal -->
            
            <div class="row">
                <!--div class="col-md-3">
                    <div class="card panel">
                        <img class="card-img-top col-md-12" src="images/person-male.png" alt="Card image cap">
                        <div class="card-block">
                            <center><h4 class="card-title">Kabir, Azad</h4></center>
                            <p class="card-text text-center">Friday, 2nd Feb</p>
                        </div>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">
                                Total visits today 
                                <a href="#" class="card-link pull-right">15</a>
                            </li>
                            <li class="list-group-item">
                                Patients in waiting room 
                                <a href="#" class="card-link pull-right">3</a>
                            </li>
                            <li class="list-group-item">
                                Patients hospitalized 
                                <a href="#" class="card-link pull-right">6</a>
                            </li>
                            <li class="list-group-item">
                                Average wait time
                                <a href="#" class="card-link pull-right">13 mins</a>
                            </li>
                        </ul>
                    </div>
                </div-->
                
                <div class="container">
                    <div class="col-md-12">


                        <div id="patientContainer" class="dashboard-data">
                            <div style="width: 100%; height: 50px;"></div>
                            <div class="thead">
                                <div class="tr">
                                    <div class="td patient_info">Patient Name</div>
                                    <div class="td patient_symptoms">Diagnosis</div>
                                    <div class="td patient_assign">Assign To</div>
                                    <div class="td patient_status" style="text-align: center;">Status</div>
                                    <div class="td patient_acuity" style="text-align: center;">Acuity</div>
                                    <div class="td patient_vitals">Vitals</div>
                                    <div class="td patient_waitTime">Wait time</div>
                                    <div class="td patient_action">Action</div>
                                    <div class="clear"></div>
                                </div>
                            </div>

                            <div class="tbody" id="patientContainer-body">
                                <?php
                                $query = "SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 48 HOUR) ORDER BY checkin_time DESC";
                                $run_query = mysqli_query($con, $query);
                                while($data = mysqli_fetch_array($run_query)) {
                                ?>

                               

                                <div class="tr" id="<?php echo $data['waitingroom_guid']; ?>">
                                     <input type="hidden" id="waitingEntryID" value="<?php echo $data['waitingroom_id']; ?>">
                                    <!-- Name -->
                                    <div class="td patient_info">
                                        <strong><?php echo ucwords($data['patient_name']); ?></strong>
                                        <?php
                                            $pid = $data['patient_id'];
                                            $p_query = "SELECT patient_dob, cell FROM patients WHERE patient_id='".$pid."' ";
                                            $run_p_query = mysqli_query($con, $p_query);
                                            while($p_data = mysqli_fetch_array($run_p_query)) {
                                                $DOB = $p_data['patient_dob'];
                                                $today = date("Y-m-d");
                                                $diff = date_diff(date_create($DOB), date_create($today));
                                                echo "<span class='phone'>".format_phone($p_data['cell'])."</span>";
                                                echo '<span class="age">'.$diff->format('%y').' yrs</span>';
                                            }
                                        ?>
                                        <span class="returning"><?php echo $data['is_returning_patient'] == 1 ? "Returning Patient" : "New Patient"; ?></span>
                                    </div>
                                    <!-- Name -->

                                    <!-- Diagnosis -->
                                    <div class="td patient_symptoms">
                                        <?php
                                            echo $data['diagnosis']!="" ? $data['diagnosis'] : ($data['symptoms']=="" ? "Awaiting chief complaint" : "No diagnosis matched");
                                            if((int)$data['is_SEPSIS'] == 1 && ($data['acuity']!="" && ((int) $data['acuity'] >= 5))) {
                                                echo " (SEPSIS)";
                                            } else if ((int)$data['is_SIRS'] == 1) {
                                                echo " (SIRS)";
                                            }
                                        ?>
                                        <strong><?php echo $data['symptoms']!="" ? $data['symptoms'] : "Awaiting symptoms"; ?></strong>
                                        <?php
                                            if (!empty($data['diagnosis']) && $data['diagnosis'] != '') {
                                                $string = trim($data['diagnosis']);
                                                if ((string)$string != "Awaiting chief complaint") {

                                                }
                                            }
                                        ?>
                                        
                                        <?php if( $data['symptom_photo'] != '' ){ ?><a href="<?php echo $data['symptom_photo']; ?>" class="symptom_photo" data-fancybox data-caption="<?php echo $data['symptoms']; ?>">View Photo</a><?php } ?>
                                        
                                    </div>
                                    <!-- Diagnosis -->

                                    <!-- Assign To -->
                                    <div class="td patient_assign">
                                        <select class="btn btn-primary col-md-12 physician-dropdown" for="<?php echo $data['waitingroom_id']; ?>">
                                        <option>Assign Physician</option>
                                        <?php
                                            $users = "SELECT physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where user_type = 2 and location_id =1";
                                            $users_query = mysqli_query($con, $users);
                                                 $isSelected = "";
                                            while($row = mysqli_fetch_array($users_query)) {
                                            $name = "Dr. ".$row['physician_fname']." ".$row['physician_lname'];
                                        ?>
                                            <option <?php if($data['physician_id']!=0 && $data['physician_id'] == $row['id']){ echo "selected";} ?> value="<?php echo $row['id'] ?>"><?php echo $name; ?></option>
                                        <?php } ?>
                                        </select>
                                        <a target="_blank" href="view_patient.php?wID=<?php echo $data['waitingroom_id'];?>">
                                            <button class="btn btn-primary col-md-12 view_notes">View Notes</button>
                                        </a>
                                    </div>
                                    <!-- Assign To -->

                                    <!-- Status -->
                                    <div class="td patient_status <?php echo $class; ?>" style="text-align: center;">
                                        <?php
                                            if($data['acuity']!="" && ((int) $data['acuity'] >= 4)) {
                                                $inOut = "Inpatient";
                                                $class = "text-danger";
                                            } else if($data['acuity']!="" && ((int) $data['acuity'] == 3)) {
                                                $inOut = "Undecided";
                                                $class = "text-muted";
                                            } else {
                                                $inOut = "Outpatient";
                                                $class = "text-success";
                                            }
                                        ?>
                                        <b class="inOutText"><?php echo $inOut; ?></b>
                                    </div>
                                    <!-- Satus -->

                                    <!-- Acuity -->
                                    <div class="td patient_acuity" style="text-align: center;">
                                    <input type="hidden" id="acuityValue" value="<?php echo $data['acuity']!="" ? $data['acuity'] : "0"; ?>">
                                        <h3 class="card-subtitle mb-2 <?php echo $class; ?>">
                                            <b class="acuityText"><?php echo $data['acuity']!="" ? $data['acuity'] : "0"; ?>/10</b>
                                        </h3>
                                    </div>
                                    <!-- Acuity -->

                                    <!-- Vitals -->
                                    <div class="td patient_vitals">
                                        <button class="btn btn-primary col-md-12 addVitals" data-toggle="modal" represents="<?php echo $data['waitingroom_guid']; ?>" data-target="#vitals" style="margin-bottom: 10px;" data-patient-id="<?php echo $data['patient_id']; ?>">
                                            <?php //echo $data['vital_json'] == '' ? 'Add' : 'View'; ?>
                                            Add
                                        </button>
                                        <a href="patient_vitals.php?patient_id=<?php echo $data['patient_id']; ?>" class="btn btn-primary addVitals" data-patient-id="<?php echo $data['patient_id']; ?>">View</a>
                                    </div>
                                    <!-- Vitals -->

                                    <!-- Wait Time -->
                                    <div class="td patient_waitTime">
                                        <h3 class="card-subtitle mb-2 text-muted">
                                        <?php
                                            // echo $data['checkin_time'];
                                            $datetime1 = new DateTime($data['checkin_time']);
                                            // var_dump($datetime1);
                                            $datetime2 = new DateTime();
                                            // var_dump($datetime2);
                                            $interval = $datetime1->diff($datetime2);
                                            // print_r($interval);
                                            $hrs = ($interval->format('%d') * 24) + $interval->format('%h');
                                            $mins = $interval->format('%i');
                                            echo "<input type='hidden' id='checkinTime' value='".$data['checkin_time']."'>";
                                            echo "<input type='hidden' id='hrs' value='".$hrs."'>";
                                            echo "<input type='hidden' id='mins' value='".$mins."'>";
                                            $hrs = $hrs < 10 ? "0".$hrs : $hrs;
                                            $mins = $mins < 10 ? "0".$mins : $mins;
                                            echo "<b>". $hrs .":".$mins."</b>";
                                        ?>
                                        </h3>
                                        <h6 class="card-subtitle mb-2 text-muted"><b>HH:MM</b></h6>
                                    </div>
                                    <!-- Wait Time -->
                                    
                                    <!-- Action -->
                                    <div class="td patient_action">
                                        <a href="waitingroom_delete.php?wID=<?php echo $data['waitingroom_id'];?>&request_from=nurse">
                                            <button class="btn btn-danger col-md-12 addVitals">Delete</button>
                                        </a>
                                    </div>
                                    <!-- Action -->

                                    <div class="clear"></div>
                                </div>
                                <div class="clear"></div>

                                <?php } ?>

                            </div>
                        </div>


                    </div>
                </div>

            </div>
        </div>

        <div style="width: 100%; height: 80px;"></div>
        
        </body>
        </html>

        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <script type="text/javascript">
        $(function () {
            $("#patientContainer-body .patient").each(function(){
                // console.log(Date.now());
                // console.log(new Date($(this).find("#checkInTime").val()));
                // console.log(new Date($(this).find("#checkInTime").val()).getTime());
                var totalSeconds = (Date.now() - new Date($(this).find("#checkInTime").val()).getTime())/1000;
                var hours = Math.floor(totalSeconds / 3600);
                totalSeconds = totalSeconds - hours * 3600;
                var minutes = Math.floor(totalSeconds / 60);
                $(this).find("#hrs").val(hours);
                $(this).find("#mins").val(minutes);
                $(this).find(".wait_time h3 b").html(hours+":"+minutes);
            });
            setInterval(function() {
                $("#patientContainer-body .patient").each(function(){
                    var mins = parseInt($(this).find("#mins").val());
                    var hours = parseInt($(this).find("#hrs").val());
                    if(mins < 59) {
                        mins += 1;
                        $(this).find("#mins").val(mins);
                        $(this).find(".wait_time h3 b").html(hours+":"+mins);
                    } else {
                        hours += 1;
                        mins = 0;
                        $(this).find("#hrs").val(hours);
                        $(this).find("#mins").val(mins);
                        $(this).find(".wait_time h3 b").html(hours+":"+mins);
                    }
                });
            }, 60000);
            
            
            
            $('body').on('change', '.physician-dropdown', function() {
            //$(".physician-dropdown").change(function(){
                var physician_id = $(this).val();
                var waitingroom_id = $(this).attr("for");
                console.log(waitingroom_id);
                $.ajax({
                    url: 'save_search_entry.php',
                    data: {'physicianUpdate': true, 'waitingroom_id': waitingroom_id, 'physician_id': physician_id},
                    type: 'POST',
                    dataType: 'json',
                    success: function success(msg) {
                        alert('Physician assigned');
                    },
                    error: function error(msg) {
                        console.log('error');
                    },
                });
            });
            
            
            $('body').on('click', '.addVitals', function() {
            //$(".addVitals").click(function(){
				var text = $.trim($(this).html());
                var guid = $(this).attr("represents");
                $("#guidInVitalForm").val(guid);
				var waitingroom_id = $("#"+guid).find("#waitingEntryID").val();
				if(text=="View") {
					$.ajax({
						url:"save_search_entry.php",
						type: 'POST',
						dataType: 'json',
						data: {wID: waitingroom_id, vitalFetch: true},
						success:function(data) {
							var vitalParse = JSON.parse(data.data);
                            var vitalFields = <?php echo json_encode($vitalFields); ?>;
							$.each(vitalParse, function(i, val) {
								$("#"+i).val(val);
								
							});
							
                            var currentAcuity = $("#"+guid).find("#acuityValue").val();
                            var isSEPSIS = $("#"+guid).find("#isSEPSIS").val();
                            var totalScore = 0;
                            if(isSEPSIS == 1) {
                                totalScore = 3;
                            }
                            var value;
                            var intValue;
                            var waitingroom_id = $("#"+guid).find("#waitingEntryID").val();
                            var vitalScore = 0;
                            vitalFields.forEach(function(item, index){
                                value = $("#"+item.fieldName).val();
                                if(value != "") {
                                    intValue = parseInt(value);
                                    if((item.min != 0 && intValue < item.min) || (item.max != 0 && intValue > item.max)) {
                                        vitalScore++;
                                    }
                                }
                            });
                            totalScore += vitalScore;
				            sepsisSirsLogic(guid, totalScore, isSEPSIS, vitalScore);
						}, 
						error: function error(msg) {
							console.log('error');
						},
					});
				} else {
					$('#vitals').find('input[type=text]').val('');
				}
            });
            
            
            
            
            //$("#calculateAcuity").click(function() {
            $('body').on('click', '#calculateAcuity', function() {
                var guid = $("#guidInVitalForm").val();
                var currentAcuity = $("#"+guid).find("#acuityValue").val();
                var isSEPSIS = $("#"+guid).find("#isSEPSIS").val();
                var totalScore = 0;
                if(isSEPSIS == 1) {
                    totalScore = 3;
                }
                var vitalFields = <?php echo json_encode($vitalFields); ?>;
                var value;
                var intValue;
                var waitingroom_id = $("#"+guid).find("#waitingEntryID").val();
				var jsonVital = new Object();
                var vitalScore = 0;
                vitalFields.forEach(function(item, index){
                    value = $("#"+item.fieldName).val();
					jsonVital[item.fieldName] = value;
                    if(value != "") {
                        intValue = parseInt(value);
                        if((item.min != 0 && intValue < item.min) || (item.max != 0 && intValue > item.max)) {
                            vitalScore++;
                        }
                    }
                });
                totalScore += vitalScore;
				$.ajax({
					url:"save_search_entry.php",
					type: 'POST',
					dataType: 'json',
					data: {
					    'vitalUpdate': true,
					    'data': jsonVital,
					    'waitingroom_id': waitingroom_id,
					    'acuity': totalScore,
					    'vitalScore': vitalScore
					},
					success:function(data) {
						//$("#"+guid).find(".patient_vitals .addVitals").html("View");
					}, 
					error: function error(msg) {
						console.log('error');
					},
				});
				sepsisSirsLogic(guid, totalScore, isSEPSIS, vitalScore);
            });

            var socket = io.connect('https://lighthouse.ddxrx.com:8080', {secure: true});
            socket.on('testMessage', function(msg){
                console.log("we received a test message here", msg);
            });
            socket.on('chat/190', function(msg){
                console.log("we received a here", msg);
            });
  
/*          
            socket.on('newPatient', function(msg){
                console.log("msg ",msg);
                var birth_date = new Date(msg.birthDate);
                console.log("birth_date ",birth_date);
				
				// var today = new Date();
				// var birthDate = new Date(birth_date);
				// var age = today.getFullYear() - birthDate.getFullYear();
				// var m = today.getMonth() - birthDate.getMonth();
				// if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
					// age--;
				// }
                // console.log("age ",age);
				
                var ageDifMs = Date.now() - birth_date.getTime();
                var ageDate = new Date(ageDifMs); // miliseconds from epoch
                var age = Math.abs(ageDate.getUTCFullYear() - 1970);
                console.log("age ",age);
                var content = $("#template").html();
                var name = msg.lname.charAt(0).toUpperCase()+msg.lname.slice(1)+", "+msg.fname.charAt(0).toUpperCase()+msg.fname.slice(1);
                content = content.replace("$name", name);
                var newOld = msg.isNew ? "New Patient" : "Returning Patient";
                content = content.replace("$newOld", newOld);
                content = content.replace("$id", msg.idKey);
                content = content.replace("$age", age);
                
                var CheckedInAt = new Date(msg.checkInTime);
                
                // setInterval(function() {
                    var waitInMinute = Date.now() - CheckedInAt.getTime();
                    console.log('1:', Date.now());
                    console.log('2:', CheckedInAt.getTime());
                    console.log('waitInMinute:', waitInMinute);
                    // var newWaitInMinute = parseMillisecondsIntoReadableTime(waitInMinute);
                    // console.log('3:', newWaitInMinute);
                    content = content.replace("$waitTime", waitInMinute);
                // }, 1000);
                $("#patientContainer-body").prepend(content);
            });
*/
            socket.on('existingPatient', function(msg){
				console.log('msg data', msg);
                var id = msg.idKey;
                $("#"+id).find("#symptoms").html(msg.symptoms);
                $("#"+id).find("#chiefComplaint").html(msg.chiefComplaint.passed.join(", "));
                // $("#"+id).find("#diagnosis_dropdown").html('<select class="btn btn-primary col-md-6" id="diagnosis_dropdown" style="margin-top:-3px; height:33px;"><option>--select--</option></select>');
            });
        });

        function sepsisSirsLogic(guid, totalScore, isSEPSIS, vitalScore) {
                
            $("#"+guid).find(".acuityText").html(totalScore+"/10");
            var content = $("#"+guid).find("#chiefComplaint").html();
            if(totalScore >= 4) {
                $("#"+guid).find(".inOutText").html("Inpatient");
                $("#"+guid).find(".inOutText").parent().removeClass("text-success");
                $("#"+guid).find(".inOutText").parent().addClass("text-danger");
                $("#"+guid).find(".acuityText").parent().removeClass("text-success");
                $("#"+guid).find(".acuityText").parent().addClass("text-danger");
                if(isSEPSIS == 1 && totalScore > 4) {
                    if(content.indexOf(" (SEPSIS)") < 0) {
                        content += " (SEPSIS)";
                        $("#"+guid).find("#chiefComplaint").html(content);
                    }
                } else {
                    if(content.indexOf(" (SEPSIS)") > 0) {
                        content = content.replace(" (SEPSIS)","");
                        $("#"+guid).find("#chiefComplaint").html(content);
                    }
                    if(vitalScore >= 2 && content.indexOf(" (SIRS)") < 0) {
                        content += " (SIRS)";
                        $("#"+guid).find("#chiefComplaint").html(content);
                    } else if (vitalScore < 2) {
                        content = content.replace(" (SIRS)","");
                        $("#"+guid).find("#chiefComplaint").html(content);
                    }
                }
            } else {
                if(content.indexOf(" (SEPSIS)") > 0) {
                    content = content.replace(" (SEPSIS)","");
                    $("#"+guid).find("#chiefComplaint").html(content);
                }
                if(vitalScore >= 2 && content.indexOf(" (SIRS)") < 0) {
                    content += " (SIRS)";
                    $("#"+guid).find("#chiefComplaint").html(content);
                } else if (vitalScore < 2) {
                    content = content.replace(" (SIRS)","");
                    $("#"+guid).find("#chiefComplaint").html(content);
                }
                if(totalScore < 3) {
                    $("#"+guid).find(".inOutText").html("Outpatient");
                } else {
                    $("#"+guid).find(".inOutText").html("Undecided");
                }
                $("#"+guid).find(".inOutText").parent().addClass("text-success");
                $("#"+guid).find(".inOutText").parent().removeClass("text-danger");
                $("#"+guid).find(".acuityText").parent().addClass("text-success");
                $("#"+guid).find(".acuityText").parent().removeClass("text-danger");
            }
        }
        </script>
        <script type="text/javascript" src="assets/js/jquery.fancybox.min.js"></script>
        
        <!-- Send Vitals to history table -->
        <script type="text/javascript">
            
            $('body').on('click', '.addVitals', function() {
                var patient_id = $(this).data('patient-id');
                $('#hidden_patient_id').val( patient_id );
            });
            
        
            $('body').on('click', '#calculateAcuity', function() {
                
                var patient_id = $('#hidden_patient_id').val();
                var systolicBP = $('#systolicBP').val();
                var diastolicBP = $('#diastolicBP').val();
                var heartRate = $('#heartRate').val();
                var respRate = $('#respRate').val();
                var pulseOX = $('#pulseOX').val();
                var temp = $('#temp').val();
                var lacticAcid = $('#lacticAcid').val();
                var wbc = $('#wbc').val();
                var hb = $('#hb').val();
                var platelet = $('#platelet').val();
                var pco2 = $('#pco2').val();
                var po2 = $('#po2').val();
                var ph = $('#ph').val();
                
                $.ajax({
        			type: 'POST',
        			url: 'process/save_vital_history.php',
        
        			data: {
        				patient_id:patient_id,
        				systolicBP:systolicBP,
        				diastolicBP:diastolicBP,
        				heartRate:heartRate,
        				respRate:respRate,
        				pulseOX:pulseOX,
        				temp:temp,
        				
        				lacticAcid:lacticAcid,
        				wbc:wbc,
        				hb:hb,
        				platelet:platelet,
        				pco2:pco2,
        				po2:po2,
        				ph:ph,
        				
        			},
        
        			beforeSend: function() {
        					
        			},
        			success: function(response) {
                            
                        Swal.fire({
                            icon: 'success',
                            //title: 'Data Saved',
                            text: "The vitals data have been saved",
                        });
                            
                            
        			},	
        			fail: function(response){
        				// Do Something
        			}
        
        		});
                 
            });
        </script>
        <!-- Send Vitals to history table -->
        
    </body>
</html>