<?php
    include('../includes/database_include.php');
    require_once("Mobile_Detect.php");
    $detect = new Mobile_Detect;
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>DOCTOR AI - Artificial Intelligence Based Health Care</title>
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script type="text/javascript" src="../assets/js/sweetalert2.min.js"></script>
	<script type="text/javascript" src="../assets/js/autocomplete/jquery.autocomplete.min.js"></script>
	<script type="text/javascript" src="../assets/js/autocomplete/jquery.validate.min.js"></script>
	<script type="text/javascript" src="../assets/js/jquery.tap.js"></script>
	
	<?php if( $detect->isMobile() && !$detect->isTablet() ){ ?>
	    <script type="text/javascript" src="js/chat-bot.js"></script>
	<?php }else{ ?>
	    <script type="text/javascript" src="js/chat-bot-desktop.js"></script>
    <?php } ?>
	
	<link rel="stylesheet" type="text/css" href="../assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="../assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="../assets/css/autocomplete/jquery.autocomplete.css"/>
	<link rel="stylesheet" type="text/css" href="../assets/css/sweetalert2.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/chat-bot.css">
    <link rel="stylesheet" type="text/css" href="css/nda.css">
	
	<script type="text/javascript">
	    var matched, browser;

        jQuery.uaMatch = function( ua ) {
            ua = ua.toLowerCase();
        
            var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
                /(webkit)[ \/]([\w.]+)/.exec( ua ) ||
                /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
                /(msie) ([\w.]+)/.exec( ua ) ||
                ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
                [];
        
            return {
                browser: match[ 1 ] || "",
                version: match[ 2 ] || "0"
            };
        };

        matched = jQuery.uaMatch( navigator.userAgent );
        browser = {};
        
        if ( matched.browser ) {
            browser[ matched.browser ] = true;
            browser.version = matched.version;
        }

        // Chrome is Webkit, but Webkit is also Safari.
        if ( browser.chrome ) {
            browser.webkit = true;
        } else if ( browser.webkit ) {
            browser.safari = true;
        }

        jQuery.browser = browser;
        

        /* ------------------------------------------------------------------------------ */    
    
        $(document).ready(function () {
            <?php
            if (strlen($varSSLists) <= 100) {
                $varSSLists = "";
                $_SESSION['allSymptoms'] = [];
                $result = mysqli_query($con, "SELECT distinct(name) FROM symptoms where deleted=0");
                while ($row = mysqli_fetch_array($result)) {
                    $varSSLists = $varSSLists . $row['name'] . "*";
                    $_SESSION['allSymptoms'][] = strtolower($row['name']);
                }
                
            }
            $_SESSION['varSSLists'] = $varSSLists;
            // echo $_SESSION['varSSLists'];
            ?>

            var data = "<?php echo $varSSLists;?>".split("*");
            $( "body" ).on( "keyup", ".symptoms_search_box", function() {
                $(this).autocomplete(data, {
                    mustMatch: false,
                    autoFill: false,
                    matchContains: "word",
                    max: "40",
                    scrollHeight: "400px"
                });
            });
        });
	</script>
	
	
	
	<script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
	
	<meta property="og:locale" content="en_US">
    <meta property="og:type" content="apps">
    <meta property="og:title" content="DOCTOR AI - Artificial Intelligence Based Health Care">
    <meta property="og:description" content="It can reduce unnecessary treatments and defensive medicine practices through the standardization of diagnostic criteria.">
    <meta property="og:url" content="https://doctorai.ddxrx.com/screening">
    <meta property="og:site_name" content="Doctor AI">
    <meta property="article:section" content="Health and Wellness">
    <meta property="og:image" content="https://doctorai.ddxrx.com/screening/images/preview.jpg">
    <meta property="og:image:secure_url" content="https://doctorai.ddxrx.com/screening/images/preview.jpg">
    <meta property="og:image:width" content="614">
    <meta property="og:image:height" content="450">
	
</head>
<body>
    
    
    <!-- NDA -->
    <div class="nda-container">
        <div class="ndacontent">
            
            <h6>Medical Disclaimer</h6>
            <p>You will use THE DDXRX Software Information only as a reference aid, and that such information is not intended to be (nor should it be used as) a substitute for the exercise of professional judgment. In view of the possibility of human error or changes in medical science, you should confirm the information in THE DDXRX Software Information through independent sources. You agree and acknowledge that you will, at all times, seek professional diagnosis and treatment for any medical condition and to discuss information obtained from THE DDXRX Software Information with their healthcare provider. The user understands that diseases that the user might consider appropriate may not appear on the list of disease links. The DDXRX software generated severity of illness scores, automatically generated encounter notes and treatments and other recommendations are educational purpose only, and not to be used for patient care. Individual physician must perform through examination of the patient and deliver appropriate treatments without depending on THE DDXRX software.</p>
            <p>This site is designed to offer you general health information for educational purposes only. The health information furnished on this site and the interactive responses are not intended to be professional advice and are not intended to replace personal consultation with a qualified physician, pharmacist or other healthcare professional. You must always seek the advice of a professional for questions related to your disease, disease symptoms, and appropriate therapeutic treatments. If you have or suspect that you have a medical problem or condition, please contact a qualified healthcare provider immediately.</p>
            <p>By clicking on the "I Agree" button below, you acknowledge that you have read, understand, and agree to be bound by the <a href="terms_condition.php">Terms and Conditions</a>, <a href="https://ddxrx.com/pages/consent-for-telemedicine">Consent for Telemedicne Treatment</a>, <a href="../privacy_policy.php">Privacy Policy</a>, <a href="../nda.php">Non-Disclosure Agreement</a> and <a href="../medical-disclaimer.php">Medical Disclaimer</a>.</p>
            
            <a href="javascript:;" class="button green i_agree" id="patient_login">I Agree</a>
            <a href="https://www.who.int" class="button red i_disagree">I Disagree</a>
            
        </div>
    </div>
    <!-- NDA -->
    
    <div id="google_translate_element"></div>
    
    <!-- Start Particle -->
    <div id="particles-js"></div>
    <!-- End Particle -->
    
    <!-- Start Wrapper -->
    <div class="wrapper">
        
        <!-- Bot Avatar -->
        <div class="bot-avatar">
            <div class="bot-reaction idle"></div>
        </div>
        <!-- Bot Avatar -->
        
        
        
        
        
        
        <div class="container">
            <div class="col-md-12">
                
                <div class="response-container">
                    <!--<h1>Hi Azad, what is bothering you the most?</h1>-->
                    <h1>Hello, How can I help you?</h1>
                    <h6></h6>
                </div>
                
                <div class="option_symptoms">
                    <div class="inner">
                        <ul></ul>
                    </div>
                    <a href="javascript:;" class="send_mult_ans">Send Answer</a>
                </div>
                
                <div class="form-container">
                    <input type="search" name="symptoms[0]" class="textbox search_phrase symptom-search-3 ui-input-text ui-body-c ac_input symptoms_search_box" data-type="search" id="symptoms_0" value="<?php if( !empty($_GET['symptom_0']) ){ echo $_GET['symptom_0']; } ?>"  placeholder='Try "Fever or Chest Pain"'>
                    <a href="javascript:;" class="button send">Send</a>
                    <a href="javascript:;" class="button refresh">Refresh</a>
                    <div class="clear"></div>
                </div>
                
                <div class="common-symptoms">
                    <h6>Commonly Used Symptoms</h6>
                    <div class="entries">
                        
                        <a href="javascript:;" data-symptoms="COVID-19 Screening">COVID-19 Screening</a>
                        <a href="javascript:;" data-symptoms="I have fever">Fever</a>
                        <a href="javascript:;" data-symptoms="I have headache">Headache</a>
                        <a href="javascript:;" data-symptoms="I have cough">Cough</a>
                        <a href="javascript:;" data-symptoms="I am vomiting">Vomiting</a>
                        <a href="javascript:;" data-symptoms="I feel dizziness">Dizzy</a>
                        <a href="javascript:;" data-symptoms="I have abdominal pain">Abdominal Pain</a>
                        <a href="javascript:;" data-symptoms="I have sore throat">Sore Throat</a>
                        <a href="javascript:;" data-symptoms="I have chest Pain">Chest Pain</a>
                        <a href="javascript:;" data-symptoms="I have shortness of breath">Shortness of Breath</a>
                        <a href="javascript:;" data-symptoms="I am wheezing">Wheezes</a>
                        
                        <!--
                        <a href="javascript:;" data-symptoms="Fever">Fever</a>
                        <a href="javascript:;" data-symptoms="Headache">Headache</a>
                        <a href="javascript:;" data-symptoms="Cough">Cough</a>
                        <a href="javascript:;" data-symptoms="Vomiting">Vomiting</a>
                        <a href="javascript:;" data-symptoms="Dizziness">Dizzy</a>
                        <a href="javascript:;" data-symptoms="Abdominal pain">Abdominal Pain</a>
                        <a href="javascript:;" data-symptoms="Sore throat">Sore Throat</a>
                        <a href="javascript:;" data-symptoms="Chest Pain">Chest Pain</a>
                        <a href="javascript:;" data-symptoms="Shortness of breath">Shortness of Breath</a>
                        <a href="javascript:;" data-symptoms="Wheezing">Wheezes</a>
                       -->
                       
                        <div class="clear"></div>
                    </div>
                </div>
                
                <div class="front-social-media">
                    <h6>Share Our App</h6>
                    <ul>
                        <li><a href="https://www.facebook.com/sharer/sharer.php?u=https://doctorai.ddxrx.com" target="_blank"><img src="../assets/images/boticon/facebook.png"></a></li>
                        <li><a href="http://twitter.com/home?status=Doctor AI health bot&nbsp;https://doctorai.ddxrx.com" target="_blank"><img src="../assets/images/boticon/twitter.png"></a></li>
                        <li><a href="http://www.pinterest.com/pin/create/button/?url=https://doctorai.ddxrx.com" target="_blank"><img src="../assets/images/boticon/pinterest.png"></a></li>
                        <li><a href="http://www.linkedin.com/shareArticle?mini=true&url=https://doctorai.ddxrx.com" target="_blank"><img src="../assets/images/boticon/linkedin.png"></a></li>
                    </ul>
                </div>
                
            </div>
        </div>

    </div>
    <!-- Start Wrapper -->
    
    <form id="formddX" name="formddX" method="post" action="ddx_reports.php" data-ajax="false" onsubmit="return search(event);" style="display: none"></form>
    
    <script type="text/javascript" src="../assets/js/particles.min.js"></script>
	<script type="text/javascript" src="../assets/js/particles_init.js"></script>
    
</body>
</html>