<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <style>
            .container {
                min-height:100%;
                padding-bottom: 60px;
            }
            .input-group-addon {
                padding:0px !important;
            }
            button i.glyphicon {
                padding : 3px;
            }
            .form-inline .row {
                padding-bottom:15px;
            }
            #template {
                display:none;
            }
            .typeahead.dropdown-menu { 
                width: 100%;
            }
            #sampleField {
                display:none;
            }
            #plan {
                margin-bottom:20px;
            }
            #anotherDiagnosis {
                display:none;
                margin-bottom:20px;
            }
        </style>
    </head>
    <body>
        <div id="wrap">
            <?php 
                include('new_nav.php'); 
            ?>
            <div class="container">
                <div id="form" class="form-inline">
                    <div id="sampleField">
                        <div class="row">
                            <div class="col-md-4 col-md-offset-2">
                                <div class="input-group col-md-12">
                                    <input class="form-control diagnosisAutoComplete" data-provide="typeahead" type="text" class="col-md-12" name="diagnosis">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 col-md-offset-2">
                            <div class="input-group col-md-12">
                                <input class="form-control diagnosisAutoComplete col-md-12" data-provide="typeahead" type="text" name="diagnosis">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary col-md-12" id="getPlan">Get Treatment Plan</button>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-default col-md-12" id="addAnother">+ Add another disease</button>
                        </div>
                        <div class="col-md-2">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12" id="plan">
                    </div>
                </div>
                <div class="row" id="anotherDiagnosis">
                    <div class="col-md-5 col-md-offset-2">
                        <div class="input-group col-md-12">
                            <input class="form-control diagnosisAutoComplete col-md-12" data-provide="typeahead" type="text" name="diagnosis" placeholder="Add another diagnosis">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-primary col-md-12" id="getNewPlan">Add another diagnosis</button>
                    </div>
                </div>
            </div>
        </div>
        <?php
            include ('footer_m.php');
        ?>

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <script src="https://gitcdn.link/repo/xcash/bootstrap-autocomplete/master/dist/latest/bootstrap-autocomplete.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.2/bootstrap3-typeahead.js"></script>
        <script type="text/javascript">
            $(document).ready(function(){
                console.log($(window).height());
                $(".container").css("min-height", $(window).height()-270+"px");
                function getSuggestions () {
                    $('.diagnosisAutoComplete').typeahead({
                        source: function (query, process) {
                            return $.ajax({
                                minLength: 1,
                                url: "get_all_diagnosis.php",
                                type: 'GET',
                                data : 'q='+query,
                                dataType: 'json',
                                success: function (data) {
                                    return typeof data == 'undefined' ? false : process(data);
                                }
                            }); 
                        }
                    });
                }
                
                $("#addAnother").click(function(){
                    $("#form").append($("#sampleField").html());
                    getSuggestions();
                });
                
                function getPlans() {
                    var diagnosis = [];
                    $('.diagnosisAutoComplete').each(function(index, item) {
                        if($(item).val() != "") {
                            diagnosis.push($(item).val());
                        }
                    });
                    $.ajax({
                        url: "get_plan.php",
                        type: 'POST',
                        data : {diagnosis:diagnosis},
                        success: function (data) {
                            $("#plan").html(data);
                            $("#anotherDiagnosis").show();
                        }
                    }); 
                }
                $("#getNewPlan").click(function(){
                    getPlans();
                    getSuggestions();
                });
                
                $("#getPlan").click(function(){
                    getPlans();
                });
                getSuggestions();
            });
        </script>
    </body>
</html>