<?php

header('Content-type: application/json');

include('functions.php');

// Validate Phone Number
function validate_phone_number($phone) {
    
    $valid_number = filter_var($phone, FILTER_SANITIZE_NUMBER_INT);
    $valid_number = str_replace("-", "", $valid_number);
    
    $expr = '/^\+?(\(?[0-9]{3}\)?|[0-9]{3})[-\.\s]?[0-9]{3}[-\.\s]?[0-9]{4}$/';
    
    if (preg_match($expr, $phone) == 1){
        
        return true;
        
    }else{
        
        return false;
        
    }
}


// Check Username
function checkusername($username){
    
    $sql = "SELECT username FROM all_users WHERE username = '$username' LIMIT 1";
    $result = ddxrxDBConnect()->query($sql);
    
    $data = $result->fetch_assoc();
    
    if( $data['username'] == '' ){
        return true;
    }else{
        return false;
    }
    
    ddxrxDBConnect()->close();
    
}



if( isset($_GET['step']) ){
    
    // Step one
    if( $_GET['step'] == 'one' ){
        
        if( $_POST['fname'] != '' && $_POST['mname'] != '' && $_POST['lname'] != '' ){
           
            $fname = $_POST['fname'];
            $mname = $_POST['mname'];
            $lname = $_POST['lname'];
            
            $form = '<label>
                        <span>Date of birth</span>
                        <input type="text" class="textbox birth birth-year" placeholder="Year">
                        <input type="text" class="textbox birth birth-month" placeholder="Month">
                        <input type="text" class="textbox birth birth-day" placeholder="Day">
                        <div class="clear"></div>
                    </label>
                        
                    <div class="radio-group">
                        <div class="label"><span>Gender</span><span class="why why-birthdate">Why we need this?</span></div>
                                        
                        <label><div class="checkbox active"></div><input type="radio" name="gender" value="m" class="gender" checked=""> <strong>Male</strong></label>
                        <label><div class="checkbox"></div><input type="radio" name="gender" value="f" class="gender"> <strong>Female</strong></label>
                        <label><div class="checkbox"></div><input type="radio" name="gender" value="o" class="gender"> <strong>Other</strong></label>
                    </div>
                        
                    <a href="javascript:;" class="button step-2">Next Step</a>';
            
            $verify_result = array(
                'rstatus' => 'success',
                'title' => 'Passed',
                'text' => 'All fields not empty',
                'form' => $form
            );
            
        }else{
            
            $verify_result = array(
                'rstatus' => 'error',
                'title' => 'Empty Fields',
                'text' => 'Fields highlighted in red cannot be empty, please fill up the red textbox'
            );
            
        }
        
    }
    
    if( $_GET['step'] == 'two' ){
        
        if( $_POST['year'] != '' && $_POST['month'] != '' && $_POST['day'] != '' && $_POST['gender'] != '' ){
           
            $year = $_POST['year'];
            $month = $_POST['month'];
            $day = $_POST['day'];
            $birthdate = $_POST['birthdate'];
            $gender = $_POST['gender'];
            
            $form = '
            <label>
                <span>Phone Number</span>
                <input type="text" class="textbox mobileNumber" placeholder="xxx-xxx-xxxx">
            </label>
                        
            <label>
                <span>Email Address(No Required)</span>
                <input type="text" class="textbox emailAddress" placeholder="Enter email address here">
            </label>
                        
            <a href="javascript:;" class="button step-3">Next Step</a>';
            
            $verify_result = array(
                'rstatus' => 'success',
                'title' => 'Passed',
                'text' => 'All fields not empty',
                'form' => $form
            );
            
        }else{
            
            $verify_result = array(
                'rstatus' => 'error',
                'title' => 'Empty Fields',
                'text' => 'Fields highlighted in red cannot be empty, please fill up the red textbox'
            );
            
        }
        
    }
    
    if( $_GET['step'] == 'three' ){
        
        if( $_POST['mobileNumber'] != '' ){
            
            $form = '
                <label>
                    <span>Username</span>
                    <input type="text" class="textbox username" placeholder="Enter your username">
                </label>
                
                <label>
                    <span>Password</span>
                    <input type="password" class="textbox password" placeholder="Enter your password">
                </label>
                
                <label>
                    <span>Repeat Password</span>
                    <input type="password" class="textbox repassword" placeholder="Match the first password">
                </label>
                
                <div class="nda-container">
                    <input type="checkbox" class="checkbox nda-agreement"><p>By clicking on the "Next" button below, you acknowledge that you have read, understand, and agree to be bound by the <strong><a href="terms_condition.php" target="_blank">Terms and Condition</a>, <a href="nda.php" target="_blank">Non-Disclosure Agreement,</a> and <a href="medical-disclaimer.php" target="_blank">Medical Disclaimer</a></strong>.</p>
                </div>
                
                <div class="clear"></div>
                
                <a href="javascript:;" class="button step-4">Next Step</a>
            ';
            
            $phone = $_POST['mobileNumber'];
            
            if( validate_phone_number($phone) == true ){
                
                $verify_result = array(
                    'rstatus' => 'success',
                    'title' => 'Passed',
                    'text' => 'All fields not empty',
                    'form' => $form
                );
                
            }else{
                
                $verify_result = array(
                    'rstatus' => 'error',
                    'title' => 'Invalid Number',
                    'text' => 'The phone number you entered is invalid'
                );
                
            }
            
        }else{
            
            $verify_result = array(
                'rstatus' => 'error',
                'title' => 'Required Phone Number',
                'text' => 'Phone number is required to proceed with next step'
            );
            
        }
        
    }
    
    if( $_GET['step'] == 'four' ){

        if( $_POST['username'] != '' && $_POST['password'] != '' ){
            
            $username = $_POST['username'];
            $password = $_POST['password'];
            $repassword = $_POST['repassword'];
            $nda_agreement = $_POST['nda_agreement'];
            
            if( checkusername($username) == true ){
                
                if( $password == $repassword ){
                    
                    if( isset($nda_agreement) && $nda_agreement == 'true' ){
                    
                        $verify_result = array(
                            'rstatus' => 'success',
                            'title' => 'Success',
                            'text' => 'The user is available'
                        );
                    
                    }else{
                        
                        $verify_result = array(
                            'rstatus' => 'error',
                            'title' => 'Agree To Our Terms',
                            'text' => 'Please check the tick box if you agree with our terms of use.'
                        ); 
                        
                    }
                
                }else{
                    
                    $verify_result = array(
                        'rstatus' => 'error',
                        'title' => 'Password Mismatch',
                        'text' => 'The two passwords do not match.'
                    );
                    
                }
                
            }else{
                
                $verify_result = array(
                    'rstatus' => 'error',
                    'title' => 'Username Exist',
                    'text' => 'The username you choose already exists, please choose a different one.'
                );
                
            }
               
        }
        
    }
    
}else{
    
    $verify_result = array(
        'rstatus' => 'error',
        'title' => 'Missing Parameter',
        'text' => 'Something went wrong, the parameter for step is missing.'
    );
    
}

echo json_encode($verify_result);

?>