$(document).ready(function () {

    // GENERATE UNIQUE ID
    $('.init-unique-id').click(function () {

        var group_id = $(this).data('group-id');

        // Ajax call
        $.ajax({
            url: 'process/create_existing_uid.php',
            type: 'POST',
            data: {
                group_id: group_id
            },
            beforeSend: function (data) {
                // Show loading
                $('.loading').show();
            },
            success: function (data) {

                Swal.fire({
                    title: 'Completed!',
                    text: "Unique ID generated successfully! \n Unique ID Generated: " + data.uid_generated,
                    icon: 'success',
                    showCancelButton: false,
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Continue',
                    allowOutsideClick: false
                }).then((result) => {
                    if (result.isConfirmed) {

                        // Redirect to homepage
                        window.location.href = 'index.php';

                    }
                });

            }
        });

    });

    // GENERATE MRN NUMBER
    $('.init-mrn-id').click(function () {

        var group_id = $(this).data('group-id');

        // Ajax call
        $.ajax({
            url: 'process/generate_mrn.php',
            type: 'POST',
            data: {
                group_id: group_id
            },
            beforeSend: function (data) {
                // Show loading
                $('.loading').show();
            },
            success: function (data) {

                if (data.result == true) {

                    Swal.fire({
                        title: 'Completed!',
                        text: "Unique ID generated successfully! \n Unique ID Generated: " + data.mrn_generated,
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Continue',
                        allowOutsideClick: false
                    }).then((result) => {
                        if (result.isConfirmed) {

                            // Redirect to homepage
                            window.location.href = 'index.php';

                        }
                    });

                } else {

                    Swal.fire({
                        title: 'Failed!',
                        text: data.desc,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Try Again',
                        allowOutsideClick: false
                    }).then((result) => {
                        if (result.isConfirmed) {

                            // Redirect to homepage
                            window.location.href = 'generate_mrn.php';

                        }
                    });

                }

            }
        });

    });

    $('.avatar-container .upload-icon-container').click(function () {
        $('.avatar-upload-container form .uploadfield').click();
    });

    // File upload for provider(Nurse|Physician)
    $('#uploadForm').on('submit', function (e) {

        e.preventDefault();

        var userID = $('#userid').val(); // Assuming #userid is an input field
        var first_name = $('.first_name').val();
        var last_name = $('.last_name').val();

        // Create a new FormData object
        var formData = new FormData();

        // Append the file to the formData object
        formData.append('file', $('#fileToUpload')[0].files[0]);

        // Append the userID to the formData object
        formData.append('userID', userID);
        formData.append('first_name', first_name);
        formData.append('last_name', last_name);

        $.ajax({
            type: 'POST',
            url: 'process/upload-profile.php',
            data: formData,
            dataType: 'json',
            contentType: false,
            processData: false,
            success: function (response) {

                if (response.success) {

                    $('.avatar').attr('src', response.file_path + response.filename);

                } else {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: response.message,
                    })

                }

                $('#message').text(response.message);

            },

            error: function () {
                $('#status').text('Upload failed');
                $('#filename').text('');
                $('#message').text('An error occurred during the upload.');
            }

        });

    });

});