<?php

// Set output to JSON
header('Content-Type: application/json');

// Include functions file
include('../../process/functions.php');

// Show errors
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to check if username exists
function username_exists( $username ){

    // Database connection
    $conn = ddxrxDBConnect();

    // Get username from POST
    $username = $_POST['username'];

    // SQL Query
    $sql = "SELECT * FROM `all_users` WHERE `username` = '$username'";

    // Check if username exists
    $query = mysqli_query($conn, $sql);

    // If username exists
    if(mysqli_num_rows($query) > 0) {
        return true;
    } else {
        return false;
    }

}

// Function to check if email exists
function email_exists( $email ){

    // Database connection
    $conn = ddxrxDBConnect();

    // Escape the email to prevent SQL injection
    $email = mysqli_real_escape_string($conn, $email);

    // SQL Query
    $sql = "SELECT * FROM `nurse` WHERE `nurse_email` = '$email'";

    // Check if email exists
    $query = mysqli_query($conn, $sql);

    // Close connection
    mysqli_close($conn);

    // If email exists
    if(mysqli_num_rows($query) > 0) {
        return true;
    } else {
        return false;
    }

}

if( $_SERVER['REQUEST_METHOD'] == "POST" || isset($_POST) ) {

    // Database connection
    $conn = ddxrxDBConnect();

    $version = get_version();
    $username = $_POST['username'];
    $password = $_POST['password'];
    $password = mysqli_real_escape_string($conn, $password);
    $password = password_hash($password, PASSWORD_BCRYPT);

    $user_type = '4'; // 4 = Nurse | 2 = Doctor
    $location_id = '1';
    $is_active = '1';
    $created_at = date('Y-m-d H:i:s');
    $forget_key = 'none';
    $exp_date = date('Y-m-d H:i:s', strtotime('+1 day'));
    $oauth_provider = 'none';
    $oauth_uid = 'none';

    $nurse_fname = $_POST['nurse_fname'];
    $nurse_lname = $_POST['nurse_lname'];
    $nurse_email = $_POST['nurse_email'];
    $nurse_dob = $_POST['nurse_dob'];
    $nurse_degree = $_POST['nurse_degree'];
    $mobile_phone = $_POST['mobile_phone'];
    $nurse_active = '1';

    // Only allow username if it doesn't exist AND email doesn't exist
    if( username_exists( $username ) == false && email_exists( $nurse_email ) == false ){

        // Generate unique id for provider
        $unique_id = provider_unique();

        // Insert into all_users table
        $sql_all_users = "INSERT INTO `all_users` (`groupid`, `username`, `password_new`, `user_type`, `location_id`, `is_active`, `created_at`, `forgot_key`, `forgot_exp_date`, `oauth_provider`, `oauth_uid`, `unique_id`) VALUES ('$version', '$username', '$password', '$user_type', '$location_id', '$is_active', '$created_at', '$forget_key', '$exp_date', '$oauth_provider', '$oauth_uid', '$unique_id')";

        // Insert into all_users table
        $insert_users = mysqli_query($conn, $sql_all_users);

        // Get last inserted id
        $last_id = mysqli_insert_id($conn);

        // Check if insert was successful
        if( $insert_users ){

            // Insert into nurse table
            $sql_nurse = "INSERT INTO `nurse` (`user_id`, `groupid`, `nurse_fname`, `nurse_lname`, `nurse_email`, `nurse_dob`, `nurse_degree`, `mobile_phone`, `nurse_active`) VALUES ('$last_id', '$version', '$nurse_fname', '$nurse_lname', '$nurse_email', '$nurse_dob', '$nurse_degree', '$mobile_phone', '$nurse_active')";

            // Insert into nurse table
            $insert_nurse = mysqli_query($conn, $sql_nurse);

            // Check if insert was successful
            if( $insert_nurse ){

                // Return success
                $output = array(
                    'result' => true,
                    'icon' => 'success',
                    'title' => 'Success!',
                    'message' => 'Nurse added successfully'
                );

            } else {

                // Return error
                $output = array(
                    'result' => false,
                    'icon' => 'error',
                    'title' => 'Error!',
                    'message' => 'Nurse not added, something went wrong'
                );

            }

        } else {

            // Return error
            $output = array(
                'result' => false,
                'icon' => 'error',
                'title' => 'Error!',
                'message' => 'User not added, something went wrong'
            );

        }

    } else {

        // Check what the issue is - username or email
        if( username_exists( $username ) == true ) {
            // Return error for username
            $output = array(
                'result' => false,
                'icon' => 'error',
                'title' => 'Username Exists',
                'message' => 'Username already exists'
            );
        } else if( email_exists( $nurse_email ) == true ) {
            // Return error for email
            $output = array(
                'result' => false,
                'icon' => 'error',
                'title' => 'Email Exists',
                'message' => 'Email address already exists'
            );
        } else {
            // Generic error
            $output = array(
                'result' => false,
                'icon' => 'error',
                'title' => 'Validation Error',
                'message' => 'Please check your input data'
            );
        }

    }

}else{

    // Return error
    $output = array(
        'result' => false,
        'icon' => 'error',
        'title' => 'Missing Parameters',
        'message' => 'There are missing parameters in your request'
    );


}

echo json_encode($output);

?>