<?php

// Set output to JSON
header('Content-Type: application/json');

// Include functions file
include('../../process/functions.php');

// Show errors for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to check if email exists in nurse table
function email_exists($email) {
    // Database connection
    $conn = ddxrxDBConnect();
    
    if (!$conn) {
        return array('error' => 'Database connection failed: ' . mysqli_connect_error());
    }
    
    // Escape the email to prevent SQL injection
    $email = mysqli_real_escape_string($conn, $email);
    
    // SQL Query - Check only in nurse table since this is for nurse registration
    $sql = "SELECT `nurse_email` FROM `nurse` WHERE `nurse_email` = '$email' LIMIT 1";
    
    $query = mysqli_query($conn, $sql);
    
    if (!$query) {
        $error = mysqli_error($conn);
        mysqli_close($conn);
        return array('error' => 'SQL Error: ' . $error, 'sql' => $sql);
    }
    
    $count = mysqli_num_rows($query);
    
    // Close connection
    mysqli_close($conn);
    
    return array(
        'found' => ($count > 0),
        'count' => $count,
        'sql' => $sql
    );
}

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['email'])) {
    
    $email = trim($_POST['email']);
    
    if(!empty($email)) {
        // Validate email format
        if(filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $check_result = email_exists($email);
            
            if (isset($check_result['error'])) {
                $output = array(
                    'exists' => false,
                    'email' => $email,
                    'valid_format' => true,
                    'error' => $check_result['error'],
                    'debug' => $check_result
                );
            } else {
                $output = array(
                    'exists' => $check_result['found'],
                    'email' => $email,
                    'valid_format' => true,
                    'debug' => $check_result
                );
            }
        } else {
            $output = array(
                'exists' => false,
                'email' => $email,
                'valid_format' => false,
                'error' => 'Invalid email format'
            );
        }
    } else {
        $output = array(
            'exists' => false,
            'email' => '',
            'valid_format' => false,
            'error' => 'Empty email provided'
        );
    }
    
} else {
    $output = array(
        'exists' => false,
        'error' => 'No email provided or invalid request method',
        'valid_format' => false,
        'request_method' => $_SERVER['REQUEST_METHOD'],
        'post_data' => $_POST
    );
}

echo json_encode($output);

?>

echo json_encode($output);

?>
