<?php

// Set output to JSON
header('Content-Type: application/json');

// Include functions file
include('../../process/functions.php');

// Show errors
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to check if email exists for edit (excluding current nurse)
function email_exists_for_edit($email, $nurse_id) {
    // Database connection
    $conn = ddxrxDBConnect();
    
    if (!$conn) {
        return true; // Assume exists if can't connect (safe default)
    }
    
    // Escape the email to prevent SQL injection
    $email = mysqli_real_escape_string($conn, $email);
    $nurse_id = mysqli_real_escape_string($conn, $nurse_id);
    
    // SQL Query - Check email exists but exclude current nurse
    $sql = "SELECT `nurse_email` FROM `nurse` WHERE `nurse_email` = '$email' AND `user_id` != '$nurse_id' LIMIT 1";
    
    $query = mysqli_query($conn, $sql);
    
    if (!$query) {
        mysqli_close($conn);
        return true; // Assume exists if query fails (safe default)
    }
    
    $count = mysqli_num_rows($query);
    
    // Close connection
    mysqli_close($conn);
    
    return ($count > 0);
}

if( $_SERVER['REQUEST_METHOD'] == "POST" || isset($_POST) ) {

    $id = $_POST['nurse_id'];
    $nurse_email = $_POST['nurse_email'];

    // Check if email already exists (excluding current nurse)
    if( email_exists_for_edit( $nurse_email, $id ) == true ) {
        // Return error for email
        $output = array(
            'result' => false,
            'icon' => 'error',
            'title' => 'Email Exists',
            'message' => 'Email address already exists'
        );
        echo json_encode($output);
        exit;
    }

    // Database connection
    $conn = ddxrxDBConnect();

    $version = get_version();

    if( isset($_POST['password']) && !empty($_POST['password']) ){
        $password = $_POST['password'];
        $password = ddxrxDBConnect()->real_escape_string($password);
        $password = password_hash($password, PASSWORD_BCRYPT);
    }else{
        $password = null;
    }

    $nurse_fname = $_POST['nurse_fname'];
    $nurse_lname = $_POST['nurse_lname'];
    $nurse_email = $_POST['nurse_email'];
    $nurse_dob = $_POST['nurse_dob'];
    $nurse_degree = $_POST['nurse_degree'];
    $mobile_phone = $_POST['mobile_phone'];
    $unique_id = $_POST['unique_id'];

    // Edit query
    if( isset($password) && !empty($password) ){

        // Update nurse table
        $sql_nurse = "UPDATE `nurse` SET `nurse_fname` = '$nurse_fname', `nurse_lname` = '$nurse_lname', `nurse_email` = '$nurse_email', `nurse_dob` = '$nurse_dob', `nurse_degree` = '$nurse_degree', `mobile_phone` = '$mobile_phone' WHERE `user_id` = '$id'";
        $edit_nurse = mysqli_query($conn, $sql_nurse);
        
        // Update password and unique_id in all_users table if nurse update was successful
        if($edit_nurse) {
            $sql_users = "UPDATE `all_users` SET `password_new` = '$password', `unique_id` = '$unique_id' WHERE `all_users`.`userid` = '$id'";
            $edit_users = mysqli_query($conn, $sql_users);
            
            // Both updates must be successful
            $edit_nurse = $edit_nurse && $edit_users;
        }

    }else{

        // Update nurse table
        $sql_nurse = "UPDATE `nurse` SET `nurse_fname` = '$nurse_fname', `nurse_lname` = '$nurse_lname', `nurse_email` = '$nurse_email', `nurse_dob` = '$nurse_dob', `nurse_degree` = '$nurse_degree', `mobile_phone` = '$mobile_phone' WHERE `user_id` = '$id'";
        $edit_nurse = mysqli_query($conn, $sql_nurse);
        
        // Update unique_id in all_users table if nurse update was successful
        if($edit_nurse) {
            $sql_users = "UPDATE `all_users` SET `unique_id` = '$unique_id' WHERE `all_users`.`userid` = '$id'";
            $edit_users = mysqli_query($conn, $sql_users);
            
            // Both updates must be successful
            $edit_nurse = $edit_nurse && $edit_users;
        }

    }

    // Get the last MySQL error for debugging (before closing connection)
    $mysql_error = mysqli_error($conn);
    
    // Close database connection
    mysqli_close($conn);

    // Check if update was successful
    if( $edit_nurse ){

        // Return success
        $output = array(
            'result' => true,
            'icon' => 'success',
            'title' => 'Success!',
            'message' => 'Nurse edited successfully'
        );

    } else {

        // Return error
        $output = array(
            'result' => false,
            'icon' => 'error',
            'title' => 'Error!',
            'message' => 'Nurse not edited, something went wrong',
            'debug_error' => $mysql_error
        );

    }

}else{

    // Return error
    $output = array(
        'result' => false,
        'icon' => 'error',
        'title' => 'Missing Parameters',
        'message' => 'There are missing parameters in your request'
    );


}

echo json_encode($output);

?>