<?php

// Output JSON header
header('Content-Type: application/json');

// Include function file
include('../process/functions.php');

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

try{

    $inputJSON = file_get_contents('php://input');
    $input = json_decode($inputJSON, true);

    // If input is not empty
    if(!empty($input)) {

        // If all required parameters are present
        if( isset($input['patient_id']) && isset($input['provider_id']) && isset($input['message']) ){

            if( is_numeric($input['patient_id']) && is_numeric($input['provider_id']) && is_string($input['message']) ){
                
                $dictation_id = mt_rand(100000000, 999999999);
                $patient_id = mysqli_real_escape_string(ddxrxDBConnect(), $input['patient_id']);
                $provider_id = mysqli_real_escape_string(ddxrxDBConnect(), $input['provider_id']);
                
                    // Shadow ban: if patient_id or provider_id is 0, skip DB insert but return 200 OK
                    if ($patient_id === '0' || $provider_id === '0') {
                        $output = array(
                            'result' => true,
                            'status_code' => '200',
                            'title' => 'OK',
                            'message' => 'The request was successful.'
                        );
                        echo json_encode($output);
                        exit();
                    }

                // If note_type is present
                if( isset($input['note_type']) ){
                    $note_type = mysqli_real_escape_string(ddxrxDBConnect(), $input['note_type']);
                }else{
                    $note_type = '0';
                }

                $message = mysqli_real_escape_string(ddxrxDBConnect(), $input['message']);
                $message = addslashes($message);

                $group_id = get_version();

                $sql = "INSERT INTO `notes_dictation` (`dictation_id`, `patient_id`, `provider_id`, `note_type`, `message`, `group_id`) VALUES ('$dictation_id', '$patient_id', '$provider_id', '$note_type', '$message', '$group_id')";

                if (mysqli_query(ddxrxDBConnect(), $sql)) {

                    $output = array(
                        'result' => true,
                        'status_code' => '200',
                        'title' => 'OK',
                        'message' => 'The request was successful.'
                    );

                } else {

                    $output = array(
                        'result' => false,
                        'status_code' => '500',
                        'title' => 'Internal Server Error',
                        'message' => 'Opps! Something went wrong in our backend. Please try again later.'
                    );

                }

                // Close the database connection
                mysqli_close(ddxrxDBConnect());

            }else{

                $output = array(
                    'result' => false,
                    'status_code' => '422',
                    'title' => 'Invalid Data Type',
                    'message' => 'One or more parameters have incorrect data type.'
                );

            }
        
        }else{

            $output = array(
                'result' => false,
                'status_code' => '422',
                'title' => 'Missing Parameters',
                'message' => 'The request sent by client was incomplete or incorrect. One or more parameters are missing or have incorrect data type.'
            );
        }

    }else{

        $output = array(
            'result' => false,
            'status_code' => '400',
            'title' => 'Bad Request',
            'message' => 'The request sent by client was empty. Please send a non-empty request in JSON format.'
        );

    }

} catch (Exception $e) {

    $output = array(
        'result' => false,
        'user_exist' => false,
        'error' => 'An error occurred: ' . $e->getMessage()
    );

}

// Output Response
echo json_encode($output);

?>