<?php

// Output as JSON
header('Content-Type: application/json');

// Include functions
include('../process/functions.php');

// Get input data
$data = json_decode(file_get_contents('php://input'), true);

// Register values to variables
$userid = $data['userid'];
$parameter = $data['parameter'];
$text = $data['text'];

// Function to check if user exists in database
function check_user($userid){

    $sql = "SELECT * FROM dictation WHERE userid = '$userid'";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $row = mysqli_fetch_assoc($result);

    if( isset($row['userid']) ){
        return true;
    } else {
        return false;
    }

}

// Check if all required fields are set
if( $parameter == 'review_of_system' ){

    // Check if useid is integer
    if( !is_numeric($userid) ){

        // Set status code
        http_response_code(400);

        $output = array(
            'status_code' => '400',
            'status' => 'error',
            'message' => 'User ID must be an integer'
        );

    }else{

        // Check if user exists in database
        if( check_user($userid) == false ){

            // Set SQL Insert query
            $sql = "INSERT INTO dictation (userid, `review_of_system`) VALUES ('$userid', '$text')";
            $message = 'Added new user with dictation data for review of system: '.$text;

        }else{

            // Set SQL Update query
            $sql = "UPDATE dictation SET `review_of_system` = '$text' WHERE userid = '$userid'";
            $message = 'Updated user dictation data for review of system: '.$text;

        }

        if (ddxrxDBConnect()->query($sql) === TRUE) {
            
            // Set status code
            http_response_code(200);

            $output = array(
                'status_code' => '200',
                'status' => 'success',
                'message' => $message
            );

        } else {

            // Set status code
            $output = array(
                'status_code' => '500',
                'status' => 'error',
                'message' => 'Error: ' . $sql . '<br>' . ddxrxDBConnect()->error
            );
        }

        // Close Connection
        ddxrxDBConnect()->close();

    }

}else{
    
    // Set status code
    http_response_code(400);
    
    $output = array(
        'status_code' => '400',
        'status' => 'error',
        'message' => 'Invalid parameter please use a valid parameter'
    );

}


// Output JSON
echo json_encode($output);

?>