<?php

/**
 * ============================================
 * SAMPLE API END POINT 
 * ============================================
 *
 * VIEWING
 * {URL}/api/labs.php?method=view&type=biochemistry&limit=20
 * 
 * Description: You can view the recent data
 * Method: view - Use this to initiate the view method
 * Type: biochemistry - The type of dataset you want to look
 * Limit: 20 - Is the data limit,, default value is 10
 * user_id: This is optional parameter to display data of a specific user by user ID
 * 
 * */

// Include functions file
include('../process/functions.php');

// Set Content to json
header('Content-Type: application/json');

// Get the CRUD operation type from the URL parameter
$method = isset($_GET['method']) ? $_GET['method'] : '';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';

// Perform CRUD operations based on the type parameter
switch ($method) {


    // View Method
    case 'view':
        
        include('lab_parts/view/index.php');

    break;
    

    // Add Method
    case 'add':

        include('lab_parts/add/index.php');

    break;


    // Edit Method
    case 'edit':
        
        $output = array(
            'result' => false,
            'status_code' => '405',
            'message' => 'Method not allowed'
        );

    break;
    

    // Delete Method
    case 'delete':

        $output = array(
            'result' => false,
            'status_code' => '405',
            'message' => 'Method not allowed'
        );

    break;
    

    // Default
    default:

        $output = array(
            'result' => false,
            'status_code' => '400',
            'message' => 'Invalid request method'
        );

    break;


}

// Display the results
echo json_encode($output);