<?php

/*
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error
*/

// Set Content to json
header('Content-Type: application/json');

include('../process/functions.php');

try {
    $data = json_decode(file_get_contents('php://input'), true);

    // Check if 'patient_id' is set in the incoming data
    if (!isset($data['patient_id'])) {
        throw new Exception("Invalid input: 'patient_id' is missing.");
    }

    $patient_id = $data['patient_id'];

    $sql = "SELECT * FROM `multi_answer` WHERE user_id = '$patient_id' ORDER BY id ASC LIMIT 1";
    $result = ddxrxDBConnect()->query($sql);

    if ($result === false) {
        throw new Exception("Database query failed: " . ddxrxDBConnect()->error);
    }

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $resultJson = array(
                'result' => true,
                'id' => $row['id'],
                'user_id' => $row['user_id'],
                'type' => $row['type'],
                'question_id' => $row['question_id'],
                'text' => $row['question'] . ', please answer yes or no!'
            );

            $row_id = $row['id'];
        }

        // Delete Record
        $sqldelete = "DELETE FROM `multi_answer` WHERE id = '$row_id'";
        $deleteResult = ddxrxDBConnect()->query($sqldelete);

        if ($deleteResult === false) {
            throw new Exception("Failed to delete record: " . ddxrxDBConnect()->error);
        }
    } else {
        $resultJson = array(
            'result' => false,
            'error_message' => "No entries found for user with an ID of: " . $patient_id
        );
    }
} catch (Exception $e) {
    $resultJson = array(
        'result' => false,
        'error' => 'An error occurred: ' . $e->getMessage()
    );
}

ddxrxDBConnect()->close();

echo json_encode($resultJson);

?>