<?php

    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();
    
    function get_user_info( $patient_id, $field = null ){
    
        $query = "SELECT * FROM patients WHERE patient_id = '$patient_id' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Patient Vital History</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/jquery-ui.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery-ui-drag-and-drop.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.0/dist/js.cookie.min.js"></script>
    
    <!-- Ion Icons -->
    <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
    <!-- Ion Icons -->

	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 100,
                "order": [[ 0, "desc" ]],
                "language": {
                    "emptyTable": "No data for this date"
                }
            });
            
        });
	</script>
	
</head>
<?php

if( isset($_GET['cctype']) || $_GET['cctype'] != '' ){
    $cctype = $_GET['cctype'];
}else{
    $cctype = 'none';
}
?>
<body data-patient-id="<?php if( isset($_GET['patient_id']) ){ echo $_GET['patient_id']; } ?>" data-user-type="<?php echo $_SESSION['user_type']; ?>" <?php if( $_SESSION['user_type'] == 'nurse' ){ echo 'data-nurse-id="'.$_SESSION['userid'].'"'; } ?> <?php if( $_SESSION['user_type'] == 'doctor' ){ echo 'data-physician-id="'.$_SESSION['userid'].'"'; } ?> data-cctype="<?php echo $cctype; ?>">
    
    <!-- Manual Timer Popup -->
    <div class="manual-timer-popup">
        <div class="manual-timer-form">
            <div class="inner">
                
                <a href="javascript:;" class="close">Close</a>
                
                <h4>Add manual timer</h4>
                
                <label>
                    <span>How much time?</span>
                    <div class="timerEntry">
                        <input type="number" class="textbox timerEntry min" max="10" placeholder="MM"><div class="dot">:</div>
                        <div class="clear"></div>
                    </div>
                    <div class="timerEntry"><input type="number" max="60" class="textbox timerEntry sec" placeholder="SS"></div>
                    <div class="clear"></div>
                </label>
                
                <a href="javascript:;" class="btn">Submit</a>
                
                <div class="clear"></div>
            </div>
        </div>
    </div>
    <!-- Manual Timer Popup -->
    
    <!-- Billing Code Popup -->
    <div class="billing-code-popup">
        <div class="billing-form">
            <div class="inner">
                
                <a href="javascript:;" class="close">Close</a>
                
                <h4>Select RPM CPT Code</h4>
                
                <?php
                /*
                $sql = "SELECT * FROM billing_code WHERE";
                $result = ddxrxDBConnect()->query($sql);
                
                // Associative array
                $row = $result -> fetch_assoc();
                */
                ?>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_1" name="cpt_1" value="99453" <?php //if( $row['cpt_code'] == '99453' ){ echo 'checked disabled'; } ?>>
                    <span>99453</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_2" name="cpt_2" value="99454" checked <?php //if( $row['cpt_code'] == '99454' ){ echo 'disabled'; } ?>>
                    <span>99454</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_3" name="cpt_3" value="99457" checked <?php //if( $row['cpt_code'] == '99457' ){ echo 'disabled'; } ?>>
                    <span>99457</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_4" name="cpt_4" value="99458" <?php //if( $row['cpt_code'] == '99458' ){ echo 'checked disabled'; } ?>>
                    <span>99458</span>
                    <div class="clear"></div>
                </label>
                
                <h4>Select CCM CPT Code</h4>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_1" name="cpt_1" value="99490" <?php //if( $row['cpt_code'] == '99490' ){ echo 'checked disabled'; } ?>>
                    <span>99490</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_2" name="cpt_2" value="99491" <?php //if( $row['cpt_code'] == '99491' ){ echo 'checked disabled'; } ?>>
                    <span>99491</span>
                    <div class="clear"></div>
                </label>
                
                <label>
                    <input type="checkbox" class="checkbox" id="cpt_3" name="cpt_3" value="99487" <?php //if( $row['cpt_code'] == '99487' ){ echo 'checked disabled'; } ?>>
                    <span>99487</span>
                    <div class="clear"></div>
                </label>
                
                <a href="javascript:;" class="button submit">Submit</a>
                
                <?php
                /*
                $result -> free_result();
                
                ddxrxDBConnect() -> close();
                */
                ?>
                
            </div>
        </div>
    </div>
    <!-- Billing Code Popup -->
    
    <!-- Popup: Vitals -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature (°F)</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight (lb)</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup: Vitals -->
    
    <!-- Sticky -->
    <div class="popup-sticky-container" style="display: none">
        
        <!-- Item -->
        <div class="item">
            Test
        </div>
        <!-- Item -->
        
    </div>
    <!-- Sticky -->
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            <div class="col-md-12">
                
                <!-- Patient Info -->
                <div class="patient-info">
                    <ul>
                        <li>Patient Name:<span><?php echo get_user_info($_GET['patient_id'], 'patient_fname').' '.get_user_info($_GET['patient_id'], 'patient_lname'); ?></span></li>
                        <li>Gender:<span><?php echo get_user_info($_GET['patient_id'], 'patient_gender'); ?></span></li>
                        <li>Age:<span><?php echo get_user_info($_GET['patient_id'], 'patient_dob'); ?></span></li>
                        <li>Phone Number:<span><a href="tel:<?php echo get_user_info($_GET['patient_id'], 'cell'); ?>"><?php echo get_user_info($_GET['patient_id'], 'cell'); ?></a></span></li>
                    </ul>
                    
                    <a href="vitals_dashboard.php" class="button">Go Back</a>

                </div>
                <!-- Patient Info -->
                
                <!-- Timer -->
                <div class="timer-container">
                    <script>
                        function secondsTimeSpanToHMS(s) {
                            var h = Math.floor(s/3600); //Get whole hours
                            s -= h*3600;
                            var m = Math.floor(s/60); //Get remaining minutes
                            s -= m*60;
                            return h+":"+(m < 10 ? '0'+m : m)+":"+(s < 10 ? '0'+s : s); //zero padding on minutes and seconds
                        }
                        
                        
                        localStorage.setItem("storedTime", "0");
                        
                        var c = 0;
                        
                        function standardTime( resetTime ) {
                            
                        	var counter = setInterval(function() {
                        	    
                            	var currentTime = 0;
                            	var time = ++c;
                            	  	
                            	currentTime = Number(currentTime)+1;
                            	  	
                            	// Store Values in local storage
                                localStorage.setItem("storedTime", currentTime);
                            	  	
                            	// Increment Number In DOM
                            	$('#time-counter span').html( secondsTimeSpanToHMS(time) );
                                
                                var totaltime = localStorage.getItem("storedTime");
                            
                                $.ajax({
                                    type: 'POST',
                                    url: 'process/synctime.php',
                                        
                                    data: {
                                        cctype: "<?php echo $_GET['cctype']; ?>",
                                        provider_id: "<?php echo $_SESSION['userid']; ?>",
                                        provider_type: "<?php echo $_SESSION['user_type']; ?>",
                                    	patient_id: "<?php echo $_GET['patient_id']; ?>",
                                    	totaltime: totaltime
                                    },
                                    success: function(response) {
                                        
                                    },
                                });
                                
                          	}, 1000);
                            
                        	return counter;
                        }
                        
                        standardTime();
                        
                        
                        $('body').on('click', '#stopTime', function() {
                            
                            var totaltime = localStorage.getItem("storedTime");
                            
                            $.ajax({
                                type: 'POST',
                                url: 'process/synctime.php',
                                    
                                data: {
                                    cctype: "<?php echo $_GET['cctype']; ?>",
                                    provider_id: "<?php echo $_SESSION['userid']; ?>",
                                    provider_type: "<?php echo $_SESSION['user_type']; ?>",
                                	patient_id: "<?php echo $_GET['patient_id']; ?>",
                                	totaltime: totaltime
                                },
                                success: function(response) {
                                    
                                    if( response.rstatus == 'success' ){
                                        localStorage.setItem("storedTime", "0");
                                        $('#stopTime').hide();
                                        $('#startTime').show();
                                    }
                                    
                                },
                            });
                            
                        });
                        
                        $('body').on('click', '#startTime', function() {
                            $('#startTime').hide();
                            $('#stopTime').show();
                        });
                        
                    </script>
                    
                    <div class="timer">
                        
                        <div class="timerStats">
                            <div class="item" id="time-counter"><strong>Elapsed Time:</strong> <span>0:00:00</span></div>
                            <a href="javascript:;" class="manualTimerBtn">Add Manual Time</a>
                        </div>

                        <div class="total-time">
                            <!-- <div class="item" id="totalTimeData"><?php echo file_get_contents('https://'.$_SERVER['SERVER_NAME'].'/process/time_report.php?type=current_month&patient_id='.$_GET['patient_id'].'&cctype='.$_GET['cctype'] ); ?></div> -->
                            <div class="item" id="totalTimeData"><?php echo file_get_contents('http://'.$_SERVER['SERVER_NAME'].'/ddxrx-main/process/time_report.php?type=current_month&patient_id='.$_GET['patient_id'].'&cctype='.$_GET['cctype'] ); ?></div>
                            
                            <select class="selectbox month">
                                <option value="0">Month</option>
                                <?php
                                    for( $i = 1; $i <= 12; $i++ ){
                                        $dt = DateTime::createFromFormat('!m', $i);
                                        echo '<option value="'.$i.'">'.$dt->format('F').'</option>';
                                    }
                                ?>
                            </select>

                            <select class="selectbox year">
                                <option value="0">Year</option>
                                <?php
                                    $currentYear = date('Y');

                                    for ($year = $currentYear; $year >= $currentYear - 5; $year--) {
                                        echo '<option value="'.$year.'">' . $year . '</option>';
                                    }
                                ?>
                            </select>

                            <input type="hidden" class="hiddenfield" data-month="" data-year="">
                        </div>
                        
                    </div>
                    
                    <div class="clear"></div>
                </div>
                <!-- Timer -->
                
                <!-- Vitals Navigation Menu -->
                <div class="menu-container">
                    <ul>
                        <li><a href="javascript:;" class="popup_vitals">Add Vitals</a></li>
                        <li><a href="javascript:;" class="popup_new_notes">New Note</a></li>
                        
                        <?php if( $cctype == 'rpm' ){ ?>
                            <li><a href="notes-rpm.php?id=<?php echo $_GET['patient_id']; ?>">Prior Notes</a></li>
                        <?php }elseif( $cctype == 'ccm' ){ ?>
                            <li><a href="notes_ccm.php?id=<?php echo $_GET['patient_id']; ?>">Prior Notes</a></li>
                        <?php } ?>
                        
                        <!-- <li><a href="javascript:;" class="popup_billing_codes">Submit Billing Codes</a></li> -->
                        <li><a href="medical_history.php?id=<?php echo $_GET['patient_id']; ?>&uid=<?php echo get_user_info($_GET['patient_id'], 'user_id'); ?>&patient_id=<?php echo $_GET['patient_id']; ?>">Medical History</a></li>
                        <li class="right"><a href="dashboard.php">Main Dashboard</a></li>
                        <li class="right"><a href="vitals_dashboard.php">Chronic Care Dashboard</a></li>
                    </ul>
                    <div class="clear"></div>
                </div>
                <!-- Vitals Navigation Menu -->
                
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="col-md-12">

            <div class="countbox-container">
                <div class="row">
                    
                    <!-- BP Count -->
                    <div class="col-md-3">
                        <div class="countbox">
                            <div class="icon color-1">
                                <span><ion-icon name="pulse-outline"></ion-icon></span>
                            </div>
                            <div class="desc">
                                <div class="label">Total BP Count</div>
                                <h4 class="bp-text"><?php echo get_bp_count($_GET['patient_id']); ?> Times</h4>
                                <p class="print-btn bp"><a href="rpm-pdf.php" data-patient-id="<?php echo $_GET['patient_id']; ?>" data-month="<?php echo date('m'); ?>" data-year="<?php echo date('Y'); ?>">Print</a> Selected month's BP Count</p>
                            </div>
                        </div>
                    </div>
                    <!-- BP Count -->

                    <!-- Timer Count -->
                    <div class="col-md-3">
                        <div class="countbox">
                            <div class="icon color-2">
                                <span><ion-icon name="alarm"></ion-icon></span>
                            </div>
                            <div class="desc">
                                <div class="label">Session Time</div>
                                <?php
                                    $year = strval(date('Y'));
                                    $month = strval(date('n'));
                                    $format = 'dashboard-raw';
                                ?>
                                <h4 class="session-text"><?php echo session_time($_GET['patient_id'], $month, $year, $format); ?></h4>
                                <p class="print-btn session"><a href="timer-pdf.php" data-patient-id="<?php echo $_GET['patient_id']; ?>" data-month="<?php echo date('m'); ?>" data-year="<?php echo date('Y'); ?>">Print</a> Selected month's time</p>
                            </div>
                        </div>
                    </div>
                    <!-- Timer Count -->

                    <!-- User Active -->
                    <div class="col-md-3">
                        <div class="countbox">
                            <div class="icon color-3">
                                <span><ion-icon name="accessibility"></ion-icon></span>
                            </div>
                            <div class="desc">
                                <div class="label">RPM Enrollment</div>
                                <h4><?php echo get_user_rpm_status($_GET['patient_id']); ?></h4>
                                <p class="print-btn">Determine if the user is active</p>
                            </div>
                        </div>
                    </div>
                    <!-- User Active -->

                    <!-- User Active -->
                    <div class="col-md-3">
                        <div class="countbox">
                            <div class="icon color-4">
                                <span><ion-icon name="calendar"></ion-icon></span>
                            </div>
                            <div class="desc">
                                <div class="label">Webpage last visited</div>
                                <h4><?php echo get_last_use($_GET['patient_id']); ?></h4>
                                <p class="print-btn">User last submitted RPM data</p>
                            </div>
                        </div>
                    </div>
                    <!-- User Active -->

                </div>
            </div>

            <div class="TableContainer">
                <div class="syncContainer"></div>
                <table id="myTable" class="single_user_data">
                	<thead>
                        <tr>
                            <td>Date</td>
                            <td>Systolic</td>
                            <td>Diastolic</td>
                            <td>Heartrate</td>
                            <td>Rhythm</td>
                            <td>Pulse OX</td>
                            <td>Temp</td>
                            <td>Glucose</td>
                            <td>Weight</td>
                            <td>Data Type</td>
                        </tr>
                    </thead>
        
                    <tbody>
                        
                        <?php
                            
                            $patient_id = $_GET['patient_id'];
                            $sql = "SELECT * FROM `vitals_history` WHERE `patient_id` = '$patient_id' ORDER by `date_added` DESC";
                            $result = ddxrxDBConnect()->query($sql);

                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    // Check respiratory for each row
                                    if ($row["respiratory"] == 0) {
                                        $respiratory = 'Regular';
                                    } else {
                                        $respiratory = "Irregular";
                                    }

                                    echo '<tr>';
                                    echo '<td>' . explode(" ", $row["date_added"])[0] . '</td>';
                                    echo '<td>' . $row["systolic"] . '</td>';
                                    echo '<td>' . $row["diastolic"] . '</td>';
                                    echo '<td>' . $row["heartrate"] . '</td>';
                                    echo '<td>' . $respiratory . '</td>';
                                    echo '<td>' . $row["pulseox"] . '</td>';
                                    echo '<td>' . $row["temp"] . '</td>';
                                    echo '<td>' . $row["glucose"] . '</td>';
                                    echo '<td>' . $row["weight"] . '</td>';
                                    echo '<td>' . $row["dataSource"] . '</td>';
                                    echo '</tr>';
                                }
                            } else {
                                // Do something here
                            }

                            ddxrxDBConnect()->close();

                        ?>
                        
                    </tbody>
                </table>
                <button class="export-excel-btn">Export Data</button>
            </div>
        </div>
    </div>
    
    <?php
        if( $_SESSION['user_type'] == 'nurse' ){
            provider_bottom_nav();
        }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
            physician_bottom_nav();
        }
    ?>
    
</body>
</html>