jQuery(document).ready(function($){
    
    // Get Body Height
    var body_height = $(document).height()-60;
    var chatControls = $('.button-controls').innerHeight();
    var userMeta = $('.messenger-container .user-meta').innerHeight();
    var messengerControlsContainer = $('.messenger-controls-container').innerHeight();
    var innerWidth = $('.messenger-container .inner').width();
    var innerHeight = $('.messenger-container .inner').innerHeight();
    var innerList = body_height-chatControls;
    var messageListContainer = body_height-userMeta-messengerControlsContainer-40;
    
    
    // Assign height to chat elements
    $('.chat-sidebar').css('height', body_height);
    $('.messenger-container').css('height', body_height);
    $('.innerList').css('height', innerList);
    $('#user-meta').css('height', userMeta);
    $('#messageControlSpacing').css('height',messengerControlsContainer);
    $('.messageListContainer').css('height', messageListContainer);
    
    $('.messenger-container .inner').css({'width': innerWidth, 'height': innerHeight});
    $('.messenger-container .user-meta').css('width', innerWidth);
    $('.messenger-container .messenger-controls-container').css('width', innerWidth);
    
    
    
    
    
    
    // Contacts and Messenger Button
    $('.button').click(function(){
         $('.button').removeClass('green');
         $('.button').addClass('gray');
         $(this).removeClass('gray');
         $(this).addClass('green');
    });
    
    
    
    
    
    // Recent Messages
    function recent_messages(){
        
        var provider_id = $('body').data('provider-id');
        
        $.ajax({
    			type: 'POST',
    			url: 'process/chat/recent_messages.php?type=nurse',
    			data: {
    				provider_id:provider_id
			    },
    			beforeSend: function() {
    			    
    			    //$('.chat-sidebar .messageList').fadeOut();
        			//$('.chat-sidebar .messageList').html('');
        			//$('.chat-sidebar .messageList').html('<div class="loading-bar absolute"></div>');
    			    
    			},
    			success: function(response) {
    			    
    			    $('.loading-bar').fadeOut();
    			    $('.chat-sidebar .messageList').html('');
    			    
    			    let result = response;
    			    for (let user of result) {
    			        
    			        if( user.read_status_nurse == 'unread' ){ var readStatus = 'unread' }else{ var readStatus = 'read' }
    			        
        			    $('.chat-sidebar .messageList').append('<li class="contact-item '+user.read_status_nurse+'" data-participant-id="'+user.participant_id+'" data-userid="'+user.user_chat_id+'" data-patient_fname="'+user.user_profile.first_name+'" data-patient_lname="'+user.user_profile.last_name+'"><i class="flaticon-user"></i><div class="desc"><strong>'+user.user_profile.full_name+'</strong><p>'+user.user_profile.email_address+'</p></div></li>');
    			    }
    			    
    			    $('.chat-sidebar .messageList').fadeIn();
    			    
    			},
    			
    			fail: function(response){
    				//alert('Update Failed!');
    			}
    
    	});
        
    }
    
    // Load Recent Messages
    recent_messages();
    
    
    
    
    
    
    // Load Recent Messages when clicked on the icon
    $('.sidebar-list .button.messages').click(function(){
        
        var provider_id = $('body').data('provider-id');
        
        $.ajax({
    			type: 'POST',
    			url: 'process/chat/recent_messages.php?type=nurse',
    			data: {
    				provider_id:provider_id
			    },
    			beforeSend: function() {
    			    
    			    $('.chat-sidebar .messageList').fadeOut();
        			$('.chat-sidebar .messageList').html('');
        			$('.chat-sidebar .messageList').html('<div class="loading-bar absolute"></div>');
    			    
    			},
    			success: function(response) {
    			    
    			    $('.loading-bar').fadeOut();
    			    $('.chat-sidebar .messageList').html('');
    			    
    			    let result = response;
    			    for (let user of result) {
        			    $('.chat-sidebar .messageList').append('<li class="contact-item" data-userid="'+user.user_chat_id+'" data-patient_fname="'+user.user_profile.first_name+'" data-patient_lname="'+user.user_profile.last_name+'"><i class="flaticon-user"></i><div class="desc"><strong>'+user.user_profile.full_name+'</strong><p>'+user.user_profile.email_address+'</p></div></li>');
    			    }
    			    
    			    $('.chat-sidebar .messageList').fadeIn();
    			    
    			},
    			
    			fail: function(response){
    				//alert('Update Failed!');
    			}
    
    	});

    });
    
    
    
    
    
    // Load Contacts
    //$('.sidebar-list .button.contacts').tap(function(){
    $('body').on('click', '.sidebar-list .button.contacts', function() {
        
        // Start Ajax Entries Data Update
        $.ajax({
    		url: 'process/chat/get_contacts.php',
    		beforeSend: function() {
    		    
    		    $('.chat-sidebar .messageList').fadeOut();
    			$('.chat-sidebar .messageList').html('');
    			$('.chat-sidebar .messageList').html('<div class="loading-bar absolute"></div>');
    			
    		},
    		success: function(response) {
    		    
    		    $('.loading-bar').fadeOut();
    		    
    		    let result = response;
			    for (let contacts of result) {
    			    $('.chat-sidebar .messageList').append('<li class="contact-item" data-userid="'+contacts.userid+'" data-patient_fname="'+contacts.patient_fname+'" data-patient_lname="'+contacts.patient_lname+'"><i class="flaticon-user"></i><div class="desc"><strong>'+contacts.patient_lname+', '+contacts.patient_fname+'</strong><p>'+contacts.email_address+'</p></div></li>');
    			    $('.messageListContainer').animate({ scrollTop: $('.messageListContainer')[0].scrollHeight}, 30);
    			  
			    }
			    
			    $('.chat-sidebar .messageList').fadeIn();
    			
    		},	
    		fail: function(response){
    			// Do Something
    			//alert('false');
    		}
    
    	});
    	// Start Ajax Entries Data Update
         
    });
    
    
    // Load Contacts: Nurses
    //$('.sidebar-list .button.contacts-nurse').tap(function(){
    $('body').on('click', '.sidebar-list .button.contacts-nurse', function() {
        
        // Start Ajax Entries Data Update
        $.ajax({
    		url: 'process/chat/get_contacts.php?type=nurse',
    		beforeSend: function() {
    		    
    		    $('.chat-sidebar .messageList').fadeOut();
    			$('.chat-sidebar .messageList').html('');
    			$('.chat-sidebar .messageList').html(' ');
    			$('.chat-sidebar .messageList').html('<div class="loading-bar absolute"></div>');
    			
    		},
    		success: function(response) {
    		    
    		    $('.loading-bar').fadeOut();
    		    
    		    $('.chat-sidebar .messageList').removeClass('physician-contact');
    		    $('.chat-sidebar .messageList').removeClass('patient-contact');
    		    $('.chat-sidebar .messageList').addClass('nurse-contact');
    		    
    		    let result = response;
			    for (let contacts of result) {
			        
			        user_email = contacts.email_address;
			        
    			    $('.chat-sidebar .messageList').append('<li class="contact-item" data-userid="'+contacts.userid+'" data-nurse_fname="'+contacts.nurse_fname+'" data-nurse_lname="'+contacts.nurse_lname+'"><i class="flaticon-user"></i><div class="desc"><strong>'+contacts.nurse_lname+', '+contacts.nurse_fname+'</strong><p>'+contacts.email_address+'</p></div></li>');
    			    $('.messageListContainer').animate({ scrollTop: $('.messageListContainer')[0].scrollHeight}, 30);
    			  
			    }
			    
			    $('.loading-bar').fadeOut();
			    $('.chat-sidebar .messageList').fadeIn();
    			
    		},	
    		fail: function(response){
    			// Do Something
    			//alert('false');
    		}
    
    	});
    	// Start Ajax Entries Data Update
         
    });
    
    
    // Load Contacts: Doctor
    //$('.sidebar-list .button.contacts-physician').tap(function(){
    $('body').on('click', '.sidebar-list .button.contacts-physician', function() {
        
        // Start Ajax Entries Data Update
        $.ajax({
    		url: 'process/chat/get_contacts.php?type=doctor',
    		beforeSend: function() {
    		    
    		    $('.chat-sidebar .messageList').fadeOut();
    			$('.chat-sidebar .messageList').html('');
    			$('.chat-sidebar .messageList').html(' ');
    			$('.chat-sidebar .messageList').html('<div class="loading-bar absolute"></div>');
    			
    		},
    		success: function(response) {
    		    
    		    $('.chat-sidebar .messageList').removeClass('patient-contact');
    		    $('.chat-sidebar .messageList').removeClass('nurse-contact');
    		    $('.chat-sidebar .messageList').addClass('physician-contact');
    		    
    		    let result = response;
			    for (let contacts of result) {
			        
			        user_email = contacts.email_address;
			        
    			    $('.chat-sidebar .messageList').append('<li class="contact-item" data-userid="'+contacts.userid+'" data-physician_fname="'+contacts.physician_fname+'" data-physician_lname="'+contacts.physician_lname+'"><i class="flaticon-user"></i><div class="desc"><strong>'+contacts.physician_lname+', '+contacts.physician_fname+'</strong><p>'+contacts.email_address+'</p></div></li>');
    			    $('.messageListContainer').animate({ scrollTop: $('.messageListContainer')[0].scrollHeight}, 30);
    			  
			    }
			    
			    $('.loading-bar').fadeOut();
			    $('.chat-sidebar .messageList').fadeIn();
    			
    		},	
    		fail: function(response){
    			// Do Something
    			//alert('false');
    		}
    
    	});
    	// Start Ajax Entries Data Update
         
    });
    
    
    // View Contact
    $('body').on('click', 'ul.messageList li.contact-item', function() {
        
        var participant_id = $(this).data('participant-id');
        var room_id = $('.user-meta').attr('data-room-id');
        var user_id = $(this).data('userid');
        var provider_id = $('body').data('provider-id');
        
        $('.user-meta h1').text( $(this).data('patient_fname')+' '+$(this).data('patient_lname') );
        $('.user-meta').attr("data-user-id", user_id);
        $('.user-meta .message-list').attr('id', 'message-list-'+user_id);
        
        // Remove unread function
        $(this).removeClass('unread');
        
        $.ajax({
			type: 'POST',
			url: 'process/chat/show_room.php',
            
			data: {
				user_id:user_id,
				provider_id:provider_id,
				participant_id:participant_id
			},

			beforeSend: function() {
			    // Do Something
			    $('.messenger-container .message-list').html('');
			},
			success: function(response) {
                // Do something
                
                $('.user-meta').attr('data-room-id', response[0].room_id);
                $('.user-meta').attr('data-participant-id', response[0].participant_id);
                $('.user-meta').attr('data-sender-type', response[0].sender_type);
                $('.user-meta').attr('data-total-msg', response.length);
                
                let result = response;
			    for (let messenger of result) {
    			    
    			    if( messenger.sender_type == 0 ){
    			        var message_item = '<li class="system"><div class="separator"></div><p><span>'+messenger.message+'</span></p></li>';
    			    }else{
    			        var message_item = '<li><div class="userAvatar"><i class="flaticon-user"></i></div><div class="desc"><strong>'+messenger.user_profile.full_name+'</strong><p>'+messenger.message+'</p></div><div class="time">'+messenger.message_date+'</div><div class="clear"></div></li>';
    			    }
    			    
    			    
    			    
    			    $('.messenger-container .message-list').append(message_item);
    			    $('.messageListContainer').animate({ scrollTop: $('.messageListContainer')[0].scrollHeight}, 30);
    			    
			    }
                
                
			},
			
			fail: function(response){
				//alert('Update Failed!');
			}

		});
        
    });
    
    
    
    
    
    // Update Chat
    function update_chat(){
        
        var user_id = $('.user-meta').attr('data-user-id');
        var room_id = $('.user-meta').attr('data-room-id');
        var total_msg = $('.user-meta').attr('data-total-msg');
        
        $.ajax({
    		type: 'POST',
    		url: 'process/chat/get_messages.php',
                
    		data: {
    			user_id:user_id,
    			room_id:room_id,
    		},
    
    		beforeSend: function() {
    		    // Do Something
    		},
    		success: function(response) {
    		    
    		    var last_item = response.length-1;
    		    var total_msg = parseInt($('.user-meta').attr('data-total-msg'));
    		    console.log( response[last_item].message );
    		    
    		    if( response.length > total_msg ){
        	        $('.messenger-container .message-list').append('<li><div class="userAvatar"><i class="flaticon-user"></i></div><div class="desc"><strong>'+response[last_item].user_profile.full_name+'</strong><p>'+response[last_item].message+'</p></div><div class="time">'+response[last_item].message_date+'</div><div class="clear"></div></li>');
    		        total_msg = total_msg+1;
    		        $('.user-meta').attr('data-total-msg', total_msg);
    		        $('.messageListContainer').animate({ scrollTop: $('.messageListContainer')[0].scrollHeight}, 30);
    		    }
    		    
    		},
    			
    		fail: function(response){
    			//alert('Update Failed!');
    		}
    
    	});
        
    }
    
    
    
    
    
    // Send Message
    var txtMessageBlock = $('textarea#messageBlock').val();
    
    $('.messenger-controls-container').on('click', '.send-message', function() {
        //if( txtMessageBlock != '' ){
        if ($(`#messageBlock`).val().length){
            
            var room_id = $('.user-meta').attr('data-room-id');
            var sent_by = $('body').attr('data-provider-id');
            var sent_to = $('.user-meta').attr('data-user-id');
            var sender_type = '4';
            var message = $('textarea#messageBlock').val();
            var message_type = 'text';
            
            $.ajax({
    			type: 'POST',
    			url: 'process/chat/send_message.php',
                
    			data: {
    				room_id:room_id,
    				sent_by:sent_by,
    				sent_to:sent_to,
    				sender_type:sender_type,
    				message:message,
    				message_type:message_type
    			},
    
    			beforeSend: function() {
    			    // Do something
    			},
    			success: function(response) {
    			    $('textarea#messageBlock').val('');
    			    //$('.messenger-container .message-list').append('<li><div class="userAvatar"><i class="flaticon-user"></i></div><div class="desc"><strong>Ankush Badlas</strong><p>'+message+'</p></div><div class="time">2019-12-20 04:39:20</div><div class="clear"></div></li>');
    			    if( response == 'true' ){
    			        $('textarea#messageBlock').val('');
    			        update_chat();
    			        recent_messages();
    			    }
    			},
    			
    			fail: function(response){
    				//alert('Update Failed!');
    			}
    
    		});

        }
    });
    
    
    
    
    
    $('body').on('click', '.add-physician', function() {
        
        var counter = parseInt( $(this).attr('data-count') );
        counter = counter+1;
        $(this).attr('data-count', counter);
            
        $('.search-form-container .physician-list').html('');
        $('.search-form-container').fadeIn();
        
        $.ajax({
    		type: 'POST',
    		url: 'process/chat/get_physician.php',
    		
    		
    		beforeSend: function() {
    		    // Do Something
    		},
    		
    		
    		success: function(response) {
    		    
    		    let result = response;
			    for (let physician of result) {
    			    
    			    $('.search-form-container .physician-list').append('<li>'+physician.full_name+'<span>'+physician.physician_speciality+'</span><a href="javascript:;" class="add-button add-physician-room" data-add-physician-id="'+physician.userid+'" data-physician-name="'+physician.full_name+'">Add Physician</a></li>');
    			    
			    }
    		    
    		},
    			
    		fail: function(response){
    		    // Do Something
    		}
    
    	});
        
    });

    
    // Add button
    $('body').on('click', '.add-physician-room', function() {
        
        var physician_name = $(this).attr('data-physician-name');
        var participant_id = $('.user-meta').attr('data-participant-id');
        var physician_id = $(this).attr('data-add-physician-id');
        var room_id = $('.user-meta').attr('data-room-id');
        
        $(this).removeClass('add-physician-room');
        $(this).addClass('remove-physician-room');
        $(this).addClass('disabled');
        $(this).text('Remove');
        
        $.ajax({
    		type: 'POST',
    		url: 'process/chat/add_physician.php',
    		data: {
    		    physician_id:physician_id,
    			room_id:room_id,
    			participant_id:participant_id,
    			physician_name:physician_name
    		},
    		
    		beforeSend: function() {
    		    // Do Something
    		},
    		
    		
    		success: function(response) {
    		    if(response == 'true'){
        		    $(this).addClass('disabled');
                    $(this).text('Added');
    		    }
    		},
    			
    		fail: function(response){
    		    // Do Something
    		}
    
    	});
        
    });
    
    // Close(Add User Pop-up)
    $('.search-form-container .search-form').on('click', '.close', function() {
        $('.search-form-container').fadeOut(); 
        $('.search-form-container .physician-list').html('');
    });
    
    
    
    // Check messages every 5 seconds
    window.setInterval(function(){
        update_chat();
        recent_messages();
    }, 5000);
    
});