jQuery(document).ready(function($){
    
    /* =================================================================== */
    // Hide the chatbox by default
    /* =================================================================== */
    $('.chat-widget .chat-box').hide();

    /* =================================================================== */
    // Show the chatbox
    /* =================================================================== */
    $('.chat-widget .chat-icon').click(function(e){
		$('.chat-widget .chat-box').fadeIn();
	});
	
	/* =================================================================== */
	// Close Chatbox
	/* =================================================================== */
	$('.chat-widget .close-chat').click(function(e){
		$('.chat-widget .chat-box').fadeOut();
	});
	
	/* =================================================================== */
	// Send Message
	/* =================================================================== */
	$('.send-message').click(function(e){

	    var msg = $('.chat-widget .chat-box .textarea').val();
        var user_id = $('body').data('user-id');
        var chat_room = $('body').data('user-id');
	   
	    if( msg != '' ){

            $.ajax({
                type: 'POST',
                url: '../chat/process/send_message.php',
                data: {
                    chat_room:chat_room,
                    user_id:user_id,
                    msg:msg
                },
                beforeSend: function() {
                    // Do something
                },
                success: function(response) {

                    if( response == 'true' ){

                        $('.chat-widget .chat-box .chat-list').append('<li><span>July 23,2019 01:28 PM</span><strong></strong><p>'+msg+'</p></li>');
                        $('.chat-widget .chat-box .textarea').val('');
                        $('.chat-list-container').animate({ scrollTop: $('.chat-list-container')[0].scrollHeight}, 500);

                    }else{

                        $('.chat-widget .chat-box .chat-list').append('<li class="new" style="color:#FF0033"><p>Something went wrong please try again.</p></li>');

                    }

                },
                fail: function(response){
                     // Do something
                     alert('failed');
                }
            });
	    }
	   
	});


	/* =================================================================== */
	// Create Room
	/* =================================================================== */
	function create_room( chat_room, user_id ){

		$.ajax({
            type: 'POST',
            url: '../chat/process/create_room.php',
            data: {
                chat_room:chat_room,
                user_id:user_id
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {

            	$('.chat-widget .chat-box').fadeIn();

            	console.log(response);

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

	}


	/* =================================================================== */
	// Get Conversation
	/* =================================================================== */
	function get_conversation( chat_room, user_id ){

		$.ajax({
            type: 'POST',
            url: '../chat/process/get_conversation.php',
            data: {
                chat_room:chat_room,
                user_id:user_id
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {

            	if( response == 'false' ){

            		// Append Conversation List
            		$('.chat-widget .chat-box .chat-list').html('<li class="new"><p>No recent conversation, type below to start a new one and a nurse will assist you.</p></li>');
            		console.log(response);

            	}else{

            		// Append Conversation List
            		$('.chat-widget .chat-box .chat-list').html(response);
                    //$('.chat-list-container').animate({ scrollTop: $('.chat-list-container')[0].scrollHeight}, 500);
                    
                    // Play Sound when message recieve
                    //var audioUrl = 'https://freesound.org/data/previews/172/172490_3192597-lq.mp3';
                    //var audio = new Audio(audioUrl); // define your audio
                    //audio.play();

            	}

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

	}

	/* =================================================================== */
	// Check if chat room exist
	/* =================================================================== */
	$('.chat-widget .send-message').click(function(e){

		var user_id = $('body').data('user-id');
		var chat_room = $('body').data('user-id');

		$.ajax({
            type: 'POST',
            url: '../chat/process/check_room.php',
            data: {
                user_id:user_id,
                chat_room:chat_room
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {

            	if( response == 'true' ){
            		get_conversation( chat_room, user_id );
                    $('.chat-widget .chat-box').fadeIn();
            	}else if( response == 'false' ){
            		create_room( chat_room, user_id );
            	}

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

	});


    /* =================================================================== */
    // Update Message every 5 seconds
    /* =================================================================== */
    /*
    setTimeout(function(){
        var user_id = $('body').data('user-id');
        var chat_room = $('body').data('user-id');
        get_conversation( chat_room, user_id );
        console.log('Database updated');
    }, 5000);
    */

    setInterval(function(){
        var user_id = $('body').data('user-id');
        var chat_room = $('body').data('user-id');
        get_conversation( chat_room, user_id );
        console.log('Database updated'); 
    }, 5000);
    
});