<?php

    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');
    
    function get_user_info( $patient_id, $field = null ){
    
        $query = "SELECT * FROM patients WHERE patient_id = '$patient_id' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Patient Vital Dashboard</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 20,
                "bSort": false
            });
            
        });
	</script>
	
</head>
<body>
    
    <!-- Popup -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup -->
    
    <!-- Header -->
    <div class="header">
        
        <div class="container">
            <div class="col-md-12">
                <div class="patient-info">
                    <h3 class="tabtitle">CCM Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
        <div class="menu-container">
            <div class="container">
                <div class="col-md-12">
                    <?php
                        if( $_SESSION['user_type'] == 'nurse' ){
                            include('nurse_dashboard_nav.php');
                        }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                            include('physician_dashboard_nav.php');
                        }
                    ?>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="col-md-12">
            <div class="TableContainer">
                <table id="myTable">
                	<thead>
                        <tr>
                            <td>First Name</td>
                            <td>Last Name</td>
                            <td>Gender</td>
                            <td>Age</td>
                            <td>Phone Number</td>
                            <td>CCM</td>
                            <td>User Type</td>
                            <td>Action</td>
                        </tr>
                    </thead>
        
                    <tbody>
                        
                            <?php
                            
                            $version = get_version();
                            //$sql = "SELECT pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender, iuser.ihealth_UserID FROM patients as pat LEFT JOIN ihealth_users as iuser ON pat.patient_id = iuser.patient_id ORDER BY ihealth_id DESC";
                            //$sql = "SELECT pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender, iuser.ihealth_UserID FROM patients as pat LEFT JOIN ihealth_users as iuser ON pat.patient_id = iuser.patient_id WHERE pat.groupid = '$version' ORDER BY ihealth_id DESC";
                            $sql = "SELECT pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender, pat.ccm, cuser.imei FROM patients as pat LEFT JOIN cardiowell_users as cuser ON pat.patient_id = cuser.patient_id WHERE pat.groupid = '$version' ORDER BY cardiowellid DESC";
                            $result = ddxrxDBConnect()->query($sql);
                            
                            if ($result->num_rows > 0) {
                                // output data of each row
                                while($row = $result->fetch_assoc()) {
                                    
                                    if( $row["patient_gender"] == 'm' ){
                                        $gender = 'Male';
                                    }elseif( $row["patient_gender"] == 'f' ){
                                        $gender = 'Female';
                                    }
                                    
                                    if( !empty($row["imei"]) ){
                                        $patient_type = '<span class="patientType ihealth">Cellular User</span>';
                                    }else{
                                        $patient_type = '<span class="patientType regular">Regular User</span>';
                                    }
                                    
                                    
                                    if( $row["ccm"] == 1 ){
                                        
                                        $ccm = '<div class="toggle yes" id="ccm_id_'.$row["patient_id"].'" data-patient-id="'.$row["patient_id"].'"></div>';
                                        
                                    }else{
                                        
                                        $ccm = '<div class="toggle no" id="ccm_id_'.$row["patient_id"].'" data-patient-id="'.$row["patient_id"].'"></div>';
                                        
                                    }
                                    
                                    
                                    echo '<tr class="patient_id" data-patient-id="'.$row["patient_id"].'">';
                                    
                                    echo '<td class="enabled">' . $row["patient_fname"] . '</td>';
                                    echo '<td class="enabled">' . $row["patient_lname"] . '</td>';
                                    echo '<td class="enabled">' . $gender . '</td>';
                                    echo '<td class="enabled">' . $row["patient_dob"] . '</td>';
                                    echo '<td class="enabled">' . $row["cell"] . '</td>';
                                    echo '<td class="disabled">' . $ccm . '</td>';
                                    echo '<td class="enabled">' . $patient_type . '</td>';
                                    echo '<td class="enabled"><a href="patient_vitals.php?patient_id='.$row["patient_id"].'&cctype=ccm" class="button">View Vitals</a></td>';
                                    
                                    echo '</tr></a>';
                                    
                                }

                            } else {
                                //echo "0 results";
                            }

                            ddxrxDBConnect()->close();
                            
                            ?>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <?php
        if( $_SESSION['user_type'] == 'nurse' ){
            provider_bottom_nav();
        }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
            physician_bottom_nav();
        }
    ?>
    
</body>
</html>