<?php

/*
NOTES:

Please use the URL format below, you can change the word "version" and "123567"
Where version is the name of the sub domain and 123567 is the unique ID to be given out for the demo

https://version.ddxrx.net/codeblue/123567
*/

include('../process/functions.php');

if( isset($_GET['codeid']) ){
    $codeid = $_GET['codeid'];
}else{
    $codeid = 'None';
}

if( isset($_GET['codeid']) && $_GET['codeid'] == '123567' ){

    /* Use this to identify the patient by username */

    if (!empty($_POST['username'])) {
        
        $username = $_POST['username'];
        
        $options = array(
            'get_by' => 'username',
            'identifier' => $username,
            'field' => 'patient_id',
        );
        
        $patient_id = getUserInfo($options);
        
    }


    // Get current URL
    if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'){
        $url = "https://";   
    }else{  
        $url = "http://";
    }

    // Append the host(domain name, ip) to the URL.   
    $url.= $_SERVER['HTTP_HOST'];   
        
    // Append the requested resource location to the URL   
    $url.= $_SERVER['REQUEST_URI'];

?>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    	
    	<title>Code Blue - DDXRX</title>
    	<meta name="viewport" content="width=device-width, initial-scale=1">
    
    	<link rel="stylesheet" type="text/css" href="../assets/css/reset.css">
    	<link rel="stylesheet" type="text/css" href="../assets/css/grid.css">
    	<link rel="stylesheet" type="text/css" href="../assets/css/codeblue.css">
        
    	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
        <script>
        $(document).ready(function(){
            $('#verify_username').on('input propertychange paste', function() {
                
                var username = $(this).val();
                
        		// Start Ajax
        		$.ajax({
        			type: 'POST',
        			url: '../process/verify_username.php',
        
        			data: {
        				username:username
        			},
        
        			beforeSend: function() {
        				// Do Something
        			},
        			success: function(response) {
        				
        				if( response.result === true ){
        				    $('.verifyResult').removeClass('invalid');
        				    $('.verifyResult').addClass('valid');
        					$('.verifyResult').html(' (Username is valid)');
        					$('#hidden_username').val(response.username);
                            $('#hidden_userid').val(response.userid);
                            $('#hidden_patientid').val(response.patient_id);
        				}else{
        				    $('.verifyResult').removeClass('valid');
        				    $('.verifyResult').addClass('invalid');
        					$('.verifyResult').html(' (Invalid Username)');
        					$('#hidden_username').val('0');
                            $('#hidden_userid').val('0');
                            $('#hidden_patientid').val('0');
        				}
        				
        			}
        		});
        		// End Ajax
        
            });
        });

        $(document).ready(function(){
            $('.vitals-form-container .button').click(function(e){

                e.preventDefault();

                var userid = $('#hidden_userid').val();
                if( userid == '' ){ userid = '0'; }

                var username = $('#verify_username').val();
                if( username == '' ){ username = '0'; }

                var systolicBP = $('#systolicBP').val();
                if( systolicBP == '' ){ systolicBP = '0'; }

                var diastolicBP = $('#diastolicBP').val();
                if( diastolicBP == '' ){ diastolicBP = '0'; }

                var heartRate = $('#heartRate').val();
                if( heartRate == '' ){ heartRate = '0'; }

                var respRate = $('#respRate').val();
                if( respRate == '' ){ respRate = '0'; }

                var pulseOX = $('#pulseOX').val();
                if( pulseOX == '' ){ pulseOX = '0'; }

                var temp = $('#temp').val();
                if( temp == '' ){ temp = '0'; }

                var glucose = $('#glucose').val();
                if( glucose == '' ){ glucose = '0'; }

                var weight = $('#weight').val();
                if( weight == '' ){ weight = '0'; } 

                var socketDataOBJ = {
                    userid: userid,
                    username: username,
                    systolic: systolicBP,
                    diastolic: diastolicBP,
                    heartRate:heartRate,
                    respRate:respRate,
                    pulseOX:pulseOX,
                    temp:temp,
                    glucose:glucose,
                    weight:weight
                }
                var socketData = JSON.stringify(socketDataOBJ);

                var vitalsDataObj = {
                    userid: userid,
                    username: username,
                    systolic: systolicBP,
                    diastolic: diastolicBP,
                    heartrate:heartRate,
                    respRate:respRate,
                    pulse:pulseOX,
                    temperature:temp,
                    glucose:glucose,
                    weight:weight
                }
                var vitalsData = JSON.stringify(vitalsDataObj);

                $.ajax({
                    url: 'https://clinician.club/push_data',
                    type: "POST",
                    data: socketData,
                    contentType: "application/json",
                    beforeSend: function () { },
                    success: function (response) {
                        $('#code-blue-form').submit();
                    }
                });

                $.ajax({
                    url: 'https://ddxrx.ai/abnormal_vitals_manual',
                    type: "POST",
                    data: vitalsData,
                    contentType: "application/json",
                    beforeSend: function () { },
                    success: function (response) {
                        $('#code-blue-form').submit();
                    }
                });

            })
        })
        </script>
        
    </head>
    
    <body data-userid="0">
        
    <?php
        if( isset($_POST['username']) ){
        
            // For Systolic
    	    if( isset($_POST['systolicBP']) && $_POST['systolicBP'] != '' ){
    	        $systolicBP = $_POST['systolicBP'];
    	    }else{
    	        $systolicBP = '0';
    	    }
    	   
    	    // For Diastolic
    	    if( isset($_POST['diastolicBP']) && $_POST['diastolicBP'] != '' ){
    	        $diastolicBP = $_POST['diastolicBP'];
    	    }else{
    	        $diastolicBP = '0';
    	    }
    	   
    	    // For Heart Rate
    	    if( isset($_POST['heartRate']) && $_POST['heartRate'] != '' ){
    	        $heartRate = $_POST['heartRate'];
    	    }else{
    	        $heartRate = '0';
    	    }
    	   
    	    // For Respiratory Rate
    	    if( isset($_POST['respRate']) && $_POST['respRate'] != '' ){
    	        $respRate = $_POST['respRate'];
    	    }else{
    	        $respRate = '0';
    	    }
    	   
    	    // For Heart Rate
    	    if( isset($_POST['pulseOX']) && $_POST['pulseOX'] != '' ){
    	        $pulseOX = $_POST['pulseOX'];
    	    }else{
    	        $pulseOX = '0';
    	    }
            
            // For Temperature
    	    if( isset($_POST['temp']) && $_POST['temp'] != '' ){
    	        $temp = $_POST['temp'];
    	    }else{
    	        $temp = '0';
    	    }
    	    
    	    // For Glucose
    	    if( isset($_POST['glucose']) && $_POST['glucose'] != '' ){
    	        $glucose = $_POST['glucose'];
    	    }else{
    	        $glucose = '0';
    	    }
    	    
    	    // For Weight
    	    if( isset($_POST['weight']) && $_POST['weight'] != '' ){
    	        $weight = $_POST['weight'];
    	    }else{
    	        $weight = '0';
    	    }
    	    
    	    // SQL
    	    $sql = "INSERT INTO vitals_history (patient_id, systolic, diastolic, heartrate, respiratory, pulseox, temp, glucose, weight, dataSource) VALUES ('$patient_id', '$systolicBP', '$diastolicBP', '$heartRate', '$respRate', '$pulseOX', '$temp', '$glucose', '$weight', 'Manual')";
            
            $run = mysqli_query(ddxrxDBConnect(), $sql);
            
            if($run) {
            
                echo '
                    <div class="container">
                        <div class="vitals-form-container noborder">
                                    
                            <div class="vitalNotice success">
                                <p>Patient vitals added successfully!</p>
                            </div>
                                    
                        </div>
                    </div>
                ';
    
                $userid = getUserInfo( array('get_by' => 'patient_id', 'field' => 'user_id', 'identifier' => $patient_id) );
                $username = getUserInfo( array('get_by' => 'patient_id', 'field' => 'patient_fname', 'identifier' => $patient_id) );
                
                $json_data = array(
        	        "userid" => $userid,
        	        "username" => $username,
        	        "systolic" => $systolicBP,
        	        "diastolic" => $diastolicBP,
        	        "pulse" => $pulseOX,
        	        "heartrate" => $heartRate,
        	        "temperature" => $temp,
                    "respRate" => $respRate,
                    "glucose" => $glucose,
                    "weight" => $weight
        	    );
        	    
        	    $json_data = json_encode( $json_data );
        	    
        	    manualAbnormalVitals( $json_data );
                   
                // Free result set
                mysqli_close( ddxrxDBConnect() );
            
            }
        
        }
        ?>
        
        <div class="container">
            <div class="vitals-form-container">
            
                <div class="col-md-12"><h6>Add Patient Vitals</h6></div>
            
                <div class="padded">
                    <!-- <form method="POST" id="code-blue-form" action="<?php echo base_url() . '/codeblue/' . $codeid; ?>"> -->
                    <!-- <form method="POST" id="code-blue-form" action="http://localhost/ddxrx-main/code-blue/?codeid=123567"> -->
                        <form method="POST" id="code-blue-form" action="<?php echo $url; ?>">
                        
                        <input type="hidden" id="hidden_username" name="username" value="">
                        <input type="hidden" id="hidden_userid" name="userid" value="">
                        <input type="hidden" id="hidden_patientid" name="patient_id" value="">
                        
                        <div class="col-md-12">
                            <label style="margin-bottom: 30px">
                                <span>Verify Username<strong class="verifyResult"></strong></span>
                                <input type="text" class="textbox medium" id="verify_username" name="verify_username" placeholder="">
                            </label>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-6">
                                <label>
                                    <span>Systolic BP</span>
                                    <input type="text" class="textbox" id="systolicBP" name="systolicBP" placeholder="">
                                </label>
                            </div>
                            
                            <div class="col-md-6">
                                <label>
                                    <span>Diastolic BP</span>
                                    <input type="text" class="textbox" id="diastolicBP" name="diastolicBP" placeholder="">
                                </label>
                            </div>
                            <div class="clear"></div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-6">
                                <label>
                                    <span>Heart Rate</span>
                                    <input type="text" class="textbox" id="heartRate" name="heartRate" placeholder="">
                                </label>
                            </div>
                            
                            <div class="col-md-6">
                                <label>
                                    <span>Respiratory Rate</span>
                                    <input type="text" class="textbox" id="respRate" name="respRate" placeholder="">
                                </label>
                            </div>
                            <div class="clear"></div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-6">
                                <label>
                                    <span>Pulse OX</span>
                                    <input type="text" class="textbox" id="pulseOX" name="pulseOX" placeholder="">
                                </label>
                            </div>
                            
                            <div class="col-md-6">
                                <label>
                                    <span>Temperature</span>
                                    <input type="text" class="textbox" id="temp" name="temp" placeholder="">
                                </label>
                            </div>
                            <div class="clear"></div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-6">
                                <label>
                                    <span>Glucose</span>
                                    <input type="text" class="textbox" id="glucose" name="glucose" placeholder="">
                                </label>
                            </div>
                            
                            <div class="col-md-6">
                                <label>
                                    <span>Weight</span>
                                    <input type="text" class="textbox" id="weight" name="weight" placeholder="">
                                </label>
                            </div>
                            <div class="clear"></div>
                        </div>
                        
                        <div class="col-md-12">
                            <input type="submit" class="button" value="Add Vitals">
                        </div>
                    
                    </form>
                    
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
    </body>
</html>

<?php }else{ include('403.php'); } ?>
