<?php

// Enable Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start Session
session_start();

// Include Functions
include('process/functions.php');

// Check if User is Logged In and is a Nurse or Doctor
if( !isset($_SESSION['userid']) || !isset($_SESSION['userType']) || ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') ) {
    header("Location: logout.php");
    die();
}

// Check if Patient ID is Set, Otherwise Redirect to New Records
if( isset($_GET['id']) ){
    $patient_id = $_GET['id'];
}else{
    header("Location: new_records.php");
    die();
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Progress Note</title>
    
    <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link href="assets/css/create-note-progress.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/css/encounter.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="assets/js/create-note-progress.js"></script>
    
</head>
<body>
    
    <?php note_nav( $patient_id ); ?> 
    
    <div class="container">
        <div class="col-md-12">
            <div class="note-form">
                <div class="item">
                    <span>Chief Complaints:</span>
                    <textarea class="textarea" id="chief-complaints-list" name="chief-complaints" placeholder="Chief complaints"></textarea> 

                    <!-- <p>Enter the patient's chief complaints. You can add multiple complaints.</p>
                    <ul class="list-placeholder" id="chief-complaints-list"></ul>
                    <input type="text" class="textbox" id="chief-complaints" name="chief-complaints">
                    <button>Add to list</button> -->
                </div>
                <div class="item">
                    <span>History of Present Illness:</span>
                    <textarea class="textarea" id="history-of-present-illness" name="history-of-present-illness" placeholder="History of present illness"></textarea> 

                    <!-- <p>Enter the patient's history of present illness. You can add multiple illnesses.</p>
                    <ul class="list-placeholder" id="history-of-present-illness-list"></ul>
                    <input type="text" class="textbox" id="history-of-present-illness" name="history-of-present-illness">
                    <button>Add to list</button> -->
                </div>
                <div class="item">
                    <span>Review of System</span>
                    <p>Have you reviewed the patient's system? If yes, please check the box.</p>
                    <label class="checkboxLabel"><input type="checkbox" class="checkbox" id="review-of-system" name="review-of-system"><span>Yes</span></label>
                </div>
                <div class="item">
                    <span>Vitals</span>
                    <p>Did you check the patient's vitals? If yes, please enter the vitals below.</p>
                    <label class="checkboxLabel"><input type="checkbox" class="checkbox" id="vitals" name="vitals"><span>Yes</span></label>
                </div>
                <div class="item">
                    <span>Physical Examination</span>
                    <p>Did you perform a physical examination? If yes, please enter the examination below.</p>
                    <label class="checkboxLabel"><input type="checkbox" class="checkbox" id="physical-examination" name="physical-examination"><span>Yes</span></label>
                </div>
                <div class="item">
                    <span>Hospitalization</span>
                    <p>Does the patient need to be hospitalized? If yes, please enter the reason below.</p>
                    <label class="checkboxLabel"><input type="checkbox" class="checkbox" id="hospitalization" name="hospitalization"><span>Yes</span></label>
                </div>
                <div class="item">
                    <span>Laboratory and radiology</span>
                    <textarea class="textarea" id="lab-radiology" name="lab-radiology" placeholder="Lab radiology"></textarea> 
                    <!-- <p>Add any laboratory and radiology tests that need to be performed.</p>
                    <ul class="list-placeholder" id="lab-radiology-list"></ul>
                    <input type="text" class="textbox" id="lab-radiology" name="lab-radiology">
                    <button>Add to list</button> -->
                </div>
                <div class="item">
                    <span>Treatment Plan</span>
                   
                    <textarea class="textarea" id="treatment-plan" name="treatment-plan" placeholder="Treatment Plan"></textarea> 
                    <!-- <p>Add the treatment plan for the patient. You can add multiple treatments.</p> -->
                    <!-- <ul class="list-placeholder" id="treatment-plan-list"></ul>
                    <input type="text" class="textbox" id="treatment-plan" name="treatment-plan">
                    <button>Add to list</button> -->
                </div>
                <div class="item">
                    <label>
                        <h6>Treatment Remarks</h6>
                        <textarea class="textarea" id="treatment-remarks" name="treatment-remarks" placeholder="Treatment Remarks"></textarea> 
                    </label>
                </div>
                
            </div>
        </div>
    </div>

</body>
</html>