<?php include('config.php'); ?>
<?php

ob_start();
error_reporting(E_ERROR | E_PARSE);
session_start();

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: ios-launch.php");
    die();
}

//include ('includes/database_include.php');
include('process/functions.php');
$vitalFields = [];
$vitalFields[] = ['fieldName' => 'systolicBP', 'fieldLable' => 'Systolic BP', 'min' => 90, 'max' => 190];
$vitalFields[] = ['fieldName' => 'diastolicBP', 'fieldLable' => 'Diastolic BP', 'min' => 70, 'max' => 100];
$vitalFields[] = ['fieldName' => 'heartRate', 'fieldLable' => 'Heart Rate', 'min' => 0, 'max' => 90];
$vitalFields[] = ['fieldName' => 'respRate', 'fieldLable' => 'Respiratory Rate', 'min' => 0, 'max' => 20];
$vitalFields[] = ['fieldName' => 'pulseOX', 'fieldLable' => 'Pulse Ox', 'min' => 90, 'max' => 0];
$vitalFields[] = ['fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 96.8, 'max' => 100.4];

function medical_diagnosis() {
	$sql = "SELECT * FROM medical WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {
	        if( $row["status"] == 'pending' ) {
	            $status = 'class="pending"'; $label = '<strong>Pending</strong>'; 
	            
	        }
	        echo '<label '.$status.'><span>'.$row["diagnosis"].'</span>'.$label.'</label>';
	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}


function surgical_diagnosis() {

	$sql = "SELECT * FROM surgical WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {

	    	if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["diagnosis"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function family_diagnosis() {
	$sql = "SELECT * FROM family WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {

	    	if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["diagnosis"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function allergy_history() {

	$sql = "SELECT * FROM allergies WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {
	        
	        if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["allergy"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function medication_history() {
	$sql = "SELECT * FROM medication WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {
	        
	        if( $row["status"] == 'pending' ){ $status = 'class="pending"'; $label = '<strong>Pending</strong>'; }
	        echo '<label '.$status.'><span>'.$row["medicine"].'</span>'.$label.'</label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function social_diagnosis() {

	$sql = "SELECT * FROM social WHERE patient_id = '".$_SESSION["patient_id"]."'";
	$result = mysqli_query(ddxrxDBConnect(), $sql);

	if (mysqli_num_rows($result) > 0) {
	    // output data of each row
	    while($row = mysqli_fetch_assoc($result)) {

	    	echo '<label>Tobacco: <span>'.$row["tobaco"].'</span></label>';
	    	echo '<label>Alcohol: <span>'.$row["alcohol"].'</span></label>';
	    	echo '<label>Drugs: <span>'.$row["drugs"].'</span></label>';
	    	echo '<label>Occupation: <span>'.$row["occupation"].'</span></label>';
	    	echo '<label>Prison: <span>'.$row["prison"].'</span></label>';
	    	echo '<label>Travel: <span>'.$row["travel"].'</span></label>';
	    	echo '<label>Exercise: <span>'.$row["exercise"].'</span></label>';
	    	echo '<label>Firearms: <span>'.$row["firearms"].'</span></label>';

	    }
	} else {
	    echo "<p>No History Yet</p>";
	}
}

function current_social_record( $type = null, $value = null ) {
	$user_id = $_SESSION['userid'];

	$sql = "SELECT * FROM social WHERE patient_id = '".$_SESSION["patient_id"]."' LIMIT 1";
	$result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
	$user = mysqli_fetch_assoc($result);
	
	if( $type == 'tobaco' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'alcohol' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'drugs' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'occupation' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'prison' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'travel' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'exercise' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}elseif( $type == 'firearms' ){
		if( $user[$type] == $value ){ echo ' selected="selected"'; }
	}

}

function get_user_vitals() {

	$sql = "SELECT * FROM waiting_room WHERE patient_id = '".$_SESSION["patient_id"]."' ORDER BY checkin_time DESC LIMIT 1";
	$result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
	$user = mysqli_fetch_assoc($result);

	$vitals = $user['vital_json']; // Register Dynamic data into a variable
	$vitals = str_replace("'", '"', $vitals); // Replace single quote with double quote
	$vitals = json_decode($vitals); // Decode Json

	/*
	foreach ($vitals as $vital) {
    	echo $vital, "\n";
    	//echo $vital->systolicBP;
	}
	*/

	if( isset($vitals->systolicBP) ){ echo '<li><span>Systolic BP:</span> '.$vitals->systolicBP.'</li>'; }else{ echo '<li><span>Systolic BP:</span> No Previous Record</li>'; }
	if( isset($vitals->diastolicBP) ){ echo '<li><span>Diastolic BP:</span> '.$vitals->diastolicBP.'</li>'; }else{ echo '<li><span>Diastolic BP:</span> No Previous Record</li>'; }
	if( isset($vitals->heartRate) ){ echo '<li><span>Heart Rate:</span> '.$vitals->heartRate.'</li>'; }else{ echo '<li><span>Heart Rate:</span> No Previous Record</li>'; }
	if( isset($vitals->respRate) ){ echo '<li><span>Respiratory Rate:</span> '.$vitals->respRate.'</li>'; }else{ echo '<li><span>Respiratory Rate:</span> No Previous Record</li>'; }
	if( isset($vitals->pulseOX) ){ echo '<li><span>Pulse OX:</span> '.$vitals->pulseOX.'</li>'; }else{ echo '<li><span>Pulse OX:</span> No Previous Record</li>'; }
	if( isset($vitals->temp) ){ echo '<li><span>Temperature:</span> '.$vitals->temp.'</li>'; }else{ echo '<li><span>Temperature:</span> No Previous Record</li>'; }

}

// Trial Expiration Date
function free_trial(){ 
    $userid=  $_SESSION['userid'];
    $startdate = $_SESSION['current_patient']['created_at'];
    $expire  = date("Y-m-d H:i:s", strtotime($startdate . ' + 365 days'));
    $today = date("Y-m-d H:i:s");
        
    if($today >= $expire){
        return 'false';
    } else {
        return 'true';
    }
}

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'UA-148409281-5');
    </script>


    
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>DDXRX Symtom Result</title>
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css<?php echo getAssetVersion(); ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css<?php echo getAssetVersion(); ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/main-menu.css<?php echo getAssetVersion(); ?>">
    <link rel="stylesheet" type="text/css" href="assets/css/search-style-reports.css<?php echo getAssetVersion(); ?>">
    <link rel="stylesheet" type="text/css" href="assets/css/responsive.css<?php echo getAssetVersion(); ?>">
    <link rel="stylesheet" type="text/css" href="assets/css/style.css<?php echo getAssetVersion(); ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css<?php echo getAssetVersion(); ?>">
	<script type="text/javascript">
        var vitalFields = <?php echo json_encode($vitalFields); ?>;
    </script>

    <script type="text/javascript" src="socket.io/socket.io.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/jquery-3.3.1.min.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/jquery-ui.min.js<?php echo getAssetVersion(); ?>"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	
	<script type="text/javascript" src="assets/js/mobile.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/ddx_reports_ui.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/record_data.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/base64converter.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/jquery.tap.js<?php echo getAssetVersion(); ?>"></script>
	<script type="text/javascript" src="assets/js/jquery.cookie.js<?php echo getAssetVersion(); ?>"></script>
	
    <link rel="stylesheet" type="text/css" href="assets/css/autocomplete/jquery.autocomplete.css"/>
	<script type="text/javascript" src="assets/js/autocomplete/jquery.autocomplete.min.js"></script>
	
	
	<script type="text/javascript">

	$(document).ready(function() {
	    
	    // Generate the dashboard progress note
        function send_decision_support(){
            
            var mainArray = [];
            var chiefComplaints = {
                passed:[],
                failed:[]
            };
            var submittedDivs = $(".submitted.status");
            
            $.each(submittedDivs, function (key, value) {
                
                mainArray.push($(value).closest('.padded').next().find("form").serializeArray());
                
                chiefComplaints.passed.push($(value).closest(".padded").find('.name').html());
                
            });
            
            var patientString = localStorage.getItem("patient");
            var patient = JSON.parse(patientString);
            patient.symptoms = $("#symptoms_0").val() + ", " + $("#symptoms_1").val();
            patient.chiefComplaint = chiefComplaints;
                    
            $.ajax({
                url: "combined_decision_supportpro.php",
                type: 'POST',
                dataType: 'html',
                data: {waitingroom_id : patient.waitingroom_id, data: JSON.stringify(mainArray)}, //stringify is important
                success: function (data, status) {
                            
                    // Append Results
                    $(".results-main-container").html(data);
                    $.ajax({
                        url: 'save_search_entry.php',
                        data: {
                            'update': true,
                            'diagnosis': patient.chiefComplaint,
                            'symptoms': patient.symptoms,
                            'guid': patient.idKey,
                            'waitingroom_id': patient.waitingroom_id,
                            'note': $(".results-container").html()
                        },
                        type: 'POST',
                        dataType: 'json',
                        success: function success(msg) {
                            var socket = io.connect('https://lighthouse.ddxrx.com:8080', {secure: true});
                            socket.emit('existingPatient', patient);
                        },
                        error: function error(msg) {
                            // console.log('error');
                        },
                    });
                        
                }
            });
            
        }
        
        // Send sweet alert response
        function sendSweetAlertResponse( content, yes_content, no_content, alertType ){
            
            var user_id = $('body').data('user_id');
            
            $.ajax({
                type: "POST",
                url: 'process/sendsweetalertresponse.php',
                
                data:{
                    content: content,
                    yes_content: yes_content,
                    no_content: no_content,
                    alertType: alertType,
                    userid:user_id
                },
                
                success: function(data){
                    // Do something
                }
            
            });
            
        }
        
        var all_symptoms = "<?php echo $_SESSION['varSSLists']; ?>".split("*");
        console.log(all_symptoms);
        $( "body" ).on( "keyup", ".symptoms_search_box", function() {
            $(this).autocomplete(all_symptoms, {
                mustMatch: false,
                autoFill: false,
                matchContains: "word",
                max: "40",
                scrollHeight: "400px"
            });
        });
		$('.show_questions').click('click', function () {
            var _this = $(this);
            var content = $(_this).next().html();
            if (content == "") {
                $.get("decision_support.php?dd_id=" + $(this).attr('id'), function (data, status) {
                    $(_this).next().html(data);
                    $(_this).next().trigger('create');
                    $(_this).next().show();
                });
            } else {
                $(_this).next().toggle();
            }
        });
        
        function GoToNextDiagnosis(){
            
            $(".probability-list.show").next().click();
            $(".probability-list.show").next().addClass('show');
            
            /*
            Swal.fire({
    			type: 'error',
                title: 'Click the next diagnosis',
                text: "Symptoms do not match a typical presentation of the disease. Please talk to a healthcare provider. Do you want to proceed to next diagnosis? Please answer yes or no?",
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#dd3333',
                confirmButtonText: 'Next Diagnosis',
                allowOutsideClick: false
            }).then((result) => {
                        
                if (result.value) {
                    $(".probability-list.show").next().click();
                    //$(".probability-list.show").next().removeClass('hide');
                    $(".probability-list.show").next().addClass('show');
                    //$(".probability-list").removeClass('show');
                }
            });
            */
        }
        
        /* ------------------------------------------------- */
        // Hide diagnosis without questions
        /* ------------------------------------------------- */
        /* 
        This is to solve the issue with the no dropdown bug, if the system cannot read next diagnosis that has no
        questions it causes the installer to have a bug, the bug is the installer gets stuck with the last diagnosis
        because the ddx_reports script does not forward data to the database and in turn this data is being used by 
        the installer.
        */
        /* ------------------------------------------------- */
        $(".probability-list").each(function(){
    		if( $(this).hasClass("dropdown") == false ){
    			$(this).remove();
    		}
    	});
        
        $('body').on('click', '.save_answers', function () {
            
            var user_id = $('body').data('user_id');
            
            var diagnosis_container = $(this).parent().parent().parent().parent().parent().parent().attr('id');
            var go_to = $('#'+diagnosis_container+' .go_to').html();
            var if_you_have = $('#'+diagnosis_container+' .if_you_have').html();
            var emergency_instructions = $('#'+diagnosis_container+' .hidden_instructions').html();
            
            sessionStorage.setItem("go_to", go_to);
            sessionStorage.setItem("if_you_have", if_you_have);
            sessionStorage.setItem("emergency_instructions", emergency_instructions);
            
            var _this = $(this);
            var diagnosis_id = $(this).data('diag-id');
            
            // console.log($(_this).closest("form").serializeArray());
            var formData = $(_this).closest("form").serializeArray();
            
            $.post("get_ddx.php", formData, function (data, status) {
                var parsedData = JSON.parse(data);
                $(_this).addClass("submitted");
                $(_this).closest(".questions").hide();
    
                //$('.probability-list').removeClass('opened');
                //$('.probability-list').addClass('closed');
                //$('.probability-list .options').css('display','none');
                $("#status_id_"+diagnosis_id).addClass('submitted');
                if (parsedData.result == 1) {
    
                	$('html, body').animate({
    				    scrollTop: $("#save_and_connect").offset().top
    				}, 100);
    				
    				function sendSymptomsMatch(){
    				    
    				    var user_id = $('body').data('user_id');
    				    
    				    var sendData = {
                            "patient_id" : user_id,
                            "type" : 'type_7',
                            "text" : emergency_instructions,
                            "question_id" : '0'
                        };
                        
                        $.ajax({
                            type: "POST",
                            //url: 'https://doctorai.ddxrx.net/api/speech_to_text.php',
                            url: 'process/api-data.php?target=sendSymptomsMatch',
                
                            data: JSON.stringify(sendData),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            
                        });
    				    
    				}
                    
                    // Generate the dashboard progress note
                    send_decision_support();
                    
                    <?php
                    
                    $patient_id = $_SESSION['patient_id'];
                    $sqlLocation = "SELECT * FROM patients WHERE patient_id ='$patient_id'";
                	$resultLocation = mysqli_query(ddxrxDBConnect(), $sqlLocation) or die('SQL Error :: '.mysqli_error());
                	$locationData = mysqli_fetch_assoc($resultLocation);
                    
                    ?>
                    
                    <?php if( $locationData['location'] == '1' ){ ?>
                    
                        // Send to data database
    			        sendSweetAlertResponse( 'The symptoms match the diagnosis. Your history is been sent to the provider. Thank you for using Robot Doctor.', 'Ok', '', 'type_13' );
                                
                        Swal.fire(
                            'Symptoms match the diagnosis',
                            'Your history is been sent to the provider. Thank you for using Robot Doctor.',
                            'success',
                        );
                    
                    <?php }else{ ?>
                    
                    sendSweetAlertResponse( 'Symptoms match the diagnosis. \n '+emergency_instructions, 'Proceed', 'Next Diagnosis', 'type_8' );
                    
                    const swalWithBootstrapButtons = Swal.mixin({
                        customClass: {
                            confirmButton: 'custom-btn next',
                            cancelButton: 'custom-btn submit'
                        },
                        buttonsStyling: false
                    })
                    
                    swalWithBootstrapButtons.fire({
                        title: 'Symptoms match the diagnosis',
                        text: emergency_instructions,
                        icon: 'warning',
                        showCancelButton: true,
                        cancelButtonText: 'Proceed',
                        confirmButtonText: 'Next Diagnosis',
                        reverseButtons: true,
                        allowOutsideClick: false,
                    }).then((result) => {
                        if (result.isConfirmed) {
                            
                            // Next symptoms
                            GoToNextDiagnosis();
                            
                            // Send diagnosis to database
                            sendDiagnosis();
                            
                        } else if (result.dismiss === Swal.DismissReason.cancel){
                            
                            // Send symptoms
                            sendSymptomsMatch();
                            $('#save_and_connect').click();
                            
                        }
                    });
    
                    $("#status_id_"+diagnosis_id).removeClass('failed');
                    $("#status_id_"+diagnosis_id).removeClass('red');
    
                    $("#status_id_"+diagnosis_id).addClass('success');
                    $("#status_id_"+diagnosis_id).addClass('green');
    
                    $(_this).closest(".questions").prev().find("img.failed").hide();
                    $(_this).closest(".questions").prev().find("img.passed").show();
    
    				$( "#save_and_connect" ).effect( "shake" );
    				
    				<?php } ?>
    
                } else {
                    
                    /*
                	Swal.fire({
    					type: 'error',
    				  	title: 'Click the next diagnosis',
    				  	text: 'Symptoms do not match a typical presentation of the disease. Please talk to a healhcare provider',
    				});
    				*/
    				
    				sendSweetAlertResponse( 'Symptoms do not match a typical presentation of the disease. Please talk to a healthcare provider. Do you want to proceed to next diagnosis? Please answer yes or no?', 'Next Diagnosis', 'Cancel', 'type_9' );
    				
    				Swal.fire({
    				    type: 'error',
                        title: 'Click the next diagnosis',
                        text: "Symptoms do not match a typical presentation of the disease. Please talk to a healthcare provider. Do you want to proceed to next diagnosis? Please answer yes or no?",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dd3333',
                        confirmButtonText: 'Next Diagnosis',
                        allowOutsideClick: false
                    }).then((result) => {
                        
                        if (result.value) {
                            
                            var nextID = $(".probability-list.show").next().attr('id');
                            
                            /*
                            $(".probability-list.show").next().click();
                            //$(".probability-list.show").next().removeClass('hide');
                            $(".probability-list.show").next().addClass('show');
                            //$(".probability-list").removeClass('show');
                            */
                            
                            $(".probability-list.show").next().click();
                            $(".probability-list").removeClass('show');
                            $('#'+nextID).addClass('show');
                            
                            // Call function to send diagnosis to API
                            sendDiagnosis();
                            
                        }
                        
                    });
    
                	$("#status_id_"+diagnosis_id).removeClass('success');
                    $("#status_id_"+diagnosis_id).removeClass('green');
    
                    $("#status_id_"+diagnosis_id).addClass('failed');
                    $("#status_id_"+diagnosis_id).addClass('red');
             
                    $(_this).closest(".questions").prev().find("img.passed").hide();
                    $(_this).closest(".questions").prev().find("img.failed").show();
    
                    $('html, body').animate({
    				    scrollTop: $(".probability-container").offset().top
    				}, 1000);
    
                }
            });
        });

        /*$('.note_button').click('click', function () {

            var note_btn = $(this).attr('id');
            console.log('note_btn', note_btn);
            $("#note_output").html('');
            var mainArray = [];
            var chiefComplaints = "";
            var submittedDivs = $(".submitted");
            $.each(submittedDivs, function (key, value) {
                // console.log($(value).closest("form").serializeArray());
                mainArray.push($(value).closest("form").serializeArray());
                if (chiefComplaints != "") chiefComplaints += ", ";
                chiefComplaints += $(value).closest(".questions").prev().find("a").html();
            });
            var patientString = localStorage.getItem("patient");
            var patient = JSON.parse(patientString);
            patient.symptoms = $("#symptoms_0").val() + ", " + $("#symptoms_1").val();
            patient.chiefComplaint = chiefComplaints;
            $.ajax({
                url: "combined_decision_supportpro.php",
                type: 'POST',
                dataType: 'html',
                data: {data: JSON.stringify(mainArray)}, //stringify is important
                success: function (data, status) {
                    // console.log(data);
                    // $("#note_output").hide();
                    if (note_btn == "note_output_btn") {
                        $("#note_output").html(data);
                        $("#note_output").trigger('create');
                        $('input[type="checkbox"]').click(function(){
                            if($(this).is(":checked")){
                            $(this).addClass('my_class_replace');
                    }
                            else if($(this).is(":not(:checked)")){
                            $(this).removeClass('test');
                            }
                            });
                    }
                    $.ajax({
                        url: 'save_search_entry.php',
                        data: {
                            'update': true,
                            'diagnosis': patient.chiefComplaint,
                            'symptoms': patient.symptoms,
                            'guid': patient.idKey,
                            'waitingroom_id': patient.waitingroom_id,
                          //  'total_string' : total_string,
                            'note': $("#note_output").html()
                        },
                        type: 'POST',
                        dataType: 'json',
                        success: function success(msg) {
                            alert("Save Successfully !");
                            //   var socket = io.connect('https://lighthouse.ddxrx.com:8080', {secure: true});
                            //  socket.emit('existingPatient', patient);
                        },
                        error: function error(msg) {
                            // console.log('error');
                        },
                    });
                }
            });
        });*/

        /*$('.note_button_new').click('click', function () {
            var note_btn = $(this).attr('id');
            console.log('note_btn', note_btn);
            //$("#note_output").html('');
            var mainArray = [];
            var chiefComplaints = "";
            var submittedDivs = $(".submitted");
            $.each(submittedDivs, function (key, value) {
                // console.log($(value).closest("form").serializeArray());
                mainArray.push($(value).closest("form").serializeArray());
                if (chiefComplaints != "") chiefComplaints += ", ";
                chiefComplaints += $(value).closest(".questions").prev().find("a").html();
            });
            var patientString = localStorage.getItem("patient");
            var patient = JSON.parse(patientString);
            patient.symptoms = $("#symptoms_0").val() + ", " + $("#symptoms_1").val();
            patient.chiefComplaint = chiefComplaints;
            $.ajax({
                url: "combined_decision_supportpro.php",
                type: 'POST',
                dataType: 'html',
                data: {data: JSON.stringify(mainArray)}, //stringify is important
                success: function (data, status) {
                    // console.log(data);
                    // $("#note_output").hide();

                    if (note_btn == "create_note") {
                        $('input[type="checkbox"]').click(function(){
                            if($(this).is(":checked")){
                                $(this).addClass('my_class_replace');
                            }
                            else if($(this).is(":not(:checked)")){
                                $(this).removeClass('test');
                            }
                        });
                    }
                    $.ajax({
                        url: 'save_search_entry.php',
                        data: {
                            'update': true,
                            'diagnosis': patient.chiefComplaint,
                            'symptoms': patient.symptoms,
                            'guid': patient.idKey,
                            'waitingroom_id': patient.waitingroom_id,
                          //  'total_string' : total_string,
                            'note': $("#note_output").html()
                        },
                        type: 'POST',
                        dataType: 'json',
                        success: function success(msg) {
                            $('#note_output_btn')[0].click();
                            //   var socket = io.connect('https://lighthouse.ddxrx.com:8080', {secure: true});
                            //  socket.emit('existingPatient', patient);
                        },
                        error: function error(msg) {
                            // console.log('error');
                        },
                    });
                }
            });
        });*/
	});
	
	
	
	
	
	var matched, browser;

        jQuery.uaMatch = function( ua ) {
            ua = ua.toLowerCase();
        
            var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
                /(webkit)[ \/]([\w.]+)/.exec( ua ) ||
                /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
                /(msie) ([\w.]+)/.exec( ua ) ||
                ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
                [];
        
            return {
                browser: match[ 1 ] || "",
                version: match[ 2 ] || "0"
            };
        };

        matched = jQuery.uaMatch( navigator.userAgent );
        browser = {};
        
        if ( matched.browser ) {
            browser[ matched.browser ] = true;
            browser.version = matched.version;
        }

        // Chrome is Webkit, but Webkit is also Safari.
        if ( browser.chrome ) {
            browser.webkit = true;
        } else if ( browser.webkit ) {
            browser.safari = true;
        }

        jQuery.browser = browser;
        
        jQuery.fn.extend({
            live: function (event, callback) {
               if (this.selector) {
                    jQuery(document).on(event, this.selector, callback);
                }
                return this;
            }
        });

        /* ------------------------------------------------------------------------------ */	
	
        

        jQuery.validator.addMethod("notEqualTo", function (value, element, param) {
                var notEqual = true;
                value = $.trim(value);
                for (i = 0; i < param.length; i++) {
                    if (value == $.trim($(param[i]).val())) {
                        notEqual = false;
                    }
                }
                return this.optional(element) || notEqual;
            },
            "Please enter a diferent value."
        );
        $(document).ready(function () {
            var patientString = localStorage.getItem("patient");
            var patientObj = JSON.parse(patientString);
            if (patientObj != null) {
                                
            }
            if (getUrlParameter("state") != undefined && getUrlParameter("code") != undefined) {
                // get the URL parameters received from the authorization server
                var state = getUrlParameter("state");  // session key
                var code = getUrlParameter("code");    // authorization code
                // console.log(state+" "+code);
                // load the app parameters stored in the session
                // console.log(sessionStorage[state]);
                var params = JSON.parse(sessionStorage[state]);  // load app session
                // console.log(params);
                // alert(params);
                var tokenUri = params.tokenUri;
                var clientId = params.clientId;
                var secret = params.secret;
                var redirectUri = params.redirectUri;
                serviceUri = params.serviceUri;
                // Prep the token exchange call parameters
                // var data = {
                // code: code,
                // grant_type: 'refresh_token',
                // redirect_uri: redirectUri,
                // refresh_token: "xqo2P9ILUl9OjEKGzuKapSmkj8iJS7BK3TTM8GcPrjCRN/YGC7Bxy+Rlnx+ThL2uh1RwubfPnpRgWgBdEZVIqQ=="
                // };
                // Prep the token exchange call parameters
                var data = {
                    code: code,
                    grant_type: 'authorization_code',
                    redirect_uri: redirectUri
                };
                var options;
                if (!secret) {
                    data['client_id'] = clientId;
                }
                options = {
                    url: tokenUri,
                    type: 'POST',
                    data: data
                };
                if (secret) {
                    options['headers'] = {'Authorization': 'Basic ' + btoa(clientId + ':' + secret)};
                    // console.log(options);
                }
                // alert("secret "+secret);
                // alert("clientId "+clientId);
                $.ajax({
                    url: tokenUri,
                    type: 'POST',
                    data: data,
                    headers: {
                        'Authorization': 'Basic ' + btoa(clientId + ':' + secret)
                    },
                    success: function (data) {
                        // alert(data);
                    }
                })
                // obtain authorization token from the authorization service using the authorization code
                $.ajax(options).done(function (res) {
                    // console.log("res",res);
                    // alert(res);
                    accessToken = res.access_token;
                    var patientId = res.patient;
                    // alert(accessToken+" "+patientId);
                    // $.ajax({
                    // url: "token.php",
                    // type: "POST",
                    // data: {token:accessToken, serviceUri:serviceUri},
                    // success: function(data) {
                    // console.log("response storing token",data);
                    // }
                    // });

                    var url = serviceUri + "/Patient/" + patientId;

                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        global: false,
                        async: false,
                        headers: {
                            "Authorization": "Bearer " + accessToken
                        },
                        success: function (data) {
                            // console.log(data);
                            // console.log(data.name[0].given[0]+" "+data.name[0].family[0]);
                            $("#patientNameHeader").html(data.name[0].given[0] + " " + data.name[0].family[0]);
                            // return data;
                        }
                    })
                });
            }

            // Convenience function for parsing of URL parameters
            // based on http://www.jquerybyexample.net/2012/06/get-url-parameters-using-jquery.html
            function getUrlParameter(sParam) {
                var sPageURL = window.location.search.substring(1);
                var sURLVariables = sPageURL.split('&');
                for (var i = 0; i < sURLVariables.length; i++) {
                    var sParameterName = sURLVariables[i].split('=');
                    if (sParameterName[0] == sParam) {
                        var res = sParameterName[1].replace(/\+/g, '%20');
                        return decodeURIComponent(res);
                    }
                }
            }

            $("#formddX").validate();
            $.extend($("#formddX").validate().settings, {onkeyup: false, onfocusout: false});
            $('div#show_all').hide();
            $('div#show_ten').hide();

            // Tooltip only Text
            $('.masterTooltip').hover(function () {
                // Hover over code
                var title = $(this).attr('title');
                $(this).data('tipText', title).removeAttr('title');
                $('<span class="tooltip"></span>')
                    .text(title)
                    .appendTo('body')
                    .fadeIn('fast');
            }, function () {
                // Hover out code
                $(this).attr('title', $(this).data('tipText'));
                $('.tooltip').remove();
            }).mousemove(function (e) {
                var mousex = e.pageX + 20; //Get X coordinates
                var mousey = e.pageY + 10; //Get Y coordinates
                $('.tooltip')
                    .css({top: mousey, left: mousex})
            });
            $("#searchPatient").click(function () {
                alert($("#patientSearchString").val());
            });

            $("#searchddx").click(function () {

                $('#search_box').trigger('collapse');
                var patient_id = "2";
                data = {
                    patient_id:patient_id,symptoms: [$("#symptoms_0").val(), $("#symptoms_1").val(), $("#symptoms_2").val(), $("#symptoms_3").val(), $("#symptoms_4").val()]
                }
                $("#ajax_output").html('');
            });

        });

        function clearfield() {
            $(".symptoms_search_box").val("");
        }

        $(function(){
            $('.special_field_link1').live('click', function()
            {

                if ( $("#symptoms_0").val().length == 0 )
                {   
                    $("#symptoms_0").val("Follow up visit");
                    
                    $('#f_first').live('click', function(){   
                        $("#symptoms_0").val("Follow up visit");
                    });
                    
                    $( "#s_second" ).live('click', function(){
                        $("#symptoms_0").val("to establish care");
                    });
                    
                    $("#symptoms_1").val($(this).html());
                    return false;
                }

                if ( $("#symptoms_2").val().length == 0 )
                {
                    $("#symptoms_2").val($(this).html());
                    return false;
                }

                if ( $("#symptoms_3").val().length == 0 )
                {
                    $("#symptoms_3").val($(this).html());
                    return false;
                }

                if ( $("#symptoms_4").val().length == 0 )
                {
                    $("#symptoms_4").val($(this).html());
                    return false;
                }
            });
        });

        $(function () {
            $('.special_field_link').live('click', function () {


                if ($("#symptoms_0").val().length == 0) {
                    $("#symptoms_0").val($(this).html());
                    return false;
                }
                if ($("#symptoms_1").val().length == 0) {
                    $("#symptoms_1").val($(this).html());
                    return false;
                }
                if ($("#symptoms_2").val().length == 0) {
                    $("#symptoms_2").val($(this).html());
                    return false;
                }
                if ($("#symptoms_3").val().length == 0) {
                    $("#symptoms_3").val($(this).html());
                    return false;
                }
                if ($("#symptoms_4").val().length == 0) {
                    $("#symptoms_4").val($(this).html());
                    return false;
                }
            });
            $('.show_questions').live('click', function () {
                var _this = $(this);
                var content = $(_this).next().html();
                if (content == "") {
                    $.get("decision_support.php?dd_id=" + $(this).attr('id'), function (data, status) {
                        $(_this).next().html(data);
                        $(_this).next().trigger('create');
                        $(_this).next().show();
                    });
                } else {
                    $(_this).next().toggle();
                }
            });
            
            $('.save_answers').live('click', function () {
                var _this = $(this);
                // console.log($(_this).closest("form").serializeArray());
                var formData = $(_this).closest("form").serializeArray();
                $.post("get_ddx.php", formData, function (data, status) {
                    var parsedData = JSON.parse(data);
                    $(_this).addClass("submitted");
                    $(_this).closest(".questions").hide();
                    if (parsedData.result == 1) {
                        $(_this).closest(".questions").prev().find("img.failed").hide();
                        $(_this).closest(".questions").prev().find("img.passed").show();
                    } else {
                        $(_this).closest(".questions").prev().find("img.passed").hide();
                        $(_this).closest(".questions").prev().find("img.failed").show();
                    }
                });
            });
            
            
            $('.note_button').live('click', function () {

                var narcotic_1 = $('#narcotic_1').val();
                var narcotic_2 = $('#narcotic_2').val();
                var narcotic_3 = $('#narcotic_3').val();
                var narcotic_4 = $('#narcotic_4').val();
                var narcotic_5 = $('#narcotic_5').val();
                var narcotic_6 = $('#narcotic_6').val();
                var narcotic_7 = $('#narcotic_7').val();
                var narcotic_8 = $('#narcotic_8').val();
                var narcotic_9 = $('#narcotic_9').val();

                var anti_1 = $('#anti_1').val();
                var anti_2 = $('#anti_2').val();
                var anti_3 = $('#anti_3').val();
                var anti_4 = $('#anti_4').val();
                var anti_5 = $('#anti_5').val();
                var anti_6 = $('#anti_6').val();
                var anti_7 = $('#anti_7').val();
                var anti_8 = $('#anti_8').val();

                var muscle_1 = $('#muscle_1').val();
                var muscle_2 = $('#muscle_2').val();
                var muscle_3 = $('#muscle_3').val();
                var muscle_4 = $('#muscle_4').val();
                var muscle_5 = $('#muscle_5').val();
                var muscle_6 = $('#muscle_6').val();
                var muscle_7 = $('#muscle_7').val();

                var neuropathic_1 = $('#neuropathic_1').val();
                var neuropathic_2 = $('#neuropathic_2').val();
                var neuropathic_3 = $('#neuropathic_3').val();
                var neuropathic_4 = $('#neuropathic_4').val();


                var total_string = narcotic_1.concat(',',narcotic_2,',',narcotic_3,',',narcotic_4,',',narcotic_5,',',narcotic_6,',',narcotic_7,',',narcotic_8,',',narcotic_9,',',
                    anti_1,',',anti_2,',',anti_3,',',anti_4,',',anti_5,',',anti_6,',',anti_7,',',anti_8,',',
                    muscle_1,',',muscle_2,',',muscle_3,',',muscle_4,',',muscle_5,',',muscle_6,',',muscle_7,',',
                    neuropathic_1,',',neuropathic_2,',',neuropathic_3,',',neuropathic_4);

                var note_btn = $(this).attr('id');
                console.log('note_btn', note_btn);
                $("#note_output").html('');
                var mainArray = [];
                var chiefComplaints = "";
                var submittedDivs = $(".submitted");
                
                $.each(submittedDivs, function (key, value) {
                    // console.log($(value).closest("form").serializeArray());
                    mainArray.push($(value).closest("form").serializeArray());
                    if (chiefComplaints != "") chiefComplaints += ", ";
                    chiefComplaints += $(value).closest(".questions").prev().find("a").html();
                });
                
                var patientString = localStorage.getItem("patient");
                var patient = JSON.parse(patientString);
                patient.symptoms = $("#symptoms_0").val() + ", " + $("#symptoms_1").val();
                patient.chiefComplaint = chiefComplaints;
                $.ajax({
                    url: "combined_decision_supportpro.php",
                    type: 'POST',
                    dataType: 'html',
                    data: {data: JSON.stringify(mainArray)}, //stringify is important
                    success: function (data, status) {
                        // console.log(data);
                        // $("#note_output").hide();
                        if (note_btn == "note_output_btn") {
                            $("#note_output").html(data);
                            $("#note_output").trigger('create');
                            $('input[type="checkbox"]').click(function(){
                                if($(this).is(":checked")){
                                $(this).addClass('my_class_replace');
                        }
                                else if($(this).is(":not(:checked)")){
                                $(this).removeClass('test');
                                }
                                });
                        }
                        $.ajax({
                            url: 'save_search_entry.php',
                            data: {
                                'update': true,
                                'diagnosis': patient.chiefComplaint,
                                'symptoms': patient.symptoms,
                                'guid': patient.idKey,
                                'waitingroom_id': patient.waitingroom_id,
                                'total_string' : total_string,
                                'note': $("#note_output").html()
                            },
                            type: 'POST',
                            dataType: 'json',
                            success: function success(msg) {
                                alert("Save Successfully !");
                                //   var socket = io.connect('https://lighthouse.ddxrx.com:8080', {secure: true});
                                //  socket.emit('existingPatient', patient);
                            },
                            error: function error(msg) {
                                // console.log('error');
                            },
                        });
                    }
                });
            });

            $('.note_button_new').live('click', function () {
                var narcotic_1 = $('#narcotic_1').val();
                var narcotic_2 = $('#narcotic_2').val();
                var narcotic_3 = $('#narcotic_3').val();
                var narcotic_4 = $('#narcotic_4').val();
                var narcotic_5 = $('#narcotic_5').val();
                var narcotic_6 = $('#narcotic_6').val();
                var narcotic_7 = $('#narcotic_7').val();
                var narcotic_8 = $('#narcotic_8').val();
                var narcotic_9 = $('#narcotic_9').val();

                var anti_1 = $('#anti_1').val();
                var anti_2 = $('#anti_2').val();
                var anti_3 = $('#anti_3').val();
                var anti_4 = $('#anti_4').val();
                var anti_5 = $('#anti_5').val();
                var anti_6 = $('#anti_6').val();
                var anti_7 = $('#anti_7').val();
                var anti_8 = $('#anti_8').val();

                var muscle_1 = $('#muscle_1').val();
                var muscle_2 = $('#muscle_2').val();
                var muscle_3 = $('#muscle_3').val();
                var muscle_4 = $('#muscle_4').val();
                var muscle_5 = $('#muscle_5').val();
                var muscle_6 = $('#muscle_6').val();
                var muscle_7 = $('#muscle_7').val();

                var neuropathic_1 = $('#neuropathic_1').val();
                var neuropathic_2 = $('#neuropathic_2').val();
                var neuropathic_3 = $('#neuropathic_3').val();
                var neuropathic_4 = $('#neuropathic_4').val();


                var total_string = narcotic_1.concat(',',narcotic_2,',',narcotic_3,',',narcotic_4,',',narcotic_5,',',narcotic_6,',',narcotic_7,',',narcotic_8,',',narcotic_9,',',
                    anti_1,',',anti_2,',',anti_3,',',anti_4,',',anti_5,',',anti_6,',',anti_7,',',anti_8,',',
                    muscle_1,',',muscle_2,',',muscle_3,',',muscle_4,',',muscle_5,',',muscle_6,',',muscle_7,',',
                    neuropathic_1,',',neuropathic_2,',',neuropathic_3,',',neuropathic_4);
                //alert(total_string);
                var note_btn = $(this).attr('id');
                console.log('note_btn', note_btn);
                //$("#note_output").html('');
                var mainArray = [];
                var chiefComplaints = "";
                var submittedDivs = $(".submitted");
                $.each(submittedDivs, function (key, value) {
                    // console.log($(value).closest("form").serializeArray());
                    mainArray.push($(value).closest("form").serializeArray());
                    if (chiefComplaints != "") chiefComplaints += ", ";
                    chiefComplaints += $(value).closest(".questions").prev().find("a").html();
                });
                var patientString = localStorage.getItem("patient");
                var patient = JSON.parse(patientString);
                patient.symptoms = $("#symptoms_0").val() + ", " + $("#symptoms_1").val();
                patient.chiefComplaint = chiefComplaints;
                
                $.ajax({
                    url: "combined_decision_supportpro.php",
                    type: 'POST',
                    dataType: 'html',
                    data: {data: JSON.stringify(mainArray)}, //stringify is important
                    success: function (data, status) {
                        // console.log(data);
                        // $("#note_output").hide();

                        if (note_btn == "create_note") {
                            $('input[type="checkbox"]').click(function(){
                                if($(this).is(":checked")){
                                    $(this).addClass('my_class_replace');
                                }
                                else if($(this).is(":not(:checked)")){
                                    $(this).removeClass('test');
                                }
                            });
                        }
                        $.ajax({
                            url: 'save_search_entry.php',
                            data: {
                                'update': true,
                                'diagnosis': patient.chiefComplaint,
                                'symptoms': patient.symptoms,
                                'guid': patient.idKey,
                                'waitingroom_id': patient.waitingroom_id,
                                'total_string' : total_string,
                                'note': $("#note_output").html()
                            },
                            type: 'POST',
                            dataType: 'json',
                            success: function success(msg) {
                                $('#note_output_btn')[0].click();
                                //   var socket = io.connect('https://lighthouse.ddxrx.com:8080', {secure: true});
                                //  socket.emit('existingPatient', patient);
                            },
                            error: function error(msg) {
                                // console.log('error');
                            },
                        });
                    }
                });
            });
        });
	
	</script>
    
    <style type="text/css">
        body{
            top: 0px!important;
        }
        .goog-te-banner-frame.skiptranslate {
            display: none !important;
        }
        #goog-gt-tt{
            display:none!important;
        }
        #google_translate_element{
            position: fixed; left:20px; top: 20px; z-index: 9999999;
        }
    </style>
    
    <script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
</head>
<body class="graybg ddx_reports" data-user-id="<?php if( isset($_SESSION['patient_id']) ){ echo $_SESSION['patient_id']; } ?>" data-user_id="<?php echo $_SESSION['userid']; ?>" data-patient_id="<?php echo $_SESSION['patient_id']; ?>" data-patient_name="<?php echo $_SESSION['current_patient']['patient_name']; ?>" data-patient_phone="<?php echo $_SESSION['current_patient']['cell']; ?>">
    
    <div class="loading-screen"></div>
    
    <div id="google_translate_element"></div>
    
	<?php
	
	$user_id = $_SESSION['user_id'];
    $patient_id = $_POST['patient_id'];
    
    $_SESSION['have'] = array();
    $_SESSION['denied'] = array();
        
	if (isset($_POST['missing_dds'])){
		$sqlClientName="Select * from differential_diagnoses where name='".$_POST[missing_dds]."' limit 1";
		$resultClientName=mysqli_query(ddxrxDBConnect(), $sqlClientName);
		$rowClientName= mysqli_fetch_array($resultClientName);
		$clientID=$rowClientName['id'];
	}
	
	if(isset($_POST['symptoms'])) {
	    
	    unset($_SESSION['symptomsList']);
	    
	    $_SESSION['symptomsList'] = [];
	    
		if($_POST[symptoms][0]!='') {
			$_SESSION[symptoms_0]=$_POST[symptoms][0];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][0]);
		}else {
			$_SESSION[symptoms_0]='';
		}

		if($_POST[symptoms][1]!='') {
			$_SESSION[symptoms_1]=$_POST[symptoms][1];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][1]);
		} else {
			$_SESSION[symptoms_1]='';
		}

		if($_POST[symptoms][2]!='') {
			$_SESSION[symptoms_2]=$_POST[symptoms][2];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][2]);
		} else {
			$_SESSION[symptoms_2]='';
		}

		if($_POST[symptoms][3]!='') {
			$_SESSION[symptoms_3]=$_POST[symptoms][3];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][3]);
		} else {
			$_SESSION[symptoms_3]='';
		}

		if($_POST[symptoms][4]!='') {
			$_SESSION[symptoms_4]=$_POST[symptoms][4];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][4]);
		} else {
			$_SESSION[symptoms_4]='';
		}
		
		if($_POST[symptoms][5]!='') {
			$_SESSION[symptoms_5]=$_POST[symptoms][5];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][5]);
		} else {
			$_SESSION[symptoms_5]='';
		}
		
		if($_POST[symptoms][6]!='') {
			$_SESSION[symptoms_6]=$_POST[symptoms][6];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][6]);
		} else {
			$_SESSION[symptoms_6]='';
		}
		
		if($_POST[symptoms][7]!='') {
			$_SESSION[symptoms_7]=$_POST[symptoms][7];
			$_SESSION['symptomsList'][] = strtolower($_POST[symptoms][7]);
		} else {
			$_SESSION[symptoms_7]='';
		}

		include ('analytics.php');

		$ins_id = mysqli_insert_id(ddxrxDBConnect());

		$updateit = mysqli_query(ddxrxDBConnect(), "update visitor_info set is_search = '1' where id = '".$ins_id."' limit 1");

		for($kkk=0;$kkk<8;$kkk++) {
			if($_POST[symptoms][$kkk]!=''){
				$sires = mysqli_query(ddxrxDBConnect(), "insert into search_info set visitor_info_id = '".$ins_id."', dd_name = '".$_POST['symptoms'][$kkk]."'");
			}
		}
		
		$_SESSION['visitor_info_id'] = $ins_id;
	}
    
    
	$dateTime = date("Y-m-d H:i:s");
	$fb_id=$_SESSION['fb_id'];
	$send_fb_msg=$_SESSION['send_fb_msg'];
	$fbmsg="";

	if($_POST[symptoms][0]!='') {
		$fbmsg=$fbmsg."".$_POST[symptoms][0];
	}

	if($_POST[symptoms][1]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][1];
	}

	if($_POST[symptoms][2]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][2];
	}

	if($_POST[symptoms][3]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][3];
	}

	if($_POST[symptoms][4]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][4];
	}
	if($_POST[symptoms][5]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][5];
	}
	if($_POST[symptoms][6]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][6];
	}
	if($_POST[symptoms][7]!='') {
		$fbmsg=$fbmsg."; ".$_POST[symptoms][7];
	}
	//echo $fbmsg;
	if(isset($_POST[symptoms])) {
		$_SESSION[fbmsg]=$fbmsg;
	} else {
		$fbmsg=$_SESSION['fbmsg'];
	}
	
	if (isset($_POST['missing_dds'])) { 
		$dateTime = date("Y-m-d H:i:s");
		$sqlMsg1 = "INSERT INTO missing_ss_dd (ss,dd,user_id,date_time ) VALUES ('$_SESSION[fbmsg]','$_POST[missing_dds]','$user_id','$dateTime');";
		if (!mysqli_query(ddxrxDBConnect(), $sqlMsg1)) {
			die('Error: ' . mysqli_error());
		}
	}

	$sqlSearchz="INSERT INTO search_records (keywords,user_id,date_time) VALUES ('$_SESSION[fbmsg]','$_SESSION[user_id]','$dateTime');";

	if (!mysqli_query(ddxrxDBConnect(), $sqlSearchz)) {
		die('Error: ' . mysqli_error());
	}
	if ($_SESSION['logged_user'] != 'UserLoggedEddm') {
		// header("Location: index.php?msg=Not Logged In");
		// exit;
	}
	/*
	if(count(array_unique(array_filter($_POST[symptoms])))<count(array_filter($_POST[symptoms]))) {
		echo "Please do not put duplicate SS in the box";
		header("Location: search_dd.php?msg=Please do not put duplicate SS in the box");
		exit;
	}
    */
    
	$dateTime = date("Y-m-d H:i:s");
	
	if($_SESSION[symptoms_0]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_0]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_0];
		}
	}
    
	if($_SESSION[symptoms_1]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_1]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_1];
		}
	}
    
	if($_SESSION[symptoms_2]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_2]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_2];
		}
	}
	
	if($_SESSION[symptoms_3]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_3]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_3];
		}
	}
	
	if($_SESSION[symptoms_4]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_4]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_4];
		}
	}
	
	if($_SESSION[symptoms_5]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_5]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_5];
		}
	}
	
	if($_SESSION[symptoms_6]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_6]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_6];
		}
	}
	
	if($_SESSION[symptoms_7]!='') {
		$sqlSSz="Select id from symptoms where name='".$_SESSION[symptoms_7]."' limit 1";
		$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
		$rowSSz= mysqli_fetch_array($resultSSz);
		if($rowSSz['id']!='') {
			$ss[]=$rowSSz['id'];
		} else {
			$ssBlank[]=$_SESSION[symptoms_7];
		}
	}
	
	if (count($ss)==1) {
		echo "Please Select atleast 2 SS";
		header("Location: search_dd.php?msg=Please Select alleast 2 SS");
		exit;
	}

	$comma_separated_ss = implode(",", $ss);

	foreach (array_count_values($ssBlank) as $key => $value) {
		$sqlISsz="INSERT INTO pending_symptoms (name,created) VALUES ('$key','$dateTime');";
		if (!mysqli_query(ddxrxDBConnect(), $sqlISsz)) {
			die('Error: ' . mysqli_error());
		}
	}
	
	$resultDD= mysqli_query(ddxrxDBConnect(), "select count(differential_diagnose_id),differential_diagnose_id FROM symptoms_differential_diagnoses where symptom_id in (".$comma_separated_ss.") and deleted!='1' group by differential_diagnose_id order by count(differential_diagnose_id) desc,sequence_id");

	while($rowDD= mysqli_fetch_array( $resultDD )) {
		$sqlDDz="Select * from differential_diagnoses where id=$rowDD[1] limit 1";
		$resultDDz=mysqli_query(ddxrxDBConnect(), $sqlDDz);
		$rowDDz= mysqli_fetch_array($resultDDz);
		if($rowDD[0]>=5) {
			$fiveOrMoreDD[]=$rowDDz['name'];
		} else if($rowDD[0]==4) {
			$fourDD[]=$rowDDz['name'];
		} else if($rowDD[0]==3) {
			$threeDD[]=$rowDDz['name'];
		} else if($rowDD[0]==2) {
			$twoDD[]=$rowDDz['name'];
		} else {
			$onceDD[]= $rowDDz['name'];
		}
	}

	foreach ($onceDD as $key => $value) {

	}

	if ($fbmsg!='') {
		$_SESSION['ss']=$fbmsg;
	}
    
	?>
    
    <!--
    <div class="mobile-menu-container reports_page" data-vitals-encounter="<?php echo $_SESSION['current_patient']['waitingroom_id']; ?>">
        <ul class="left">
            <li><a href="javascript:;" class="search"><img src="assets/images/mobile-nav-icons/search.png"><span>Search</span></a></li>
            <li><a href="javascript:;" class="emr"><img src="assets/images/mobile-nav-icons/emr.png"><span>History</span></a></li>
            <li><a href="patient_chat.php" class="browse"><img src="assets/images/mobile-nav-icons/chat.png"><span>Chat</span></a></li>
            <li><a href="chat-bot.php"><img src="assets/images/mobile-icon/doctor.png" class="chat"><span>Doctor AI</span></a></li>
            <li><a href="javascript:;" class="upload_button"><img src="assets/images/mobile-nav-icons/camera-green.png" class="upload"><span>Upload</span></a></li>
            <li><a href="chat-bot.php" class="back-link"><img src="assets/images/mobile-nav-icons/home.png" class="back"><span>Home</span></a></li>
        </ul>
        <input type="file" id="symptom_photo" accept="image/*" capture="user" style="display:none">
    </div>
    -->
    
    <div class="bottom-navigation-menu">
        <a href="javascript:;" class="search"><img src="assets/images/mobile-nav-icons/search.png"><div><strong>Search</strong></div></a>
        <a href="javascript:;" class="emr"><img src="assets/images/mobile-nav-icons/emr.png"><div><strong>History</strong></div></a>
        <a href="patient_chat.php" class="browse"><img src="assets/images/mobile-nav-icons/chat.png"><div><strong>Chat</strong></div></a>
        <a href="chat-bot.php"><img src="assets/images/mobile-icon/doctor.png" class="chat"><div><strong>Doctor AI</strong></div></a>
        <a href="javascript:;" class="upload_button"><img src="assets/images/mobile-nav-icons/camera-green.png" class="upload"><div><strong>Upload</strong></div></a>
        <a href="default.php" class="back-link"><img src="assets/images/mobile-nav-icons/home.png" class="back"><div><strong>Home</strong></div></a>
        <a href="logout.php"><img src="assets/images/logout.png"><div><strong>Logout</strong></div></a>
    </div>

	<!-- Notice -->
	<div class="container">

		<div class="col-md-12">
			<div class="notice white">
				<p><strong style="font-weight: 700;">High Probability Differential Diagnoses List :</strong> <span><?php echo $_SESSION['ss']; ?></span></p>
			</div>
		</div>
        <div class="clear"></div>
        
	</div>
	<!-- Notice -->
    
    <!-- Probability Container -->
    <div class="container results_list_container mt-20">
        <div class="col-md-12">
        	<div class="probability-container">
        
        		<!--<h6 style="text-transform:unset; font-weight: 500">Click on the top diagnosis and answer all the questions</h6>-->
        		<div class="notice arrow-down" style="margin-top: 0px; margin-bottom: 20px; text-transform: uppercase; font-weight: 800">
				    <p><strong>Tap the top diagnosis</strong></p>
			    </div>
        
        		<?php
        		$counter = 0;
        		if (($fiveOrMoreDD[0]!='')or($fourDD[0]!='')or($threeDD[0]!='')or($twoDD[0]!='')) { ?>
        			<?php
        				//$counter = 0;
        				foreach ($fiveOrMoreDD as $key => $value) {
        					$sqlSSz="Select id from differential_diagnoses where name='".$value."' limit 1";
        					$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
        					$rowSSz= mysqli_fetch_array($resultSSz);
        					$resultDDQ = mysqli_query(ddxrxDBConnect(), "SELECT * FROM dd_questions where differential_diagnoses='$value' limit 1");
        					$countDDQ=mysqli_num_rows($resultDDQ);
        					$counter++;
        			?>
        
        			<div class="probability-list five <?php if( $countDDQ == 1 ){ echo 'dropdown'; } ?><?php if( $counter == '1' ){ echo ' show'; }else{ echo ' hide'; } ?>" id="dd_<?php echo $rowSSz['id']; ?>" data-diag-id="<?php echo $rowSSz['id']; ?>">
        				<?php if(isset($value)){ ?>
        				    <p class="hidden_instructions" style="display: none"><?php echo get_instructions($value); ?></p>
        				    <p class="if_you_have" style="display: none"><?php echo get_instructions($value, 'if_you_have'); ?></p>
        				    <p class="go_to" style="display: none"><?php echo get_instructions($value, 'go_to'); ?></p>
        				<?php } ?>
        				<div class="padded">
        					<div class="number"><span><?php echo $counter; ?></span></div>
        					<strong class="name"><?php echo $value; ?></strong>
        					<strong class="name_translated"><?php echo $value; ?></strong>
        					<strong class="status"><span id="status_id_<?php echo $rowSSz['id']; ?>" class="status"></span></strong>
        					<div class="clear"></div>
        				</div>
        
        				<!-- Options -->
        				<div class="options separated-by-border">
        					<div class="row">
        						<div class="option-space" id="content_dd_<?php echo $rowSSz['id']; ?>"></div>
        					</div>
        				</div>
        				<!-- Options -->
        
        			</div>
        
        			<?php } ?>
        						
        			<?php
        				//$counter = 0;
        				foreach ($fourDD as $key => $value) {
        				$sqlSSz="Select id from differential_diagnoses where name='".$value."' limit 1";
        				$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
        				$rowSSz= mysqli_fetch_array($resultSSz);
        				$resultDDQ = mysqli_query(ddxrxDBConnect(), "SELECT * FROM dd_questions where differential_diagnoses='$value' limit 1");
        				$countDDQ=mysqli_num_rows($resultDDQ);
        				$counter++;
        			?>
        
        			<div class="probability-list five <?php if( $countDDQ == 1 ){ echo 'dropdown'; } ?><?php if( $counter == '1' ){ echo ' show'; }else{ echo ' hide'; } ?>" id="dd_<?php echo $rowSSz['id']; ?>" data-diag-id="<?php echo $rowSSz['id']; ?>">
        				<?php if(isset($value)){ ?>
        				    <p class="hidden_instructions" style="display: none"><?php echo get_instructions($value); ?></p>
        				    <p class="if_you_have" style="display: none"><?php echo get_instructions($value, 'if_you_have'); ?></p>
        				    <p class="go_to" style="display: none"><?php echo get_instructions($value, 'go_to'); ?></p>
        				<?php } ?>
        				<div class="padded">
        					<div class="number"><span><?php echo $counter; ?></span></div>
        					<strong class="name"><?php echo $value; ?></strong>
        					<strong class="name_translated"><?php echo $value; ?></strong>
        					<strong class="status"><span id="status_id_<?php echo $rowSSz['id']; ?>" class="status"></span></strong>
        					<div class="clear"></div>
        				</div>
        
        				<!-- Options -->
        				<div class="options separated-by-border">
        					<div class="row">
        						<div class="option-space" id="content_dd_<?php echo $rowSSz['id']; ?>"></div>
        					</div>
        				</div>
        				<!-- Options -->
        
        			</div>
        		<?php } ?>
        
        		<?php
        			//$counter = 0;
        			foreach ($threeDD as $key => $value) { 
        			$sqlSSz="Select id from differential_diagnoses where name='".$value."' limit 1";
        			$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
        			$rowSSz= mysqli_fetch_array($resultSSz);
        			$resultDDQ = mysqli_query(ddxrxDBConnect(), "SELECT * FROM dd_questions where differential_diagnoses='$value' limit 1");
        			$countDDQ=mysqli_num_rows($resultDDQ);
        			$counter++;
        		?>
        			<div class="probability-list three <?php if( $countDDQ == 1 ){ echo 'dropdown'; } ?><?php if( $counter == '1' ){ echo ' show'; }else{ echo ' hide'; } ?>" id="dd_<?php echo $rowSSz['id']; ?>" data-diag-id="<?php echo $rowSSz['id']; ?>">
        			<?php if(isset($value)){ ?>
        				    <p class="hidden_instructions" style="display: none"><?php echo get_instructions($value); ?></p>
        				    <p class="if_you_have" style="display: none"><?php echo get_instructions($value, 'if_you_have'); ?></p>
        				    <p class="go_to" style="display: none"><?php echo get_instructions($value, 'go_to'); ?></p>
        				<?php } ?>
        			<div class="padded">
        				<div class="number"><span><?php echo $counter; ?></span></div>
        				<strong class="name"><?php echo $value; ?></strong>
        				<strong class="name_translated"><?php echo $value; ?></strong>
        				<strong class="status"><span id="status_id_<?php echo $rowSSz['id']; ?>" class="status"></span></strong>
        				<div class="clear"></div>
        			</div>
        
        			<!-- Options -->
        			<div class="options separated-by-border">
        				<div class="row">
        					<div class="option-space" id="content_dd_<?php echo $rowSSz['id']; ?>"></div>
        				</div>
        			</div>
        			<!-- Options -->
        
        		</div>
        
        	    <?php } ?>
        
            	<?php
            		//$counter = 0;
            		foreach ($twoDD as $key => $value) {
            			$sqlSSz="Select id from differential_diagnoses where name='".$value."' limit 1";
            			$resultSSz=mysqli_query(ddxrxDBConnect(), $sqlSSz);
            			$rowSSz= mysqli_fetch_array($resultSSz);
            			$resultDDQ = mysqli_query(ddxrxDBConnect(), "SELECT * FROM dd_questions where differential_diagnoses='$value' limit 1");
            			$countDDQ=mysqli_num_rows($resultDDQ);
            			$counter++;
            	?>
        
        		<div class="probability-list high <?php if( $countDDQ == 1 ){ echo 'dropdown'; } ?><?php if( $counter == '1' ){ echo ' show'; }else{ echo ' hide'; } ?>" id="dd_<?php echo $rowSSz['id']; ?>" data-diag-id="<?php echo $rowSSz['id']; ?>">
        			<?php if(isset($value)){ ?>
        				<p class="hidden_instructions" style="display: none"><?php echo get_instructions($value); ?></p>
        				<p class="if_you_have" style="display: none"><?php echo get_instructions($value, 'if_you_have'); ?></p>
        				<p class="go_to" style="display: none"><?php echo get_instructions($value, 'go_to'); ?></p>
        			<?php } ?>
        			<div class="padded">
        				<div class="number"><span><?php echo $counter; ?></span></div>
        				<strong class="name"><?php echo $value; ?></strong>
        				<strong class="name_translated"><?php echo $value; ?></strong>
        				<strong class="status"><span id="status_id_<?php echo $rowSSz['id']; ?>" class="status"></span></strong>
        				<div class="clear"></div>
        			</div>
        
        			<!-- Options -->
        			<div class="options separated-by-border">
        				<div class="row">
        					<div class="option-space" id="content_dd_<?php echo $rowSSz['id']; ?>"></div>
        				</div>
        			</div>
        			<!-- Options -->
        
        		</div>
        						
        	    <?php } ?>
        
        
            	<?php
            		if (isset($_POST['missing_dds'])) {
            			echo '<li style="background-color:#D2EAF7;" data-theme="i">';
            
            			$resultssd= mysqli_query(ddxrxDBConnect(), "SELECT * FROM dd_questions WHERE differential_diagnoses='".$_POST[missing_dds]."' limit 1");
            			$countssd=mysqli_num_rows($resultssd);
            			if ($countssd>0) {
            				echo "<a href=decision_support.php?dd_id=$clientID data-theme=f data-ajax=false> " ;
            			}
            			echo $_POST[missing_dds]; 
            			if ($countssd>0) {
            				echo "</a>";
            			}
            			echo '</li>';
            		}
            			?>
            	</ul>
                <?php //} ?>
        
                <?php 
                } else {
                	echo '
                	    <div class="nothing-found-diagnosis">
                	    <img src="assets/images/exclamation-mark.png">
                	    <p>Please click on the back to the search button. And enter more symptoms in search boxes using human body system icons.</p>
                	    <a href="javascript:;" onclick="goBack()" class="button large rounded solid blue back-to-search">Back to Search</a>
                	    </div>
                	    ';
                }
                ?>
        
        
        	    <div class="more-diagnosis-container"></div>
        	    <div class="mb-20"></div>
        
        	    <!--<a href="javascript:;" id="add_differential_diagnoses" style="float: left;">Add Differential Diagnoses</a>-->
        
            	<label>
            		<span style="font-weight: 600; font-size: 14px; margin-bottom: 10px;">Add Differential Diagnoses</span>
            		<div style="position: relative!important; width: 100%; display: block;" class="add-more-diagnosys-container">
            			<a href="javascript:;" class="button large rounded solid blue enter-diagnosis" style="position:absolute!important">Add to list</a>
            			<input type="text" class="textbox diagnosis-text ac_input">
            		</div>
            	</label>
        
            	<div class="clear"></div>
            	<div class="mb-10"></div>
        	</div>
        	<div class="clear"></div>
        </div>
        
        <!-- Submit to doctor button -->
        <div class="col-md-12 mb-20">
            <?php
		    $userid=$_SESSION['userid'];
            $active_query = "Select stripe_subscription_isactive from  patients where user_id=$userid";
            $active_resul = mysqli_query(ddxrxDBConnect(), $active_query);
            $active = mysqli_fetch_array($active_resul);
            ?>
            
            <!--
		    <?php if( $active['stripe_subscription_isactive'] == '1' ){ ?>
			    <a href="javascript:;" id="save_and_connect" class="button solid rounded green medium note_button_new" style="float: right;">Submit to doctor</a>
			<?php }elseif( $active['stripe_subscription_isactive'] == '0' ){ ?>
			    <a href="javascript:;" id="save_and_connect" class="button solid rounded yellow medium note_button_new" style="float: right;">Subscribe</a>
			<?php } ?>
			-->
			
			<?php if( $active['stripe_subscription_isactive'] == '1' ){ ?>
			
			    <a href="javascript:;" id="save_and_connect" class="button solid rounded green medium note_button_new" style="float: right;">Submit to doctor</a>
			    
			<?php }elseif( $active['stripe_subscription_isactive'] != 0 || free_trial() == 'true' ){ ?>
			
			    <a href="javascript:;" id="save_and_connect" class="button solid rounded green medium note_button_new" style="float: right;">Submit to doctor</a>
			
			<?php }elseif( $active['stripe_subscription_isactive'] != 0 || free_trial() == 'false' ){ ?>
			    
			    <a href="javascript:;" class="button solid rounded green medium note_button_new save_and_connect_button" style="float: right;">Submit to doctor</a>
			    
			<?php }else{ ?>
			
			    <a href="javascript:;" class="button solid rounded green medium note_button_new save_and_connect_button" style="float: right;">Submit to doctor</a>
			    
			<?php } ?>
			
			<div class="clear"></div>
        </div>
        <div class="clear"></div>
        <!-- Submit to doctor button -->
		
		<!-- Low Probability List -->
        <div class="col-md-12">
            <div class="low-probability-list hide">
            	<h6><a href="javascript:;">Low Probability Differential Diagnoses List</a></h6>
            	<div class="inner">
            		<ul>
                        <?php foreach ($onceDD as $key => $value) { ?>
                            <li><?php echo $value;?></li>
                        <?php }?>
            		</ul>
            		<div class="clear"></div>
            	</div>
            </div>
        </div>
        <div class="clear"></div>
		<!-- Low Probability List -->
        
        <!-- Probability and results -->
		<div class="col-md-12">
            
            <a href="javascript:;" id="showResults" class="button solid rounded gray medium mt-20 disabled">Treatment for Education</a>
            
			<!--<a href="javascript:;" class="button solid rounded blue medium back-to-search" style="float: right; width: 100%; margin-top: 10px; text-align: center;">Back to Doctor AI</a>-->
            
			<!-- Results Container -->
			<div class="clear"></div>
			<div class="results-main-container hidden">
			    <!-- Results will be here -->
			</div>
			<!-- Results Container -->

		</div>
		<!-- Probability and results -->
        
    </div>
    <!-- Probability Container -->
    
	<!-- Main Container -->
	<div class="container mt-50 mb-50">

		<!-- Symptoms Details -->
		<div class="col-md-12 symptom-details" style="display:none">
			<div class="row">

				<div class="col-xs-2">
					<div class="item doctor" data-item="1"><div class="inner">Meningitis</div></div>
				</div>

				<div class="col-xs-2">
					<div class="item stetoscope" data-item="2"><div class="inner">Subarachnoid Hemorrhage</div></div>
				</div>

				<div class="col-xs-2">
					<div class="item injection" data-item="3"><div class="inner">Glaucoma</div></div>
				</div>

				<div class="col-xs-2">
					<div class="item case" data-item="4"><div class="inner">Uremia</div></div>
				</div>

				<div class="col-xs-2">
					<div class="item heart" data-item="5"><div class="inner">Hypoglycemia</div></div>
				</div>

				<div class="col-xs-2">
					<div class="item cross" data-item="6"><div class="inner">Cerebrovascular Accident ( CVA )</div></div>
				</div>

				<div class="clear"></div>

				<!-- Item -->
				<div class="symptom-item symptom-1">
					<div class="col-xs-12">
						<div class="inner">
							<h6>Meningitis</h6>
							<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer ipsum urna, consequat eu efficitur quis, accumsan a ligula. Suspendisse potenti. Mauris id rutrum ante. Praesent lacinia velit nec rhoncus tempus. Etiam ac fringilla dui, vel bibendum urna. Nulla viverra ante non sapien interdum, nec venenatis purus egestas. Fusce vehicula et mauris tincidunt pulvinar. Donec condimentum blandit quam. Aenean eget lacus ut felis dignissim porttitor ac vel libero. Phasellus semper felis id quam maximus elementum. Duis ultricies hendrerit tellus, id dignissim justo cursus nec. Nam dapibus aliquet gravida. Nunc venenatis feugiat dictum.</p>
						</div>
					</div>
					<div class="clear"></div>
				</div>
				<!-- Item -->

				<!-- Item -->
				<div class="symptom-item symptom-2">
					<div class="col-xs-12">
						<div class="inner">
							<h6>Subarachnoid Hemorrhage</h6>
							<p>Etiam at mauris rutrum, eleifend metus ac, pulvinar dui. Pellentesque pulvinar ligula vitae libero molestie accumsan. Sed id aliquam erat, vel lacinia quam. Nam aliquam sodales magna, ac sagittis nulla congue sed. Ut scelerisque a leo nec lobortis. Nam pharetra ullamcorper erat, non tincidunt lectus pharetra sit amet.</p>
						</div>
					</div>
					<div class="clear"></div>
				</div>
				<!-- Item -->

				<!-- Item -->
				<div class="symptom-item symptom-3">
					<div class="col-xs-12">
						<div class="inner">
							<h6>Glaucoma</h6>
							<p>Mauris non elementum neque, a viverra purus. Nulla molestie, arcu ut blandit imperdiet, libero felis ullamcorper dui, sit amet convallis elit ipsum ac mi. Mauris nisi arcu, faucibus id luctus ut, dapibus et ipsum. Maecenas id arcu sollicitudin, dictum tortor nec, consequat orci. Ut aliquam consectetur rutrum. Pellentesque accumsan eget lorem in condimentum.</p>
						</div>
					</div>
					<div class="clear"></div>
				</div>
				<!-- Item -->

				<!-- Item -->
				<div class="symptom-item symptom-4">
					<div class="col-xs-12">
						<div class="inner">
							<h6>Uremia</h6>
							<p>Vivamus pharetra erat nec tortor lacinia, ac scelerisque mauris viverra. Vivamus luctus sed enim fermentum sodales. Praesent dapibus, diam eu vestibulum lobortis, sapien nunc elementum felis, ac euismod massa enim at nunc. Vestibulum et finibus eros, at lobortis metus. Sed eget elit varius, tincidunt ante quis, hendrerit nunc. Ut nisi eros, viverra nec est nec, gravida venenatis dolor. Sed sit amet velit ultricies, egestas turpis a, vehicula ex. Cras congue mollis mauris ut varius. Morbi eu erat nunc.</p>
						</div>
					</div>
					<div class="clear"></div>
				</div>
				<!-- Item -->

				<!-- Item -->
				<div class="symptom-item symptom-5">
					<div class="col-xs-12">
						<div class="inner">
							<h6>Hypoglycemia</h6>
							<p>Aliquam rutrum pretium lorem, ac vestibulum justo lobortis in. Morbi euismod efficitur quam ac mollis. Aenean sit amet ligula a velit varius eleifend quis sit amet elit. Maecenas rhoncus, dolor ac vehicula porta, leo massa consequat nisi, quis congue orci purus congue massa. Nam vel pulvinar tellus, eget finibus orci. Sed non volutpat purus, non ultrices nisi.</p>
						</div>
					</div>
					<div class="clear"></div>
				</div>
				<!-- Item -->

				<!-- Item -->
				<div class="symptom-item symptom-6">
					<div class="col-xs-12">
						<div class="inner">
							<h6>Cerebrovascular Accident ( CVA )</h6>
							<p>Nunc eu felis ultricies, fringilla libero eget, faucibus ex. Vestibulum iaculis eros ac nibh fringilla, sit amet facilisis mi scelerisque. Proin nec arcu sodales, molestie lacus non, lobortis justo. Nullam rutrum porttitor velit ut consectetur. Maecenas elit dui, rutrum vel quam quis, venenatis suscipit lectus. Praesent non felis aliquet, eleifend tortor vitae, sagittis lacus. Quisque sit amet blandit lectus. Etiam sit amet posuere erat. Aliquam suscipit neque ut facilisis fringilla.</p>
						</div>
					</div>
					<div class="clear"></div>
				</div>
				<!-- Item -->

			</div>
		</div>
		<div class="clear"></div>
		<!-- Symptoms Details -->

		<!-- Search Form -->
		<div class="search-form-container">
		    <div class="col-md-12">
    			<div class="anatomy-form">
    				<h3 class="title">Add more signs & symptoms <span style="font-size: 13px; font-weight: 400;">by clicking the green arrow</span></h3>
                    
    				<div class="inner">
    				    <form id="formddX" name="formddX" method="post" action="ddx_reports.php" data-ajax="false" onSubmit="return search(event);">
        					<label><span>Enter First Symptom</span>
        						<input type="text" name="symptoms[0]" placeholder="Type to search" class="textbox symptom-search-1 symptoms_search_box ac_input" id="symptoms_0" value="<?php echo $_POST[symptoms][0]; ?>">
        					</label>
        
        					<label>
        						<span>Enter Second Symptom</span>
        						<input type="text" name="symptoms[1]" placeholder="Type to search" class="textbox symptom-search-2 symptoms_search_box ac_input" id="symptoms_1" value="<?php echo $_POST[symptoms][1]; ?>">
        					</label>
        
        					<label>
        						<span>Enter Third Symptom</span>
        						<input type="text" name="symptoms[2]" placeholder="Type to search" class="textbox symptom-search-3 symptoms_search_box ac_input" id="symptoms_2" value="<?php echo $_POST[symptoms][2]; ?>">
        					</label>
        
        					<label>
        						<span>Enter Fourth Symptom</span>
        						<input type="text" name="symptoms[3]" placeholder="Type to search" class="textbox symptom-search-4 symptoms_search_box ac_input" id="symptoms_3" value="<?php echo $_POST[symptoms][3]; ?>">
        					</label>
        
        					<label data-position="left" data-step="4" data-intro="If you add new symptoms in the search boxes...">
        						<span>Enter Fifth Symptom</span>
        						<input type="text" name="symptoms[4]" placeholder="Type to search" class="textbox symptom-search-5 symptoms_search_box ac_input" id="symptoms_4" value="<?php echo $_POST[symptoms][4]; ?>">
        					</label>
        					
        					<?php if( $_POST[symptoms][5] ){ ?>
        					    <label data-position="left" data-step="5" data-intro="If you add new symptoms in the search boxes...">
            						<span>Enter Sixth Symptom</span>
            						<input type="text" name="symptoms[5]" placeholder="Type to search" class="textbox symptom-search-5 symptoms_search_box ac_input" id="symptoms_5" value="<?php echo $_POST[symptoms][5]; ?>">
            					</label>
        				    <?php } ?>
        				    
        				    <?php if( $_POST[symptoms][6] ){ ?>
        					    <label data-position="left" data-step="6" data-intro="If you add new symptoms in the search boxes...">
            						<span>Enter Seventh Symptom</span>
            						<input type="text" name="symptoms[6]" placeholder="Type to search" class="textbox symptom-search-6 symptoms_search_box ac_input" id="symptoms_6" value="<?php echo $_POST[symptoms][6]; ?>">
            					</label>
        				    <?php } ?>
        				    
        				    <?php if( $_POST[symptoms][7] ){ ?>
        					    <label data-position="left" data-step="7" data-intro="If you add new symptoms in the search boxes...">
            						<span>Enter Eighth Symptom</span>
            						<input type="text" name="symptoms[7]" placeholder="Type to search" class="textbox symptom-search-7 symptoms_search_box ac_input" id="symptoms_7" value="<?php echo $_POST[symptoms][7]; ?>">
            					</label>
        				    <?php } ?>
        				    
        				    <?php if( $_POST[symptoms][8] ){ ?>
        					    <label data-position="left" data-step="8" data-intro="If you add new symptoms in the search boxes...">
            						<span>Enter Ninth Symptom</span>
            						<input type="text" name="symptoms[8]" placeholder="Type to search" class="textbox symptom-search-8 symptoms_search_box ac_input" id="symptoms_8" value="<?php echo $_POST[symptoms][8]; ?>">
            					</label>
        				    <?php } ?>
        				    
        				    <?php if( $_POST[symptoms][9] ){ ?>
        					    <label data-position="left" data-step="9" data-intro="If you add new symptoms in the search boxes...">
            						<span>Enter Tenth Symptom</span>
            						<input type="text" name="symptoms[9]" placeholder="Type to search" class="textbox symptom-search-9 symptoms_search_box ac_input" id="symptoms_9" value="<?php echo $_POST[symptoms][9]; ?>">
            					</label>
        				    <?php } ?>
    
        					<div class="more-search-field"></div>
        
        					<a href="javascript:;" class="add-more">+ Add More</a>
        
        					<div class="pt-10">
        						<button type="submit" class="button large solid round blue" id="redo" data-position="left" data-step="5" data-intro="Then click search again to regenerate a new list of differential diagnoses">Re-do Search</button>
        						&nbsp;
        						<a href="#" class="button large solid round gray reset">Reset Form</a>
        						<div class="clear"></div>
        					</div>
        					<input type="hidden" name="user_id" value="<?php echo $_POST['user_id']; ?>">
    					</form>
    				</div>
    			
    			</div>
			</div>
			<div style="width: 100%; height: 50px;"></div>
		</div>
		<!-- Search Form -->

		<!-- Patient History -->
		<div class="medical-history">
		    <div class="col-md-12">
			    <div class="scroll-containers">

				<div class="vitals-container encounter_id" data-vitals-encounter="<?php echo $_SESSION['current_patient']['waitingroom_id']; ?>" style="margin-bottom: 20px;">
					<h6>Add Vital Signs</h6>
					<div class="inner">
						<?php //get_user_vitals(); ?>
						
                        <?php foreach($vitalFields as $field) { ?>
                            <?php $label = $field['fieldLable']; ?>
                            <?php $name = $field['fieldName']; ?>
    						<label>
    							<span><?php echo $label; ?></span>
    							<input type="text" class="textbox vitals ac_input" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
    						</label>
                        <?php } ?>
					    <button class="button large rounded solid blue" id="saveVitals">SAVE</button>
					</div>
				</div>

				<div class="diagnosis-container" data-id="<?php echo $_GET['id']; ?>">
					<h6>Add your history</h6>
					<div class="inner">
						
						<div class="item">
							<p data-hintPosition="top-centered-right">Medical History</p>
							<div class="desc">
								<?php echo medical_diagnosis(); ?>
								<div class="dynamical_entry medical"></div>
								<input type="text" class="textbox txt_medical ac_input symptoms_search_box">
								<a href="javascript:;" class="button add_medical">Add New</a>
							</div>
						</div>

						<div class="item">
							<p>Surgical History</p>
							<div class="desc">
								<?php echo surgical_diagnosis(); ?>
								<div class="dynamical_entry surgical"></div>
								<input type="text" class="textbox txt_surgical ac_input symptoms_search_box">
								<a href="javascript:;" class="button add_surgical">Add New</a>
							</div>
						</div>

						<div class="item">
							<p>Social History</p>
							<div class="desc">
								<?php //echo social_diagnosis(); ?>

								<label>
									Tobacco
									<select class="selectbox social-status" name="tobaco">
										<option value="current" <?php current_social_record('tobaco','current'); ?>>Current</option>
										<option value="prior" <?php current_social_record('tobaco','prior'); ?>>Prior</option>
										<option value="never" <?php current_social_record('tobaco','never'); ?>>Never</option>
									</select>
								</label>

								<label>
									Alcohol
									<select class="selectbox social-status" name="alcohol">
										<option value="never" <?php current_social_record('alcohol','never'); ?>>Never</option>
										<option value="prior" <?php current_social_record('alcohol','prior'); ?>>Prior</option>
										<option value="occasional" <?php current_social_record('alcohol','occasional'); ?>>Occasional</option>
										<option value="daily" <?php current_social_record('alcohol','daily'); ?>>Daily</option>
									</select>
								</label>

								<label>
									Illicit Drug
									<select class="selectbox social-status" name="drugs">
										<option value="yes" <?php current_social_record('drugs','yes'); ?>>Yes</option>
										<option value="no" <?php current_social_record('drugs','no'); ?>>No</option>
									</select>
								</label>

								<label>
									Occupation
									<select class="selectbox social-status" name="occupation">
										<option value="unemployed" <?php current_social_record('occupation','unemployed'); ?>>Unemployed</option>
										<option value="employed" <?php current_social_record('occupation','employed'); ?>>Employed</option>
									</select>
								</label>

								<label>
									Prison History
									<select class="selectbox social-status" name="prison">
										<option value="yes" <?php current_social_record('prison','yes'); ?>>Yes</option>
										<option value="no" <?php current_social_record('prison','no'); ?>>No</option>
									</select>
								</label>

								<label>
									Recent Travel
									<select class="selectbox social-status" name="travel">
										<option value="yes" <?php current_social_record('travel','yes'); ?>>Yes</option>
										<option value="no" <?php current_social_record('travel','no'); ?>>No</option>
									</select>
								</label>

								<label>
									Exercise
									<select class="selectbox social-status" name="exercise">
										<option value="yes" <?php current_social_record('exercise','yes'); ?>>Yes</option>
										<option value="no" <?php current_social_record('exercise','no'); ?>>No</option>
									</select>
								</label>

								<label>
									Firearms in household
									<select class="selectbox social-status" name="firearms">
										<option value="yes" <?php current_social_record('firearms','yes'); ?>>Yes</option>
										<option value="no" <?php current_social_record('firearms','no'); ?>>No</option>
									</select>
								</label>

							</div>
						</div>

						<div class="item">
							<p>Family History</p>
							<div class="desc">
								
								<?php echo family_diagnosis(); ?>

								<div class="dynamical_entry family"></div>
								<input type="text" class="textbox txt_family ac_input symptoms_search_box">
								<a href="javascript:;" class="button add_family">Add New</a>

							</div>
						</div>

						<div class="item">
							<p>Allergies</p>
							<div class="desc">
								
								<?php echo allergy_history(); ?>

								<div class="dynamical_entry allergy"></div>
								<input type="text" class="textbox txt_allergy ac_input symptoms_search_box">
								<a href="javascript:;" class="button add_allergy">Add New</a>

							</div>
						</div>

						<div class="item">
							<p>Medications</p>
							<div class="desc">
								
								<?php echo medication_history(); ?>

								<div class="dynamical_entry medication"></div>
								<input type="text" class="textbox txt_medication ac_input symptoms_search_box">
								<a href="javascript:;" class="button add_medication">Add New</a>
								
							</div>
						</div>


					</div>
				</div>

			</div>
			</div>
		</div>
		<!-- Patient History -->

		<div class="clear"></div>
	</div>
	<!-- Main Container -->
    
    <script>
        
        function sendDiagnosis(){
            
            $(".probability-list.show.closed").removeClass('show');
            
            var diagnosis_id = $('.probability-list.show').data('diag-id');
            var patient_id = $('body').data('patient_id');
            var user_id = $('body').data('user_id');
            
            var JsonData = {
                "diagnosis_id" : ''+diagnosis_id+'',
                "patient_id" : ''+user_id+''
            };
    		
    		$.ajax({
    		    url: 'process/api-data.php?target=diagnose',
                type: "POST",
                data: JSON.stringify(JsonData),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                
                beforeSend: function() {},
                success: function(data){},               
                failure: function(errMsg) {}
            
            });
            
        }
        
        // Call function to send diagnosis to API
        sendDiagnosis();
		
        setInterval(function(){

            var user_id = $('body').data('user_id');
            
            $.ajax({
        		type: 'POST',
        		url: 'process/check_speech.php',
        		data: {
        			user_id:user_id,
        		},
        		
        		beforeSend: function(){
        		    // Do something
        		},
        			
        		success: function(response){
        	        
        	        if( response.result == true ){
        	            
        	            var response_ans = response.text.toLowerCase();
        	            
        	            // Mark each question as yes/no
        	            if( response.type == 'type_3' && response.text == 'yes' ){
        	            
            	            $(".probability-list label .button").each(function(){
                                
                                var buttonID = $(this).data('button-id');
                                
                                if( buttonID == response.question_id ){
                                    $(this).click();
                                }
                                
                            });
            	            
        	            // Submit diagnosis
        	            }else if( response.type == 'type_5' ){
        	                
        	                var question_id = response.question_id;
        	                
        	                $(".probability-list").each(function(){
        	                    
        	                    if( $(this).data('diag-id') == question_id ){
        	                        
        	                        $('#dd_'+question_id+' .save_answers').click();
        	                        
        	                    }
        	                    
        	                });
        	            
        	            // Click Yes/No for sweet alert or Redo sweet alert
        	            }else if( response.type == 'type_7' ){
        	                
        	                var title = $('#swal2-title').html();
        	                
        	                // If sweet alert is asking to redo search
        	                if( title == 'New Symptom added' ){
        	                    
        	                    if( response_ans == 'proceed' || response_ans == 'yes' ){
        	                        $('.swal2-confirm').click();
        	                    }else{
        	                        $('.swal2-cancel').click();
        	                    }
        	                }else if( title == 'Symptoms match the diagnosis' ){
        	                    if( response_ans == 'proceed' || response_ans == 'yes' ){
        	                        $('.swal2-cancel').click();
        	                    }else{
        	                        $('.swal2-confirm').click();
        	                    }
        	                }
        	            
        	            // Proceed to treatment sweet alert
        	            }else if( response.type == 'type_8' ){
        	                
        	                /*
        	                if( response_ans == 'proceed' || response_ans == 'yes' ){
        	                    $('.swal2-confirm').click();
        	                }else{
        	                    $('.swal2-cancel').click();
        	                }
        	                */
        	                
        	                if( response_ans == 'proceed' || response_ans == 'yes' ){
        	                    $('.swal2-cancel').click();
        	                }else{
        	                    $('.swal2-confirm').click();
        	                }
        	                
        	            // Click "Next Diagnosis" button for sweet alert(It only has one option)
        	            }else if( response.type == 'type_9' ){
        	                
        	                $('.swal2-confirm').click();
        	                
        	            }else if( response.type == 'type_10' ){
        	                
        	                if( response_ans == 'proceed' || response_ans == 'yes' ){
        	                    $('.swal2-confirm').click();
        	                }else{
        	                    $('.swal2-cancel').click();
        	                }
        	            }else if( response.type == 'type_11' ){
        	                
        	                if( response_ans == 'proceed' || response_ans == 'yes' ){
        	                    $('.swal2-confirm').click();
        	                }else{
        	                    $('.swal2-cancel').click();
        	                }
        	            }else if( response.type == 'type_12' ){
        	                window.location.replace("chat-bot.php");
        	            }
        	           // else if( response.type == 'type_14' ){
                        
                    //         var newOptions = JSON.parse( response.options );
                            
        	           //     if( newOptions.result == true ){
        	                    
        	           //         for( var i = 0; i<newOptions.diagnosis.length; i++ ){
        	                        
        	           //             $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="'+newOptions.diagnosis[i]+' follow-up">');
        	                        
        	           //         }
        	                    
        	           //         $('#formddX').attr('action', 'ddx_reports_followup.php')
        	           //         $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="Follow-up Visit">');
        	           //         $('#formddX').submit();
        	           //     }
        	                
        	           // }
        	            
        	        }
        	        
        		},
        		
        		fail: function(response){
        		    // Do something
        		},
        		
        	});
            
        }, 1000);
        
        /* ================================================== */
        // Send signal to installer once every 10 seconds
        // to indicate that the page is still active
        /* ================================================== */
        // setInterval(function(){
                
        //     var user_id = $('body').data('user_id');
        //     var patient_name = $('body').data('patient_name');
        //     var today = new Date();
                
        //     var payload = {
        //         message:{
        //             CustomerId: user_id,
        //             CustomerName: patient_name,
        // 		    IsBroadCastMessage: "False",
        // 		        MessageContent: {
        // 		            status: "open",
        //         			created_at: today
        // 		        },
        // 		        MessageType: "PhpHealthCheck",
        //             },
        //             response:"true"
        //         };
                
        //     var output = JSON.stringify(payload);
                
        //     $.ajax({
        //     	type: 'POST',
        //     	url: 'https://ddxrx.ai/broker',
        //     	data: JSON.stringify(payload),
        //         contentType: "application/json; charset=utf-8",
        //         dataType: "json",
        //     	beforeSend: function(){
        //     	    // Do something
        //     	},
            			
        //     	success: function(response){
        //             // Do something
        //     	},
            		
        //     	fail: function(response){
        //     	    // Do something
        //     	},
            		
        //     });
            
        // }, 10000);
		
    </script>
    
    <script type="text/javascript" src="assets/js/autocomplete.js"></script>
    
</body>
</html>