<?php

    session_start();

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }

    // Include function file
    include('process/functions.php');

?>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Dictation Dashboard</title>

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dictation-dashboard.css">

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="assets/js/dictation-dashboard.js"></script>
    </head>
    <body>

        <div class="dictation-container">

            <a href="dashboard.php" class="back-button"><ion-icon name="arrow-back-outline"></ion-icon> Go Back</a>

            <table class="dictation-table">
                <thead>
                    <tr>
                        <td>Patient Name</td>
                        <td>Physician</td>
                        <td>Note Type</td>
                        <td>Date</td>
                        <td>Action</td>
                    </tr>
                </thead>

                <tbody>

                    <?php
                        $sql = "SELECT notes_dictation.id, notes_dictation.dictation_id, notes_dictation.patient_id, notes_dictation.unique_id, notes_dictation.note_type, notes_dictation.date, CONCAT(patients.patient_fname, ' ', patients.patient_lname) AS patient_name FROM notes_dictation INNER JOIN patients ON patients.patient_id = notes_dictation.patient_id GROUP BY notes_dictation.dictation_id order by id desc";
                        $result = ddxrxDBConnect()->query($sql);

                        if ($result->num_rows > 0) {
                            while($row = $result->fetch_assoc()) {

                                echo '<tr id="room_no_'.$row['id'].'">';
                                echo "<td>".$row['patient_name']."</td>";
                                echo "<td>".$row['unique_id']."</td>";
                                echo "<td>".$row['note_type']."</td>";
                                echo "<td>".$row['date']."</td>";
                                echo '<td><a href="view_patient.php?id='.$row['id'].'" class="view-button">View Notes</td>';
                                echo "</tr>";
                                
                            }
                        }
                        ddxrxDBConnect()->close();
                    ?>

                <tbody>

            </table>
        </div>

    </body>
</html>