<?php
session_start();
include('includes/database_include.php');

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: provider_login.php");
    die();
}

$patient_id = null;
if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
    $patient_id = $_SESSION['patient_id'];
} else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
    $patient_id = $_GET['id'];
}
if($patient_id != null) {
    
    $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id' LIMIT 1";
    $result = mysqli_query($con, $sql) or die('SQL Error :: '.mysqli_error());
    $user = mysqli_fetch_assoc($result);
    
    function progress_notes($patient_id) {
    	$sql = "SELECT * FROM waiting_room left join patients ON waiting_room.patient_id = patients.patient_id left join physician ON waiting_room.physician_id = physician.id WHERE patients.patient_id = '$patient_id' AND waiting_room.note_selection_json != '' ORDER BY waiting_room.checkin_time desc";
    	$result = mysqli_query($con, $sql);
        
    	echo '
    	<table class="patient-notes">
    		<thead>
    			<tr>
    				<td>Type</td>
    				<td>Provider</td>
    				<td>Date of Service</td>
    			</tr>
    		</thead>
    									  
    		<tbody>
    	';
    	if (mysqli_num_rows($result) > 0) {
    	    // output data of each row
    	    while($row = mysqli_fetch_array($result)) {
    	    	echo '<tr id="record_'.$row["id"].'">';
    	        echo '<td><a target="_blank" href="view_saved_note.php?wID='.$row["waitingroom_id"].'&pID='.$patient_id.'">Progress Note</a></td>';
    			echo '<td>'.$row["physician_fname"].' '.$row["physician_lname"].'</td>';
    			echo '<td>'.date_format(date_create($row['checkin_time']),"M/d/Y").'</td>';
    			echo '</tr>';
    	    }
    
    	echo '
    		</tbody>
    	</table>
    	';
    
    	} else {
    	    echo '<p style="margin-top: 50px;">0 results</p>';
    	}
    }
    ?>
    
    <!DOCTYPE html>
    <html class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX - Encounter</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script type="text/javascript" src="assets/js/jquery.slicknav.js"></script>
            <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
            <script type="text/javascript" src="assets/js/ckeditor.js"></script>
            <script type="text/javascript" src="assets/js/progress_note.js"></script>
            <script type="text/javascript" src="assets/js/admin.js"></script>
            <script type="text/javascript" src="assets/js/init.js"></script>
            <script type="text/javascript" src="assets/js/general-ui.js"></script>
            <script type="text/javascript" src="assets/js/mobile.js"></script>
            
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
            <link rel="stylesheet" type="text/css" href="assets/css/slicknav.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/general-ui.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            
            <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
            
            <!-- Global site tag (gtag.js) - Google Analytics -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
            <script>
              window.dataLayer = window.dataLayer || [];
              function gtag(){dataLayer.push(arguments);}
              gtag('js', new Date());
            
              gtag('config', 'UA-148409281-5');
            </script>
            
        </head>
        <body data-user-id="<?php echo $patient_id; ?>">
            
            <div class="loading-screen"></div>
            
            <div id="google_translate_element"></div>
            
            <?php include('dashboard_menu.php'); ?>
            
    
            <div class="container pb-100 optimized-container"<?php if( $patient_id != null ){ echo ' data-user="'.$patient_id.'"'; } ?>>
                <div class="col-md-12">
                    <div id="toPrint">
                        <div class="form-container">
    
    						<ul class="patient-information">
    		                    <li><strong>Name: </strong> <span><?php echo $user['patient_fname'].' '.$user['patient_lname']; ?></span></li>
    		                    <li><strong>Date and Birth: </strong><?php echo $user['patient_dob']; ?></li>
    		                    <li><strong>Address: </strong><?php //echo $user['patient_dob']; ?></li>
    		                    <li><strong>Cell: </strong><?php echo $user['cell']; ?></li>
    		                    
    		                    <li class="nav closed">
    		                        <a href="javascript:;"><img src="assets/images/menu-dot.png"></a>
    		                        <ul class="sub-menu">
    		                            <li><a href="javascript:;" class="action view-all">View Notes</a></li>
    		                            <li><a href="javascript:;" class="action add-new">Add New Note</a></li>
    		                            <li><a href="javascript:;" class="action add-template">Add Note Template</a></li>
    		                        </ul>
    		                    </li>
    		                    
    	                    </ul>
    	                    <div class="clear"></div>
                            
                            <div class="editor-container">
                                <!--
                                <div id="editor">
                                    <p>Here goes the initial content of the editor.</p>
                                </div>
                                -->
                                <textarea name="content" id="editor">test</textarea>
                            </div>
                            
                            <a href="javascript:;" class="save-button">Save Changes</a>
                            
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
    
        </body>
    </html>

<?php } ?>