<?php include('process/functions.php'); ?>
<!DOCTYPE html>
<html>
<head>
	
	<title>IMEI Delete Request</title>
	
	<style type="text/css">
	
	    @import url('https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap');
	
	    body{
	        background-color: #EEEEEE;
	        font-weight: 400;
	    }
	    
	    .content{
	        font-family: 'Open Sans', sans-serif;
	        width: 35%;
	        margin: 0 auto;
	        text-align: center;
	        border-radius: 5px;
	    }
	    .content .inner{
	        background-color: #FFFFFF;
	        padding: 30px;
	    }
	    
	    .content .inner h1{
	        font-weight: 700;
	        font-size: 35px;
	        margin: 0px;
	        margin-bottom: 15px;
	        line-height: 1.2em;
	    }
	    .content .inner h6{
	        font-size: 20px;
	        margin: 0px;
	        line-height: 1.0em;
	    }
	    .content .inner p{
	        color: #AAAAAA;
	        font-size: 14px;
	    }
	    
	    .button{
	        display: inline-block;
	        background-color: #e74c3c;
	        color: #FFFFFF;
	        font-size: 16px;
	        text-decoration: none;
	        padding: 10px;
	        padding-left: 15px;
	        padding-right: 15px;
	        border-radius: 5px;
	    }
	    .button.login{
	        background-color: #3498db;
	    }
	    
	</style>
	
</head>
<body>
    
    <div class="content">
        <div class="inner">
            
            <?php if( isset($_GET['imeiIdNumber']) && !isset($_GET['deleteConfirm']) ){ ?>
            
                <h1>Are you sure you want to delete IMEI number?</h1>
                <h6>IMEI: <?php echo $_GET['imeiIdNumber']; ?></h6>
                <p>You are about to delete this imei number, please proceed with caution as this action cannot be reverted back. After deleting you can add the same IMEI number back by manually entering the IMEI number into the patient vitals history page.</p>
                <a href="?deleteConfirm=true&imeiIdNumber=<?php echo $_GET['imeiIdNumber']; ?>" class="button">Delete</a>
                
            <?php }elseif( isset($_GET['imeiIdNumber']) && isset($_GET['deleteConfirm']) ){ ?>
                
                <?php
                    $imei = $_GET['imeiIdNumber'];
                    $sql = "DELETE FROM cardiowell_users WHERE imei = '$imei'";

                    if (mysqli_query(ddxrxDBConnect(), $sql)) {
                        echo '
                            <h1>IMEI Number has been deleted</h1>
                            <a href="/provider_login.php" class="button login">Login</a>
                        ';
                    } else {
                      echo '
                            <h1>Internal Server Error</h1>
                            <h6>Delete unsuccessful, something went wrong please contact system administrator.</h6>
                        ';
                    }
                    
                    mysqli_close(ddxrxDBConnect());
                ?>
                
                
                
            <?php }else{ ?>
            
                <h1>Error: IMEI Number does not exist!</h1>
                <p>The IMEI number has already been deleted by your fellow nurse</p>
                
            <?php } ?>
            
        </div>
    </div>
    
</body>
</html>