<?php
    session_start();
    
    if(isset($_SESSION['userid']) || isset($_SESSION['userType'])) {
        
        if( $_SESSION['userType'] == 'doctor' ){
            
            header("Location: physician_default.php");
            die();
            
        }elseif( $_SESSION['userType'] == 'nurse' ){
            header("Location: nurse_default.php");
            die();
        }else{
            
            header("Location: home_default.php");
            die();
            
        }
        
    }
    
    include ('includes/database_include.php');

    $getEpicDetails = "Select epic_token, epic_serviceURL from locations where location_id=1";
    $epicResults = mysqli_query($con, $getEpicDetails);
    $epicDetails = mysqli_fetch_array($epicResults);
    
    ob_start();

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-5');
    </script>

	
	<title>AI Based Health Care - DDxRx.com</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="google-signin-scope" content="profile email">
    <meta name="google-signin-client_id" content="1007608720684-vo3pt3b4gj9u619n60blra88f6jo7n7r.apps.googleusercontent.com">
    
    <meta property="og:type" content="article">
    <meta property="og:title" content="DOCTOR AI: Exact. Physician. Replica.">
    <meta property="og:description" content="Sign up for a FREE automated patient support system. Humanize medicine and reduce care delivery expenses using DOCTOR AI. Download DOCTOR AI app from the App Store or Google Play">
    <meta property="og:url" content="https://doctorai.ddxrx.com">
    <meta property="og:image" content="https://doctorai.ddxrx.com/assets/images/preview.jpg">
    <meta property="og:image:secure_url" content="https://doctorai.ddxrx.com/assets/images/preview.jpg">
    
    <script src="https://apis.google.com/js/platform.js" async defer></script>
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">
	<link rel="stylesheet" type="text/css" href="assets/css/login-selector.css">
	<link rel="stylesheet" type="text/css" href="assets/css/style.css">
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
	<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
    
	<script type="text/javascript" src="assets/js/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
	<script type="text/javascript" src="assets/js/admin.js"></script>
	<script type="text/javascript" src="assets/js/mobile.js"></script>
    
    <script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
</head>
<body>
    
    <div id="google_translate_element"></div>

    <div class="loading-screen"></div>
    
    <script type="text/javascript">
        jQuery(document).ready(function($){
            $(".login-selector .item.default").click(function(){
                $('.login-selector').fadeOut();
            });
        });
    </script>
    
    <!-- Disclaimer -->
    <div class="disclaimer-popup-container">
        <div class="disclaimer-popup">
            <div class="overlay"></div>
            <h6>Medical Disclaimer</h6>
            <p>You will use THE DDXRX Software Information only as a reference aid, and that such information is not intended to be (nor should it be used as) a substitute for the exercise of professional judgment. In view of the possibility of human error or changes in medical science, you should confirm the information in THE DDXRX Software Information through independent sources. You agree and acknowledge that you will, at all times, seek professional diagnosis and treatment for any medical condition and to discuss information obtained from THE DDXRX Software Information with their healthcare provider. The user understands that diseases that the user might consider appropriate may not appear on the list of disease links. The DDXRX software generated severity of illness scores, automatically generated encounter notes and treatments and other recommendations are educational purpose only, and not to be used for patient care. Individual physician must perform through examination of the patient and deliver appropriate treatments without depending on THE DDXRX software.</p>
            <p>This site is designed to offer you general health information for educational purposes only. The health information furnished on this site and the interactive responses are not intended to be professional advice and are not intended to replace personal consultation with a qualified physician, pharmacist or other healthcare professional. You must always seek the advice of a professional for questions related to your disease, disease symptoms, and appropriate therapeutic treatments. If you have or suspect that you have a medical problem or condition, please contact a qualified healthcare provider immediately.</p>
            
            <div class="floating">
                <p>By clicking on the "I Agree" button below, you acknowledge that you have read, understand, and agree to be bound by the <a href="terms_condition.php">Terms and Conditions</a>, <a href="https://ddxrx.com/pages/consent-for-telemedicine">Consent for Telemedicne Treatment</a>, <a href="privacy_policy.php">Privacy Policy</a>, <a href="nda.php">Non-Disclosure Agreement</a> and <a href="medical-disclaimer.php">Medical Disclaimer</a>.</p>
                <a href="javascript:;" class="button green i_agree" id="patient_login">I Agree</a>
                <a href="javascript:;" class="button gray i_disagree">I Disagree</a>
            </div>
            
            <div style="width: 100%; height: 300px;"></div>
        </div>
    </div>
    <!-- Disclaimer -->
    
    
    
    
    
    <!-- Login Content -->
    <div id="login-content" style="position:relative">
        
         <!-- Floating Menu -->
        <div class="floating-menu-icon">
            <img src="assets/images/nav-menu.png">
        </div>
        <div class="floating-menu-container">
            
            <div class="inner">
                <ul>
                <li><a href="dashboard.php" class="home_menu_login">Provider Login</a></li>
                
                <li class="deactive">
                    <!--<a href="signUpPatient.php?plan=0">Free Symptoms Checker</a>-->
                    <a href="#">Free Symptoms Checker</a>
                    <div class="pricing-box">
                        <h2>$0 <span>Per Month</span></h2>
                        <h1>AI Acess only <span>Unsupervised Unlimited AI access</span></h1>
                        <ol>
                            <li>No Electronic Medical Record</li>
                            <li>Unlimited AI Access</li>
                            <li>Unsupervised</li>
                            <li>24/7 AI Access</li>
                            <li>Education Purpose Only</li>
                        </ol>
                        <a href="signUpPatient.php?plan=0" class="button">Get Started</a>
                    </div>
                </li>
                <li class="deactive">
                    <!--<a href="signUpPatient.php?plan=5">AI Based EMR</a>-->
                    <a href="#">AI Based EMR</a>
                    <div class="pricing-box">
                        <h2>$5 <span>Per Month</span></h2>
                        <h1>AI Based EMR <span>Unsupervised Unlimited AI access</span></h1>
                        <ol>
                                <li>No Free Trial</li>
                                <li>Electronic Medical Record</li>
                                <li>Unlimited AI Access</li>
                                <li>Unsupervised</li>
                                <li>24/7 AI Access</li>
                                <li>Education Purpose Only</li>
                            </ol>
                        <a href="signUpPatient.php?plan=5" class="button">Get Started</a>
                    </div>
                </li>
                <li class="deactive">
                    <a href="#">Telemedicine Monthly</a>
                    <div class="pricing-box">
                        <h2>$20 <span>Per Month</span></h2>
                        <h1>Monthly <span>Unlimited AI access Supervised by Physician</span></h1>
                        <ol>
                            <li>One Month Free Trial</li>
                            <li>1 User</li>
                            <li>Electronic Medical Record</li>
                            <li>Unlimited AI Access</li>
                            <li>Supervised by physician</li>
                            <li>24/7 AI Access</li>
                            <li>8AM to 10PM Supervision</li>
                        </ol>
                        <a href="signUpPatient.php?plan=20" class="button">Get Started</a>
                    </div>
                </li>
                <li class="deactive">
                    <a href="#">Telemedicine Single Visit</a>
                    <div class="pricing-box">
                        <h2>$40 <span>Per Visit</span></h2>
                        <h1>One Month <span>Unlimited AI access for 1 Month, Supervised by Physician</span></h1>
                        <ol>
                            <li>No Free Trial</li>
                            <li>1 User</li>
                            <li>Electronic Medical Record</li>
                            <li>Unlimited AI Access</li>
                            <li>Supervised by physician</li>
                            <li>24/7 AI Access</li>
                            <li>8AM to 10PM Supervision</li>
                        </ol>
                        <a href="signUpPatient.php?plan=40" class="button">Get Started</a>
                    </div>
                </li>
                <li class="deactive">
                    <a href="#">AI Based Education</a>
                    <div class="pricing-box">
                        <h2>$30 <span>Per Month</span></h2>
                        <h1>Education <span>Nurse Practitioner/RN <br>Medical Student <br>Intern/Resident</span></h1>
                        <ol>
                            <li>Free Limited Version</li>
                            <li>1 Provider Account</li>
                            <li>1 Patient Account</li>
                            <li>Educational Medical Record</li>
                            <li>AI generated visit note</li>
                            <li>Unlimited AI Access</li>
                            <li>24/7 AI Access</li>
                            <li>Download <span style="font-weight:800">DDXRX</span> App</li>
                            <li>Education Purpose Only</li>
                        </ol>
                        <a href="signup_admin.php?plan=30" class="button">Get Started</a>
                    </div>
                </li>
                <li class="deactive">
                    <a href="#">AI Based Clinic</a>
                    <div class="pricing-box">
                        <h2>$500 <span>Per Month</span></h2>
                        <h1>Clinics <span>Primary Care <br>Urgent Care <br>Specialty Clinic</span></h1>
                        <ol>
                            <li>Up to 2 Provider Account</li>
                            <li>Up to 10 Assistant Account</li>
                            <li>Additional Provider $250/Mo</li>
                            <li>Up to 5,000 Patient Account</li>
                            <li>AI generated visit note</li>
                            <li>Electronic Paper Chart</li>
                            <li>Unlimited AI Access</li>
                            <li>24/7 AI Access</li>
                        </ol>
                        <a href="signup_admin.php?plan=500" class="button">Get Started</a>
                    </div>
                </li>
                <li class="deactive">
                    <a href="#">AI Based Nursing Home</a>
                    <div class="pricing-box">
                        <h2>$500 <span>Per Month</span></h2>
                        <h1>Nursing Home <span>Rehab Facility <br>Assisted Living <br>Nursing Home</span></h1>
                        <ol>
                            <li>Up to 4 Provider Account</li>
                            <li>Up to 25 Assistant Account</li>
                            <li>Additional Provider $250/Mo</li>
                            <li>Up to 5,000 Patient Account</li>
                            <li>AI generated visit note</li>
                            <li>Electronic Paper Chart</li>
                            <li>Unlimited AI Access</li>
                            <li>24/7 AI Access</li>
                        </ol>
                        <a href="signup_admin.php?plan=1000" class="button">Get Started</a>
                    </div>
                </li>
            </ul>
            </div>
            
            <div class="floating-menu-icon close">
                <img src="assets/images/nav-menu-close.png">
            </div>
            
        </div>
        <!-- Floating Menu -->
        
        <!-- Login Container -->
        <div class="login-container pt-30 pb-150">
            <div class="logo-container"><img src="assets/images/logo.png"></div>
            <div class="login-form">
                <h1>Login</h1>
                <div class="padded">
                    
                    <label class="mb-10"><input type="text" class="textbox" id="email" placeholder="Username" name="email"></label>
                    <label class="mb-10"><input type="password" class="textbox" id="password" required="required" name="password" placeholder="Password"></label>
                    
                    <p style="text-align: left;">By clicking on the "Login" button below, you acknowledge that you have read, understand, and agree to be bound by the <a href="terms_condition.php">Terms and Conditions</a>, <a href="consent-for-telemedicine.php">Consent for Telemedicne Treatment</a>, <a href="privacy_policy.php">Privacy Policy</a>, <a href="nda.php">Non-Disclosure Agreement</a> and <a href="medical-disclaimer.php">Medical Disclaimer</a>.</p>
                    
                    <button class="button large solid rounded green mb-10 login_trigger" type="submit">Login to account</button>
                    <a href="signUpPatient.php?plan=0" class="button large solid rounded blue mb-10" style="text-align:center">Create A Free Account</a>
                    <a href="forgot_password.php" class="button large border rounded blue mb-10" style="text-align:center">Reset Password</a>
                    <!--<a href="javascript:;" class="g-signin2 button large solid rounded blue mb-10" data-onsuccess="onSignIn" style="text-align:center">Google Signup</a>-->
     
                    <!-- <a href="javascript:;" onclick="checkLoginState()" class="login_facebook">Facebook Login</a>-->
                    <!--<fb:login-button scope="public_profile,email" onlogin="checkLoginState();"></fb:login-button>-->
                    <!--<div class="fb-login-button" data-width="" data-scope="public_profile,email" data-size="large" data-button-type="continue_with" data-auto-logout-link="false" data-use-continue-as="true"></div>-->
                    <!--
                    <p style="margin-bottom:5px; text-align: left;">Don't have an account? Create one its free!</p>
                    <p style="text-align: left;"><a href="signUpPatient.php?plan=0">Create A Free Account</a><br><a href="forgot_password.php">Reset Password</a></p>
                    -->
    
                </div>
            </div>
        </div>
        <!-- Login Container -->
    </div>
    <!-- Login Content -->

    

<?php //include('footer.php'); ?>
</body>
</html>