$(document).ready(function(){
    
    // Global Variables
    var patient_id = $('body').data('patient-id');
    
    
    // Get Recent Vitals
    function get_recent_vitals(patient_id){
        
        $.ajax({
            type: 'POST',
            url: 'process/get_recent_vitals.php',
                
            data: {
            	patient_id:patient_id
            },

            success: function(response) {
                
                // Do something
                $('table.single_user_data tbody').html(response);
                
            },
            
            fail: function(response){
            	Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
            }
                
        });
        
    }
    
    
    
    
    
    $('body').on('click', '.addVitals', function() {
        var patient_id = $(this).data('patient-id');
        $('#hidden_patient_id').val( patient_id );
    });
    
    $('body').on('click', '.popup_vitals', function() {
        $('.popup-container').fadeIn();
    });
    
    $('body').on('click', '.popup-container .button.cancel', function() {
        $('.popup-container').fadeOut();
    });
            
    $('body').on('click', '.add_vitals', function() {
                    
        var patient_id = $('#hidden_patient_id').val();
        var systolicBP = $('#systolicBP').val();
        var diastolicBP = $('#diastolicBP').val();
        var heartRate = $('#heartRate').val();
        var respRate = $('#respRate').val();
        var pulseOX = $('#pulseOX').val();
        var temp = $('#temp').val();
        var glucose = $('#glucose').val();
        var weight = $('#weight').val();
                    
        $.ajax({
            type: 'POST',
            url: 'process/save_vital_history.php',
            
            data: {
            	patient_id:patient_id,
            	systolicBP:systolicBP,
            	diastolicBP:diastolicBP,
            	heartRate:heartRate,
            	respRate:respRate,
            	pulseOX:pulseOX,
            	temp:temp,
            	glucose:glucose,
            	weight:weight
            },
            
            beforeSend: function() {
            					
            },
            success: function(response) {
                
                $('.textbox').val();
                $('.popup-container').fadeOut();
                            
                Swal.fire({
                    icon: 'success',
                    title: 'Data Saved',
                    text: "The vitals data have been saved",
                });
                
                get_recent_vitals(patient_id);             
                                
            },	
            fail: function(response){
            	// Do Something
            }
            
        });
                     
    });
    
    
    $('body').on('click', '.patient_id', function() {
        
        var patient_id = $(this).data('patient-id');
        location.href = 'patient_vitals.php?patient_id='+patient_id;
        
    });
    
    
    
    
    
    
    
    
    
    
    // Auto Sync on load
    $.ajax({
        type: 'POST',
        url: 'process/syncvitals.php',
            
        data: {
        	patient_id:patient_id
        },
            
        beforeSend: function() {
            
            $('.syncContainer').fadeIn();
            					
        },
        
        success: function(response) {
            
            get_recent_vitals(patient_id);
            $('.syncContainer').fadeOut();
            
        },
        
        fail: function(response){
        	Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Something went wrong!',
            });
        }
            
    });
    
    
    
    
});